/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;

public class Traversal<T>
extends IteratorAdapter<DSPair<T>> {
    private DelaneySymbol<T> ds;
    private List<Integer> indices;
    private Iterator<T> seeds;
    private boolean visitAllEdges;
    private List<LinkedList<T>> buffer;
    private HashMap<T, Integer> elm2num;
    private int nextNum;

    public Traversal(DelaneySymbol<T> delaneySymbol, List<Integer> list, Iterator<T> iterator, boolean bl) {
        this.ds = delaneySymbol;
        this.indices = list;
        this.seeds = iterator;
        this.visitAllEdges = bl;
        this.buffer = new ArrayList<LinkedList<T>>();
        for (int i = 0; i < list.size(); ++i) {
            this.buffer.add(new LinkedList());
        }
        this.elm2num = new HashMap();
        this.nextNum = 0;
    }

    public Traversal(DelaneySymbol<T> delaneySymbol, List<Integer> list, Iterator<T> iterator) {
        this((DelaneySymbol<Iterator<T>>)delaneySymbol, list, iterator, false);
    }

    public Traversal(DelaneySymbol<T> delaneySymbol, List<Integer> list, T t) {
        this(delaneySymbol, list, Iterators.singleton(t), false);
    }

    public Traversal(DelaneySymbol<T> delaneySymbol, List<Integer> list, T t, boolean bl) {
        this(delaneySymbol, list, Iterators.singleton(t), bl);
    }

    public Traversal(DelaneySymbol<T> delaneySymbol, boolean bl) {
        this(delaneySymbol, (List<Integer>)new IndexList(delaneySymbol), delaneySymbol.elements(), bl);
    }

    public Traversal(DelaneySymbol<T> delaneySymbol) {
        this(delaneySymbol, (List<Integer>)new IndexList(delaneySymbol), delaneySymbol.elements(), false);
    }

    @Override
    protected DSPair<T> findNext() {
        int n;
        for (int i = 0; i < this.indices.size(); ++i) {
            while (this.buffer.get(i).size() > 0) {
                int n2;
                int n3;
                n = this.indices.get(i);
                T t = i < 2 ? this.buffer.get(i).removeLast() : this.buffer.get(i).removeFirst();
                if (!this.ds.hasElement(t)) continue;
                if (!this.elm2num.containsKey(t)) {
                    this.elm2num.put(t, this.nextNum++);
                    for (n3 = 0; n3 < this.indices.size(); ++n3) {
                        n2 = this.indices.get(n3);
                        if (n2 == n) continue;
                        this.buffer.get(n3).addLast(this.ds.op(n2, t));
                    }
                    return new DSPair<T>(n, t);
                }
                if (!this.visitAllEdges) continue;
                n3 = this.elm2num.get(t);
                n2 = this.elm2num.get(this.ds.op(n, t));
                if (n2 > n3) continue;
                return new DSPair<T>(n, t);
            }
        }
        while (this.seeds.hasNext()) {
            T t = this.seeds.next();
            if (t == null || this.elm2num.containsKey(t)) continue;
            this.elm2num.put(t, this.nextNum++);
            for (n = 0; n < this.indices.size(); ++n) {
                int n4 = this.indices.get(n);
                this.buffer.get(n).addLast(this.ds.op(n4, t));
            }
            return new DSPair<T>(-1, t);
        }
        throw new NoSuchElementException("at end");
    }
}

