/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Traversal;

public class TestTraversal
extends TestCase {
    private static final Integer one = new Integer(1);
    private static final Integer two = new Integer(2);
    private static final Integer three = new Integer(3);
    private static final Integer four = new Integer(4);
    private static final Integer five = new Integer(5);
    private static final Integer six = new Integer(6);
    private DelaneySymbol ds;

    protected void setUp() throws Exception {
        super.setUp();
        this.ds = new DSymbol("6:2 4 6,6 3 5,2 4 6:3,3");
    }

    protected void tearDown() throws Exception {
        this.ds = null;
        super.tearDown();
    }

    public void testTraversal1() {
        Traversal trav = new Traversal(this.ds);
        Assert.assertEquals(new DSPair<Integer>(-1, one), trav.next());
        Assert.assertEquals(new DSPair<Integer>(0, two), trav.next());
        Assert.assertEquals(new DSPair<Integer>(1, three), trav.next());
        Assert.assertEquals(new DSPair<Integer>(0, four), trav.next());
        Assert.assertEquals(new DSPair<Integer>(1, five), trav.next());
        Assert.assertEquals(new DSPair<Integer>(0, six), trav.next());
    }

    public void testTraversal2() {
        IndexList idcs = new IndexList(this.ds);
        Collections.reverse(idcs);
        Traversal trav = new Traversal(this.ds, (List<Integer>)idcs, this.ds.elements(), false);
        Assert.assertEquals(new DSPair<Integer>(-1, one), trav.next());
        Assert.assertEquals(new DSPair<Integer>(2, two), trav.next());
        Assert.assertEquals(new DSPair<Integer>(1, three), trav.next());
        Assert.assertEquals(new DSPair<Integer>(2, four), trav.next());
        Assert.assertEquals(new DSPair<Integer>(1, five), trav.next());
        Assert.assertEquals(new DSPair<Integer>(2, six), trav.next());
    }
}

