/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import junit.framework.TestCase;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.joss.dsyms.basic.DSMorphism;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.Covers;

public class TestMorphism
extends TestCase {
    private DSymbol ds;
    private DelaneySymbol renumbered;
    private DelaneySymbol unconnected;
    private DelaneySymbol cover;
    private DSMorphism map;
    private DSMorphism iso;

    private Object getImage(Object x) {
        return new Integer(((Integer)x - 1) % this.ds.size() + 1);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ds = new DSymbol("3:1 2 3,1 3,2 3:6 4,3");
        this.renumbered = new DSymbol("3:1 2 3,3 2,2 3:4 6,3");
        this.unconnected = new DSymbol("4:1 2 3 4,1 3 4,2 3 4:6 4 3,3 3");
        TestMorphism.assertEquals((Object)this.ds, (Object)this.renumbered);
        this.cover = Covers.finiteUniversalCover(this.ds);
        this.map = new DSMorphism(this.cover, this.ds);
        this.iso = new DSMorphism<Integer, Integer>(this.ds, this.renumbered, new Integer(1), new Integer(2));
    }

    protected void tearDown() throws Exception {
        this.iso = null;
        this.map = null;
        this.cover = null;
        this.unconnected = null;
        this.renumbered = null;
        this.ds = null;
        super.tearDown();
    }

    public void testMorphismDelaneySymbolDelaneySymbolObjectObject() {
        DSMorphism<Integer, Integer> map = new DSMorphism<Integer, Integer>(this.cover, this.ds, new Integer(this.ds.size() + 1), new Integer(1));
        TestMorphism.assertNotNull(map);
        IteratorAdapter iter = this.cover.elements();
        while (iter.hasNext()) {
            Object x = iter.next();
            TestMorphism.assertEquals((Object)map.get((Integer)x), (Object)this.getImage(x));
        }
        try {
            new DSMorphism<Integer, Integer>(this.cover, this.ds, new Integer(2), new Integer(1));
            TestMorphism.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DSMorphism<Integer, Object>(this.ds, this.cover, new Integer(2), null);
            TestMorphism.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMorphismDelaneySymbolDelaneySymbol() {
        DSMorphism map = new DSMorphism(this.cover, this.ds);
        TestMorphism.assertNotNull(map);
        IteratorAdapter iter = this.cover.elements();
        while (iter.hasNext()) {
            Object x = iter.next();
            TestMorphism.assertEquals((Object)map.get(x), (Object)this.getImage(x));
        }
        try {
            new DSMorphism(this.ds, this.cover);
            TestMorphism.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new DSMorphism(this.ds, this.unconnected);
        try {
            new DSMorphism(this.unconnected, this.ds);
            TestMorphism.fail((String)"Should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testMorphismMorphism() {
        DSMorphism map = new DSMorphism(this.map);
        TestMorphism.assertNotNull(map);
        IteratorAdapter iter = this.cover.elements();
        while (iter.hasNext()) {
            Object x = iter.next();
            TestMorphism.assertEquals(map.get(x), (Object)this.getImage(x));
        }
    }

    public void testInverse() {
        DSMorphism inv = this.iso.inverse();
        IteratorAdapter<Integer> iter = this.ds.elements();
        while (iter.hasNext()) {
            Object x = iter.next();
            TestMorphism.assertEquals(x, inv.get(this.iso.get(x)));
        }
        try {
            this.map.inverse();
            TestMorphism.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new DSMorphism(this.ds, this.unconnected).inverse();
            TestMorphism.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsIsomorphism() {
        TestMorphism.assertTrue((boolean)this.iso.isIsomorphism());
        TestMorphism.assertFalse((boolean)this.map.isIsomorphism());
        TestMorphism.assertFalse((boolean)new DSMorphism(this.ds, this.unconnected).isIsomorphism());
    }

    public void testGetASource() {
        IteratorAdapter<Integer> iter = this.ds.elements();
        while (iter.hasNext()) {
            Object x = iter.next();
            TestMorphism.assertEquals(x, (Object)this.getImage(this.map.getASource(x)));
        }
    }

    public void testSize() {
        TestMorphism.assertEquals((int)this.map.size(), (int)this.cover.size());
    }

    public void testGet() {
        IteratorAdapter iter = this.cover.elements();
        while (iter.hasNext()) {
            Object x = iter.next();
            TestMorphism.assertEquals(this.map.get(x), (Object)this.getImage(x));
        }
    }
}

