/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;

public class DynamicDSymbol
extends DelaneySymbol<Integer> {
    private final int dim;
    private int lastId = 0;
    final Map<Integer, int[]> op;
    final Map<Integer, int[]> v;

    public DynamicDSymbol(int n) {
        this.dim = n;
        this.op = new LinkedHashMap<Integer, int[]>();
        this.v = new LinkedHashMap<Integer, int[]>();
    }

    public DynamicDSymbol(int n, DSymbol dSymbol) {
        this(n);
        this.append(dSymbol);
    }

    public DynamicDSymbol(DSymbol dSymbol) {
        this(dSymbol.dim(), dSymbol);
    }

    public DynamicDSymbol(String string) {
        this(new DSymbol(string));
    }

    @Override
    public int dim() {
        return this.dim;
    }

    @Override
    public int size() {
        return this.op.size();
    }

    @Override
    public IteratorAdapter<Integer> elements() {
        return new FilteredIterator<Integer, Integer>(this.op.keySet().iterator()){

            @Override
            public Integer filter(Integer n) {
                return n;
            }
        };
    }

    @Override
    public boolean hasElement(Integer n) {
        return this.op.containsKey(n);
    }

    @Override
    public IteratorAdapter<Integer> indices() {
        return Iterators.range(0, this.dim() + 1);
    }

    @Override
    public boolean hasIndex(int n) {
        return n >= 0 && n <= this.dim();
    }

    @Override
    public boolean definesOp(int n, Integer n2) {
        return this.hasElement(n2) && this.hasIndex(n) && this.op.get(n2)[n] != 0;
    }

    @Override
    public Integer op(int n, Integer n2) {
        if (!this.hasElement(n2)) {
            throw new IllegalArgumentException("not an element: " + n2);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        return this.op.get(n2)[n];
    }

    @Override
    public boolean definesV(int n, int n2, Integer n3) {
        return this.hasElement(n3) && this.hasIndex(n) && this.hasIndex(n2) && (Math.abs(n - n2) != 1 || this.v.get(n3)[Math.min(n, n2)] != 0);
    }

    @Override
    public int v(int n, int n2, Integer n3) {
        if (!this.hasElement(n3)) {
            throw new IllegalArgumentException("not an element: " + n3);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        if (!this.hasIndex(n2)) {
            throw new IllegalArgumentException("invalid index: " + n2);
        }
        int n4 = n2 == n + 1 ? this.v.get(n3)[n] : (n2 == n - 1 ? this.v.get(n3)[n2] : (n != n2 && this.op(n, n3).equals(this.op(n2, n3)) ? 2 : 1));
        return this.normalizedV(n4);
    }

    public void undefineOp(int n, Integer n2) {
        if (!this.hasElement(n2)) {
            throw new IllegalArgumentException("not an element: " + n2);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        if (this.definesOp(n, n2)) {
            this.op.get((Object)this.op((int)n, (Integer)n2))[n] = 0;
        }
        this.op.get((Object)n2)[n] = 0;
    }

    public void undefineV(int n, int n2, Integer n3) {
        if (!this.hasElement(n3)) {
            throw new IllegalArgumentException("not an element: " + n3);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        if (!this.hasIndex(n2)) {
            throw new IllegalArgumentException("invalid index: " + n2);
        }
        if (Math.abs(n - n2) != 1) {
            throw new IllegalArgumentException("implied value cannot be undefined");
        }
        int n4 = Math.min(n, n2);
        for (int n5 : this.orbit(new IndexList(n4, n4 + 1), n3)) {
            this.v.get((Object)Integer.valueOf((int)n5))[n4] = 0;
        }
    }

    public void redefineOp(int n, Integer n2, Integer n3) {
        if (!this.hasElement(n2)) {
            throw new IllegalArgumentException("not an element: " + n2);
        }
        if (!this.hasElement(n3)) {
            throw new IllegalArgumentException("not an element: " + n3);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        if (n > 0 && this.v(n - 1, n, n2) != this.v(n - 1, n, n3)) {
            throw new IllegalArgumentException("branching numbers differ");
        }
        if (n < this.dim() && this.v(n, n + 1, n2) != this.v(n, n + 1, n3)) {
            throw new IllegalArgumentException("branching numbers differ");
        }
        if (this.definesOp(n, n2)) {
            this.undefineOp(n, n2);
        }
        if (this.definesOp(n, n3)) {
            this.undefineOp(n, n3);
        }
        this.op.get((Object)n2)[n] = n3;
        this.op.get((Object)n3)[n] = n2;
    }

    public void redefineV(int n, int n2, Integer n3, int n4) {
        if (!this.hasElement(n3)) {
            throw new IllegalArgumentException("not an element: " + n3);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        if (!this.hasIndex(n2)) {
            throw new IllegalArgumentException("invalid index: " + n2);
        }
        if (Math.abs(n - n2) != 1) {
            throw new IllegalArgumentException("implied value cannot be redefined");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("invalid branching value " + n4);
        }
        int n5 = Math.min(n, n2);
        for (int n6 : this.orbit(new IndexList(n5, n5 + 1), n3)) {
            this.v.get((Object)Integer.valueOf((int)n6))[n5] = n4;
        }
    }

    public Integer addElement() {
        int n = ++this.lastId;
        this.op.put(n, new int[this.dim() + 1]);
        this.v.put(n, new int[this.dim()]);
        return n;
    }

    public void removeElement(Integer n) {
        if (!this.hasElement(n)) {
            throw new IllegalArgumentException("not an element: " + n);
        }
        for (int i = 0; i <= this.dim(); ++i) {
            this.undefineOp(i, n);
        }
        this.op.remove(n);
        this.v.remove(n);
    }

    public List<Integer> grow(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.addElement());
        }
        return arrayList;
    }

    public void collapse(Collection<Integer> collection, int n) {
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("illegal index " + n);
        }
        for (int n2 : collection) {
            if (!this.hasElement(n2)) {
                throw new IllegalArgumentException("illegal element " + n2);
            }
            for (int i = 0; i < this.dim(); ++i) {
                if (this.definesV(i, i + 1, n2) && this.v(i, i + 1, n2) == 1) continue;
                String string = "nontrivial branching at " + n2;
                throw new UnsupportedOperationException(string);
            }
            if (collection.contains(this.op(n, n2))) continue;
            throw new IllegalArgumentException("elements not invariant under connnector");
        }
        for (int n2 : this.indices()) {
            if (n2 == n) continue;
            for (int n3 : collection) {
                int n4;
                if (!this.definesOp(n2, n3) || collection.contains(n4 = this.op(n2, n3).intValue())) continue;
                int n5 = n3;
                while (collection.contains(n5)) {
                    n5 = this.op(n2, this.op(n, n5));
                }
                this.redefineOp(n2, n4, n5);
            }
        }
        for (int n2 : collection) {
            this.removeElement(n2);
        }
    }

    public DynamicDSymbol dual() {
        int n;
        int n2;
        DynamicDSymbol dynamicDSymbol = new DynamicDSymbol(this.dim);
        List<Integer> list = dynamicDSymbol.grow(this.size());
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        for (int n4 : this.elements()) {
            hashMap.put(n4, list.get(n3));
            ++n3;
        }
        for (int n4 : this.elements()) {
            for (n2 = 0; n2 <= this.dim(); ++n2) {
                if (!this.definesOp(n2, n4)) continue;
                n = this.op(n2, n4);
                dynamicDSymbol.redefineOp(this.dim() - n2, (Integer)hashMap.get(n4), (Integer)hashMap.get(n));
            }
        }
        for (int n4 : this.elements()) {
            for (n2 = 0; n2 < this.dim(); ++n2) {
                if (!this.definesV(n2, n2 + 1, n4)) continue;
                n = this.v(n2, n2 + 1, n4);
                dynamicDSymbol.redefineV(this.dim() - n2, this.dim() - (n2 + 1), (Integer)hashMap.get(n4), n);
            }
        }
        return dynamicDSymbol;
    }

    public List<Integer> append(DSymbol dSymbol) {
        int n;
        int n2;
        List<Integer> list = this.grow(dSymbol.size());
        for (int n3 : dSymbol.elements()) {
            n2 = list.get(n3 - 1);
            for (n = 0; n <= this.dim(); ++n) {
                if (!dSymbol.definesOp(n, n3)) continue;
                int n4 = dSymbol.op(n, n3);
                int n5 = list.get(n4 - 1);
                this.redefineOp(n, n2, n5);
            }
        }
        for (int n3 : dSymbol.elements()) {
            n2 = list.get(n3 - 1);
            for (n = 0; n < this.dim(); ++n) {
                if (!dSymbol.definesV(n, n + 1, n3)) continue;
                this.redefineV(n, n + 1, n2, dSymbol.v(n, n + 1, n3));
            }
        }
        return list;
    }

    public void clear() {
        this.op.clear();
        this.v.clear();
        this.lastId = 0;
    }

    public void renumber() {
        DSymbol dSymbol = new DSymbol(this);
        this.clear();
        this.append(dSymbol);
    }
}

