/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.numbers;

import java.math.BigInteger;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Rational;

public class Whole
extends Rational {
    private BigInteger val;
    public static final Whole ZERO = new Whole(0L);
    public static final Whole ONE = new Whole(1L);

    public Whole(long l) {
        this.val = BigInteger.valueOf(l);
    }

    public Whole(BigInteger bigInteger) {
        this.val = bigInteger;
    }

    @Override
    public Whole numerator() {
        return this;
    }

    @Override
    public Whole denominator() {
        return ONE;
    }

    @Override
    public int sign() {
        return this.val.signum();
    }

    @Override
    public boolean isZero() {
        return this.val.equals(BigInteger.ZERO);
    }

    @Override
    public boolean isOne() {
        return this.val.equals(BigInteger.ONE);
    }

    @Override
    public double doubleValue() {
        return this.val.doubleValue();
    }

    @Override
    public long longValue() {
        return this.val.longValue();
    }

    @Override
    public int intValue() {
        return this.val.intValue();
    }

    @Override
    public String toString() {
        return this.val.toString();
    }

    @Override
    public IArithmetic negative() {
        return new Whole(this.val.negate());
    }

    @Override
    public IArithmetic abs() {
        return new Whole(this.val.abs());
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public IArithmetic plus(Object object) {
        if (object instanceof Whole) {
            return new Whole(this.val.add(((Whole)object).val));
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rplus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic minus(Object object) {
        if (object instanceof Whole) {
            return new Whole(this.val.subtract(((Whole)object).val));
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rminus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof Whole) {
            return new Whole(this.val.multiply(((Whole)object).val));
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rtimes(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic dividedBy(Object object) {
        if (object instanceof Whole) {
            return Rational.make(this, (Whole)object);
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rdividedBy(this);
        }
        throw new IllegalArgumentException();
    }

    public Whole div(Whole whole) {
        Whole whole2 = new Whole(this.val.divide(whole.val));
        if (whole2.times(whole).isGreaterThan(this)) {
            return (Whole)whole2.minus(ONE);
        }
        return whole2;
    }

    public Whole gcd(Whole whole) {
        return new Whole(this.val.gcd(whole.val));
    }

    public Whole gcd(long l) {
        return new Whole(this.val.gcd(BigInteger.valueOf(l)));
    }
}

