/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.SmallActionsIterator;

public class TestSmallActionsIterator
extends TestCase {
    private FiniteAlphabet A;
    private FpGroup G;
    private FpGroup T;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = new FiniteAlphabet<String>(new String[]{"a", "b", "c"});
        this.G = new FpGroup(this.A, new String[]{"[a,b]", "[a,c]", "[b,c]"});
        this.T = new FpGroup(this.A, new String[]{"a^2", "b^2", "c^2", "(a*b)^4", "(a*c)^2", "(b*c)^4"});
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.A = null;
        this.G = null;
        this.T = null;
    }

    public void test1() {
        this.test(this.G, 4, false, 56);
        this.test(this.G, 4, true, 56);
    }

    public void test2() {
        this.test(this.T, 3, false, 8);
        this.test(this.T, 3, true, 8);
    }

    public void test3() {
        this.test(this.T, 4, false, 27);
        this.test(this.T, 4, true, 15);
    }

    public void test(FpGroup G, int index, boolean normalOnly, int expected) {
        SmallActionsIterator actions = new SmallActionsIterator(G, index, normalOnly);
        int count = 0;
        while (actions.hasNext()) {
            ++count;
            actions.next();
        }
        Assert.assertEquals((int)expected, (int)count);
    }
}

