/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FiniteGroupAction;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.fpgroups.GroupAction;
import org.gavrog.jane.fpgroups.GroupActions;

public class TestGroupActions
extends TestCase {
    private FiniteAlphabet A;
    private FpGroup G;
    private List domain;
    private GroupAction action1;
    private GroupAction action2;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = new FiniteAlphabet<String>(new String[]{"a"});
        this.G = new FpGroup(this.A);
        this.domain = new LinkedList();
        int i = 0;
        while (i < 5) {
            this.domain.add(new Integer(i));
            ++i;
        }
        this.action1 = new FiniteGroupAction(this.G, this.domain){

            protected Object applyGenerator(Object x, int gen, int sign) {
                int i = (Integer)x;
                return new Integer((i + sign * gen + 5) % 5);
            }
        };
        this.action2 = new FiniteGroupAction(this.G, this.domain){

            protected Object applyGenerator(Object x, int gen, int sign) {
                int i = (Integer)x;
                if (sign > 0) {
                    return new Integer(i * 2 % 5);
                }
                return new Integer(i * 3 % 5);
            }
        };
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.A = null;
        this.G = null;
        this.domain = null;
        this.action1 = null;
        this.action2 = null;
    }

    private Pair pair(int a, int b) {
        return new Pair<Integer, Integer>(new Integer(a), new Integer(b));
    }

    public void testProduct() {
        GroupAction product = GroupActions.product(this.action1, this.action2);
        Assert.assertEquals((Object)this.G, product.getGroup());
        Assert.assertEquals((int)25, (int)product.size());
        Assert.assertTrue((boolean)Iterators.equal(Iterators.cantorProduct(this.domain.iterator(), this.domain.iterator()), product.domain()));
        Assert.assertTrue((boolean)product.isDefinedOn(this.pair(1, 4)));
        Assert.assertFalse((boolean)product.isDefinedOn(this.pair(1, 5)));
        Assert.assertEquals((Object)this.pair(3, 4), (Object)product.apply(this.pair(1, 1), FreeWord.parsedWord(this.A, "a^2")));
        Assert.assertEquals((Object)this.pair(0, 0), (Object)product.apply(this.pair(0, 0), FreeWord.parsedWord(this.A, "a^5")));
    }

    public void testFlat() {
        GroupAction flat = GroupActions.flat(GroupActions.product(this.action1, this.action2));
        Assert.assertEquals((Object)this.G, flat.getGroup());
        Assert.assertEquals((int)25, (int)flat.size());
        Assert.assertTrue((boolean)Iterators.equal(Iterators.range(0, 25), flat.domain()));
        Assert.assertTrue((boolean)flat.isDefinedOn(new Integer(15)));
        Assert.assertFalse((boolean)flat.isDefinedOn(new Integer(25)));
        Assert.assertEquals((Object)new Integer(0), (Object)flat.apply(new Integer(0), FreeWord.parsedWord(this.A, "a^5")));
        Assert.assertEquals((Object)new Integer(22), (Object)flat.apply(new Integer(4), FreeWord.parsedWord(this.A, "a^2")));
    }

    private List perm(int a, int b, int c, int d, int e) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        res.add(new Integer(a));
        res.add(new Integer(b));
        res.add(new Integer(c));
        res.add(new Integer(d));
        res.add(new Integer(e));
        return res;
    }

    public void testCover() {
        GroupAction cover = GroupActions.cover(this.action2);
        Assert.assertEquals((Object)this.G, cover.getGroup());
        Assert.assertEquals((int)120, (int)cover.size());
        Iterator dom = cover.domain();
        Assert.assertEquals((Object)this.perm(0, 1, 2, 3, 4), dom.next());
        Assert.assertEquals((Object)this.perm(0, 1, 2, 4, 3), dom.next());
        Assert.assertEquals((Object)this.perm(0, 1, 3, 2, 4), dom.next());
        Assert.assertEquals((Object)this.perm(0, 1, 3, 4, 2), dom.next());
        Assert.assertTrue((boolean)cover.isDefinedOn(this.perm(0, 1, 2, 3, 4)));
        Assert.assertFalse((boolean)cover.isDefinedOn(this.perm(1, 2, 3, 4, 5)));
        Assert.assertEquals((Object)this.perm(0, 4, 3, 2, 1), (Object)cover.apply(this.perm(0, 1, 2, 3, 4), FreeWord.parsedWord(this.A, "a^2")));
        Assert.assertEquals((Object)this.perm(0, 2, 4, 1, 3), (Object)cover.apply(this.perm(0, 1, 2, 3, 4), FreeWord.parsedWord(this.A, "a^5")));
    }

    public void testOrbit() {
        GroupAction orbit0 = GroupActions.orbit(new Integer(0), this.action2);
        Assert.assertEquals((int)1, (int)orbit0.size());
        GroupAction orbit1 = GroupActions.orbit(new Integer(1), this.action2);
        Assert.assertEquals((int)4, (int)orbit1.size());
        HashSet<Integer> seen = new HashSet<Integer>();
        Iterator<Integer> iter = orbit1.domain();
        while (iter.hasNext()) {
            Integer x = iter.next();
            int i = x;
            Assert.assertTrue((boolean)orbit1.isDefinedOn(x));
            Assert.assertTrue((1 <= i && i <= 4 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)seen.contains(x));
            seen.add(x);
            Assert.assertTrue((boolean)seen.contains(x));
        }
    }
}

