/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FreeWord;

public class TestFreeWord
extends TestCase {
    private FiniteAlphabet A;
    private FreeWord w1;
    private FreeWord w2;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = new FiniteAlphabet<String>(new String[]{"a", "b", "c"});
        this.w1 = new FreeWord(this.A, new int[]{2, -3, 2, -2, -1, -2});
        this.w2 = FreeWord.parsedWord(this.A, "b*a*c*b*a");
    }

    protected void tearDown() throws Exception {
        this.w1 = null;
        this.A = null;
        super.tearDown();
    }

    public void testSmallWords() {
        Assert.assertEquals((String)"*", (String)new FreeWord(this.A).toString());
        Assert.assertEquals((String)"a", (String)new FreeWord(this.A, 1).toString());
        Assert.assertEquals((String)"b", (String)FreeWord.parsedWord(this.A, "b").toString());
    }

    public void testParser() {
        Assert.assertEquals((String)"a*b*c*b*c*b*b*c*b*c*b", (String)FreeWord.parsedWord(this.A, "a * (c*( c ^ -1*b^-1 )^3 ) ^-2").toString());
        Assert.assertEquals(FreeWord.parsedWord(this.A, "[a,c*b]"), FreeWord.parsedWord(this.A, "a*c * b*a^-1*b^-1* c ^ -1"));
    }

    public void testCompare() {
        Assert.assertTrue((this.w1.compareTo(this.w2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.w1.compareTo(this.w1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.w1.compareTo(FreeWord.parsedWord(this.A, "b*(b*a*c)^-1*a")) < 0 ? 1 : 0) != 0);
    }

    public void testSize() {
        Assert.assertEquals((int)4, (int)this.w1.size());
        Assert.assertEquals((int)5, (int)this.w2.size());
    }

    public void testGetLetter() {
        Assert.assertEquals((Object)"b", (Object)this.w1.getLetterName(0));
        Assert.assertEquals((Object)"c", (Object)this.w1.getLetterName(1));
        Assert.assertEquals((Object)"a", (Object)this.w1.getLetterName(2));
    }

    public void testGetSign() {
        Assert.assertTrue((this.w1.getSign(3) == -1 ? 1 : 0) != 0);
    }

    public void testSubword() {
        Assert.assertEquals((String)"a^-1*b^-1", (String)this.w1.subword(2, 4).toString());
        try {
            this.w1.subword(-1, 4);
            TestFreeWord.fail((String)"should raise a IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.w1.subword(4, 4);
            TestFreeWord.fail((String)"should raise a IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.w1.subword(2, 1);
            TestFreeWord.fail((String)"should raise a IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.w1.subword(2, 5);
            TestFreeWord.fail((String)"should raise a IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTimes() {
        Assert.assertEquals((String)"b*b*a", (String)this.w1.times(this.w2).toString());
        Assert.assertEquals((String)"*", (String)this.w1.times(this.w1.inverse()).toString());
    }

    public void testRaisedTo() {
        Assert.assertEquals((String)"b*c^-1*a^-1*b^-1", (String)this.w1.raisedTo(1).toString());
        Assert.assertEquals((String)"*", (String)this.w2.raisedTo(0).toString());
        Assert.assertEquals((String)"*", (String)new FreeWord(this.A).raisedTo(-5).toString());
        Assert.assertEquals((String)"a^-1*b^-1*c^-1*a^-1*b^-1", (String)this.w2.raisedTo(-1).toString());
        Assert.assertEquals((String)"b*c^-1*a^-1*c^-1*a^-1*c^-1*a^-1*b^-1", (String)this.w1.raisedTo(3).toString());
        Assert.assertEquals((String)"b*a*c*a*c*a*c*a*c*a*c*b^-1", (String)this.w1.raisedTo(-5).toString());
    }

    public void testToString() {
        Assert.assertEquals((String)"b*c^-1*a^-1*b^-1", (String)this.w1.toString());
    }
}

