/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.jane.fpgroups.Coset;
import org.gavrog.jane.fpgroups.CosetAction;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;

public class TestCosetAction
extends TestCase {
    private FiniteAlphabet A;
    private FpGroup G;
    private FpGroup H;
    private FpGroup T;
    private CosetAction ActionG;
    private CosetAction ActionG5;
    private CosetAction ActionH;
    private CosetAction ActionT4;
    private Coset C_0;
    private Coset C_a;
    private Coset C_aa;
    private Coset C_b;
    private Coset C_ab;
    private Coset C_aab;
    private FreeWord a;
    private FreeWord a_1;
    private FreeWord b;
    private FreeWord b_1;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = new FiniteAlphabet<String>(new String[]{"a", "b"});
        this.G = new FpGroup(this.A, new String[]{"a^3", "b^2", "(a*b)^5"});
        this.H = new FpGroup(this.A, new String[]{"a^3", "b^2", "a*b*a^-1*b^-1"});
        this.T = new FpGroup(this.A, new String[]{"a*b*a^-1*b^-1"});
        LinkedList sgens = new LinkedList();
        sgens.add(FreeWord.parsedWord(this.A, "a"));
        sgens.add(FreeWord.parsedWord(this.A, "b^3"));
        this.ActionT4 = new CosetAction(this.T, sgens, 10);
        this.ActionG = new CosetAction(this.G);
        this.ActionH = new CosetAction(this.H);
        sgens = new LinkedList();
        sgens.add(FreeWord.parsedWord(this.A, "a*b"));
        this.ActionG5 = new CosetAction(this.G, sgens);
        this.a = FreeWord.parsedWord(this.A, "a");
        this.a_1 = FreeWord.parsedWord(this.A, "a^-1");
        this.b = FreeWord.parsedWord(this.A, "b");
        this.b_1 = FreeWord.parsedWord(this.A, "b^-1");
        this.C_0 = this.ActionH.getTrivialCoset();
        this.C_a = this.ActionH.getCoset(FreeWord.parsedWord(this.A, "a"));
        this.C_aa = this.ActionH.getCoset(FreeWord.parsedWord(this.A, "a*a"));
        this.C_b = this.ActionH.getCoset(FreeWord.parsedWord(this.A, "b"));
        this.C_ab = this.ActionH.getCoset(FreeWord.parsedWord(this.A, "a*b"));
        this.C_aab = this.ActionH.getCoset(FreeWord.parsedWord(this.A, "a*a*b"));
    }

    protected void tearDown() throws Exception {
        this.A = null;
        this.G = null;
        this.H = null;
        this.T = null;
        this.ActionG = null;
        this.ActionG5 = null;
        this.ActionH = null;
        this.ActionT4 = null;
        this.C_0 = null;
        this.C_a = null;
        this.C_aa = null;
        this.C_b = null;
        this.C_ab = null;
        this.C_aab = null;
        this.a = null;
        this.a_1 = null;
        this.b = null;
        this.b_1 = null;
        super.tearDown();
    }

    public void testGetSubgroupGenerators() {
        ArrayList empty = new ArrayList();
        Assert.assertEquals(empty, this.ActionH.getSubgroupGenerators());
        Assert.assertEquals(empty, this.ActionG.getSubgroupGenerators());
    }

    public void testGetSizeLimit() {
        Assert.assertEquals((int)100000, (int)this.ActionG.getSizeLimit());
        Assert.assertEquals((int)100000, (int)this.ActionH.getSizeLimit());
    }

    public void testGetNumberOfCosets() {
        Assert.assertEquals((int)60, (int)this.ActionG.size());
        Assert.assertEquals((int)3, (int)this.ActionT4.size());
        Assert.assertEquals((int)6, (int)this.ActionH.size());
        Assert.assertEquals((int)12, (int)this.ActionG5.size());
    }

    public void testGetTrivialCoset() {
        Coset c1 = this.ActionG.getTrivialCoset();
        Coset c2 = this.ActionG.getCoset("*");
        Assert.assertSame((Object)this.ActionG, c1.getAction());
        Assert.assertSame((Object)this.ActionG, c2.getAction());
        Assert.assertEquals(FreeWord.parsedWord(this.A, "*"), c1.getRepresentative());
        Assert.assertEquals(FreeWord.parsedWord(this.A, "*"), c2.getRepresentative());
        Assert.assertEquals((String)"*", (String)c1.toString());
        Assert.assertEquals((String)"*", (String)c2.toString());
        Assert.assertEquals(c1, c2);
        Assert.assertEquals((int)c1.hashCode(), (int)c2.hashCode());
    }

    public void testGetCoset() {
        Coset ab1 = this.ActionG.getCoset("a*b");
        Coset ab2 = this.ActionG.getCoset("a^4*b^-1");
        Assert.assertSame((Object)this.ActionG, ab1.getAction());
        Assert.assertSame((Object)this.ActionG, ab2.getAction());
        Assert.assertEquals(FreeWord.parsedWord(this.A, "a*b"), ab1.getRepresentative());
        Assert.assertEquals(FreeWord.parsedWord(this.A, "a*b"), ab2.getRepresentative());
        Assert.assertEquals((String)"a*b", (String)ab1.toString());
        Assert.assertEquals((String)"a*b", (String)ab2.toString());
        Assert.assertEquals(ab1, ab2);
        Assert.assertEquals((int)ab1.hashCode(), (int)ab2.hashCode());
    }

    public void testGetGroup() {
        Assert.assertSame((Object)this.G, this.ActionG.getGroup());
        Assert.assertSame((Object)this.H, this.ActionH.getGroup());
    }

    public void testGetSet() {
        LinkedList set = new LinkedList();
        Iterator iter = this.ActionH.domain();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        Assert.assertEquals((int)6, (int)set.size());
        Assert.assertTrue((boolean)set.contains(this.C_0));
        Assert.assertTrue((boolean)set.contains(this.C_a));
        Assert.assertTrue((boolean)set.contains(this.C_aa));
        Assert.assertTrue((boolean)set.contains(this.C_b));
        Assert.assertTrue((boolean)set.contains(this.C_ab));
        Assert.assertTrue((boolean)set.contains(this.C_aab));
    }

    public void testApply() {
        Assert.assertEquals((Object)this.C_a, this.ActionH.apply(this.C_0, this.a));
        Assert.assertEquals((Object)this.C_aa, this.ActionH.apply(this.C_a, this.a));
        Assert.assertEquals((Object)this.C_0, this.ActionH.apply(this.C_aa, this.a));
        Assert.assertEquals((Object)this.C_ab, this.ActionH.apply(this.C_b, this.a));
        Assert.assertEquals((Object)this.C_aab, this.ActionH.apply(this.C_ab, this.a));
        Assert.assertEquals((Object)this.C_b, this.ActionH.apply(this.C_aab, this.a));
        Assert.assertEquals((Object)this.C_aa, this.ActionH.apply(this.C_0, this.a_1));
        Assert.assertEquals((Object)this.C_0, this.ActionH.apply(this.C_a, this.a_1));
        Assert.assertEquals((Object)this.C_a, this.ActionH.apply(this.C_aa, this.a_1));
        Assert.assertEquals((Object)this.C_aab, this.ActionH.apply(this.C_b, this.a_1));
        Assert.assertEquals((Object)this.C_b, this.ActionH.apply(this.C_ab, this.a_1));
        Assert.assertEquals((Object)this.C_ab, this.ActionH.apply(this.C_aab, this.a_1));
        Assert.assertEquals((Object)this.C_b, this.ActionH.apply(this.C_0, this.b));
        Assert.assertEquals((Object)this.C_ab, this.ActionH.apply(this.C_a, this.b));
        Assert.assertEquals((Object)this.C_aab, this.ActionH.apply(this.C_aa, this.b));
        Assert.assertEquals((Object)this.C_0, this.ActionH.apply(this.C_b, this.b));
        Assert.assertEquals((Object)this.C_a, this.ActionH.apply(this.C_ab, this.b));
        Assert.assertEquals((Object)this.C_aa, this.ActionH.apply(this.C_aab, this.b));
        Assert.assertEquals((Object)this.C_b, this.ActionH.apply(this.C_0, this.b_1));
        Assert.assertEquals((Object)this.C_ab, this.ActionH.apply(this.C_a, this.b_1));
        Assert.assertEquals((Object)this.C_aab, this.ActionH.apply(this.C_aa, this.b_1));
        Assert.assertEquals((Object)this.C_0, this.ActionH.apply(this.C_b, this.b_1));
        Assert.assertEquals((Object)this.C_a, this.ActionH.apply(this.C_ab, this.b_1));
        Assert.assertEquals((Object)this.C_aa, this.ActionH.apply(this.C_aab, this.b_1));
        Assert.assertEquals((Object)this.C_ab, this.ActionH.apply(this.C_0, FreeWord.parsedWord(this.A, "a^2*b^-1*a^-1")));
    }
}

