/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import org.gavrog.jane.fpgroups.CosetAction;
import org.gavrog.jane.fpgroups.FreeWord;

public class Coset<E, D> {
    private final CosetAction<E, D> action;
    private final int index;
    private final FreeWord<E> representative;

    Coset(CosetAction<E, D> cosetAction, int n) {
        if (n < 1 || n > cosetAction.size()) {
            throw new IllegalArgumentException("no such coset index");
        }
        this.action = cosetAction;
        this.index = n;
        this.representative = this.action.cosetRepresentatives[n];
    }

    public CosetAction<E, D> getAction() {
        return this.action;
    }

    int getIndex() {
        return this.index;
    }

    public FreeWord<E> getRepresentative() {
        return this.representative;
    }

    public boolean equals(Coset<?, ?> coset) {
        return this.getAction() == coset.getAction() && this.getIndex() == coset.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof Coset) {
            return this.equals((Coset)object);
        }
        return false;
    }

    public int hashCode() {
        return this.getAction().hashCode() * 37 + this.getIndex();
    }

    public String toString() {
        return this.getRepresentative().toString();
    }
}

