/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.compounds;

import junit.framework.TestCase;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Whole;

public class TestMatrix
extends TestCase {
    private Matrix A;
    private Matrix B;
    private Matrix C;
    private Matrix R;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = new Matrix(new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}, {13, 14, 15, 16}}).mutableClone();
        this.B = new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}).mutableClone();
        this.C = new Matrix(new int[][]{{-1}, {-2}, {-3}, {-4}});
        this.R = new Matrix(new int[][]{{-1, -2, -3, -4}});
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAsDoubleArray() {
        double[][] a = new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}, {9.0, 10.0, 11.0, 12.0}, {13.0, 14.0, 15.0, 16.0}};
        double[][] b = this.A.asDoubleArray();
        TestMatrix.assertEquals((int)a.length, (int)b.length);
        TestMatrix.assertEquals((int)a[0].length, (int)b[0].length);
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[i].length) {
                TestMatrix.assertTrue((a[i][j] == b[i][j] ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
    }

    public void testInverse() {
        Matrix A = new Matrix(3, 3);
        A.set(0, 0, new FloatingPoint(0.8164965809277261));
        A.set(0, 1, new FloatingPoint(0.0));
        A.set(0, 2, new FloatingPoint(0.0));
        A.set(1, 0, new FloatingPoint(-0.47140452079103173));
        A.set(1, 1, new FloatingPoint(0.9428090415820632));
        A.set(1, 2, new FloatingPoint(0.0));
        A.set(2, 0, new FloatingPoint(-0.3333333333333335));
        A.set(2, 1, new FloatingPoint(-0.3333333333333332));
        A.set(2, 2, new FloatingPoint(1.0));
        FloatingPoint eps = new FloatingPoint(1.0E-12);
        Matrix D = (Matrix)Matrix.one(3).minus(A.times(A.inverse()));
        TestMatrix.assertTrue((boolean)D.norm().isLessOrEqual(eps));
    }

    public void testTriangulate() {
        this.testTriangulate(new Matrix(new int[][]{{13, 21}, {34, 55}}));
        this.testTriangulate(new Matrix(new int[][]{{-13, 21}, {34, 55}}));
        this.testTriangulate(new Matrix(new int[][]{{34, 55}, {13, 21}}));
        this.testTriangulate(new Matrix(new int[][]{{34, 55}, {-13, 21}}));
    }

    private void testTriangulate(Matrix A) {
        int j;
        IArithmetic det = A.get(0, 0).times(A.get(1, 1)).minus(A.get(1, 0).times(A.get(0, 1)));
        Matrix M = A.mutableClone();
        Matrix B = ((Matrix)A.one()).mutableClone();
        int sign = Matrix.triangulate(M, B, false, true);
        TestMatrix.assertEquals((Object)M, (Object)B.times(A));
        if (A.numberOfRows() == 2 && A.numberOfColumns() == 2) {
            TestMatrix.assertEquals((Object)det, (Object)M.get(0, 0).times(M.get(1, 1)).times(new Whole(sign)));
        }
        M = A.mutableClone();
        B = ((Matrix)A.one()).mutableClone();
        sign = Matrix.triangulate(M, B, true, true);
        int i = 0;
        while (i < M.numberOfColumns()) {
            j = 0;
            while (j < M.numberOfRows()) {
                TestMatrix.assertTrue((boolean)(M.get(i, j) instanceof Whole));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < B.numberOfColumns()) {
            j = 0;
            while (j < B.numberOfRows()) {
                TestMatrix.assertTrue((boolean)(B.get(i, j) instanceof Whole));
                ++j;
            }
            ++i;
        }
        TestMatrix.assertEquals((Object)M, (Object)B.times(A));
        if (A.numberOfRows() == 2 && A.numberOfColumns() == 2) {
            TestMatrix.assertEquals((Object)det, (Object)M.get(0, 0).times(M.get(1, 1)).times(new Whole(sign)));
        }
    }

    public void testRank() {
        TestMatrix.assertEquals((int)2, (int)new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}).rank());
        TestMatrix.assertEquals((int)3, (int)new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {8, 8, 9}}).rank());
    }

    public void testDeterminant() {
        TestMatrix.assertEquals((Object)Whole.ZERO, (Object)new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}).determinant());
        TestMatrix.assertEquals((Object)new Whole(-3L), (Object)new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {8, 8, 9}}).determinant());
    }

    public void testSolve() {
        Matrix A1 = new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}});
        Matrix A2 = new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {8, 8, 9}});
        Matrix b1 = new Matrix(new int[][]{{6}, {15}, {24}});
        Matrix b2 = new Matrix(new int[][]{{6}, {15}, {25}});
        this.testSolve(A1, b1, true);
        this.testSolve(A1, b2, false);
        this.testSolve(A2, b1, true);
        this.testSolve(A2, b2, true);
    }

    private void testSolve(Matrix A, Matrix b, boolean hasSolution) {
        Matrix A_saved = (Matrix)A.clone();
        Matrix b_saved = (Matrix)b.clone();
        Matrix x = Matrix.solve(A, b);
        TestMatrix.assertEquals((Object)A, (Object)A_saved);
        TestMatrix.assertEquals((Object)b, (Object)b_saved);
        if (hasSolution) {
            TestMatrix.assertNotNull((Object)x);
            TestMatrix.assertEquals((Object)b, (Object)A.times(x));
        } else {
            TestMatrix.assertNull((Object)x);
        }
    }

    public void testGetSubMatrix() {
        Matrix T = new Matrix(new int[][]{{10, 11, 12}, {14, 15, 16}});
        TestMatrix.assertEquals((Object)T, (Object)this.A.getSubMatrix(2, 1, 2, 3));
    }

    public void testGetMinor() {
        Matrix T = new Matrix(new int[][]{{1, 3, 4}, {5, 7, 8}, {13, 15, 16}});
        TestMatrix.assertEquals((Object)T, (Object)this.A.getMinor(2, 1));
    }

    public void testSetSubMatrix() {
        Matrix T = new Matrix(new int[][]{{1, 2, 3, 4}, {1, 2, 3, 8}, {4, 5, 6, 12}, {7, 8, 9, 16}});
        this.A.setSubMatrix(1, 0, this.B);
        TestMatrix.assertEquals((Object)T, (Object)this.A);
    }

    public void testGetColumn() {
        Matrix T = new Matrix(new int[][]{{3}, {7}, {11}, {15}});
        TestMatrix.assertEquals((Object)T, (Object)this.A.getColumn(2));
    }

    public void testSetColumn() {
        Matrix T = new Matrix(new int[][]{{1, 2, -1, 4}, {5, 6, -2, 8}, {9, 10, -3, 12}, {13, 14, -4, 16}});
        this.A.setColumn(2, this.C);
        TestMatrix.assertEquals((Object)T, (Object)this.A);
        try {
            this.A.setRow(2, this.C);
            TestMatrix.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetRow() {
        Matrix T = new Matrix(new int[][]{{13, 14, 15, 16}});
        TestMatrix.assertEquals((Object)T, (Object)this.A.getRow(3));
    }

    public void testGetRows() {
        Matrix R0 = new Matrix(new int[][]{{1, 2, 3, 4}});
        Matrix R1 = new Matrix(new int[][]{{5, 6, 7, 8}});
        Matrix R2 = new Matrix(new int[][]{{9, 10, 11, 12}});
        Matrix R3 = new Matrix(new int[][]{{13, 14, 15, 16}});
        Matrix[] rows = this.A.getRows();
        TestMatrix.assertEquals((Object)R0, (Object)rows[0]);
        TestMatrix.assertEquals((Object)R1, (Object)rows[1]);
        TestMatrix.assertEquals((Object)R2, (Object)rows[2]);
        TestMatrix.assertEquals((Object)R3, (Object)rows[3]);
    }

    public void testSetRow() {
        Matrix T = new Matrix(new int[][]{{1, 2, 3, 4}, {-1, -2, -3, -4}, {9, 10, 11, 12}, {13, 14, 15, 16}});
        this.A.setRow(1, this.R);
        TestMatrix.assertEquals((Object)T, (Object)this.A);
        TestMatrix.assertEquals((Object)T, (Object)this.A);
        try {
            this.A.setColumn(2, this.R);
            TestMatrix.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

