/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.simple;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;

public class Stopwatch {
    private long accumulated = 0L;
    private long start = 0L;
    private boolean isRunning;
    private static boolean useCpuTime = true;
    private static final Map<String, Stopwatch> named = new HashMap<String, Stopwatch>();

    public static Stopwatch global(String name) {
        if (!named.containsKey(name)) {
            named.put(name, new Stopwatch());
        }
        return named.get(name);
    }

    private static long time() {
        ThreadMXBean tb;
        if (useCpuTime && (tb = ManagementFactory.getThreadMXBean()).isThreadCpuTimeSupported() && tb.isThreadCpuTimeEnabled()) {
            return tb.getCurrentThreadUserTime();
        }
        return System.nanoTime();
    }

    public String mode() {
        ThreadMXBean tb;
        if (useCpuTime && (tb = ManagementFactory.getThreadMXBean()).isThreadCpuTimeSupported() && tb.isThreadCpuTimeEnabled()) {
            return "ThreadMXBean::getCurrentThreadUserTime()";
        }
        return "System.nanoTime()";
    }

    public void start() {
        if (!this.isRunning) {
            this.start = Stopwatch.time();
            this.isRunning = true;
        }
    }

    public void stop() {
        if (this.isRunning) {
            this.accumulated += Stopwatch.time() - this.start;
            this.isRunning = false;
        }
    }

    public void reset() {
        this.accumulated = 0L;
        if (this.isRunning) {
            this.start = Stopwatch.time();
        }
    }

    public long elapsed() {
        return (this.accumulated + (this.isRunning ? Stopwatch.time() - this.start : 0L)) / 1000000L;
    }

    public String format() {
        return Stopwatch.format(this.elapsed());
    }

    public static String format(long milliseconds) {
        return String.valueOf((double)(milliseconds / 10L) / 100.0) + " seconds";
    }
}

