/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import buoy.widget.BScrollBar;
import buoy.widget.BScrollPane;
import buoy.widget.BTextArea;
import buoy.widget.Widget;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.SwingUtilities;

public class TextAreaOutputStream
extends OutputStream {
    private final BTextArea output;
    private final StringBuffer buffer = new StringBuffer(128);
    private final BScrollPane scrollPane;
    private final BScrollBar vscroll;
    private char last_seen = '\u0000';

    public TextAreaOutputStream() {
        this.output = new BTextArea(20, 40);
        this.scrollPane = new BScrollPane(this.output, BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_ALWAYS);
        this.scrollPane.setForceHeight(true);
        this.scrollPane.setForceWidth(true);
        this.vscroll = this.scrollPane.getVerticalScrollBar();
        this.scrollPane.setBackground(null);
    }

    public void write(int b) throws IOException {
        char c = (char)b;
        if (c == '\n' || c == '\r') {
            if (this.last_seen != '\r') {
                this.buffer.append('\n');
                this.flush();
            }
        } else if (c == '\t') {
            this.buffer.append(c);
        } else if (c < ' ') {
            this.buffer.append('^');
            this.buffer.append((char)(c + 64));
        } else if (!Character.isISOControl(c)) {
            this.buffer.append(c);
        }
        if (this.buffer.length() > 1023) {
            this.flush();
        }
        this.last_seen = c;
    }

    public void flush() {
        this.output.append(this.buffer.toString());
        this.buffer.delete(0, this.buffer.length());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextAreaOutputStream.this.vscroll.setValue(TextAreaOutputStream.this.vscroll.getMaximum());
            }
        });
    }

    public Widget getWidget() {
        return this.scrollPane;
    }
}

