/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetMouseEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import org.gavrog.box.gui.SliderBase;

public class RangeSlider
extends SliderBase {
    private double lo;
    private double hi;
    private double oldLo;
    private double oldHi;
    private boolean draggingLo;
    private boolean draggingHi;

    public RangeSlider(double lo, double hi, double min, double max) {
        this.min = min;
        this.max = Math.max(min, max);
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.setLow(lo);
        this.setHigh(hi);
    }

    public Dimension getPreferredSize() {
        int width = this.showValue ? 240 : 180;
        int height = this.showTicks ? 14 : 11;
        return new Dimension(width, height);
    }

    public void paint(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        if (g == null) {
            return;
        }
        g.setStroke(new BasicStroke(1.0f));
        this.clearCanvas(g);
        this.drawGuide(g);
        this.drawTicks(g);
        if (this.showValue) {
            this.showValue(g);
        }
        this.fillGuide(g, this.lo, this.hi);
        this.drawMarker(g, this.lo);
        this.drawMarker(g, this.hi);
    }

    protected void showValue(Graphics2D g) {
        Font f = new Font("Verdana", 0, 10);
        g.setFont(f);
        g.setColor(new Color(0.0f, 0.4f, 0.6f));
        String s = this.lo == (double)((int)this.lo) && this.hi == (double)((int)this.hi) ? String.format("%d:%d", (int)this.lo, (int)this.hi) : String.format("%.2f:%.2f", this.lo, this.hi);
        g.drawString(s, this.sliderWidth() + 8, 10);
    }

    protected int sliderWidth() {
        return this.getBounds().width - 7 - (this.showValue ? 60 : 0);
    }

    protected void mousePressed(MousePressedEvent ev) {
        this.draggingHi = false;
        this.draggingLo = false;
        this.oldLo = this.lo;
        this.oldHi = this.hi;
        this.mouseDragged(ev);
    }

    protected void mouseDragged(WidgetMouseEvent ev) {
        int x = ev.getPoint().x;
        this.decide(x);
        if (this.draggingHi) {
            this.setHigh(this.xToValue(x));
        } else if (this.draggingLo) {
            this.setLow(this.xToValue(x));
        }
    }

    protected void decide(int x) {
        if (this.draggingLo || this.draggingHi) {
            return;
        }
        int xlo = this.valueToX(this.lo);
        int xhi = this.valueToX(this.hi);
        if (x < xlo || xhi > xlo && 3 * x < 2 * xlo + xhi) {
            this.draggingLo = true;
        } else if (x > xhi + 5 || xhi > xlo && 3 * x > xlo + 2 * xhi) {
            this.draggingHi = true;
        }
    }

    protected void mouseReleased(MouseReleasedEvent ev) {
        Point pos = ev.getPoint();
        if (this.lo != this.oldLo || this.hi != this.oldHi) {
            this.dispatchEvent(new ValueChangedEvent(this));
        }
    }

    public double getLow() {
        return this.lo;
    }

    public double getHigh() {
        return this.hi;
    }

    public void setLow(double newValue) {
        this.lo = newValue;
        if (this.snapInterval > 0.0) {
            this.lo = (double)Math.round((this.lo - this.min) / this.snapInterval) * this.snapInterval + this.min;
        }
        if (this.lo < this.min) {
            this.lo = this.min;
        }
        if (this.lo > this.hi) {
            this.lo = this.hi;
        }
        this.repaint();
    }

    public void setHigh(double newValue) {
        this.hi = newValue;
        if (this.snapInterval > 0.0) {
            this.hi = (double)Math.round((this.hi - this.min) / this.snapInterval) * this.snapInterval + this.min;
        }
        if (this.hi < this.lo) {
            this.hi = this.lo;
        }
        if (this.hi > this.max) {
            this.hi = this.max;
        }
        this.repaint();
    }
}

