/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Partition;

public class TestPartition
extends TestCase {
    private Partition<String> P;

    protected void setUp() throws Exception {
        super.setUp();
        this.P = new Partition();
        this.P.unite("apfel", "birne");
        this.P.unite("gurke", "zucchini");
        this.P.unite("kirsche", "birne");
        this.P.unite("apfel", "pfirsich");
        this.P.unite("zucchini", "paprika");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.P = null;
    }

    public void testClone() {
        Object Q = this.P.clone();
        Assert.assertEquals(this.P.representativeMap(), ((Partition)Q).representativeMap());
    }

    public void testFind() {
        String s1 = "auto";
        String s2 = "kirsche";
        Assert.assertSame((Object)s1, (Object)this.P.find(s1));
        Assert.assertSame((Object)this.P.find(s2), (Object)this.P.find(this.P.find(s2)));
    }

    public void testAreEquivalent() {
        Assert.assertTrue((boolean)this.P.areEquivalent("kirsche", "pfirsich"));
        Assert.assertTrue((boolean)this.P.areEquivalent("gurke", "paprika"));
        Assert.assertFalse((boolean)this.P.areEquivalent("gurke", "kirsche"));
        Assert.assertFalse((boolean)this.P.areEquivalent("gurke", "auto"));
    }

    public void testRepresentativeMap() {
        String[] entries = new String[]{"apfel", "birne", "gurke", "zucchini", "kirsche", "pfirsich", "paprika"};
        Map<String, String> M = this.P.representativeMap();
        int i = 0;
        while (i < entries.length) {
            String key = entries[i];
            Assert.assertTrue((boolean)M.containsKey(key));
            Assert.assertSame((Object)M.get(key), (Object)this.P.find(key));
            ++i;
        }
        Assert.assertFalse((boolean)M.containsKey("auto"));
    }

    public void testNullEntry() {
        this.P.unite("apfel", null);
        Assert.assertEquals((String)this.P.find(null), (String)this.P.find(this.P.find(null)));
        Assert.assertTrue((boolean)this.P.areEquivalent("apfel", null));
        Assert.assertFalse((boolean)this.P.areEquivalent("gurke", null));
    }

    public void testClasses() {
        Set<String> class2;
        Set<String> class1;
        List<Set<String>> classes = Iterators.asList(this.P.classes());
        TestPartition.assertEquals((int)2, (int)classes.size());
        if (classes.get(0).contains("apfel")) {
            class1 = classes.get(0);
            class2 = classes.get(1);
        } else {
            class1 = classes.get(1);
            class2 = classes.get(0);
        }
        TestPartition.assertEquals((int)4, (int)class1.size());
        TestPartition.assertTrue((boolean)class1.contains("apfel"));
        TestPartition.assertTrue((boolean)class1.contains("birne"));
        TestPartition.assertTrue((boolean)class1.contains("kirsche"));
        TestPartition.assertTrue((boolean)class1.contains("pfirsich"));
        TestPartition.assertEquals((int)3, (int)class2.size());
        TestPartition.assertTrue((boolean)class2.contains("gurke"));
        TestPartition.assertTrue((boolean)class2.contains("zucchini"));
        TestPartition.assertTrue((boolean)class2.contains("paprika"));
    }
}

