/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Partition<E> {
    private HashMap<E, Integer> index = new HashMap();
    private ArrayList<E> value = new ArrayList();
    private ArrayList<Integer> dad = new ArrayList();
    private ArrayList<Integer> rnk = new ArrayList();

    public Partition<E> clone() {
        Partition<E> partition = new Partition<E>();
        partition.index = new HashMap<E, Integer>(this.index);
        partition.value = new ArrayList<E>(this.value);
        partition.dad = new ArrayList<Integer>(this.dad);
        partition.rnk = new ArrayList<Integer>(this.rnk);
        return partition;
    }

    private int repIndex(E e) {
        int n;
        if (this.index.containsKey(e)) {
            int n2 = n = this.index.get(e).intValue();
            while (this.dad.get(n2) != null) {
                n2 = this.dad.get(n2);
            }
            while (this.dad.get(n) != null) {
                int n3 = this.dad.get(n);
                this.dad.set(n, n2);
                n = n3;
            }
        } else {
            n = this.value.size();
            this.index.put(e, n);
            this.value.add(e);
            this.dad.add(null);
            this.rnk.add(0);
        }
        return n;
    }

    public E find(E e) {
        if (this.index.containsKey(e)) {
            return this.value.get(this.repIndex(e));
        }
        return e;
    }

    public boolean areEquivalent(E e, E e2) {
        return this.find(e) == this.find(e2);
    }

    public void unite(E e, E e2) {
        int n;
        int n2 = this.repIndex(e);
        if (n2 != (n = this.repIndex(e2))) {
            if (this.rnk.get(n) > this.rnk.get(n2)) {
                int n3 = n2;
                n2 = n;
                n = n3;
            }
            this.dad.set(n, n2);
            this.rnk.set(n2, this.rnk.get(n2) + this.rnk.get(n) + 1);
            this.rnk.set(n, 0);
        }
    }

    public Map<E, E> representativeMap() {
        HashMap<E, E> hashMap = new HashMap<E, E>();
        for (E e : this.value) {
            hashMap.put(e, this.find(e));
        }
        return hashMap;
    }

    public Iterator<Set<E>> classes() {
        HashMap hashMap = new HashMap();
        for (E e : this.value) {
            E e2 = this.find(e);
            if (!hashMap.containsKey(e2)) {
                hashMap.put(e2, new HashSet());
            }
            ((Set)hashMap.get(e2)).add(e);
        }
        return hashMap.values().iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("{\n");
        Iterator<Set<E>> iterator = this.classes();
        while (iterator.hasNext()) {
            Set<E> set = iterator.next();
            stringBuffer.append("  {");
            boolean bl = true;
            for (E e : set) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(e);
            }
            stringBuffer.append("},\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

