/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Pair;

public final class Iterators {
    private Iterators() {
    }

    public static <E> IteratorAdapter<E> empty() {
        return new IteratorAdapter<E>(){

            @Override
            protected E findNext() throws NoSuchElementException {
                throw new NoSuchElementException("at end");
            }
        };
    }

    public static <E> IteratorAdapter<E> singleton(final E e) {
        return new IteratorAdapter<E>(){
            private boolean done = false;

            @Override
            protected E findNext() throws NoSuchElementException {
                if (this.done) {
                    throw new NoSuchElementException("at end");
                }
                this.done = true;
                return e;
            }
        };
    }

    public static IteratorAdapter<Integer> range(final int n, final int n2) {
        return new IteratorAdapter<Integer>(){
            private int next;
            {
                this.next = n;
            }

            @Override
            protected Integer findNext() throws NoSuchElementException {
                if (this.next >= n2) {
                    throw new NoSuchElementException("at end");
                }
                return this.next++;
            }
        };
    }

    public static <A, B> IteratorAdapter<Pair<A, B>> cantorProduct(final Iterator<A> iterator, final Iterator<B> iterator2) {
        if (iterator == iterator2) {
            throw new UnsupportedOperationException("identical iterators");
        }
        return new IteratorAdapter<Pair<A, B>>(){
            final LinkedList<A> cacheA = new LinkedList();
            final LinkedList<B> cacheB = new LinkedList();
            Iterator<A> iterA = Iterators.empty();
            Iterator<B> iterB = Iterators.empty();

            @Override
            protected Pair<A, B> findNext() throws NoSuchElementException {
                if (!this.iterA.hasNext()) {
                    if (iterator.hasNext()) {
                        this.cacheA.addLast(iterator.next());
                    } else {
                        this.cacheB.removeLast();
                    }
                    if (iterator2.hasNext()) {
                        this.cacheB.addFirst(iterator2.next());
                    } else {
                        this.cacheA.removeFirst();
                    }
                    this.iterA = this.cacheA.iterator();
                    this.iterB = this.cacheB.iterator();
                }
                if (this.iterA.hasNext() && this.iterB.hasNext()) {
                    return new Pair(this.iterA.next(), this.iterB.next());
                }
                throw new NoSuchElementException("at end");
            }
        };
    }

    public static <E> IteratorAdapter<List<E>> permutations(final E[] EArray) {
        final int n = EArray.length;
        return new IteratorAdapter<List<E>>(){
            private int[] a = null;

            @Override
            protected List<E> findNext() throws NoSuchElementException {
                int n4;
                int n2;
                if (this.a == null) {
                    this.a = new int[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        this.a[n2] = n2;
                    }
                } else {
                    for (n2 = n - 2; n2 >= 0 && this.a[n2] >= this.a[n2 + 1]; --n2) {
                    }
                    if (n2 < 0) {
                        throw new NoSuchElementException("at end");
                    }
                    n4 = n - 1;
                    while (this.a[n4] <= this.a[n2]) {
                        --n4;
                    }
                    int n3 = this.a[n2];
                    this.a[n2] = this.a[n4];
                    this.a[n4] = n3;
                    ++n2;
                    for (n4 = n - 1; n2 < n4; ++n2, --n4) {
                        n3 = this.a[n2];
                        this.a[n2] = this.a[n4];
                        this.a[n4] = n3;
                    }
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                for (n4 = 0; n4 < n; ++n4) {
                    arrayList.add(EArray[this.a[n4]]);
                }
                return arrayList;
            }
        };
    }

    public static <E> IteratorAdapter<List<E>> combinations(final E[] EArray, final int n) {
        final int n2 = EArray.length;
        if (n2 < n) {
            throw new IllegalArgumentException("not enough objects to pick from");
        }
        return new IteratorAdapter<List<E>>(){
            private Iterator<List<Object>> perms = Iterators.empty();
            private final int[] a = new int[n];

            @Override
            protected List<E> findNext() throws NoSuchElementException {
                Object[] objectArray;
                if (!this.perms.hasNext()) {
                    int n4;
                    int n22;
                    if (this.a[1] == 0) {
                        for (n22 = 0; n22 < n; ++n22) {
                            this.a[n22] = n22;
                        }
                    } else {
                        for (n22 = n - 1; n22 >= 0 && n2 - this.a[n22] <= n - n22; --n22) {
                        }
                        if (n22 < 0) {
                            throw new NoSuchElementException("at end");
                        }
                        int n3 = n22;
                        this.a[n3] = this.a[n3] + 1;
                        for (n4 = n22 + 1; n4 < n; ++n4) {
                            this.a[n4] = this.a[n22] + n4 - n22;
                        }
                    }
                    objectArray = new Object[n];
                    for (n4 = 0; n4 < n; ++n4) {
                        objectArray[n4] = EArray[this.a[n4]];
                    }
                    this.perms = Iterators.permutations(objectArray);
                }
                objectArray = this.perms.next();
                return objectArray;
            }
        };
    }

    public static <E> IteratorAdapter<List<E>> selections(final E[] EArray, final int n) {
        final int n2 = EArray.length;
        return new IteratorAdapter<List<E>>(){
            int[] a = null;

            @Override
            protected List<E> findNext() throws NoSuchElementException {
                int n3;
                if (this.a == null) {
                    this.a = new int[n];
                    for (n3 = 0; n3 < n; ++n3) {
                        this.a[n3] = 0;
                    }
                } else {
                    for (n3 = n - 1; n3 >= 0 && this.a[n3] >= n2 - 1; --n3) {
                    }
                    if (n3 < 0) {
                        throw new NoSuchElementException("at end");
                    }
                    int n22 = n3;
                    this.a[n22] = this.a[n22] + 1;
                    while (n3 < n - 1) {
                        this.a[n3 + 1] = this.a[n3];
                        ++n3;
                    }
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(EArray[this.a[i]]);
                }
                return arrayList;
            }
        };
    }

    public static <E> boolean equal(Iterator<E> iterator, Iterator<?> iterator2) {
        block2: {
            do {
                if (iterator.hasNext() != iterator2.hasNext()) {
                    return false;
                }
                if (!iterator.hasNext()) break block2;
            } while (iterator.next().equals(iterator2.next()));
            return false;
        }
        return true;
    }

    public static <E> int size(Iterator<E> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public static <E> boolean contains(Iterator<E> iterator, E e) {
        if (e == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!e.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> List<E> asList(Iterator<E> iterator) {
        LinkedList<E> linkedList = new LinkedList<E>();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        return linkedList;
    }

    public static <E> void addAll(List<E> list, Iterator<? extends E> iterator) {
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
    }

    public static <E> int write(BufferedWriter bufferedWriter, Iterator<E> iterator, String string) throws IOException {
        int n = 0;
        if (iterator.hasNext()) {
            bufferedWriter.write(String.valueOf(iterator.next()));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            ++n;
        }
        while (iterator.hasNext()) {
            bufferedWriter.write(String.valueOf(iterator.next()));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            ++n;
        }
        return n;
    }

    public static <E> int print(PrintStream printStream, Iterator<E> iterator, String string) {
        int n = 0;
        while (iterator.hasNext()) {
            printStream.print(String.valueOf(iterator.next()));
            printStream.print(string);
            printStream.flush();
            ++n;
        }
        return n;
    }
}

