/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public abstract class IteratorAdapter<E>
implements Iterator<E>,
Iterable<E> {
    private Deque<E> cache = new LinkedList();

    protected abstract E findNext() throws NoSuchElementException;

    @Override
    public boolean hasNext() {
        if (this.cache.size() == 0) {
            try {
                this.cache.addLast(this.findNext());
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E next() {
        if (this.cache.size() == 0) {
            return this.findNext();
        }
        return this.cache.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }
}

