/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.collections;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.gavrog.box.collections.CacheMissException;

public class Cache<K, V> {
    private final Map<K, SoftReference<V>> content = new HashMap<K, SoftReference<V>>();

    public void clear() {
        this.content.clear();
    }

    public V get(K k) {
        V v;
        SoftReference<V> softReference = this.content.get(k);
        if (softReference != null && (v = softReference.get()) != null) {
            return v;
        }
        throw new CacheMissException();
    }

    public V put(K k, V v) {
        this.content.put(k, new SoftReference<V>(v));
        return v;
    }

    public V remove(K k) {
        V v = null;
        try {
            v = this.get(k);
        }
        catch (CacheMissException cacheMissException) {
            // empty catch block
        }
        this.content.remove(k);
        return v;
    }
}

