/*
 * Decompiled with CFR 0.152.
 */
package buoy.xml;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class WidgetLocalization {
    private static HashSet localizedStringSet = new HashSet();
    private static ResourceBundle currentBundle;

    public static void addLocalizedString(String string) {
        localizedStringSet.add(new WeakIdentityReference(string));
    }

    public static void removeLocalizedString(String string) {
        localizedStringSet.remove(new WeakIdentityReference(string));
    }

    public static boolean isLocalizedString(String string) {
        return localizedStringSet.contains(new WeakIdentityReference(string));
    }

    static void setResourceBundle(ResourceBundle resourceBundle) {
        currentBundle = resourceBundle;
    }

    public static String[] getAllLocalizedStrings() {
        Iterator iterator = localizedStringSet.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object t = ((Reference)iterator.next()).get();
            if (t != null) {
                arrayList.add(t);
                continue;
            }
            iterator.remove();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Object getLocalizedString(String string) {
        if (currentBundle == null) {
            WidgetLocalization.addLocalizedString(string);
            return string;
        }
        try {
            return currentBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    private static class WeakIdentityReference
    extends WeakReference {
        private int hash;

        public WeakIdentityReference(Object object) {
            super(object);
            this.hash = object.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            object = ((Reference)object).get();
            Object t = this.get();
            if (t == null || object == null) {
                return false;
            }
            return t == object;
        }
    }
}

