/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.CommandEvent;
import buoy.event.EventSource;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BRadioButton;
import buoy.widget.BRadioButtonMenuItem;
import buoy.widget.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;

public class RadioButtonGroup
extends EventSource {
    private ArrayList buttons = new ArrayList();

    void add(BRadioButton button) {
        this.buttons.add(button);
        button.addEventLink(ValueChangedEvent.class, this);
    }

    void add(BRadioButtonMenuItem item) {
        this.buttons.add(item);
        item.addEventLink(CommandEvent.class, this);
    }

    void remove(int i) {
        EventSource button = (EventSource)this.buttons.get(i);
        if (button instanceof BRadioButton) {
            button.removeEventLink(ValueChangedEvent.class, this);
        } else {
            button.removeEventLink(CommandEvent.class, this);
        }
        this.buttons.remove(i);
    }

    public Object getSelection() {
        int i = 0;
        while (i < this.buttons.size()) {
            if (this.getState(i)) {
                return this.buttons.get(i);
            }
            ++i;
        }
        return null;
    }

    public void setSelection(Object sel) {
        int i = 0;
        while (i < this.buttons.size()) {
            boolean state;
            Widget radio = (Widget)this.buttons.get(i);
            boolean bl = state = radio == sel;
            if (radio instanceof BRadioButton) {
                ((JRadioButton)radio.getComponent()).setSelected(state);
            } else {
                ((JRadioButtonMenuItem)radio.getComponent()).setSelected(state);
            }
            ++i;
        }
    }

    public Iterator getRadioButtons() {
        return this.buttons.iterator();
    }

    public int getRadioButtonCount() {
        return this.buttons.size();
    }

    public Object getRadioButton(int i) {
        return this.buttons.get(i);
    }

    private boolean getState(int i) {
        Object button = this.buttons.get(i);
        if (button instanceof BRadioButton) {
            return ((BRadioButton)button).getState();
        }
        return ((BRadioButtonMenuItem)button).getState();
    }

    private void processEvent(WidgetEvent ev) {
        this.setSelection(ev.getWidget());
        this.dispatchEvent(new SelectionChangedEvent(ev.getWidget(), false));
    }
}

