/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.OverlayContainerDelegate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlayContainer
extends WidgetContainer {
    private ArrayList<Widget> children;
    private Dimension minSize;
    private Dimension prefSize;

    static {
        WidgetEncoder.setPersistenceDelegate(OverlayContainer.class, new OverlayContainerDelegate());
    }

    public OverlayContainer() {
        this.component = new WidgetContainerPanel(this);
        this.children = new ArrayList();
    }

    @Override
    public JPanel getComponent() {
        return (JPanel)this.component;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    public Widget getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public Collection<Widget> getChildren() {
        return new ArrayList<Widget>(this.children);
    }

    public int getChildIndex(Widget widget) {
        return this.children.indexOf(widget);
    }

    @Override
    public void layoutChildren() {
        Rectangle bounds = this.getBounds();
        int i = 0;
        while (i < this.children.size()) {
            Widget child = this.children.get(i);
            Dimension max = child.getMaximumSize();
            child.getComponent().setBounds(new Rectangle(0, 0, Math.min(bounds.width, max.width), Math.min(bounds.height, max.height)));
            if (child instanceof WidgetContainer) {
                ((WidgetContainer)child).layoutChildren();
            }
            ++i;
        }
    }

    public void add(Widget widget, int index) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.children.add(index, widget);
        this.getComponent().add(widget.getComponent(), index);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public void add(Widget widget) {
        this.add(widget, 0);
    }

    @Override
    public void remove(Widget widget) {
        int index = this.children.indexOf(widget);
        if (index > -1) {
            this.getComponent().remove(widget.getComponent());
            this.children.remove(index);
            this.removeAsParent(widget);
            this.invalidateSize();
        }
    }

    @Override
    public void removeAll() {
        this.getComponent().removeAll();
        for (Widget w : this.children) {
            this.removeAsParent(w);
        }
        this.children.clear();
        this.invalidateSize();
    }

    public void setVisibleChild(int i) {
        int j = 0;
        while (j < this.children.size()) {
            this.children.get(j).setVisible(i == j);
            ++j;
        }
    }

    public void setVisibleChild(Widget child) {
        for (Widget w : this.children) {
            w.setVisible(w == child);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            this.minSize = new Dimension();
            for (Widget w : this.children) {
                Dimension size = w.getMinimumSize();
                if (size.width > this.minSize.width) {
                    this.minSize.width = size.width;
                }
                if (size.height <= this.minSize.height) continue;
                this.minSize.height = size.height;
            }
        }
        return this.minSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            this.prefSize = new Dimension();
            for (Widget w : this.children) {
                Dimension size = w.getPreferredSize();
                if (size.width > this.prefSize.width) {
                    this.prefSize.width = size.width;
                }
                if (size.height <= this.prefSize.height) continue;
                this.prefSize.height = size.height;
            }
        }
        return this.prefSize;
    }

    @Override
    protected void invalidateSize() {
        this.prefSize = null;
        this.minSize = null;
        super.invalidateSize();
    }
}

