/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.GridContainerDelegate;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class GridContainer
extends WidgetContainer {
    private Widget[][] child;
    private LayoutInfo defaultLayout;
    private LayoutInfo[][] childLayout;
    private int numRows;
    private int numCols;

    public GridContainer(int n, int n2) {
        this.component = new WidgetContainerPanel(this);
        this.child = new Widget[n][n2];
        this.childLayout = new LayoutInfo[n][n2];
        this.defaultLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
        this.numRows = n2;
        this.numCols = n;
    }

    @Override
    public JPanel getComponent() {
        return (JPanel)this.component;
    }

    @Override
    public int getChildCount() {
        int n = 0;
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public Collection<Widget> getChildren() {
        ArrayList<Widget> arrayList = new ArrayList<Widget>(this.numCols * this.numRows);
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                arrayList.add(this.child[i][j]);
            }
        }
        return arrayList;
    }

    public Widget getChild(int n, int n2) {
        return this.child[n][n2];
    }

    @Override
    public void layoutChildren() {
        int n;
        Dimension dimension = this.getComponent().getSize();
        int[] nArray = new int[this.numCols + 1];
        int[] nArray2 = new int[this.numRows + 1];
        double d = dimension.width / this.numCols;
        double d2 = dimension.height / this.numRows;
        for (n = 1; n < nArray.length; ++n) {
            nArray[n] = (int)((double)n * d);
        }
        for (n = 1; n < nArray2.length; ++n) {
            nArray2[n] = (int)((double)n * d2);
        }
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                Widget widget = this.child[i][j];
                LayoutInfo layoutInfo = this.childLayout[i][j];
                if (layoutInfo == null) {
                    layoutInfo = this.defaultLayout;
                }
                rectangle.x = nArray[i];
                rectangle.y = nArray2[j];
                rectangle.width = nArray[i + 1] - rectangle.x;
                rectangle.height = nArray2[j + 1] - rectangle.y;
                widget.getComponent().setBounds(layoutInfo.getWidgetLayout(widget, rectangle));
                if (!(widget instanceof WidgetContainer)) continue;
                ((WidgetContainer)widget).layoutChildren();
            }
        }
    }

    public void add(Widget widget, int n, int n2) {
        this.add(widget, n, n2, null);
    }

    public void add(Widget widget, int n, int n2, LayoutInfo layoutInfo) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        if (this.child[n][n2] != null) {
            this.remove(n, n2);
        }
        this.child[n][n2] = widget;
        this.childLayout[n][n2] = layoutInfo;
        this.getComponent().add(widget.getComponent());
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(int n, int n2) {
        return this.childLayout[n][n2];
    }

    public void setChildLayout(int n, int n2, LayoutInfo layoutInfo) {
        this.childLayout[n][n2] = layoutInfo;
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] != widget) continue;
                return this.childLayout[i][j];
            }
        }
        return null;
    }

    public void setChildLayout(Widget widget, LayoutInfo layoutInfo) {
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] != widget) continue;
                this.childLayout[i][j] = layoutInfo;
                this.invalidateSize();
                return;
            }
        }
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layoutInfo) {
        this.defaultLayout = layoutInfo;
        this.invalidateSize();
    }

    public int getRowCount() {
        return this.numRows;
    }

    public void setRowCount(int n) {
        if (n < this.numRows) {
            for (int i = 0; i < this.child.length; ++i) {
                for (int j = n; j < this.child[i].length; ++j) {
                    if (this.child[i][j] == null) continue;
                    this.remove(i, j);
                }
            }
        }
        Widget[][] widgetArray = new Widget[this.numCols][n];
        LayoutInfo[][] layoutInfoArray = new LayoutInfo[this.numCols][n];
        int n2 = Math.min(n, this.numRows);
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < n2; ++j) {
                widgetArray[i][j] = this.child[i][j];
                layoutInfoArray[i][j] = this.childLayout[i][j];
            }
        }
        this.child = widgetArray;
        this.childLayout = layoutInfoArray;
        this.numRows = n;
        this.invalidateSize();
    }

    public int getColumnCount() {
        return this.numCols;
    }

    public void setColumnCount(int n) {
        if (n < this.numCols) {
            for (int i = n; i < this.child.length; ++i) {
                for (int j = 0; j < this.child[i].length; ++j) {
                    if (this.child[i][j] == null) continue;
                    this.remove(i, j);
                }
            }
        }
        Widget[][] widgetArray = new Widget[n][this.numRows];
        LayoutInfo[][] layoutInfoArray = new LayoutInfo[n][this.numRows];
        int n2 = Math.min(n, this.numCols);
        for (int i = 0; i < n2; ++i) {
            widgetArray[i] = this.child[i];
            layoutInfoArray[i] = this.childLayout[i];
        }
        this.child = widgetArray;
        this.childLayout = layoutInfoArray;
        this.numCols = n;
        this.invalidateSize();
    }

    @Override
    public void remove(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] != widget) continue;
                this.getComponent().remove(widget.getComponent());
                this.removeAsParent(widget);
                this.child[i][j] = null;
                this.childLayout[i][j] = null;
                this.invalidateSize();
                return;
            }
        }
    }

    public void remove(int n, int n2) {
        this.getComponent().remove(this.child[n][n2].getComponent());
        this.removeAsParent(this.child[n][n2]);
        this.child[n][n2] = null;
        this.childLayout[n][n2] = null;
        this.invalidateSize();
    }

    @Override
    public void removeAll() {
        this.getComponent().removeAll();
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                this.removeAsParent(this.child[i][j]);
                this.child[i][j] = null;
                this.childLayout[i][j] = null;
            }
        }
        this.invalidateSize();
    }

    public Point getChildCell(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] != widget) continue;
                return new Point(i, j);
            }
        }
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                Dimension dimension = this.child[i][j].getMinimumSize();
                if (dimension.width > n) {
                    n = dimension.width;
                }
                if (dimension.height <= n2) continue;
                n2 = dimension.height;
            }
        }
        return new Dimension(n * this.numCols, n2 * this.numRows);
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                Widget widget = this.child[i][j];
                LayoutInfo layoutInfo = this.childLayout[i][j];
                if (layoutInfo == null) {
                    layoutInfo = this.defaultLayout;
                }
                Dimension dimension = layoutInfo.getPreferredSize(widget);
                if (dimension.width > n) {
                    n = dimension.width;
                }
                if (dimension.height <= n2) continue;
                n2 = dimension.height;
            }
        }
        return new Dimension(n * this.numCols, n2 * this.numRows);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(GridContainer.class, new GridContainerDelegate());
    }
}

