/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.BScrollPane;
import buoy.widget.TextWidget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.EventSourceDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class BTextArea
extends TextWidget {
    public static final WrapStyle WRAP_NONE = new WrapStyle();
    public static final WrapStyle WRAP_CHARACTER = new WrapStyle();
    public static final WrapStyle WRAP_WORD = new WrapStyle();

    public BTextArea() {
        this(null, 0, 0);
    }

    public BTextArea(String string) {
        this(string, 0, 0);
    }

    public BTextArea(int n, int n2) {
        this(null, n, n2);
    }

    public BTextArea(String string, int n, int n2) {
        this.component = this.createComponent();
        JTextArea jTextArea = this.getComponent();
        jTextArea.setText(string);
        jTextArea.setRows(n);
        jTextArea.setColumns(n2);
        jTextArea.addCaretListener(this.caretListener);
        jTextArea.getDocument().addDocumentListener(this.documentListener);
    }

    protected JTextArea createComponent() {
        return new JTextArea();
    }

    @Override
    public JTextArea getComponent() {
        return (JTextArea)this.component;
    }

    public int getRows() {
        return this.getComponent().getRows();
    }

    public void setRows(int n) {
        this.getComponent().setRows(n);
        this.invalidateSize();
    }

    public int getColumns() {
        return this.getComponent().getColumns();
    }

    public void setColumns(int n) {
        this.getComponent().setColumns(n);
        this.invalidateSize();
    }

    public int getLineCount() {
        return this.getComponent().getLineCount();
    }

    public WrapStyle getWrapStyle() {
        if (!this.getComponent().getLineWrap()) {
            return WRAP_NONE;
        }
        if (this.getComponent().getWrapStyleWord()) {
            return WRAP_WORD;
        }
        return WRAP_CHARACTER;
    }

    public void setWrapStyle(WrapStyle wrapStyle) {
        JTextArea jTextArea = this.getComponent();
        if (wrapStyle == WRAP_NONE) {
            jTextArea.setLineWrap(false);
        } else if (wrapStyle == WRAP_CHARACTER) {
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(false);
        } else if (wrapStyle == WRAP_WORD) {
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
        }
        this.invalidateSize();
    }

    public int getTabSize() {
        return this.getComponent().getTabSize();
    }

    public void setTabSize(int n) {
        this.getComponent().setTabSize(n);
    }

    public void append(String string) {
        try {
            ++this.suppressEvents;
            this.getComponent().append(string);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public void insert(String string, int n) {
        try {
            ++this.suppressEvents;
            this.getComponent().insert(string, n);
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceRange(String string, int n, int n2) {
        try {
            ++this.suppressEvents;
            this.getComponent().replaceRange(string, n, n2);
        }
        finally {
            --this.suppressEvents;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (this.getWrapStyle() != WRAP_NONE) {
            dimension.width = 0;
        }
        return dimension;
    }

    @Override
    protected void textChanged() {
        super.textChanged();
        if (this.getParent() instanceof BScrollPane) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BTextArea.this.getParent().layoutChildren();
                }
            });
        }
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BTextArea.class, new EventSourceDelegate(new String[]{"text"}));
        WidgetEncoder.setPersistenceDelegate(WrapStyle.class, new StaticFieldDelegate(BTextArea.class));
    }

    public static class WrapStyle {
        private WrapStyle() {
        }
    }
}

