/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;

public class BLabel
extends Widget {
    public static final Position CENTER = new Position(0);
    public static final Position NORTH = new Position(1);
    public static final Position SOUTH = new Position(2);
    public static final Position WEST = new Position(4);
    public static final Position EAST = new Position(8);
    public static final Position NORTHEAST = new Position(BLabel.NORTH.value + BLabel.EAST.value);
    public static final Position SOUTHEAST = new Position(BLabel.SOUTH.value + BLabel.EAST.value);
    public static final Position NORTHWEST = new Position(BLabel.NORTH.value + BLabel.WEST.value);
    public static final Position SOUTHWEST = new Position(BLabel.SOUTH.value + BLabel.WEST.value);

    public BLabel() {
        this((String)null, WEST);
    }

    public BLabel(String string) {
        this(string, WEST);
    }

    public BLabel(String string, Position position) {
        this.component = this.createComponent(string, null);
        this.setAlignment(position);
    }

    public BLabel(Icon icon) {
        this(icon, WEST);
    }

    public BLabel(Icon icon, Position position) {
        this.component = this.createComponent(null, icon);
        this.setAlignment(position);
    }

    public BLabel(String string, Icon icon, Position position, Position position2) {
        this.component = this.createComponent(string, icon);
        this.setAlignment(position);
        this.setTextPosition(position2);
    }

    protected JLabel createComponent(String string, Icon icon) {
        return new JLabel(string, icon, 4);
    }

    @Override
    public JLabel getComponent() {
        return (JLabel)this.component;
    }

    public String getText() {
        return this.getComponent().getText();
    }

    public void setText(String string) {
        this.getComponent().setText(string);
        this.invalidateSize();
    }

    public Icon getIcon() {
        return this.getComponent().getIcon();
    }

    public void setIcon(Icon icon) {
        this.getComponent().setIcon(icon);
        this.invalidateSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Position getAlignment() {
        int n = this.getComponent().getHorizontalAlignment();
        int n2 = this.getComponent().getVerticalAlignment();
        return Position.get(n, n2);
    }

    public void setAlignment(Position position) {
        int n = position.value;
        JLabel jLabel = this.getComponent();
        if ((n & BLabel.NORTH.value) != 0) {
            jLabel.setVerticalAlignment(1);
        } else if ((n & BLabel.SOUTH.value) != 0) {
            jLabel.setVerticalAlignment(3);
        } else {
            jLabel.setVerticalAlignment(0);
        }
        if ((n & BLabel.EAST.value) != 0) {
            jLabel.setHorizontalAlignment(4);
        } else if ((n & BLabel.WEST.value) != 0) {
            jLabel.setHorizontalAlignment(2);
        } else {
            jLabel.setHorizontalAlignment(0);
        }
        this.invalidateSize();
    }

    public Position getTextPosition() {
        int n = this.getComponent().getHorizontalTextPosition();
        int n2 = this.getComponent().getVerticalTextPosition();
        return Position.get(n, n2);
    }

    public void setTextPosition(Position position) {
        int n = position.value;
        JLabel jLabel = this.getComponent();
        if ((n & BLabel.NORTH.value) != 0) {
            jLabel.setVerticalTextPosition(1);
        } else if ((n & BLabel.SOUTH.value) != 0) {
            jLabel.setVerticalTextPosition(3);
        } else {
            jLabel.setVerticalTextPosition(0);
        }
        if ((n & BLabel.EAST.value) != 0) {
            jLabel.setHorizontalTextPosition(4);
        } else if ((n & BLabel.WEST.value) != 0) {
            jLabel.setHorizontalTextPosition(2);
        } else {
            jLabel.setHorizontalTextPosition(0);
        }
        this.invalidateSize();
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Position.class, new StaticFieldDelegate(BLabel.class));
    }

    public static class Position {
        protected int value;

        private Position(int n) {
            this.value = n;
        }

        private static Position get(int n, int n2) {
            switch (n) {
                case 2: {
                    switch (n2) {
                        case 1: {
                            return NORTHWEST;
                        }
                        case 3: {
                            return SOUTHWEST;
                        }
                    }
                    return WEST;
                }
                case 4: {
                    switch (n2) {
                        case 1: {
                            return NORTHEAST;
                        }
                        case 3: {
                            return SOUTHEAST;
                        }
                    }
                    return EAST;
                }
            }
            switch (n2) {
                case 1: {
                    return NORTH;
                }
                case 3: {
                    return SOUTH;
                }
            }
            return CENTER;
        }
    }
}

