/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.DocumentLinkEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class BDocumentViewer
extends Widget {
    public BDocumentViewer() {
        this.component = this.createComponent();
        JEditorPane jEditorPane = this.getComponent();
        jEditorPane.setEditable(false);
        jEditorPane.addPropertyChangeListener("page", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (BDocumentViewer.this.getComponent().isDisplayable()) {
                    BDocumentViewer.this.updateScrollPane();
                }
                BDocumentViewer.this.dispatchEvent(new ValueChangedEvent(BDocumentViewer.this));
            }
        });
        jEditorPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (BDocumentViewer.this.getComponent().isDisplayable()) {
                    BDocumentViewer.this.updateScrollPane();
                }
            }
        });
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BDocumentViewer.this.dispatchEvent(new DocumentLinkEvent(BDocumentViewer.this, hyperlinkEvent));
                }
            }
        });
    }

    public BDocumentViewer(URL uRL) throws IOException {
        this();
        this.setDocument(uRL);
    }

    protected JEditorPane createComponent() {
        return new JEditorPane();
    }

    @Override
    public JEditorPane getComponent() {
        return (JEditorPane)this.component;
    }

    public URL getDocument() {
        return this.getComponent().getPage();
    }

    public void setDocument(URL uRL) throws IOException {
        this.getComponent().setPage(uRL);
    }

    public void setDocument(String string, String string2) {
        this.getComponent().setContentType(string2);
        this.getComponent().setText(string);
    }

    public String getContentType() {
        return this.getComponent().getContentType();
    }

    public void processLinkEvent(DocumentLinkEvent documentLinkEvent) throws IOException {
        if (documentLinkEvent.getEvent() instanceof HTMLFrameHyperlinkEvent) {
            HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)documentLinkEvent.getEvent();
            ((HTMLDocument)this.getComponent().getDocument()).processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
        } else {
            this.setDocument(documentLinkEvent.getURL());
        }
    }

    protected void updateScrollPane() {
        this.invalidateSize();
        if (this.getParent() instanceof BScrollPane) {
            this.getParent().layoutChildren();
        }
    }
}

