from discrete_fuzzy_operators.base.generators.discrete_operator_counter import DiscreteOperatorCounter
from math import comb


class DiscreteNegationsCounter(DiscreteOperatorCounter):

    def __init__(self, n: int):
        """
        Initializes the object that counts all possible discrete negations over the finite chain Ln.

        Args:
            n: An integer, representing the dimension of the finite chain.
        """
        super(DiscreteNegationsCounter, self).__init__(n)
        self.n = n

    def count_operators(self) -> int:
        """
        Counts the number of discrete negations defined over the finite chain Ln.

        Returns:
            An integer, representing the cardinality of the set of discrete negations.
        """
        return comb(2*self.n-1, self.n)