"""Service interfaces and protocols for dependency injection."""

from typing import Any, Protocol


class ConfigService(Protocol):
    """Protocol for configuration service."""

    def get_printer_ip(self) -> str: ...
    def set_printer_ip(self, ip_address: str) -> None: ...
    def get_chars_per_line(self) -> int: ...
    def set_chars_per_line(self, chars_per_line: int) -> None: ...
    def get_enable_special_letters(self) -> bool: ...
    def set_enable_special_letters(self, enable: bool) -> None: ...
    def get_check_for_updates(self) -> bool: ...
    def set_check_for_updates(self, check: bool) -> None: ...
    def get_flask_port(self) -> int: ...
    def get_flask_secret_key(self) -> str: ...
    def get_gui_recent_templates(self) -> list[str]: ...
    def set_gui_recent_templates(self, templates: list[str]) -> None: ...


class TemplateService(Protocol):
    """Protocol for template service."""

    def get_template(self, name: str) -> dict[str, Any]: ...
    def list_templates(self) -> list[str]: ...
    def render_template(self, template_name: str, context: dict[str, Any]) -> list[dict[str, Any]]: ...


class PrinterService(Protocol):
    """Protocol for printer service."""

    def print_template(self, template_name: str, context: dict[str, Any]) -> None: ...
    def print_segments(self, segments: list[dict[str, Any]]) -> None: ...


class UpdateService(Protocol):
    """Protocol for update service."""

    def get_latest_version(self) -> str: ...
    def is_new_version_available(self, current_version: str) -> bool: ...
    def clear_cache(self) -> None: ...
