# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List


class Config(TeaModel):
    """
    Model for initing client
    """
    def __init__(
        self,
        access_key_id: str = None,
        access_key_secret: str = None,
        security_token: str = None,
        protocol: str = None,
        read_timeout: int = None,
        connect_timeout: int = None,
        http_proxy: str = None,
        https_proxy: str = None,
        endpoint: str = None,
        no_proxy: str = None,
        max_idle_conns: int = None,
        user_agent: str = None,
        socks_5proxy: str = None,
        socks_5net_work: str = None,
        max_idle_time_millis: int = None,
        keep_alive_duration_millis: int = None,
        max_requests: int = None,
        max_requests_per_host: int = None,
    ):
        # accesskey id
        self.access_key_id = access_key_id
        # accesskey secret
        self.access_key_secret = access_key_secret
        # security token
        self.security_token = security_token
        # http protocol
        self.protocol = protocol
        # read timeout
        self.read_timeout = read_timeout
        # connect timeout
        self.connect_timeout = connect_timeout
        # http proxy
        self.http_proxy = http_proxy
        # https proxy
        self.https_proxy = https_proxy
        # endpoint
        self.endpoint = endpoint
        # proxy white list
        self.no_proxy = no_proxy
        # max idle conns
        self.max_idle_conns = max_idle_conns
        # user agent
        self.user_agent = user_agent
        # socks5 proxy
        self.socks_5proxy = socks_5proxy
        # socks5 network
        self.socks_5net_work = socks_5net_work
        # 长链接最大空闲时长
        self.max_idle_time_millis = max_idle_time_millis
        # 长链接最大连接时长
        self.keep_alive_duration_millis = keep_alive_duration_millis
        # 最大连接数（长链接最大总数）
        self.max_requests = max_requests
        # 每个目标主机的最大连接数（分主机域名的长链接最大总数
        self.max_requests_per_host = max_requests_per_host

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key_secret is not None:
            result['accessKeySecret'] = self.access_key_secret
        if self.security_token is not None:
            result['securityToken'] = self.security_token
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.read_timeout is not None:
            result['readTimeout'] = self.read_timeout
        if self.connect_timeout is not None:
            result['connectTimeout'] = self.connect_timeout
        if self.http_proxy is not None:
            result['httpProxy'] = self.http_proxy
        if self.https_proxy is not None:
            result['httpsProxy'] = self.https_proxy
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.no_proxy is not None:
            result['noProxy'] = self.no_proxy
        if self.max_idle_conns is not None:
            result['maxIdleConns'] = self.max_idle_conns
        if self.user_agent is not None:
            result['userAgent'] = self.user_agent
        if self.socks_5proxy is not None:
            result['socks5Proxy'] = self.socks_5proxy
        if self.socks_5net_work is not None:
            result['socks5NetWork'] = self.socks_5net_work
        if self.max_idle_time_millis is not None:
            result['maxIdleTimeMillis'] = self.max_idle_time_millis
        if self.keep_alive_duration_millis is not None:
            result['keepAliveDurationMillis'] = self.keep_alive_duration_millis
        if self.max_requests is not None:
            result['maxRequests'] = self.max_requests
        if self.max_requests_per_host is not None:
            result['maxRequestsPerHost'] = self.max_requests_per_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKeySecret') is not None:
            self.access_key_secret = m.get('accessKeySecret')
        if m.get('securityToken') is not None:
            self.security_token = m.get('securityToken')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('readTimeout') is not None:
            self.read_timeout = m.get('readTimeout')
        if m.get('connectTimeout') is not None:
            self.connect_timeout = m.get('connectTimeout')
        if m.get('httpProxy') is not None:
            self.http_proxy = m.get('httpProxy')
        if m.get('httpsProxy') is not None:
            self.https_proxy = m.get('httpsProxy')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('noProxy') is not None:
            self.no_proxy = m.get('noProxy')
        if m.get('maxIdleConns') is not None:
            self.max_idle_conns = m.get('maxIdleConns')
        if m.get('userAgent') is not None:
            self.user_agent = m.get('userAgent')
        if m.get('socks5Proxy') is not None:
            self.socks_5proxy = m.get('socks5Proxy')
        if m.get('socks5NetWork') is not None:
            self.socks_5net_work = m.get('socks5NetWork')
        if m.get('maxIdleTimeMillis') is not None:
            self.max_idle_time_millis = m.get('maxIdleTimeMillis')
        if m.get('keepAliveDurationMillis') is not None:
            self.keep_alive_duration_millis = m.get('keepAliveDurationMillis')
        if m.get('maxRequests') is not None:
            self.max_requests = m.get('maxRequests')
        if m.get('maxRequestsPerHost') is not None:
            self.max_requests_per_host = m.get('maxRequestsPerHost')
        return self


class Attribute(TeaModel):
    def __init__(
        self,
        attribute_name: str = None,
        name: str = None,
    ):
        # 属性名
        self.attribute_name = attribute_name
        # 属性描述
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class TaskIdc(TeaModel):
    def __init__(
        self,
        idc_id: str = None,
        task_state: str = None,
    ):
        # 机房id
        self.idc_id = idc_id
        # 机房执行状态
        self.task_state = task_state

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.idc_id is not None:
            result['idc_id'] = self.idc_id
        if self.task_state is not None:
            result['task_state'] = self.task_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('idc_id') is not None:
            self.idc_id = m.get('idc_id')
        if m.get('task_state') is not None:
            self.task_state = m.get('task_state')
        return self


class SwitchoverAction(TeaModel):
    def __init__(
        self,
        dest_cell: str = None,
        source_cell: str = None,
    ):
        # 目标单元
        self.dest_cell = dest_cell
        # 来源单元
        self.source_cell = source_cell

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.dest_cell is not None:
            result['dest_cell'] = self.dest_cell
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dest_cell') is not None:
            self.dest_cell = m.get('dest_cell')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        return self


class Idc(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        id: str = None,
        name: str = None,
        preprod: bool = None,
    ):
        # 机房对应配置中心域名
        self.domain_name = domain_name
        # 机房id
        self.id = id
        # 机房名称
        self.name = name
        # 是否为预发环境
        self.preprod = preprod

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.domain_name is not None:
            result['domain_name'] = self.domain_name
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.preprod is not None:
            result['preprod'] = self.preprod
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain_name') is not None:
            self.domain_name = m.get('domain_name')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('preprod') is not None:
            self.preprod = m.get('preprod')
        return self


class ScheduleTask(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        cronexp: str = None,
        divide_count: int = None,
        id: str = None,
        max_load: int = None,
        name: str = None,
        priority: str = None,
        strategy_name: str = None,
        task_idcs: List[TaskIdc] = None,
        task_type: str = None,
    ):
        # 系统名称
        self.app_name = app_name
        # cron 表达式
        self.cronexp = cronexp
        # 任务拆分个数
        self.divide_count = divide_count
        # 任务id
        self.id = id
        # 任务加载上限
        self.max_load = max_load
        # 任务名称
        self.name = name
        # 调度任务优先级
        self.priority = priority
        # 关联的策略名称
        self.strategy_name = strategy_name
        # 调度任务关联的机房信息
        self.task_idcs = task_idcs
        # 调度任务类型
        self.task_type = task_type

    def validate(self):
        if self.task_idcs:
            for k in self.task_idcs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.cronexp is not None:
            result['cronexp'] = self.cronexp
        if self.divide_count is not None:
            result['divide_count'] = self.divide_count
        if self.id is not None:
            result['id'] = self.id
        if self.max_load is not None:
            result['max_load'] = self.max_load
        if self.name is not None:
            result['name'] = self.name
        if self.priority is not None:
            result['priority'] = self.priority
        if self.strategy_name is not None:
            result['strategy_name'] = self.strategy_name
        result['task_idcs'] = []
        if self.task_idcs is not None:
            for k in self.task_idcs:
                result['task_idcs'].append(k.to_map() if k else None)
        if self.task_type is not None:
            result['task_type'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('cronexp') is not None:
            self.cronexp = m.get('cronexp')
        if m.get('divide_count') is not None:
            self.divide_count = m.get('divide_count')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('max_load') is not None:
            self.max_load = m.get('max_load')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('strategy_name') is not None:
            self.strategy_name = m.get('strategy_name')
        self.task_idcs = []
        if m.get('task_idcs') is not None:
            for k in m.get('task_idcs'):
                temp_model = TaskIdc()
                self.task_idcs.append(temp_model.from_map(k))
        if m.get('task_type') is not None:
            self.task_type = m.get('task_type')
        return self


class Task(TeaModel):
    def __init__(
        self,
        cronexp: str = None,
        name: str = None,
        system: str = None,
    ):
        self.cronexp = cronexp
        self.name = name
        self.system = system

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cronexp is not None:
            result['cronexp'] = self.cronexp
        if self.name is not None:
            result['name'] = self.name
        if self.system is not None:
            result['system'] = self.system
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cronexp') is not None:
            self.cronexp = m.get('cronexp')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('system') is not None:
            self.system = m.get('system')
        return self


class Strategy(TeaModel):
    def __init__(
        self,
        name: str = None,
        related_task_count: int = None,
    ):
        # 调度策略名称
        self.name = name
        # 关联的调度任务数
        self.related_task_count = related_task_count

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.related_task_count is not None:
            result['related_task_count'] = self.related_task_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('related_task_count') is not None:
            self.related_task_count = m.get('related_task_count')
        return self


class ClientInfo(TeaModel):
    def __init__(
        self,
        ip: str = None,
    ):
        # 订阅客户端地址列表
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.ip is not None:
            result['ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        return self


class Resource(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        attributes: List[Attribute] = None,
        name: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        self.app_name = app_name
        self.attributes = attributes
        self.name = name
        self.region = region
        self.resource_id = resource_id

    def validate(self):
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        result['attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['attributes'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        self.attributes = []
        if m.get('attributes') is not None:
            for k in m.get('attributes'):
                temp_model = Attribute()
                self.attributes.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class KeyValueModel(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # key
        self.key = key
        # value
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class TransparentProxyPortPair(TeaModel):
    def __init__(
        self,
        default_value: int = None,
        end_port: int = None,
        start_port: int = None,
    ):
        # 是否是默认值
        self.default_value = default_value
        # 端口
        self.end_port = end_port
        # 起始端口
        self.start_port = start_port

    def validate(self):
        self.validate_required(self.end_port, 'end_port')
        self.validate_required(self.start_port, 'start_port')

    def to_map(self):
        result = dict()
        if self.default_value is not None:
            result['default_value'] = self.default_value
        if self.end_port is not None:
            result['end_port'] = self.end_port
        if self.start_port is not None:
            result['start_port'] = self.start_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('default_value') is not None:
            self.default_value = m.get('default_value')
        if m.get('end_port') is not None:
            self.end_port = m.get('end_port')
        if m.get('start_port') is not None:
            self.start_port = m.get('start_port')
        return self


class TransparentProxyIpPair(TeaModel):
    def __init__(
        self,
        default_value: int = None,
        start_ip: str = None,
        end_ip: str = None,
    ):
        # 是否是默认值
        self.default_value = default_value
        # 起始IP
        self.start_ip = start_ip
        # 终止IP
        self.end_ip = end_ip

    def validate(self):
        self.validate_required(self.start_ip, 'start_ip')
        self.validate_required(self.end_ip, 'end_ip')

    def to_map(self):
        result = dict()
        if self.default_value is not None:
            result['default_value'] = self.default_value
        if self.start_ip is not None:
            result['start_ip'] = self.start_ip
        if self.end_ip is not None:
            result['end_ip'] = self.end_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('default_value') is not None:
            self.default_value = m.get('default_value')
        if m.get('start_ip') is not None:
            self.start_ip = m.get('start_ip')
        if m.get('end_ip') is not None:
            self.end_ip = m.get('end_ip')
        return self


class BaseConditionModel(TeaModel):
    def __init__(
        self,
        field: str = None,
        operation: str = None,
        type: str = None,
        value: List[str] = None,
    ):
        # 匹配字段
        self.field = field
        # 操作符
        self.operation = operation
        # SYSTEM、CUSTOM系统字段还是自定义字段
        self.type = type
        # 匹配值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.field is not None:
            result['field'] = self.field
        if self.operation is not None:
            result['operation'] = self.operation
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('field') is not None:
            self.field = m.get('field')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ActionModel(TeaModel):
    def __init__(
        self,
        extension: str = None,
        type: str = None,
    ):
        # 拓展信息
        self.extension = extension
        # REJECT/PASS
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.extension is not None:
            result['extension'] = self.extension
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AuthRuleItemModel(TeaModel):
    def __init__(
        self,
        auth_rule_id: int = None,
        field: str = None,
        operation: str = None,
        value: str = None,
        changed_type: str = None,
    ):
        # 规则id
        self.auth_rule_id = auth_rule_id
        # 规则字段
        self.field = field
        # 操作类型(EQUAL,NOT_EQUAL,IN,NOT_INT,REGEX)
        self.operation = operation
        # 规则项的值
        self.value = value
        # 操作类型
        self.changed_type = changed_type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_rule_id is not None:
            result['auth_rule_id'] = self.auth_rule_id
        if self.field is not None:
            result['field'] = self.field
        if self.operation is not None:
            result['operation'] = self.operation
        if self.value is not None:
            result['value'] = self.value
        if self.changed_type is not None:
            result['changed_type'] = self.changed_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_rule_id') is not None:
            self.auth_rule_id = m.get('auth_rule_id')
        if m.get('field') is not None:
            self.field = m.get('field')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('changed_type') is not None:
            self.changed_type = m.get('changed_type')
        return self


class FaultInjectConfigModel(TeaModel):
    def __init__(
        self,
        fault_percent: str = None,
        code: str = None,
        fixed_delay: str = None,
    ):
        # 故障百分比
        self.fault_percent = fault_percent
        # 故障错误码
        self.code = code
        # 故障延迟时间（ms）
        self.fixed_delay = fixed_delay

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.fault_percent is not None:
            result['fault_percent'] = self.fault_percent
        if self.code is not None:
            result['code'] = self.code
        if self.fixed_delay is not None:
            result['fixed_delay'] = self.fixed_delay
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fault_percent') is not None:
            self.fault_percent = m.get('fault_percent')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('fixed_delay') is not None:
            self.fixed_delay = m.get('fixed_delay')
        return self


class TransparentProxyBound(TeaModel):
    def __init__(
        self,
        port_range: List[TransparentProxyPortPair] = None,
        ip_range: List[TransparentProxyIpPair] = None,
    ):
        # 端口段
        self.port_range = port_range
        # 网段
        self.ip_range = ip_range

    def validate(self):
        self.validate_required(self.port_range, 'port_range')
        if self.port_range:
            for k in self.port_range:
                if k:
                    k.validate()
        self.validate_required(self.ip_range, 'ip_range')
        if self.ip_range:
            for k in self.ip_range:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['port_range'] = []
        if self.port_range is not None:
            for k in self.port_range:
                result['port_range'].append(k.to_map() if k else None)
        result['ip_range'] = []
        if self.ip_range is not None:
            for k in self.ip_range:
                result['ip_range'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.port_range = []
        if m.get('port_range') is not None:
            for k in m.get('port_range'):
                temp_model = TransparentProxyPortPair()
                self.port_range.append(temp_model.from_map(k))
        self.ip_range = []
        if m.get('ip_range') is not None:
            for k in m.get('ip_range'):
                temp_model = TransparentProxyIpPair()
                self.ip_range.append(temp_model.from_map(k))
        return self


class KV(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # 键
        self.key = key
        # 值
        self.value = value

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class AuthRuleItemVO(TeaModel):
    def __init__(
        self,
        auth_rule_id: int = None,
        changed_type: str = None,
        field: str = None,
        operation: str = None,
        published_auth_rule_item: AuthRuleItemModel = None,
        type: str = None,
        value: str = None,
        id: int = None,
    ):
        # 规则id
        self.auth_rule_id = auth_rule_id
        # 操作类型
        self.changed_type = changed_type
        # 规则字段
        self.field = field
        # 操作类型(EQUAL,NOT_EQUAL,IN,NOT_INT,REGEX)
        self.operation = operation
        # AuthRuleItemModel
        self.published_auth_rule_item = published_auth_rule_item
        # 系统内置或者用户自定义 SYSTEM/CUSTOM
        self.type = type
        # 规则项的值
        self.value = value
        # id
        self.id = id

    def validate(self):
        if self.published_auth_rule_item:
            self.published_auth_rule_item.validate()
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_rule_id is not None:
            result['auth_rule_id'] = self.auth_rule_id
        if self.changed_type is not None:
            result['changed_type'] = self.changed_type
        if self.field is not None:
            result['field'] = self.field
        if self.operation is not None:
            result['operation'] = self.operation
        if self.published_auth_rule_item is not None:
            result['published_auth_rule_item'] = self.published_auth_rule_item.to_map()
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_rule_id') is not None:
            self.auth_rule_id = m.get('auth_rule_id')
        if m.get('changed_type') is not None:
            self.changed_type = m.get('changed_type')
        if m.get('field') is not None:
            self.field = m.get('field')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('published_auth_rule_item') is not None:
            temp_model = AuthRuleItemModel()
            self.published_auth_rule_item = temp_model.from_map(m['published_auth_rule_item'])
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class TransparentProxyRuleConfig(TeaModel):
    def __init__(
        self,
        in_bound: List[TransparentProxyBound] = None,
        out_bound: List[TransparentProxyBound] = None,
    ):
        # 入方向配置
        self.in_bound = in_bound
        # 出方向配置
        self.out_bound = out_bound

    def validate(self):
        self.validate_required(self.in_bound, 'in_bound')
        if self.in_bound:
            for k in self.in_bound:
                if k:
                    k.validate()
        self.validate_required(self.out_bound, 'out_bound')
        if self.out_bound:
            for k in self.out_bound:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['in_bound'] = []
        if self.in_bound is not None:
            for k in self.in_bound:
                result['in_bound'].append(k.to_map() if k else None)
        result['out_bound'] = []
        if self.out_bound is not None:
            for k in self.out_bound:
                result['out_bound'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.in_bound = []
        if m.get('in_bound') is not None:
            for k in m.get('in_bound'):
                temp_model = TransparentProxyBound()
                self.in_bound.append(temp_model.from_map(k))
        self.out_bound = []
        if m.get('out_bound') is not None:
            for k in m.get('out_bound'):
                temp_model = TransparentProxyBound()
                self.out_bound.append(temp_model.from_map(k))
        return self


class FaultInjectRuleItemModel(TeaModel):
    def __init__(
        self,
        rule_type: str = None,
        action: ActionModel = None,
        configs: FaultInjectConfigModel = None,
        traffic_conditions: List[BaseConditionModel] = None,
    ):
        # 规则类型 ABORT/DELAY
        self.rule_type = rule_type
        # 执行策略 拦截/监控
        self.action = action
        # 故障注入配置
        self.configs = configs
        # 流量匹配条件
        self.traffic_conditions = traffic_conditions

    def validate(self):
        if self.action:
            self.action.validate()
        if self.configs:
            self.configs.validate()
        if self.traffic_conditions:
            for k in self.traffic_conditions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.rule_type is not None:
            result['rule_type'] = self.rule_type
        if self.action is not None:
            result['action'] = self.action.to_map()
        if self.configs is not None:
            result['configs'] = self.configs.to_map()
        result['traffic_conditions'] = []
        if self.traffic_conditions is not None:
            for k in self.traffic_conditions:
                result['traffic_conditions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rule_type') is not None:
            self.rule_type = m.get('rule_type')
        if m.get('action') is not None:
            temp_model = ActionModel()
            self.action = temp_model.from_map(m['action'])
        if m.get('configs') is not None:
            temp_model = FaultInjectConfigModel()
            self.configs = temp_model.from_map(m['configs'])
        self.traffic_conditions = []
        if m.get('traffic_conditions') is not None:
            for k in m.get('traffic_conditions'):
                temp_model = BaseConditionModel()
                self.traffic_conditions.append(temp_model.from_map(k))
        return self


class DrmResourceWithoutAttributes(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_domain: str = None,
        resource_id: str = None,
        resource_version: str = None,
        type: str = None,
    ):
        # 应用名
        self.app_name = app_name
        # id
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 资源类描述
        self.name = name
        # 资源类所属的域
        self.region = region
        # Region.appName
        self.resource_domain = resource_domain
        # 资源id
        self.resource_id = resource_id
        # 资源版本号固定 3.0
        self.resource_version = resource_version
        # 资源类型，tpl 表示模板类型，normal 表示普通资源
        self.type = type

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_domain, 'resource_domain')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.resource_version, 'resource_version')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_domain is not None:
            result['resource_domain'] = self.resource_domain
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.resource_version is not None:
            result['resource_version'] = self.resource_version
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_domain') is not None:
            self.resource_domain = m.get('resource_domain')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('resource_version') is not None:
            self.resource_version = m.get('resource_version')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class RouterDestinationModel(TeaModel):
    def __init__(
        self,
        destination: List[BaseConditionModel] = None,
        weight: int = None,
    ):
        # 路由目标集合
        self.destination = destination
        # 权重
        self.weight = weight

    def validate(self):
        if self.destination:
            for k in self.destination:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['destination'] = []
        if self.destination is not None:
            for k in self.destination:
                result['destination'].append(k.to_map() if k else None)
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.destination = []
        if m.get('destination') is not None:
            for k in m.get('destination'):
                temp_model = BaseConditionModel()
                self.destination.append(temp_model.from_map(k))
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class BaseActionModel(TeaModel):
    def __init__(
        self,
        type: str = None,
        extension: str = None,
        enabled: bool = None,
    ):
        # 行为类型REJECT/PASS
        self.type = type
        # 扩展字段
        self.extension = extension
        # 开启状态
        self.enabled = enabled

    def validate(self):
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.extension is not None:
            result['extension'] = self.extension
        if self.enabled is not None:
            result['enabled'] = self.enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('extension') is not None:
            self.extension = m.get('extension')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        return self


class FaultToleranceConfigs(TeaModel):
    def __init__(
        self,
        exception_types: List[str] = None,
        time_window: int = None,
        least_window_count: int = None,
        max_ip_count: int = None,
        exception_rate_multiple: int = None,
        least_exception_rate: int = None,
    ):
        # 异常类型值
        self.exception_types = exception_types
        # 时间窗口
        self.time_window = time_window
        # 时间窗口内最少调用次数
        self.least_window_count = least_window_count
        # 最大隔离数量
        self.max_ip_count = max_ip_count
        # 异常比例倍数
        self.exception_rate_multiple = exception_rate_multiple
        # 异常比例阈值
        self.least_exception_rate = least_exception_rate

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.exception_types is not None:
            result['exception_types'] = self.exception_types
        if self.time_window is not None:
            result['time_window'] = self.time_window
        if self.least_window_count is not None:
            result['least_window_count'] = self.least_window_count
        if self.max_ip_count is not None:
            result['max_ip_count'] = self.max_ip_count
        if self.exception_rate_multiple is not None:
            result['exception_rate_multiple'] = self.exception_rate_multiple
        if self.least_exception_rate is not None:
            result['least_exception_rate'] = self.least_exception_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('exception_types') is not None:
            self.exception_types = m.get('exception_types')
        if m.get('time_window') is not None:
            self.time_window = m.get('time_window')
        if m.get('least_window_count') is not None:
            self.least_window_count = m.get('least_window_count')
        if m.get('max_ip_count') is not None:
            self.max_ip_count = m.get('max_ip_count')
        if m.get('exception_rate_multiple') is not None:
            self.exception_rate_multiple = m.get('exception_rate_multiple')
        if m.get('least_exception_rate') is not None:
            self.least_exception_rate = m.get('least_exception_rate')
        return self


class AuthRuleItemModelVO(TeaModel):
    def __init__(
        self,
        auth_rule_id: int = None,
        type: str = None,
        field: str = None,
        operation: str = None,
        value: str = None,
        id: int = None,
        operator: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # 所属鉴权规则id
        self.auth_rule_id = auth_rule_id
        # 类型
        self.type = type
        # 字段
        self.field = field
        # 操作方式
        self.operation = operation
        # 匹配值
        self.value = value
        # 主键
        self.id = id
        # 操作人
        self.operator = operator
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.auth_rule_id is not None:
            result['auth_rule_id'] = self.auth_rule_id
        if self.type is not None:
            result['type'] = self.type
        if self.field is not None:
            result['field'] = self.field
        if self.operation is not None:
            result['operation'] = self.operation
        if self.value is not None:
            result['value'] = self.value
        if self.id is not None:
            result['id'] = self.id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_rule_id') is not None:
            self.auth_rule_id = m.get('auth_rule_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('field') is not None:
            self.field = m.get('field')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class CircuitBreakerConfigModel(TeaModel):
    def __init__(
        self,
        error_percent_threshold: int = None,
        provider_timeout: int = None,
        request_volume_threshold: int = None,
        sleep_window: int = None,
        total_metric_window: int = None,
        rpc_timeout: int = None,
        average_rt_threshold: int = None,
    ):
        # 熔断错误比率条件
        self.error_percent_threshold = error_percent_threshold
        # 请求超时时间
        self.provider_timeout = provider_timeout
        # 发生熔断的总请求数
        self.request_volume_threshold = request_volume_threshold
        # 熔断之后时间窗口
        self.sleep_window = sleep_window
        # metric窗口
        self.total_metric_window = total_metric_window
        # rpc超时时间>0
        self.rpc_timeout = rpc_timeout
        # 平均RT阈值>0
        self.average_rt_threshold = average_rt_threshold

    def validate(self):
        self.validate_required(self.sleep_window, 'sleep_window')
        self.validate_required(self.total_metric_window, 'total_metric_window')

    def to_map(self):
        result = dict()
        if self.error_percent_threshold is not None:
            result['error_percent_threshold'] = self.error_percent_threshold
        if self.provider_timeout is not None:
            result['provider_timeout'] = self.provider_timeout
        if self.request_volume_threshold is not None:
            result['request_volume_threshold'] = self.request_volume_threshold
        if self.sleep_window is not None:
            result['sleep_window'] = self.sleep_window
        if self.total_metric_window is not None:
            result['total_metric_window'] = self.total_metric_window
        if self.rpc_timeout is not None:
            result['rpc_timeout'] = self.rpc_timeout
        if self.average_rt_threshold is not None:
            result['average_rt_threshold'] = self.average_rt_threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('error_percent_threshold') is not None:
            self.error_percent_threshold = m.get('error_percent_threshold')
        if m.get('provider_timeout') is not None:
            self.provider_timeout = m.get('provider_timeout')
        if m.get('request_volume_threshold') is not None:
            self.request_volume_threshold = m.get('request_volume_threshold')
        if m.get('sleep_window') is not None:
            self.sleep_window = m.get('sleep_window')
        if m.get('total_metric_window') is not None:
            self.total_metric_window = m.get('total_metric_window')
        if m.get('rpc_timeout') is not None:
            self.rpc_timeout = m.get('rpc_timeout')
        if m.get('average_rt_threshold') is not None:
            self.average_rt_threshold = m.get('average_rt_threshold')
        return self


class TransparentProxyProtocolVo(TeaModel):
    def __init__(
        self,
        max_req: int = None,
        port: int = None,
        protocol: str = None,
    ):
        # 最大请求数
        self.max_req = max_req
        # 端口
        self.port = port
        # 协议
        self.protocol = protocol

    def validate(self):
        self.validate_required(self.port, 'port')
        self.validate_required(self.protocol, 'protocol')

    def to_map(self):
        result = dict()
        if self.max_req is not None:
            result['max_req'] = self.max_req
        if self.port is not None:
            result['port'] = self.port
        if self.protocol is not None:
            result['protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('max_req') is not None:
            self.max_req = m.get('max_req')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        return self


class AuthRuleModelVO(TeaModel):
    def __init__(
        self,
        auth_rule_group_id: int = None,
        enabled: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: str = None,
        mode: str = None,
        name: str = None,
        rule_items: List[AuthRuleItemModelVO] = None,
        type: str = None,
    ):
        # 鉴权规则组id
        self.auth_rule_group_id = auth_rule_group_id
        # 规则开启状态。0关闭，1开启
        self.enabled = enabled
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # 主键
        self.id = id
        # 模式，观察者模式（OBSERVER），拦截模式（REJECT）
        self.mode = mode
        # 名称
        self.name = name
        # 鉴权规则配置项
        self.rule_items = rule_items
        # 类型。白名单（WHITELIST），黑名单（BLACKLIST）
        self.type = type

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.rule_items:
            for k in self.rule_items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.auth_rule_group_id is not None:
            result['auth_rule_group_id'] = self.auth_rule_group_id
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.mode is not None:
            result['mode'] = self.mode
        if self.name is not None:
            result['name'] = self.name
        result['rule_items'] = []
        if self.rule_items is not None:
            for k in self.rule_items:
                result['rule_items'].append(k.to_map() if k else None)
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_rule_group_id') is not None:
            self.auth_rule_group_id = m.get('auth_rule_group_id')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('name') is not None:
            self.name = m.get('name')
        self.rule_items = []
        if m.get('rule_items') is not None:
            for k in m.get('rule_items'):
                temp_model = AuthRuleItemModelVO()
                self.rule_items.append(temp_model.from_map(k))
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AuthRuleItem(TeaModel):
    def __init__(
        self,
        auth_rule_id: int = None,
        type: str = None,
        field: str = None,
        operation: str = None,
        value: str = None,
    ):
        # 所属的鉴权规则id
        self.auth_rule_id = auth_rule_id
        # 枚举类型
        # SYSTEM 表示系统内置字段
        # CUSTOM 表示用户自定义字段
        self.type = type
        # 匹配字段
        self.field = field
        # 操作符，通过 FormConfig 可以获取支持所有的操作符
        self.operation = operation
        # 匹配的值
        self.value = value

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.field, 'field')
        self.validate_required(self.operation, 'operation')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.auth_rule_id is not None:
            result['auth_rule_id'] = self.auth_rule_id
        if self.type is not None:
            result['type'] = self.type
        if self.field is not None:
            result['field'] = self.field
        if self.operation is not None:
            result['operation'] = self.operation
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_rule_id') is not None:
            self.auth_rule_id = m.get('auth_rule_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('field') is not None:
            self.field = m.get('field')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class BaseOrderDO(TeaModel):
    def __init__(
        self,
        key: str = None,
        dir: str = None,
    ):
        # 排序的字段名称
        self.key = key
        # 排序的关键字
        self.dir = dir

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.dir is not None:
            result['dir'] = self.dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('dir') is not None:
            self.dir = m.get('dir')
        return self


class RouterRuleModel(TeaModel):
    def __init__(
        self,
        conditions: List[BaseConditionModel] = None,
        destinations: List[RouterDestinationModel] = None,
        enabled: int = None,
        fallback: int = None,
        fault_protection: int = None,
        gmt_modified: int = None,
        grays: List[BaseConditionModel] = None,
        name: str = None,
        order_num: int = None,
        id: str = None,
    ):
        # [
        # {
        # "type":"system",
        # "field":"app.kubernetes.io/version",
        # "operation":"equal",
        # "value":[
        # "22"
        # ]
        # }
        # ]
        self.conditions = conditions
        # [
        # {
        # "weight":100,
        # "destination":[
        # {
        # "type":"system",
        # "field":"app.kubernetes.io/version",
        # "operation":"equal",
        # "value":[
        # "22"
        # ]
        # }
        # ]
        # }
        # ]
        self.destinations = destinations
        # 是否生效，1 生效，0 未生效。默认未生效
        self.enabled = enabled
        # fallback
        self.fallback = fallback
        # faultProtection
        self.fault_protection = fault_protection
        # 更新时间
        self.gmt_modified = gmt_modified
        # TreeSet<BaseConditionModel>
        self.grays = grays
        # 规则名
        self.name = name
        # 优先级
        self.order_num = order_num
        # 唯一UUID
        self.id = id

    def validate(self):
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()
        if self.destinations:
            for k in self.destinations:
                if k:
                    k.validate()
        if self.grays:
            for k in self.grays:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['conditions'] = []
        if self.conditions is not None:
            for k in self.conditions:
                result['conditions'].append(k.to_map() if k else None)
        result['destinations'] = []
        if self.destinations is not None:
            for k in self.destinations:
                result['destinations'].append(k.to_map() if k else None)
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.fallback is not None:
            result['fallback'] = self.fallback
        if self.fault_protection is not None:
            result['fault_protection'] = self.fault_protection
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        result['grays'] = []
        if self.grays is not None:
            for k in self.grays:
                result['grays'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.order_num is not None:
            result['order_num'] = self.order_num
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.conditions = []
        if m.get('conditions') is not None:
            for k in m.get('conditions'):
                temp_model = BaseConditionModel()
                self.conditions.append(temp_model.from_map(k))
        self.destinations = []
        if m.get('destinations') is not None:
            for k in m.get('destinations'):
                temp_model = RouterDestinationModel()
                self.destinations.append(temp_model.from_map(k))
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('fallback') is not None:
            self.fallback = m.get('fallback')
        if m.get('fault_protection') is not None:
            self.fault_protection = m.get('fault_protection')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        self.grays = []
        if m.get('grays') is not None:
            for k in m.get('grays'):
                temp_model = BaseConditionModel()
                self.grays.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('order_num') is not None:
            self.order_num = m.get('order_num')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class AuthRuleVO(TeaModel):
    def __init__(
        self,
        auth_rule_group_id: str = None,
        changed_item_cnt: int = None,
        changed_type: str = None,
        enabled: int = None,
        id: int = None,
        mode: str = None,
        name: str = None,
        rule_items: List[AuthRuleItemVO] = None,
    ):
        # 分组id
        self.auth_rule_group_id = auth_rule_group_id
        # changedItemCnt
        self.changed_item_cnt = changed_item_cnt
        # changed_type
        self.changed_type = changed_type
        # 是否生效，1 生效，0 未生效。默认未生效
        self.enabled = enabled
        # 规则id
        self.id = id
        # 模式
        self.mode = mode
        # 规则名
        self.name = name
        # 所有规则项
        self.rule_items = rule_items

    def validate(self):
        self.validate_required(self.id, 'id')
        if self.rule_items:
            for k in self.rule_items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.auth_rule_group_id is not None:
            result['auth_rule_group_id'] = self.auth_rule_group_id
        if self.changed_item_cnt is not None:
            result['changed_item_cnt'] = self.changed_item_cnt
        if self.changed_type is not None:
            result['changed_type'] = self.changed_type
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.id is not None:
            result['id'] = self.id
        if self.mode is not None:
            result['mode'] = self.mode
        if self.name is not None:
            result['name'] = self.name
        result['rule_items'] = []
        if self.rule_items is not None:
            for k in self.rule_items:
                result['rule_items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_rule_group_id') is not None:
            self.auth_rule_group_id = m.get('auth_rule_group_id')
        if m.get('changed_item_cnt') is not None:
            self.changed_item_cnt = m.get('changed_item_cnt')
        if m.get('changed_type') is not None:
            self.changed_type = m.get('changed_type')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('name') is not None:
            self.name = m.get('name')
        self.rule_items = []
        if m.get('rule_items') is not None:
            for k in m.get('rule_items'):
                temp_model = AuthRuleItemVO()
                self.rule_items.append(temp_model.from_map(k))
        return self


class CircuitRuleBaseConditionModel(TeaModel):
    def __init__(
        self,
        field: str = None,
        operation: str = None,
        type: str = None,
        value: List[str] = None,
    ):
        # 生效域
        self.field = field
        # 生效条件
        self.operation = operation
        # 类型
        self.type = type
        # 值
        self.value = value

    def validate(self):
        self.validate_required(self.field, 'field')
        self.validate_required(self.operation, 'operation')
        self.validate_required(self.type, 'type')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.field is not None:
            result['field'] = self.field
        if self.operation is not None:
            result['operation'] = self.operation
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('field') is not None:
            self.field = m.get('field')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class DrmAttribute(TeaModel):
    def __init__(
        self,
        attribute_name: str = None,
        data_id: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        parent: DrmResourceWithoutAttributes = None,
        parent_id: int = None,
    ):
        # 属性名，与代码中的成员变量名一致
        self.attribute_name = attribute_name
        # 资源id
        # 
        self.data_id = data_id
        # 属性id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 节点名称，显示在树形菜单上用的
        self.name = name
        # 属性所属的资源
        self.parent = parent
        # 父节点ID，冗余字段
        self.parent_id = parent_id

    def validate(self):
        if self.parent:
            self.parent.validate()

    def to_map(self):
        result = dict()
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.parent is not None:
            result['parent'] = self.parent.to_map()
        if self.parent_id is not None:
            result['parent_id'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('parent') is not None:
            temp_model = DrmResourceWithoutAttributes()
            self.parent = temp_model.from_map(m['parent'])
        if m.get('parent_id') is not None:
            self.parent_id = m.get('parent_id')
        return self


class FaultInjectRuleConfigModel(TeaModel):
    def __init__(
        self,
        method_name: str = None,
        http_method: str = None,
        http_path: str = None,
        traffic_type: str = None,
        resource: str = None,
        fault_inject_rule_items: List[FaultInjectRuleItemModel] = None,
    ):
        # 方法名
        self.method_name = method_name
        # 请求类型
        self.http_method = http_method
        # 请求路径
        self.http_path = http_path
        # 故障注入生效端（o:客户端生效/ i:服务端生效）
        self.traffic_type = traffic_type
        # 资源标识
        self.resource = resource
        # 配置项
        self.fault_inject_rule_items = fault_inject_rule_items

    def validate(self):
        if self.fault_inject_rule_items:
            for k in self.fault_inject_rule_items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.method_name is not None:
            result['method_name'] = self.method_name
        if self.http_method is not None:
            result['http_method'] = self.http_method
        if self.http_path is not None:
            result['http_path'] = self.http_path
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.resource is not None:
            result['resource'] = self.resource
        result['fault_inject_rule_items'] = []
        if self.fault_inject_rule_items is not None:
            for k in self.fault_inject_rule_items:
                result['fault_inject_rule_items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('method_name') is not None:
            self.method_name = m.get('method_name')
        if m.get('http_method') is not None:
            self.http_method = m.get('http_method')
        if m.get('http_path') is not None:
            self.http_path = m.get('http_path')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('resource') is not None:
            self.resource = m.get('resource')
        self.fault_inject_rule_items = []
        if m.get('fault_inject_rule_items') is not None:
            for k in m.get('fault_inject_rule_items'):
                temp_model = FaultInjectRuleItemModel()
                self.fault_inject_rule_items.append(temp_model.from_map(k))
        return self


class CellInfo(TeaModel):
    def __init__(
        self,
        cell: str = None,
        special_push: bool = None,
        value: str = None,
    ):
        # 单元
        self.cell = cell
        # 是否特别推送
        self.special_push = special_push
        # 推送值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cell is not None:
            result['cell'] = self.cell
        if self.special_push is not None:
            result['special_push'] = self.special_push
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('special_push') is not None:
            self.special_push = m.get('special_push')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class CircuitBreakerRuleItemModel(TeaModel):
    def __init__(
        self,
        rule_type: str = None,
        configs: CircuitBreakerConfigModel = None,
        traffic_conditions: List[BaseConditionModel] = None,
        action: BaseActionModel = None,
    ):
        # 熔断规则类型(取值avgRt，errorRatio)
        self.rule_type = rule_type
        # 熔断配置，和ruleType的值有关,
        # "ruleType": "avgRt",
        # "configs": {
        # "averageRtThreshold": 50,
        # "errorPercentThreshold": 50,
        # "requestVolumeThreshold": 10,
        # "sleepWindow": 1000,
        # "totalMetricWindow": 10
        # },
        self.configs = configs
        # "trafficConditions": [
        # {
        # "type": "system",
        # "field": "trafficType",
        # "operation": "EQUAL",
        # "value": [
        # "online"
        # ]
        # }
        # ]
        self.traffic_conditions = traffic_conditions
        # 熔断规则中Action,
        # "action": {
        # "type": "REJECT"
        # },
        self.action = action

    def validate(self):
        self.validate_required(self.rule_type, 'rule_type')
        self.validate_required(self.configs, 'configs')
        if self.configs:
            self.configs.validate()
        if self.traffic_conditions:
            for k in self.traffic_conditions:
                if k:
                    k.validate()
        self.validate_required(self.action, 'action')
        if self.action:
            self.action.validate()

    def to_map(self):
        result = dict()
        if self.rule_type is not None:
            result['rule_type'] = self.rule_type
        if self.configs is not None:
            result['configs'] = self.configs.to_map()
        result['traffic_conditions'] = []
        if self.traffic_conditions is not None:
            for k in self.traffic_conditions:
                result['traffic_conditions'].append(k.to_map() if k else None)
        if self.action is not None:
            result['action'] = self.action.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rule_type') is not None:
            self.rule_type = m.get('rule_type')
        if m.get('configs') is not None:
            temp_model = CircuitBreakerConfigModel()
            self.configs = temp_model.from_map(m['configs'])
        self.traffic_conditions = []
        if m.get('traffic_conditions') is not None:
            for k in m.get('traffic_conditions'):
                temp_model = BaseConditionModel()
                self.traffic_conditions.append(temp_model.from_map(k))
        if m.get('action') is not None:
            temp_model = BaseActionModel()
            self.action = temp_model.from_map(m['action'])
        return self


class CommunicationLabelModel(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
        type: int = None,
    ):
        # 关键字
        self.key = key
        # 值
        self.value = value
        # 类型(0-应用,1-标签)
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.value is not None:
            result['value'] = self.value
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AppMetaDataModel(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        url: str = None,
    ):
        # 应用名
        self.app_name = app_name
        # 应用打开链接
        self.url = url

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.url, 'url')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class FaultToleranceRuleItemModel(TeaModel):
    def __init__(
        self,
        enabled: str = None,
        scopes: List[str] = None,
        conditions: List[BaseConditionModel] = None,
        configs: FaultToleranceConfigs = None,
        actions: List[BaseActionModel] = None,
    ):
        # 是否启用(0-未启用1-启用2-部分启用)
        self.enabled = enabled
        # 暂时不用
        self.scopes = scopes
        # 流量管控规则
        self.conditions = conditions
        # 具体隔离规则配置
        self.configs = configs
        # 行为项(type取值DOWNGRADE隔离/NONE监控)
        self.actions = actions

    def validate(self):
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()
        if self.configs:
            self.configs.validate()
        if self.actions:
            for k in self.actions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.scopes is not None:
            result['scopes'] = self.scopes
        result['conditions'] = []
        if self.conditions is not None:
            for k in self.conditions:
                result['conditions'].append(k.to_map() if k else None)
        if self.configs is not None:
            result['configs'] = self.configs.to_map()
        result['actions'] = []
        if self.actions is not None:
            for k in self.actions:
                result['actions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('scopes') is not None:
            self.scopes = m.get('scopes')
        self.conditions = []
        if m.get('conditions') is not None:
            for k in m.get('conditions'):
                temp_model = BaseConditionModel()
                self.conditions.append(temp_model.from_map(k))
        if m.get('configs') is not None:
            temp_model = FaultToleranceConfigs()
            self.configs = temp_model.from_map(m['configs'])
        self.actions = []
        if m.get('actions') is not None:
            for k in m.get('actions'):
                temp_model = BaseActionModel()
                self.actions.append(temp_model.from_map(k))
        return self


class ConfigEntity(TeaModel):
    def __init__(
        self,
        value: str = None,
        desc_en: str = None,
        desc_cn: str = None,
    ):
        # 值
        self.value = value
        # 英文描述
        self.desc_en = desc_en
        # 中文描述
        self.desc_cn = desc_cn

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.desc_en, 'desc_en')
        self.validate_required(self.desc_cn, 'desc_cn')

    def to_map(self):
        result = dict()
        if self.value is not None:
            result['value'] = self.value
        if self.desc_en is not None:
            result['desc_en'] = self.desc_en
        if self.desc_cn is not None:
            result['desc_cn'] = self.desc_cn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('desc_en') is not None:
            self.desc_en = m.get('desc_en')
        if m.get('desc_cn') is not None:
            self.desc_cn = m.get('desc_cn')
        return self


class TransparentProxyAppConfig(TeaModel):
    def __init__(
        self,
        blacklist: TransparentProxyRuleConfig = None,
    ):
        # 黑名单配置
        self.blacklist = blacklist

    def validate(self):
        self.validate_required(self.blacklist, 'blacklist')
        if self.blacklist:
            self.blacklist.validate()

    def to_map(self):
        result = dict()
        if self.blacklist is not None:
            result['blacklist'] = self.blacklist.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('blacklist') is not None:
            temp_model = TransparentProxyRuleConfig()
            self.blacklist = temp_model.from_map(m['blacklist'])
        return self


class DowngradeRuleVo(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        group_id: int = None,
        downgrade_service: str = None,
        downgrade_method: str = None,
        rule_name: str = None,
        enabled: int = None,
        mode: str = None,
        downgrade_action: str = None,
        gmt_modified: str = None,
    ):
        # 主键
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 降级规则组id
        self.group_id = group_id
        # 降级服务
        self.downgrade_service = downgrade_service
        # 降级方法
        self.downgrade_method = downgrade_method
        # 规则描述
        self.rule_name = rule_name
        # 降级开关(0: 关闭 1: 开启)
        self.enabled = enabled
        # 运行模式
        self.mode = mode
        # 降级行为
        self.downgrade_action = downgrade_action
        # 更新时间
        self.gmt_modified = gmt_modified

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.downgrade_service, 'downgrade_service')
        self.validate_required(self.downgrade_method, 'downgrade_method')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.downgrade_action, 'downgrade_action')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.downgrade_service is not None:
            result['downgrade_service'] = self.downgrade_service
        if self.downgrade_method is not None:
            result['downgrade_method'] = self.downgrade_method
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.mode is not None:
            result['mode'] = self.mode
        if self.downgrade_action is not None:
            result['downgrade_action'] = self.downgrade_action
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('downgrade_service') is not None:
            self.downgrade_service = m.get('downgrade_service')
        if m.get('downgrade_method') is not None:
            self.downgrade_method = m.get('downgrade_method')
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('downgrade_action') is not None:
            self.downgrade_action = m.get('downgrade_action')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class TrafficMirrorConfigModel(TeaModel):
    def __init__(
        self,
        percent: int = None,
        amplification: int = None,
    ):
        # 百分比
        self.percent = percent
        # 放大倍数
        self.amplification = amplification

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.percent is not None:
            result['percent'] = self.percent
        if self.amplification is not None:
            result['amplification'] = self.amplification
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('percent') is not None:
            self.percent = m.get('percent')
        if m.get('amplification') is not None:
            self.amplification = m.get('amplification')
        return self


class SidecarInjectConfigModel(TeaModel):
    def __init__(
        self,
        type: str = None,
        strs: List[str] = None,
        kvs: List[KV] = None,
    ):
        # sidecar类型 支持inject_all，clusters，namespaces，labels，annotations
        self.type = type
        # 字符串数组
        self.strs = strs
        # kv键值对数组
        self.kvs = kvs

    def validate(self):
        if self.kvs:
            for k in self.kvs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.strs is not None:
            result['strs'] = self.strs
        result['kvs'] = []
        if self.kvs is not None:
            for k in self.kvs:
                result['kvs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('strs') is not None:
            self.strs = m.get('strs')
        self.kvs = []
        if m.get('kvs') is not None:
            for k in m.get('kvs'):
                temp_model = KV()
                self.kvs.append(temp_model.from_map(k))
        return self


class TransparentProxyOperatorLogVo(TeaModel):
    def __init__(
        self,
        id: int = None,
        modify_content: str = None,
        modify_name: str = None,
        modify_time: str = None,
        port: int = None,
    ):
        # 日志 ID
        self.id = id
        # 修改内容
        self.modify_content = modify_content
        # 操作人
        self.modify_name = modify_name
        # 操作时间
        self.modify_time = modify_time
        # 端口
        self.port = port

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.modify_content, 'modify_content')
        self.validate_required(self.modify_name, 'modify_name')
        self.validate_required(self.modify_time, 'modify_time')
        self.validate_required(self.port, 'port')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.modify_content is not None:
            result['modify_content'] = self.modify_content
        if self.modify_name is not None:
            result['modify_name'] = self.modify_name
        if self.modify_time is not None:
            result['modify_time'] = self.modify_time
        if self.port is not None:
            result['port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('modify_content') is not None:
            self.modify_content = m.get('modify_content')
        if m.get('modify_name') is not None:
            self.modify_name = m.get('modify_name')
        if m.get('modify_time') is not None:
            self.modify_time = m.get('modify_time')
        if m.get('port') is not None:
            self.port = m.get('port')
        return self


class Job(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        app: str = None,
        name: str = None,
        cron: str = None,
        sharding_count: int = None,
        custom_params: List[str] = None,
        status: str = None,
        des: str = None,
        creation_time: str = None,
        update_time: str = None,
    ):
        # 数据库ID
        self.id = id
        # 所属租户实例ID
        self.instance_id = instance_id
        # 任务所属APP
        self.app = app
        # 任务名字
        self.name = name
        # 任务CRON表达式
        self.cron = cron
        # 任务分片数量
        self.sharding_count = sharding_count
        # 任务自定义参数
        self.custom_params = custom_params
        # 任务状态
        self.status = status
        # 任务描述信息
        self.des = des
        # 任务创建时间
        self.creation_time = creation_time
        # 任务修改时间
        self.update_time = update_time

    def validate(self):
        if self.creation_time is not None:
            self.validate_pattern(self.creation_time, 'creation_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.update_time is not None:
            self.validate_pattern(self.update_time, 'update_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app is not None:
            result['app'] = self.app
        if self.name is not None:
            result['name'] = self.name
        if self.cron is not None:
            result['cron'] = self.cron
        if self.sharding_count is not None:
            result['sharding_count'] = self.sharding_count
        if self.custom_params is not None:
            result['custom_params'] = self.custom_params
        if self.status is not None:
            result['status'] = self.status
        if self.des is not None:
            result['des'] = self.des
        if self.creation_time is not None:
            result['creation_time'] = self.creation_time
        if self.update_time is not None:
            result['update_time'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('cron') is not None:
            self.cron = m.get('cron')
        if m.get('sharding_count') is not None:
            self.sharding_count = m.get('sharding_count')
        if m.get('custom_params') is not None:
            self.custom_params = m.get('custom_params')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('des') is not None:
            self.des = m.get('des')
        if m.get('creation_time') is not None:
            self.creation_time = m.get('creation_time')
        if m.get('update_time') is not None:
            self.update_time = m.get('update_time')
        return self


class ServiceRateLimitRule(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        data_id: str = None,
        enable: bool = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
        service_type: str = None,
    ):
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 是否启用
        self.enable = enable
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # 服务限制规则id
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 规则名
        self.name = name
        # 操作人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # 规则配置
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode
        # 服务框架类型
        self.service_type = service_type

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.enable is not None:
            result['enable'] = self.enable
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        if self.service_type is not None:
            result['service_type'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        return self


class SyncBucketAddResult(TeaModel):
    def __init__(
        self,
        cluster_task_id: str = None,
        cluster_task_status: str = None,
        source_cluster_id: str = None,
        target_cluster_id: str = None,
    ):
        # 集群同步任务id
        self.cluster_task_id = cluster_task_id
        # 集群同步任务状态
        self.cluster_task_status = cluster_task_status
        # 源集群id
        self.source_cluster_id = source_cluster_id
        # 目标集群id
        self.target_cluster_id = target_cluster_id

    def validate(self):
        self.validate_required(self.cluster_task_id, 'cluster_task_id')
        self.validate_required(self.cluster_task_status, 'cluster_task_status')
        self.validate_required(self.source_cluster_id, 'source_cluster_id')
        self.validate_required(self.target_cluster_id, 'target_cluster_id')

    def to_map(self):
        result = dict()
        if self.cluster_task_id is not None:
            result['cluster_task_id'] = self.cluster_task_id
        if self.cluster_task_status is not None:
            result['cluster_task_status'] = self.cluster_task_status
        if self.source_cluster_id is not None:
            result['source_cluster_id'] = self.source_cluster_id
        if self.target_cluster_id is not None:
            result['target_cluster_id'] = self.target_cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cluster_task_id') is not None:
            self.cluster_task_id = m.get('cluster_task_id')
        if m.get('cluster_task_status') is not None:
            self.cluster_task_status = m.get('cluster_task_status')
        if m.get('source_cluster_id') is not None:
            self.source_cluster_id = m.get('source_cluster_id')
        if m.get('target_cluster_id') is not None:
            self.target_cluster_id = m.get('target_cluster_id')
        return self


class RouterRuleGroupVO(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        rule_name: str = None,
        version: int = None,
        enabled: int = None,
        priority: int = None,
        gray_condition: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        operator: str = None,
        rules: List[RouterRuleModel] = None,
    ):
        # 主键
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 规则名称
        self.rule_name = rule_name
        # 版本号
        self.version = version
        # 1 开启/ 0 关闭
        self.enabled = enabled
        # 优先级
        self.priority = priority
        # 灰度条件
        self.gray_condition = gray_condition
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # 操作人
        self.operator = operator
        # 路由规则
        self.rules = rules

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        if self.version is not None:
            result['version'] = self.version
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.priority is not None:
            result['priority'] = self.priority
        if self.gray_condition is not None:
            result['gray_condition'] = self.gray_condition
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.operator is not None:
            result['operator'] = self.operator
        result['rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        if m.get('version') is not None:
            self.version = m.get('version')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('gray_condition') is not None:
            self.gray_condition = m.get('gray_condition')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        self.rules = []
        if m.get('rules') is not None:
            for k in m.get('rules'):
                temp_model = RouterRuleModel()
                self.rules.append(temp_model.from_map(k))
        return self


class ServiceRecord(TeaModel):
    def __init__(
        self,
        data_id: str = None,
    ):
        # 服务标识
        self.data_id = data_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.data_id is not None:
            result['data_id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        return self


class ServiceSubscriber(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        data_id: str = None,
        app_name: str = None,
        host_ip: str = None,
        zone: str = None,
    ):
        # 实例标识
        self.instance_id = instance_id
        # 服务标识
        self.data_id = data_id
        # 应用名称
        self.app_name = app_name
        # 服务提供方客户端IP
        self.host_ip = host_ip
        # 逻辑机房
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.host_ip is not None:
            result['host_ip'] = self.host_ip
        if self.zone is not None:
            result['zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('host_ip') is not None:
            self.host_ip = m.get('host_ip')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        return self


class AuthRuleGroupListModelVO(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        black_group_id: int = None,
        black_state: int = None,
        data_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        operator: str = None,
        rules: List[AuthRuleModelVO] = None,
        status: int = None,
        white_group_id: int = None,
        white_state: int = None,
        change_status: str = None,
    ):
        # 应用名称, 多个应用逗号分隔
        self.app_name = app_name
        # 黑名单组id
        self.black_group_id = black_group_id
        # 黑名单状态（1开启/0关闭）
        self.black_state = black_state
        # 鉴权源
        self.data_id = data_id
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # 主键
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 操作人
        self.operator = operator
        # 鉴权规则列表
        self.rules = rules
        # 生效状态（0 失败, 1 成功, 2 部分失败）
        self.status = status
        # 白名单组id
        self.white_group_id = white_group_id
        # 白名单状态（1开启/0关闭）
        self.white_state = white_state
        # 变更状态
        self.change_status = change_status

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.black_group_id is not None:
            result['black_group_id'] = self.black_group_id
        if self.black_state is not None:
            result['black_state'] = self.black_state
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        result['rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['rules'].append(k.to_map() if k else None)
        if self.status is not None:
            result['status'] = self.status
        if self.white_group_id is not None:
            result['white_group_id'] = self.white_group_id
        if self.white_state is not None:
            result['white_state'] = self.white_state
        if self.change_status is not None:
            result['change_status'] = self.change_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('black_group_id') is not None:
            self.black_group_id = m.get('black_group_id')
        if m.get('black_state') is not None:
            self.black_state = m.get('black_state')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        self.rules = []
        if m.get('rules') is not None:
            for k in m.get('rules'):
                temp_model = AuthRuleModelVO()
                self.rules.append(temp_model.from_map(k))
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('white_group_id') is not None:
            self.white_group_id = m.get('white_group_id')
        if m.get('white_state') is not None:
            self.white_state = m.get('white_state')
        if m.get('change_status') is not None:
            self.change_status = m.get('change_status')
        return self


class CircuitBreakerRuleAppNamesModel(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        rules_num: int = None,
    ):
        # 应用名
        self.app_name = app_name
        # 规则个数
        self.rules_num = rules_num

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.rules_num, 'rules_num')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.rules_num is not None:
            result['rules_num'] = self.rules_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('rules_num') is not None:
            self.rules_num = m.get('rules_num')
        return self


class AuthRuleConfig(TeaModel):
    def __init__(
        self,
        fields: List[ConfigEntity] = None,
        operations: List[ConfigEntity] = None,
        types: List[ConfigEntity] = None,
    ):
        # 字段信息
        self.fields = fields
        # 操作符集合
        self.operations = operations
        # 类型，系统内置或者是自定义
        self.types = types

    def validate(self):
        self.validate_required(self.fields, 'fields')
        if self.fields:
            for k in self.fields:
                if k:
                    k.validate()
        self.validate_required(self.operations, 'operations')
        if self.operations:
            for k in self.operations:
                if k:
                    k.validate()
        self.validate_required(self.types, 'types')
        if self.types:
            for k in self.types:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['fields'] = []
        if self.fields is not None:
            for k in self.fields:
                result['fields'].append(k.to_map() if k else None)
        result['operations'] = []
        if self.operations is not None:
            for k in self.operations:
                result['operations'].append(k.to_map() if k else None)
        result['types'] = []
        if self.types is not None:
            for k in self.types:
                result['types'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fields = []
        if m.get('fields') is not None:
            for k in m.get('fields'):
                temp_model = ConfigEntity()
                self.fields.append(temp_model.from_map(k))
        self.operations = []
        if m.get('operations') is not None:
            for k in m.get('operations'):
                temp_model = ConfigEntity()
                self.operations.append(temp_model.from_map(k))
        self.types = []
        if m.get('types') is not None:
            for k in m.get('types'):
                temp_model = ConfigEntity()
                self.types.append(temp_model.from_map(k))
        return self


class FaultInjectRuleVO(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        data_id: str = None,
        app_name: str = None,
        service_type: str = None,
        rule_name: str = None,
        enabled: bool = None,
        operator: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        rule_config: FaultInjectRuleConfigModel = None,
    ):
        # 主键
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 服务ID
        self.data_id = data_id
        # 应用名
        self.app_name = app_name
        # 服务类型（SOFA DUBBO SPRINGCLOUD）
        self.service_type = service_type
        # 规则名称
        self.rule_name = rule_name
        # 是否启用规则
        self.enabled = enabled
        # 操作人
        self.operator = operator
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # 规则配置
        self.rule_config = rule_config

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.rule_config:
            self.rule_config.validate()

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('rule_config') is not None:
            temp_model = FaultInjectRuleConfigModel()
            self.rule_config = temp_model.from_map(m['rule_config'])
        return self


class CircuitBreakerRuleModel(TeaModel):
    def __init__(
        self,
        app_names: List[str] = None,
        circuit_breaker_rule_items: List[CircuitBreakerRuleItemModel] = None,
        conditions: List[CircuitRuleBaseConditionModel] = None,
        config: CircuitBreakerConfigModel = None,
        data_id: str = None,
        gmt_modified: int = None,
        http_method: str = None,
        http_path: str = None,
        id: str = None,
        instance_id: str = None,
        method_name: str = None,
        mode: str = None,
        name: str = None,
        operator: str = None,
        resource: str = None,
        res_type: str = None,
        service_type: str = None,
        status: int = None,
        traffic_type: str = None,
    ):
        # 应用名，数组形式，一般只有一个
        self.app_names = app_names
        # 统一熔断模型
        # "circuit_breaker_rule_items": [
        # {
        # "ruleType": "avgRt",
        # "action": {
        # "type": "REJECT"
        # },
        # "configs": {
        # "totalMetricWindow": 10,
        # "requestVolumeThreshold": 10,
        # "averageRtThreshold": 50,
        # "sleepWindow": 1000
        # },
        # "trafficConditions": [
        # {
        # "type": "system",
        # "field": "trafficType",
        # "operation": "EQUAL",
        # "value": [
        # "online"
        # ]
        # }
        # ]
        # }
        # ],
        self.circuit_breaker_rule_items = circuit_breaker_rule_items
        # 熔断生效条件
        self.conditions = conditions
        # 熔断配置
        self.config = config
        # 服务id
        self.data_id = data_id
        # 修改时间
        self.gmt_modified = gmt_modified
        # 取值GET、POST、DELETE、PUT(serviceType为SPRINGCLOUD时才有值)
        self.http_method = http_method
        # 可以传*表示通配符(serviceType为SPRINGCLOUD时才有值)
        self.http_path = http_path
        # 数据库自增id
        self.id = id
        # 租户id
        self.instance_id = instance_id
        # 方法名称(serviceType为SPRINGCLOUD时不传)
        self.method_name = method_name
        # 熔断生效模式
        self.mode = mode
        # 熔断规则名
        self.name = name
        # 操作人
        self.operator = operator
        # dataId.methodName:trfficType:resType(当serviceType类型为SPRINGCLOUD时结构为dataId:trfficType:resType)
        self.resource = resource
        # res的类型(r-rpc,g-gateway,q-mq)
        self.res_type = res_type
        # 服务类型
        self.service_type = service_type
        # 规则是否生效
        self.status = status
        # 流量方向(i-inbound,o-outbound)
        self.traffic_type = traffic_type

    def validate(self):
        self.validate_required(self.app_names, 'app_names')
        if self.circuit_breaker_rule_items:
            for k in self.circuit_breaker_rule_items:
                if k:
                    k.validate()
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()
        if self.config:
            self.config.validate()
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.service_type, 'service_type')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = dict()
        if self.app_names is not None:
            result['app_names'] = self.app_names
        result['circuit_breaker_rule_items'] = []
        if self.circuit_breaker_rule_items is not None:
            for k in self.circuit_breaker_rule_items:
                result['circuit_breaker_rule_items'].append(k.to_map() if k else None)
        result['conditions'] = []
        if self.conditions is not None:
            for k in self.conditions:
                result['conditions'].append(k.to_map() if k else None)
        if self.config is not None:
            result['config'] = self.config.to_map()
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.http_method is not None:
            result['http_method'] = self.http_method
        if self.http_path is not None:
            result['http_path'] = self.http_path
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.method_name is not None:
            result['method_name'] = self.method_name
        if self.mode is not None:
            result['mode'] = self.mode
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource is not None:
            result['resource'] = self.resource
        if self.res_type is not None:
            result['res_type'] = self.res_type
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.status is not None:
            result['status'] = self.status
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        self.circuit_breaker_rule_items = []
        if m.get('circuit_breaker_rule_items') is not None:
            for k in m.get('circuit_breaker_rule_items'):
                temp_model = CircuitBreakerRuleItemModel()
                self.circuit_breaker_rule_items.append(temp_model.from_map(k))
        self.conditions = []
        if m.get('conditions') is not None:
            for k in m.get('conditions'):
                temp_model = CircuitRuleBaseConditionModel()
                self.conditions.append(temp_model.from_map(k))
        if m.get('config') is not None:
            temp_model = CircuitBreakerConfigModel()
            self.config = temp_model.from_map(m['config'])
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('http_method') is not None:
            self.http_method = m.get('http_method')
        if m.get('http_path') is not None:
            self.http_path = m.get('http_path')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('method_name') is not None:
            self.method_name = m.get('method_name')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource') is not None:
            self.resource = m.get('resource')
        if m.get('res_type') is not None:
            self.res_type = m.get('res_type')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class PushHistory(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        gmt_create: str = None,
        id: int = None,
        instance_id: str = None,
        operator: str = None,
        push_content: str = None,
        rule_ids: str = None,
        success: bool = None,
        target: str = None,
    ):
        # app name
        self.app_name = app_name
        # 创建
        self.gmt_create = gmt_create
        # 推送历史id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 编辑人
        self.operator = operator
        # 推送内容
        # 
        # 
        # 
        # 
        self.push_content = push_content
        # 逗号分隔的ruleId
        self.rule_ids = rule_ids
        # 是否成功
        self.success = success
        # 推送目标
        self.target = target

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.push_content is not None:
            result['push_content'] = self.push_content
        if self.rule_ids is not None:
            result['rule_ids'] = self.rule_ids
        if self.success is not None:
            result['success'] = self.success
        if self.target is not None:
            result['target'] = self.target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('push_content') is not None:
            self.push_content = m.get('push_content')
        if m.get('rule_ids') is not None:
            self.rule_ids = m.get('rule_ids')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('target') is not None:
            self.target = m.get('target')
        return self


class FaultToleranceRuleAppModel(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        rules_num: int = None,
    ):
        # app名称
        self.app_name = app_name
        # 规则数量
        self.rules_num = rules_num

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.rules_num is not None:
            result['rules_num'] = self.rules_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('rules_num') is not None:
            self.rules_num = m.get('rules_num')
        return self


class TransparentProxyProtocolModel(TeaModel):
    def __init__(
        self,
        port: int = None,
        protocol: str = None,
    ):
        # 端口
        self.port = port
        # 协议
        self.protocol = protocol

    def validate(self):
        self.validate_required(self.port, 'port')
        self.validate_required(self.protocol, 'protocol')

    def to_map(self):
        result = dict()
        if self.port is not None:
            result['port'] = self.port
        if self.protocol is not None:
            result['protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        return self


class GrayPublishResultItem(TeaModel):
    def __init__(
        self,
        host: str = None,
        success: bool = None,
    ):
        # 推送目标 host
        self.host = host
        # 是否推送成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.host is not None:
            result['host'] = self.host
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CircuitBreakerRuleResult(TeaModel):
    def __init__(
        self,
        app_names: str = None,
        data_id: str = None,
        rules_num: int = None,
        service_type: str = None,
    ):
        # 多个应用名
        self.app_names = app_names
        # 服务id
        self.data_id = data_id
        # 规则总数
        self.rules_num = rules_num
        # 服务类型
        self.service_type = service_type

    def validate(self):
        self.validate_required(self.app_names, 'app_names')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.rules_num, 'rules_num')
        self.validate_required(self.service_type, 'service_type')

    def to_map(self):
        result = dict()
        if self.app_names is not None:
            result['app_names'] = self.app_names
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.rules_num is not None:
            result['rules_num'] = self.rules_num
        if self.service_type is not None:
            result['service_type'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('rules_num') is not None:
            self.rules_num = m.get('rules_num')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        return self


class GuardianApp(TeaModel):
    def __init__(
        self,
        enable: bool = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        run_mode: str = None,
    ):
        # 是否生效
        self.enable = enable
        # 监控id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.enable is not None:
            result['enable'] = self.enable
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class CellLdcInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
    ):
        # 单元名称
        self.name = name
        # 单元类型
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ConfigSnapshotModel(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        key: str = None,
        type: str = None,
        value: str = None,
    ):
        # 实例id
        self.instance_id = instance_id
        # 配置的key，例如在服务鉴权里是dataId
        self.key = key
        # 配置类型：例如 auth、lb 等
        self.type = type
        # 配置值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.key is not None:
            result['key'] = self.key
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class TransparentProxyNodeModel(TeaModel):
    def __init__(
        self,
        ip: str = None,
        node_type: str = None,
        id: int = None,
    ):
        # ip地址
        self.ip = ip
        # 节点类型
        self.node_type = node_type
        # 节点ID
        self.id = id

    def validate(self):
        self.validate_required(self.ip, 'ip')
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.ip is not None:
            result['ip'] = self.ip
        if self.node_type is not None:
            result['node_type'] = self.node_type
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('node_type') is not None:
            self.node_type = m.get('node_type')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class Subscriber(TeaModel):
    def __init__(
        self,
        alive: bool = None,
        app_name: str = None,
        check_sum: str = None,
        data_id: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        host_ip: str = None,
        id: int = None,
        instance_id: str = None,
        process_id: str = None,
        scope: str = None,
        zone: str = None,
    ):
        # 订阅端是否存活，默认1-存活，订阅端下线标记为0，默认1
        # 
        self.alive = alive
        # 应用名
        self.app_name = app_name
        # 校验值
        # 
        self.check_sum = check_sum
        # 服务id
        # 
        self.data_id = data_id
        # 创建日期
        self.gmt_create = gmt_create
        # 最后更新时间
        self.gmt_modified = gmt_modified
        # 发布这个服务的主机的 ip，不同于 service_ip
        self.host_ip = host_ip
        # 消费者id
        self.id = id
        # 租户实例id
        # 
        self.instance_id = instance_id
        # 进程ID
        # 
        self.process_id = process_id
        # 订阅者的订阅维度
        self.scope = scope
        # 订阅端订阅时使用的 zone
        self.zone = zone

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.alive is not None:
            result['alive'] = self.alive
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.check_sum is not None:
            result['check_sum'] = self.check_sum
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.host_ip is not None:
            result['host_ip'] = self.host_ip
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.process_id is not None:
            result['process_id'] = self.process_id
        if self.scope is not None:
            result['scope'] = self.scope
        if self.zone is not None:
            result['zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alive') is not None:
            self.alive = m.get('alive')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('check_sum') is not None:
            self.check_sum = m.get('check_sum')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('host_ip') is not None:
            self.host_ip = m.get('host_ip')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('process_id') is not None:
            self.process_id = m.get('process_id')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        return self


class ServiceSummary(TeaModel):
    def __init__(
        self,
        app_count: int = None,
        service_count: int = None,
        node_count: int = None,
    ):
        # 应用数
        self.app_count = app_count
        # 服务数
        self.service_count = service_count
        # 节点数
        self.node_count = node_count

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.app_count is not None:
            result['app_count'] = self.app_count
        if self.service_count is not None:
            result['service_count'] = self.service_count
        if self.node_count is not None:
            result['node_count'] = self.node_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_count') is not None:
            self.app_count = m.get('app_count')
        if m.get('service_count') is not None:
            self.service_count = m.get('service_count')
        if m.get('node_count') is not None:
            self.node_count = m.get('node_count')
        return self


class PublishDataItem(TeaModel):
    def __init__(
        self,
        cell: str = None,
        data: str = None,
    ):
        # 推送目标 cell
        self.cell = cell
        # 推送值
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cell is not None:
            result['cell'] = self.cell
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class SimpleServiceInfo(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        pub_app: List[str] = None,
        pub_count: int = None,
        service_type: str = None,
        sub_count: int = None,
        app_infos: List[AppMetaDataModel] = None,
    ):
        # 服务id
        self.data_id = data_id
        # 服务提供者列表
        self.pub_app = pub_app
        # 服务提供者数
        self.pub_count = pub_count
        # 服务架构类型
        self.service_type = service_type
        # 消费者数
        self.sub_count = sub_count
        # 应用元数据
        self.app_infos = app_infos

    def validate(self):
        if self.app_infos:
            for k in self.app_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.pub_app is not None:
            result['pub_app'] = self.pub_app
        if self.pub_count is not None:
            result['pub_count'] = self.pub_count
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.sub_count is not None:
            result['sub_count'] = self.sub_count
        result['app_infos'] = []
        if self.app_infos is not None:
            for k in self.app_infos:
                result['app_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('pub_app') is not None:
            self.pub_app = m.get('pub_app')
        if m.get('pub_count') is not None:
            self.pub_count = m.get('pub_count')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('sub_count') is not None:
            self.sub_count = m.get('sub_count')
        self.app_infos = []
        if m.get('app_infos') is not None:
            for k in m.get('app_infos'):
                temp_model = AppMetaDataModel()
                self.app_infos.append(temp_model.from_map(k))
        return self


class RouterRuleGroupModel(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        data_id: str = None,
        enabled: int = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        operator: str = None,
        rules: List[RouterRuleModel] = None,
        type: str = None,
        dispatch_version: int = None,
    ):
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 是否生效，1 生效，0 未生效。默认未生效
        self.enabled = enabled
        # 更新日期
        self.gmt_modified = gmt_modified
        # id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 编辑人
        self.operator = operator
        # 路由规则
        self.rules = rules
        # service 表示服务
        self.type = type
        # 版本号
        self.dispatch_version = dispatch_version

    def validate(self):
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        result['rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['rules'].append(k.to_map() if k else None)
        if self.type is not None:
            result['type'] = self.type
        if self.dispatch_version is not None:
            result['dispatch_version'] = self.dispatch_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        self.rules = []
        if m.get('rules') is not None:
            for k in m.get('rules'):
                temp_model = RouterRuleModel()
                self.rules.append(temp_model.from_map(k))
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('dispatch_version') is not None:
            self.dispatch_version = m.get('dispatch_version')
        return self


class DrmLog(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        data_id: str = None,
        fail_target: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        operator: str = None,
        push_mode: str = None,
        result: str = None,
        source_app: str = None,
        target: str = None,
        value: str = None,
    ):
        # 触发推送客户端IP
        self.client_ip = client_ip
        # 资源标识
        self.data_id = data_id
        # 推送失败目标
        self.fail_target = fail_target
        # 创建时间
        self.gmt_create = gmt_create
        # 修改时间
        self.gmt_modified = gmt_modified
        # id
        self.id = id
        # 实例ID
        self.instance_id = instance_id
        # 操作者
        self.operator = operator
        # 推送类型
        self.push_mode = push_mode
        # 推送结果
        self.result = result
        # 来源应用
        self.source_app = source_app
        # 目标
        self.target = target
        # 推送值
        self.value = value

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.client_ip is not None:
            result['client_ip'] = self.client_ip
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.fail_target is not None:
            result['fail_target'] = self.fail_target
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.push_mode is not None:
            result['push_mode'] = self.push_mode
        if self.result is not None:
            result['result'] = self.result
        if self.source_app is not None:
            result['source_app'] = self.source_app
        if self.target is not None:
            result['target'] = self.target
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('client_ip') is not None:
            self.client_ip = m.get('client_ip')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('fail_target') is not None:
            self.fail_target = m.get('fail_target')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('push_mode') is not None:
            self.push_mode = m.get('push_mode')
        if m.get('result') is not None:
            self.result = m.get('result')
        if m.get('source_app') is not None:
            self.source_app = m.get('source_app')
        if m.get('target') is not None:
            self.target = m.get('target')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class CommunicationRuleModel(TeaModel):
    def __init__(
        self,
        labels: List[CommunicationLabelModel] = None,
        label_code: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        direction: int = None,
        mode: int = None,
        strategy: str = None,
        enabled: int = None,
        scope: int = None,
        operator: str = None,
        operate_time: str = None,
    ):
        # [{"key":"aa","value":"bb","type":1}]
        self.labels = labels
        # 对labels取的hash值
        self.label_code = label_code
        # id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 
        # 规则名称
        self.name = name
        # 取值(0-客户端,1-服务端)
        self.direction = direction
        # 模式(0-tls,1-mtls)
        self.mode = mode
        # 策略(0-普通,1-国密)
        self.strategy = strategy
        # 
        # 状态(0-关闭,1-开启)
        self.enabled = enabled
        # 分类(0-应用,1-标签)
        self.scope = scope
        # 操作人
        self.operator = operator
        # 操作时间
        self.operate_time = operate_time

    def validate(self):
        if self.labels:
            for k in self.labels:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['labels'] = []
        if self.labels is not None:
            for k in self.labels:
                result['labels'].append(k.to_map() if k else None)
        if self.label_code is not None:
            result['label_code'] = self.label_code
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.direction is not None:
            result['direction'] = self.direction
        if self.mode is not None:
            result['mode'] = self.mode
        if self.strategy is not None:
            result['strategy'] = self.strategy
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.scope is not None:
            result['scope'] = self.scope
        if self.operator is not None:
            result['operator'] = self.operator
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.labels = []
        if m.get('labels') is not None:
            for k in m.get('labels'):
                temp_model = CommunicationLabelModel()
                self.labels.append(temp_model.from_map(k))
        if m.get('label_code') is not None:
            self.label_code = m.get('label_code')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('direction') is not None:
            self.direction = m.get('direction')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('strategy') is not None:
            self.strategy = m.get('strategy')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        return self


class DDCSPushHistoryItem(TeaModel):
    def __init__(
        self,
        id: int = None,
        platform: str = None,
        change_type: str = None,
        title: str = None,
        influence_app: str = None,
        data_id: str = None,
        push_type: str = None,
        target: str = None,
        env: str = None,
        operator: str = None,
        gmt_start: int = None,
        gmt_end: int = None,
        push_result: str = None,
        value: str = None,
    ):
        # 推送记录的id
        self.id = id
        # 变更平台，固定值 ddcs
        self.platform = platform
        # 变更类型，固定值
        self.change_type = change_type
        # 推送标题
        self.title = title
        # 变更影响的应用名
        self.influence_app = influence_app
        # 变更的 dataId
        self.data_id = data_id
        # 推送类型，Cluster 表示集群推送，IP 表示按机器灰度推送
        self.push_type = push_type
        # 推送的目标。按集群推送时，AllCells 表示向所用的 cell 推送，多个Cell之间逗号隔开。
        # 按机器推送时，值为 IP列表，逗号隔开
        self.target = target
        # 固定为 dataId 所属的 instanceId
        self.env = env
        # 操作人。如果是系统调用，则值为调用应用名
        self.operator = operator
        # 变更的起始时间，值为  1970年到现在的毫秒数，主要是为了屏蔽时区的问题。
        self.gmt_start = gmt_start
        # 变更的结束时间，值为  1970年到现在的毫秒数，主要是为了屏蔽时区的问题。
        self.gmt_end = gmt_end
        # 推送结果
        self.push_result = push_result
        # 推送值
        self.value = value

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.push_type, 'push_type')
        self.validate_required(self.target, 'target')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.gmt_start, 'gmt_start')
        self.validate_required(self.gmt_end, 'gmt_end')
        self.validate_required(self.push_result, 'push_result')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.platform is not None:
            result['platform'] = self.platform
        if self.change_type is not None:
            result['change_type'] = self.change_type
        if self.title is not None:
            result['title'] = self.title
        if self.influence_app is not None:
            result['influence_app'] = self.influence_app
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.push_type is not None:
            result['push_type'] = self.push_type
        if self.target is not None:
            result['target'] = self.target
        if self.env is not None:
            result['env'] = self.env
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_start is not None:
            result['gmt_start'] = self.gmt_start
        if self.gmt_end is not None:
            result['gmt_end'] = self.gmt_end
        if self.push_result is not None:
            result['push_result'] = self.push_result
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('platform') is not None:
            self.platform = m.get('platform')
        if m.get('change_type') is not None:
            self.change_type = m.get('change_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('influence_app') is not None:
            self.influence_app = m.get('influence_app')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('push_type') is not None:
            self.push_type = m.get('push_type')
        if m.get('target') is not None:
            self.target = m.get('target')
        if m.get('env') is not None:
            self.env = m.get('env')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_start') is not None:
            self.gmt_start = m.get('gmt_start')
        if m.get('gmt_end') is not None:
            self.gmt_end = m.get('gmt_end')
        if m.get('push_result') is not None:
            self.push_result = m.get('push_result')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class GuardianRule(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        enable: bool = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
    ):
        # app name
        self.app_name = app_name
        # 是否可用
        self.enable = enable
        # 创建
        self.gmt_create = gmt_create
        # 更新
        self.gmt_modified = gmt_modified
        # 监控规则id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 规则名称
        self.name = name
        # 编辑人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # 规则配置
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.enable is not None:
            result['enable'] = self.enable
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class DrmDataCellInfo(TeaModel):
    def __init__(
        self,
        cell_infos: List[CellInfo] = None,
        has_special_cell: bool = None,
    ):
        # 单元信息列表
        self.cell_infos = cell_infos
        # 所有单元中是否存在有特殊推送过值的单元
        self.has_special_cell = has_special_cell

    def validate(self):
        if self.cell_infos:
            for k in self.cell_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['cell_infos'] = []
        if self.cell_infos is not None:
            for k in self.cell_infos:
                result['cell_infos'].append(k.to_map() if k else None)
        if self.has_special_cell is not None:
            result['has_special_cell'] = self.has_special_cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cell_infos = []
        if m.get('cell_infos') is not None:
            for k in m.get('cell_infos'):
                temp_model = CellInfo()
                self.cell_infos.append(temp_model.from_map(k))
        if m.get('has_special_cell') is not None:
            self.has_special_cell = m.get('has_special_cell')
        return self


class AppNameCountModel(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        rule_num: int = None,
    ):
        # 应用名
        self.app_name = app_name
        # 规则数
        self.rule_num = rule_num

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.rule_num is not None:
            result['rule_num'] = self.rule_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('rule_num') is not None:
            self.rule_num = m.get('rule_num')
        return self


class SidecarInjectModel(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        sidecar_name: str = None,
        status: int = None,
        operator: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        configs: List[SidecarInjectConfigModel] = None,
    ):
        # 主键
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # sidecar名称
        self.sidecar_name = sidecar_name
        # 状态 0关闭 1开启
        self.status = status
        # 操作人
        self.operator = operator
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # sidecar注入配置
        self.configs = configs

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.sidecar_name is not None:
            result['sidecar_name'] = self.sidecar_name
        if self.status is not None:
            result['status'] = self.status
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        result['configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('sidecar_name') is not None:
            self.sidecar_name = m.get('sidecar_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        self.configs = []
        if m.get('configs') is not None:
            for k in m.get('configs'):
                temp_model = SidecarInjectConfigModel()
                self.configs.append(temp_model.from_map(k))
        return self


class Client(TeaModel):
    def __init__(
        self,
        cell: str = None,
        data: str = None,
        ip: str = None,
        push_data: str = None,
    ):
        # 所属的 cell
        self.cell = cell
        # 客户端内存里的值
        self.data = data
        # 客户端 IP
        self.ip = ip
        # 推送的值
        self.push_data = push_data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.cell is not None:
            result['cell'] = self.cell
        if self.data is not None:
            result['data'] = self.data
        if self.ip is not None:
            result['ip'] = self.ip
        if self.push_data is not None:
            result['push_data'] = self.push_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('push_data') is not None:
            self.push_data = m.get('push_data')
        return self


class FaultToleranceRuleModel(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        app_name: str = None,
        name: str = None,
        operator: str = None,
        gmt_modified: str = None,
        orders: List[BaseOrderDO] = None,
        enabled: int = None,
        rule_item_list: List[FaultToleranceRuleItemModel] = None,
        direction: str = None,
    ):
        # id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # app名称
        self.app_name = app_name
        # 规则名称
        self.name = name
        # 操作人
        self.operator = operator
        # 修改时间
        self.gmt_modified = gmt_modified
        # 排序字段
        self.orders = orders
        # 是否启用(0-未启用1启用-2部分启用)
        self.enabled = enabled
        # 故障隔离的具体规则项
        # {"appName":"testApp","name":"test23","ruleItemList":[{"conditions":[{"type":"system","field":"targetApp","operation":"IN","value":["A"]}],"configs":{"timeWindow":10,"leastWindowCount":100,"maxIpCount":3,"exceptionRateMultiple":3,"leastExceptionRate":10,"exceptionTypes":["500"]},"actions":[{"type":"DOWNGRADE"}]}]}
        self.rule_item_list = rule_item_list
        # 取值client,server二选1，默认是client
        self.direction = direction

    def validate(self):
        if self.orders:
            for k in self.orders:
                if k:
                    k.validate()
        if self.rule_item_list:
            for k in self.rule_item_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        result['orders'] = []
        if self.orders is not None:
            for k in self.orders:
                result['orders'].append(k.to_map() if k else None)
        if self.enabled is not None:
            result['enabled'] = self.enabled
        result['rule_item_list'] = []
        if self.rule_item_list is not None:
            for k in self.rule_item_list:
                result['rule_item_list'].append(k.to_map() if k else None)
        if self.direction is not None:
            result['direction'] = self.direction
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        self.orders = []
        if m.get('orders') is not None:
            for k in m.get('orders'):
                temp_model = BaseOrderDO()
                self.orders.append(temp_model.from_map(k))
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        self.rule_item_list = []
        if m.get('rule_item_list') is not None:
            for k in m.get('rule_item_list'):
                temp_model = FaultToleranceRuleItemModel()
                self.rule_item_list.append(temp_model.from_map(k))
        if m.get('direction') is not None:
            self.direction = m.get('direction')
        return self


class TransparentProxySidecarScriptLinkVo(TeaModel):
    def __init__(
        self,
        install_sidecar_script_link: str = None,
        clean_sidecar_script_link: str = None,
    ):
        # 安装sidecar下载链接
        self.install_sidecar_script_link = install_sidecar_script_link
        # 清理sidecar脚本下载链接
        self.clean_sidecar_script_link = clean_sidecar_script_link

    def validate(self):
        self.validate_required(self.install_sidecar_script_link, 'install_sidecar_script_link')
        self.validate_required(self.clean_sidecar_script_link, 'clean_sidecar_script_link')

    def to_map(self):
        result = dict()
        if self.install_sidecar_script_link is not None:
            result['install_sidecar_script_link'] = self.install_sidecar_script_link
        if self.clean_sidecar_script_link is not None:
            result['clean_sidecar_script_link'] = self.clean_sidecar_script_link
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('install_sidecar_script_link') is not None:
            self.install_sidecar_script_link = m.get('install_sidecar_script_link')
        if m.get('clean_sidecar_script_link') is not None:
            self.clean_sidecar_script_link = m.get('clean_sidecar_script_link')
        return self


class TransparentProxyNodeVo(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        id: int = None,
        instance_id: str = None,
        ip: str = None,
        mosn_version: str = None,
        node_status: str = None,
        node_type: str = None,
        real_run: str = None,
        sidecar_status: str = None,
        transparent_proxy_switch: int = None,
    ):
        # 应用名
        self.app_name = app_name
        # 节点 ID
        self.id = id
        # 应用实例 ID
        self.instance_id = instance_id
        # IP 地址
        self.ip = ip
        # mosn 版本
        self.mosn_version = mosn_version
        # 节点状态
        self.node_status = node_status
        # 节点集群类型
        self.node_type = node_type
        # 节点是否在运行透明劫持
        self.real_run = real_run
        # Sidecar 状态
        self.sidecar_status = sidecar_status
        # 透明劫持开关
        self.transparent_proxy_switch = transparent_proxy_switch

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ip, 'ip')
        self.validate_required(self.mosn_version, 'mosn_version')
        self.validate_required(self.node_status, 'node_status')
        self.validate_required(self.node_type, 'node_type')
        self.validate_required(self.real_run, 'real_run')
        self.validate_required(self.sidecar_status, 'sidecar_status')
        self.validate_required(self.transparent_proxy_switch, 'transparent_proxy_switch')

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.mosn_version is not None:
            result['mosn_version'] = self.mosn_version
        if self.node_status is not None:
            result['node_status'] = self.node_status
        if self.node_type is not None:
            result['node_type'] = self.node_type
        if self.real_run is not None:
            result['real_run'] = self.real_run
        if self.sidecar_status is not None:
            result['sidecar_status'] = self.sidecar_status
        if self.transparent_proxy_switch is not None:
            result['transparent_proxy_switch'] = self.transparent_proxy_switch
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('mosn_version') is not None:
            self.mosn_version = m.get('mosn_version')
        if m.get('node_status') is not None:
            self.node_status = m.get('node_status')
        if m.get('node_type') is not None:
            self.node_type = m.get('node_type')
        if m.get('real_run') is not None:
            self.real_run = m.get('real_run')
        if m.get('sidecar_status') is not None:
            self.sidecar_status = m.get('sidecar_status')
        if m.get('transparent_proxy_switch') is not None:
            self.transparent_proxy_switch = m.get('transparent_proxy_switch')
        return self


class ConfigDispatchLogDO(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        key: str = None,
        type: str = None,
        status: int = None,
        value: str = None,
    ):
        # 实例id
        self.instance_id = instance_id
        # 配置的key
        self.key = key
        # 配置的类型
        self.type = type
        # 状态
        self.status = status
        # 配置下发的信息
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.key is not None:
            result['key'] = self.key
        if self.type is not None:
            result['type'] = self.type
        if self.status is not None:
            result['status'] = self.status
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class SyncData(TeaModel):
    def __init__(
        self,
        source_data: str = None,
        target_data: str = None,
    ):
        # 源数据
        self.source_data = source_data
        # 目标数据
        self.target_data = target_data

    def validate(self):
        self.validate_required(self.source_data, 'source_data')
        self.validate_required(self.target_data, 'target_data')

    def to_map(self):
        result = dict()
        if self.source_data is not None:
            result['source_data'] = self.source_data
        if self.target_data is not None:
            result['target_data'] = self.target_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('source_data') is not None:
            self.source_data = m.get('source_data')
        if m.get('target_data') is not None:
            self.target_data = m.get('target_data')
        return self


class FaultInjectRuleAppNameModel(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        rule_num: int = None,
    ):
        # 应用名称
        self.app_name = app_name
        # 规则数量
        self.rule_num = rule_num

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.rule_num is not None:
            result['rule_num'] = self.rule_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('rule_num') is not None:
            self.rule_num = m.get('rule_num')
        return self


class DrmResource(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        attributes: List[DrmAttribute] = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_domain: str = None,
        resource_id: str = None,
        resource_version: str = None,
        type: str = None,
    ):
        # appName
        self.app_name = app_name
        # 资源属性列表
        self.attributes = attributes
        # drm资源id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 资源域
        self.region = region
        # 资源域和应用名
        self.resource_domain = resource_domain
        # 资源类路径
        self.resource_id = resource_id
        # 资源版本
        self.resource_version = resource_version
        # type
        self.type = type

    def validate(self):
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        result['attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['attributes'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_domain is not None:
            result['resource_domain'] = self.resource_domain
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.resource_version is not None:
            result['resource_version'] = self.resource_version
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        self.attributes = []
        if m.get('attributes') is not None:
            for k in m.get('attributes'):
                temp_model = DrmAttribute()
                self.attributes.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_domain') is not None:
            self.resource_domain = m.get('resource_domain')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('resource_version') is not None:
            self.resource_version = m.get('resource_version')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ClientValue(TeaModel):
    def __init__(
        self,
        data: str = None,
        ip: str = None,
        success: bool = None,
    ):
        # 客户端内存里的值
        self.data = data
        # 客户端 IP
        self.ip = ip
        # 是否查询成功
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.data is not None:
            result['data'] = self.data
        if self.ip is not None:
            result['ip'] = self.ip
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AuthRule(TeaModel):
    def __init__(
        self,
        name: str = None,
        mode: str = None,
        auth_rule_group_id: int = None,
        enabled: int = None,
        rule_items: List[AuthRuleItem] = None,
    ):
        # 鉴权规则描述
        self.name = name
        # REJECT : 表示严格模式，例如不匹配白名单则拒绝访问
        # OBSERVER：表示非严格模式，例如不匹配白名单只记录日志，不拒绝访问
        self.mode = mode
        # 规则所属的名单id
        self.auth_rule_group_id = auth_rule_group_id
        # 是否生效，1 表示生效，0 表示不生效
        self.enabled = enabled
        # 一条规则下，所有的规则项
        self.rule_items = rule_items

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.auth_rule_group_id, 'auth_rule_group_id')
        self.validate_required(self.enabled, 'enabled')
        if self.rule_items:
            for k in self.rule_items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.mode is not None:
            result['mode'] = self.mode
        if self.auth_rule_group_id is not None:
            result['auth_rule_group_id'] = self.auth_rule_group_id
        if self.enabled is not None:
            result['enabled'] = self.enabled
        result['rule_items'] = []
        if self.rule_items is not None:
            for k in self.rule_items:
                result['rule_items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('auth_rule_group_id') is not None:
            self.auth_rule_group_id = m.get('auth_rule_group_id')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        self.rule_items = []
        if m.get('rule_items') is not None:
            for k in m.get('rule_items'):
                temp_model = AuthRuleItem()
                self.rule_items.append(temp_model.from_map(k))
        return self


class AuthRuleGroup(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        enabled: int = None,
        instance_id: str = None,
        rules: List[AuthRuleVO] = None,
        status: int = None,
        type: str = None,
        gmt_modified: str = None,
    ):
        # 服务id
        self.data_id = data_id
        # 是否生效，1 生效，0 未生效。默认未生效
        self.enabled = enabled
        # 租户实例id
        self.instance_id = instance_id
        # 一份白名单或者黑名单下所有服务鉴权规则
        self.rules = rules
        # 下发是否成功, 0 失败, 1 成功, 2 部分失败
        self.status = status
        # whitelist/blacklist
        self.type = type
        # 最后更新时间
        self.gmt_modified = gmt_modified

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        result['rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['rules'].append(k.to_map() if k else None)
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        self.rules = []
        if m.get('rules') is not None:
            for k in m.get('rules'):
                temp_model = AuthRuleVO()
                self.rules.append(temp_model.from_map(k))
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class SyncCluster(TeaModel):
    def __init__(
        self,
        id: str = None,
        extra_params: List[KeyValueModel] = None,
        name: str = None,
        type: str = None,
        vip: str = None,
    ):
        # 集群id
        self.id = id
        # [{   //扩展参数，比如涉及到鉴权
        # "key": "user",
        # "value": "xx"
        # }, {
        # "key": "password",
        # "value": "xx"
        # }]
        self.extra_params = extra_params
        # 集群描述信息
        self.name = name
        # 集群类型
        self.type = type
        # 集群所有的机器列表，；隔开
        self.vip = vip

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.extra_params, 'extra_params')
        if self.extra_params:
            for k in self.extra_params:
                if k:
                    k.validate()
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vip, 'vip')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        result['extra_params'] = []
        if self.extra_params is not None:
            for k in self.extra_params:
                result['extra_params'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.type is not None:
            result['type'] = self.type
        if self.vip is not None:
            result['vip'] = self.vip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        self.extra_params = []
        if m.get('extra_params') is not None:
            for k in m.get('extra_params'):
                temp_model = KeyValueModel()
                self.extra_params.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('vip') is not None:
            self.vip = m.get('vip')
        return self


class ServiceSyncStatus(TeaModel):
    def __init__(
        self,
        service_id: str = None,
        service_name: str = None,
        status: str = None,
        date: str = None,
    ):
        # 服务id
        self.service_id = service_id
        # 服务所属的应用名
        self.service_name = service_name
        # 当前同步状态
        self.status = status
        # 日期
        self.date = date

    def validate(self):
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_name, 'service_name')
        self.validate_required(self.status, 'status')
        self.validate_required(self.date, 'date')
        if self.date is not None:
            self.validate_pattern(self.date, 'date', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.service_id is not None:
            result['service_id'] = self.service_id
        if self.service_name is not None:
            result['service_name'] = self.service_name
        if self.status is not None:
            result['status'] = self.status
        if self.date is not None:
            result['date'] = self.date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('service_id') is not None:
            self.service_id = m.get('service_id')
        if m.get('service_name') is not None:
            self.service_name = m.get('service_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('date') is not None:
            self.date = m.get('date')
        return self


class MeshClusterModel(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        cluster_name: str = None,
        status: int = None,
        operator: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # 主键
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 集群名称
        self.cluster_name = cluster_name
        # 开通/关闭状态 0：关闭 1：开通
        self.status = status
        # 操作人
        self.operator = operator
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.cluster_name is not None:
            result['cluster_name'] = self.cluster_name
        if self.status is not None:
            result['status'] = self.status
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('cluster_name') is not None:
            self.cluster_name = m.get('cluster_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class ServiceRelation(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        data_id: str = None,
    ):
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        return self


class Publisher(TeaModel):
    def __init__(
        self,
        alive: bool = None,
        app_name: str = None,
        app_version: str = None,
        check_sum: str = None,
        content: str = None,
        data_id: str = None,
        host_ip: str = None,
        id: int = None,
        instance_id: str = None,
        mosn: bool = None,
        process_id: str = None,
        protocol: str = None,
        service_ip: str = None,
        service_port: int = None,
        status: bool = None,
        timeout: int = None,
        vm_mode: bool = None,
        weight: int = None,
        zone: str = None,
        config_weight: str = None,
    ):
        # 订阅端是否存活，默认1-存活，订阅端下线标记为0，默认1
        self.alive = alive
        # 应用名
        self.app_name = app_name
        # appVersion
        self.app_version = app_version
        # 校验值
        self.check_sum = check_sum
        # 注册的内容
        self.content = content
        # 服务id
        self.data_id = data_id
        # IP
        self.host_ip = host_ip
        # 服务id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # mosn
        self.mosn = mosn
        # 进程ID
        # 
        self.process_id = process_id
        # 协议
        self.protocol = protocol
        # 服务ip
        self.service_ip = service_ip
        # 服务端口
        self.service_port = service_port
        # 状态
        self.status = status
        # 超时时间
        self.timeout = timeout
        # 是否是虚拟机模式
        self.vm_mode = vm_mode
        # 权重
        self.weight = weight
        # 逻辑机房
        # 
        self.zone = zone
        # 修改过的权重
        self.config_weight = config_weight

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.alive is not None:
            result['alive'] = self.alive
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.app_version is not None:
            result['app_version'] = self.app_version
        if self.check_sum is not None:
            result['check_sum'] = self.check_sum
        if self.content is not None:
            result['content'] = self.content
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.host_ip is not None:
            result['host_ip'] = self.host_ip
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.mosn is not None:
            result['mosn'] = self.mosn
        if self.process_id is not None:
            result['process_id'] = self.process_id
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.service_ip is not None:
            result['service_ip'] = self.service_ip
        if self.service_port is not None:
            result['service_port'] = self.service_port
        if self.status is not None:
            result['status'] = self.status
        if self.timeout is not None:
            result['timeout'] = self.timeout
        if self.vm_mode is not None:
            result['vm_mode'] = self.vm_mode
        if self.weight is not None:
            result['weight'] = self.weight
        if self.zone is not None:
            result['zone'] = self.zone
        if self.config_weight is not None:
            result['config_weight'] = self.config_weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alive') is not None:
            self.alive = m.get('alive')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('app_version') is not None:
            self.app_version = m.get('app_version')
        if m.get('check_sum') is not None:
            self.check_sum = m.get('check_sum')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('host_ip') is not None:
            self.host_ip = m.get('host_ip')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('mosn') is not None:
            self.mosn = m.get('mosn')
        if m.get('process_id') is not None:
            self.process_id = m.get('process_id')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('service_ip') is not None:
            self.service_ip = m.get('service_ip')
        if m.get('service_port') is not None:
            self.service_port = m.get('service_port')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('timeout') is not None:
            self.timeout = m.get('timeout')
        if m.get('vm_mode') is not None:
            self.vm_mode = m.get('vm_mode')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        if m.get('config_weight') is not None:
            self.config_weight = m.get('config_weight')
        return self


class AuthRuleGroupVO(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        enabled: int = None,
        gmt_modified: str = None,
        instance_id: str = None,
        rules: List[AuthRuleVO] = None,
        status: int = None,
        type: str = None,
        id: int = None,
    ):
        # 服务id
        self.data_id = data_id
        # 是否生效，1 生效，0 未生效。默认未生效
        self.enabled = enabled
        # 最后更新日期
        self.gmt_modified = gmt_modified
        # 租户实例id
        # 
        self.instance_id = instance_id
        # 一份白名单或者黑名单下所有服务鉴权规则
        self.rules = rules
        # 下发是否成功, 0 失败, 1 成功, 2 部分失败
        self.status = status
        # WHITELIST 或者是 BLACKLIST
        self.type = type
        # 规则组id
        self.id = id

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.gmt_modified, 'gmt_modified')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rules, 'rules')
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        result['rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['rules'].append(k.to_map() if k else None)
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        self.rules = []
        if m.get('rules') is not None:
            for k in m.get('rules'):
                temp_model = AuthRuleVO()
                self.rules.append(temp_model.from_map(k))
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class ServicePublisher(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        data_id: str = None,
        app_name: str = None,
        host_ip: str = None,
        service_ip: str = None,
        service_port: int = None,
        weight: int = None,
        zone: str = None,
    ):
        # 实例标识
        self.instance_id = instance_id
        # 服务标识
        self.data_id = data_id
        # 应用名称
        self.app_name = app_name
        # 服务提供方客户端IP
        self.host_ip = host_ip
        # 服务提供方客户端发布的IP
        self.service_ip = service_ip
        # 服务提供方客户端发布的端口
        self.service_port = service_port
        # 请求权重，范围：0-100
        self.weight = weight
        # 逻辑机房
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.host_ip is not None:
            result['host_ip'] = self.host_ip
        if self.service_ip is not None:
            result['service_ip'] = self.service_ip
        if self.service_port is not None:
            result['service_port'] = self.service_port
        if self.weight is not None:
            result['weight'] = self.weight
        if self.zone is not None:
            result['zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('host_ip') is not None:
            self.host_ip = m.get('host_ip')
        if m.get('service_ip') is not None:
            self.service_ip = m.get('service_ip')
        if m.get('service_port') is not None:
            self.service_port = m.get('service_port')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        return self


class DrmResourceTpl(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        attributes: List[DrmAttribute] = None,
        desc: str = None,
        has_instance: bool = None,
        id: int = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # app name
        self.app_name = app_name
        # 资源属性列表
        self.attributes = attributes
        # 描述
        self.desc = desc
        # 所有单元中是否存在有特殊推送过值的单元
        self.has_instance = has_instance
        # drm资源id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 资源域
        self.region = region
        # 资源类路径
        self.resource_id = resource_id

    def validate(self):
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        result['attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['attributes'].append(k.to_map() if k else None)
        if self.desc is not None:
            result['desc'] = self.desc
        if self.has_instance is not None:
            result['has_instance'] = self.has_instance
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        self.attributes = []
        if m.get('attributes') is not None:
            for k in m.get('attributes'):
                temp_model = DrmAttribute()
                self.attributes.append(temp_model.from_map(k))
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('has_instance') is not None:
            self.has_instance = m.get('has_instance')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class AuditLogModel(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        operate_type: str = None,
        operate_interface: str = None,
        description: str = None,
        content: str = None,
        response: str = None,
        status: int = None,
        operator: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
    ):
        # 主键
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 操作类型
        self.operate_type = operate_type
        # sofa.ms.auditlogs.list
        self.operate_interface = operate_interface
        # 描述信息
        self.description = description
        # 请求参数
        self.content = content
        # 响应结果
        self.response = response
        # 0 失败 1 成功
        self.status = status
        # 操作人
        self.operator = operator
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operate_type is not None:
            result['operate_type'] = self.operate_type
        if self.operate_interface is not None:
            result['operate_interface'] = self.operate_interface
        if self.description is not None:
            result['description'] = self.description
        if self.content is not None:
            result['content'] = self.content
        if self.response is not None:
            result['response'] = self.response
        if self.status is not None:
            result['status'] = self.status
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operate_type') is not None:
            self.operate_type = m.get('operate_type')
        if m.get('operate_interface') is not None:
            self.operate_interface = m.get('operate_interface')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('response') is not None:
            self.response = m.get('response')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        return self


class CommunicationPageModel(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        direction: int = None,
        mode: int = None,
        strategy: str = None,
        enabled: int = None,
        scope: int = None,
        operator: str = None,
        operate_time: str = None,
    ):
        # id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 规则名称
        self.name = name
        # 取值(0-客户端,1-服务端)
        self.direction = direction
        # 模式(0-tls,1-mtls)
        self.mode = mode
        # 策略(0-普通,1-国密)
        self.strategy = strategy
        # 状态(0-关闭,1-开启)
        self.enabled = enabled
        # 分类(0-应用,1-标签)
        self.scope = scope
        # 操作人
        self.operator = operator
        # 操作时间
        self.operate_time = operate_time

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.direction is not None:
            result['direction'] = self.direction
        if self.mode is not None:
            result['mode'] = self.mode
        if self.strategy is not None:
            result['strategy'] = self.strategy
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.scope is not None:
            result['scope'] = self.scope
        if self.operator is not None:
            result['operator'] = self.operator
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('direction') is not None:
            self.direction = m.get('direction')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('strategy') is not None:
            self.strategy = m.get('strategy')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        return self


class DowngradeRuleGroupVo(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        app_name: str = None,
        type: str = None,
        enabled: int = None,
        downgrade_rules: List[DowngradeRuleVo] = None,
    ):
        # 主键
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # foo
        self.app_name = app_name
        # 类型
        self.type = type
        # 降级全局开关(0:关闭 1:开启)
        self.enabled = enabled
        # 降级规则
        self.downgrade_rules = downgrade_rules

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.downgrade_rules, 'downgrade_rules')
        if self.downgrade_rules:
            for k in self.downgrade_rules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.type is not None:
            result['type'] = self.type
        if self.enabled is not None:
            result['enabled'] = self.enabled
        result['downgrade_rules'] = []
        if self.downgrade_rules is not None:
            for k in self.downgrade_rules:
                result['downgrade_rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        self.downgrade_rules = []
        if m.get('downgrade_rules') is not None:
            for k in m.get('downgrade_rules'):
                temp_model = DowngradeRuleVo()
                self.downgrade_rules.append(temp_model.from_map(k))
        return self


class SideCarDetailModel(TeaModel):
    def __init__(
        self,
        app_service_name: str = None,
        clustername: str = None,
        created_time: str = None,
        namespace: str = None,
        pod_ip: str = None,
        pod_name: str = None,
        pod_status: str = None,
        sidecar_status: str = None,
        sidecar_type: str = None,
        sidecar_version: str = None,
    ):
        # 应用服务名
        self.app_service_name = app_service_name
        # 集群名
        self.clustername = clustername
        # pod创建时间
        self.created_time = created_time
        # 命名空间
        self.namespace = namespace
        # pod ip
        self.pod_ip = pod_ip
        # pod实例名
        self.pod_name = pod_name
        # pod状态
        self.pod_status = pod_status
        # sidecar状态
        self.sidecar_status = sidecar_status
        # sidecar类型(mosn/odp/mist)
        self.sidecar_type = sidecar_type
        # sidecar版本
        self.sidecar_version = sidecar_version

    def validate(self):
        self.validate_required(self.app_service_name, 'app_service_name')
        self.validate_required(self.clustername, 'clustername')
        self.validate_required(self.created_time, 'created_time')
        if self.created_time is not None:
            self.validate_pattern(self.created_time, 'created_time', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.pod_ip, 'pod_ip')
        self.validate_required(self.pod_name, 'pod_name')
        self.validate_required(self.pod_status, 'pod_status')
        self.validate_required(self.sidecar_status, 'sidecar_status')
        self.validate_required(self.sidecar_type, 'sidecar_type')
        self.validate_required(self.sidecar_version, 'sidecar_version')

    def to_map(self):
        result = dict()
        if self.app_service_name is not None:
            result['app_service_name'] = self.app_service_name
        if self.clustername is not None:
            result['clustername'] = self.clustername
        if self.created_time is not None:
            result['created_time'] = self.created_time
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.pod_ip is not None:
            result['pod_ip'] = self.pod_ip
        if self.pod_name is not None:
            result['pod_name'] = self.pod_name
        if self.pod_status is not None:
            result['pod_status'] = self.pod_status
        if self.sidecar_status is not None:
            result['sidecar_status'] = self.sidecar_status
        if self.sidecar_type is not None:
            result['sidecar_type'] = self.sidecar_type
        if self.sidecar_version is not None:
            result['sidecar_version'] = self.sidecar_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_service_name') is not None:
            self.app_service_name = m.get('app_service_name')
        if m.get('clustername') is not None:
            self.clustername = m.get('clustername')
        if m.get('created_time') is not None:
            self.created_time = m.get('created_time')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('pod_ip') is not None:
            self.pod_ip = m.get('pod_ip')
        if m.get('pod_name') is not None:
            self.pod_name = m.get('pod_name')
        if m.get('pod_status') is not None:
            self.pod_status = m.get('pod_status')
        if m.get('sidecar_status') is not None:
            self.sidecar_status = m.get('sidecar_status')
        if m.get('sidecar_type') is not None:
            self.sidecar_type = m.get('sidecar_type')
        if m.get('sidecar_version') is not None:
            self.sidecar_version = m.get('sidecar_version')
        return self


class Test(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class TransparentProxyAppVo(TeaModel):
    def __init__(
        self,
        app_config: TransparentProxyAppConfig = None,
        app_name: str = None,
        id: int = None,
        instance_id: str = None,
        node_num: int = None,
        open_num: int = None,
        run_num: int = None,
        support_protocols: List[TransparentProxyProtocolVo] = None,
    ):
        # 透明劫持配置
        self.app_config = app_config
        # 应用名称
        self.app_name = app_name
        # 应用 ID
        self.id = id
        # 租户实例 ID
        self.instance_id = instance_id
        # 节点数
        self.node_num = node_num
        # 打开透明劫持的节点数
        self.open_num = open_num
        # 运行透明劫持的节点数
        self.run_num = run_num
        # 应用支持的协议
        self.support_protocols = support_protocols

    def validate(self):
        if self.app_config:
            self.app_config.validate()
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.node_num, 'node_num')
        self.validate_required(self.open_num, 'open_num')
        self.validate_required(self.run_num, 'run_num')
        if self.support_protocols:
            for k in self.support_protocols:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.app_config is not None:
            result['app_config'] = self.app_config.to_map()
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.node_num is not None:
            result['node_num'] = self.node_num
        if self.open_num is not None:
            result['open_num'] = self.open_num
        if self.run_num is not None:
            result['run_num'] = self.run_num
        result['support_protocols'] = []
        if self.support_protocols is not None:
            for k in self.support_protocols:
                result['support_protocols'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_config') is not None:
            temp_model = TransparentProxyAppConfig()
            self.app_config = temp_model.from_map(m['app_config'])
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('node_num') is not None:
            self.node_num = m.get('node_num')
        if m.get('open_num') is not None:
            self.open_num = m.get('open_num')
        if m.get('run_num') is not None:
            self.run_num = m.get('run_num')
        self.support_protocols = []
        if m.get('support_protocols') is not None:
            for k in m.get('support_protocols'):
                temp_model = TransparentProxyProtocolVo()
                self.support_protocols.append(temp_model.from_map(k))
        return self


class TrafficMirrorRuleVO(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
        source_app: str = None,
        source_data_id: str = None,
        target_app: str = None,
        target_data_id: str = None,
        rule_name: str = None,
        enabled: bool = None,
        operator: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        rule_config: TrafficMirrorConfigModel = None,
    ):
        # id
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 源应用
        self.source_app = source_app
        # 源服务ID
        self.source_data_id = source_data_id
        # 目标应用
        self.target_app = target_app
        # 目标服务ID
        self.target_data_id = target_data_id
        # 规则名
        self.rule_name = rule_name
        # 是否开启
        self.enabled = enabled
        # 操作人
        self.operator = operator
        # 创建时间
        self.gmt_create = gmt_create
        # 更新时间
        self.gmt_modified = gmt_modified
        # 规则配置
        self.rule_config = rule_config

    def validate(self):
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.rule_config:
            self.rule_config.validate()

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.source_app is not None:
            result['source_app'] = self.source_app
        if self.source_data_id is not None:
            result['source_data_id'] = self.source_data_id
        if self.target_app is not None:
            result['target_app'] = self.target_app
        if self.target_data_id is not None:
            result['target_data_id'] = self.target_data_id
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.operator is not None:
            result['operator'] = self.operator
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('source_app') is not None:
            self.source_app = m.get('source_app')
        if m.get('source_data_id') is not None:
            self.source_data_id = m.get('source_data_id')
        if m.get('target_app') is not None:
            self.target_app = m.get('target_app')
        if m.get('target_data_id') is not None:
            self.target_data_id = m.get('target_data_id')
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('rule_config') is not None:
            temp_model = TrafficMirrorConfigModel()
            self.rule_config = temp_model.from_map(m['rule_config'])
        return self


class TransparentProxyConnPoolConfig(TeaModel):
    def __init__(
        self,
        max_req: int = None,
    ):
        # 最大连接数
        self.max_req = max_req

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.max_req is not None:
            result['max_req'] = self.max_req
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('max_req') is not None:
            self.max_req = m.get('max_req')
        return self


class PersistpushMsDdcsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        operator: str = None,
        region: str = None,
        resource_id: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        # 属性名称，长度50以内
        self.attribute_name = attribute_name
        # 实例标识，通常在中间件门户首页获取，长度50以内
        self.instance_id = instance_id
        # 操作人，可以定义为系统或者实际操作人，用于推送源追溯，长度50以内
        self.operator = operator
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id
        # 推送值，长度10240以内
        self.value = value

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class PersistpushMsDdcsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        version: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 推送成功数据版本，有效值为1~Long最大值
        self.version = version

    def validate(self):
        self.validate_required(self.version, 'version')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class QueryclientsMsDdcsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        # 属性名称，长度50以内
        self.attribute_name = attribute_name
        # 实例标识，通常在中间件门户首页获取，长度50以内
        self.instance_id = instance_id
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class QueryclientsMsDdcsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        clients: List[ClientInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 订阅客户端列表
        self.clients = clients

    def validate(self):
        self.validate_required(self.clients, 'clients')
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['clients'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.clients = []
        if m.get('clients') is not None:
            for k in m.get('clients'):
                temp_model = ClientInfo()
                self.clients.append(temp_model.from_map(k))
        return self


class AddMsDdcsResourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attributes: List[Attribute] = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        # 属性列表，类型是数组
        self.attributes = attributes
        self.instance_id = instance_id
        # 资源描述，长度150以内
        self.name = name
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        result['attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['attributes'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        self.attributes = []
        if m.get('attributes') is not None:
            for k in m.get('attributes'):
                temp_model = Attribute()
                self.attributes.append(temp_model.from_map(k))
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class AddMsDdcsResourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求是否执行成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class UpdateMsDdcsResourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        new_app_name: str = None,
        new_name: str = None,
        new_region: str = None,
        new_resource_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        self.instance_id = instance_id
        # 应用名称，长度50以内
        self.new_app_name = new_app_name
        # 资源描述，长度150以内
        self.new_name = new_name
        # 机构名称，长度20以内
        self.new_region = new_region
        # 配置类名称，长度150以内
        self.new_resource_id = new_resource_id
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.new_app_name is not None:
            result['new_app_name'] = self.new_app_name
        if self.new_name is not None:
            result['new_name'] = self.new_name
        if self.new_region is not None:
            result['new_region'] = self.new_region
        if self.new_resource_id is not None:
            result['new_resource_id'] = self.new_resource_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('new_app_name') is not None:
            self.new_app_name = m.get('new_app_name')
        if m.get('new_name') is not None:
            self.new_name = m.get('new_name')
        if m.get('new_region') is not None:
            self.new_region = m.get('new_region')
        if m.get('new_resource_id') is not None:
            self.new_resource_id = m.get('new_resource_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class UpdateMsDdcsResourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteMsDdcsResourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        self.instance_id = instance_id
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class DeleteMsDdcsResourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddMsDdcsAttributeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.attribute_name = attribute_name
        self.instance_id = instance_id
        # 属性描述
        self.name = name
        self.region = region
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class AddMsDdcsAttributeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行结果
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class UpdateMsDdcsAttributeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        new_attribute_name: str = None,
        new_name: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.attribute_name = attribute_name
        self.instance_id = instance_id
        self.new_attribute_name = new_attribute_name
        self.new_name = new_name
        self.region = region
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.new_attribute_name is not None:
            result['new_attribute_name'] = self.new_attribute_name
        if self.new_name is not None:
            result['new_name'] = self.new_name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('new_attribute_name') is not None:
            self.new_attribute_name = m.get('new_attribute_name')
        if m.get('new_name') is not None:
            self.new_name = m.get('new_name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class UpdateMsDdcsAttributeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteMsDdcsAttributeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.attribute_name = attribute_name
        self.instance_id = instance_id
        self.region = region
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class DeleteMsDdcsAttributeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class SearchMsDdcsResourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.instance_id = instance_id
        self.keyword = keyword
        self.page_size = page_size
        self.start = start

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class SearchMsDdcsResourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current: int = None,
        data: List[Resource] = None,
        page_size: int = None,
        success: bool = None,
        total: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        self.current = current
        self.data = data
        self.page_size = page_size
        # 请求执行是否成功
        self.success = success
        self.total = total

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current is not None:
            result['current'] = self.current
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current') is not None:
            self.current = m.get('current')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = Resource()
                self.data.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class AddMsDssTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cron: str = None,
        instance_id: str = None,
        name: str = None,
        system: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.cron = cron
        self.instance_id = instance_id
        self.name = name
        self.system = system

    def validate(self):
        self.validate_required(self.cron, 'cron')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.system, 'system')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cron is not None:
            result['cron'] = self.cron
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.system is not None:
            result['system'] = self.system
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cron') is not None:
            self.cron = m.get('cron')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('system') is not None:
            self.system = m.get('system')
        return self


class AddMsDssTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class UpdateMsDssTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        new_cron: str = None,
        new_name: str = None,
        new_system: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id
        self.name = name
        self.new_cron = new_cron
        self.new_name = new_name
        self.new_system = new_system

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.new_cron is not None:
            result['new_cron'] = self.new_cron
        if self.new_name is not None:
            result['new_name'] = self.new_name
        if self.new_system is not None:
            result['new_system'] = self.new_system
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('new_cron') is not None:
            self.new_cron = m.get('new_cron')
        if m.get('new_name') is not None:
            self.new_name = m.get('new_name')
        if m.get('new_system') is not None:
            self.new_system = m.get('new_system')
        return self


class UpdateMsDssTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteMsDssTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id
        self.name = name

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class DeleteMsDssTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class SearchMsDssTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        page_size: int = None,
        start: int = None,
        system: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id
        self.name = name
        self.page_size = page_size
        self.start = start
        self.system = system

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        if self.system is not None:
            result['system'] = self.system
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('system') is not None:
            self.system = m.get('system')
        return self


class SearchMsDssTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[Task] = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        self.data = data
        # 请求执行是否成功
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = Task()
                self.data.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class QueryMsDssTaskStrategyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.name = name
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryMsDssTaskStrategyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        strategies: List[Strategy] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        self.strategies = strategies

    def validate(self):
        if self.strategies:
            for k in self.strategies:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['strategies'] = []
        if self.strategies is not None:
            for k in self.strategies:
                result['strategies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.strategies = []
        if m.get('strategies') is not None:
            for k in m.get('strategies'):
                temp_model = Strategy()
                self.strategies.append(temp_model.from_map(k))
        return self


class ListDssIdcRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListDssIdcResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        idcs: List[Idc] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        self.idcs = idcs

    def validate(self):
        self.validate_required(self.idcs, 'idcs')
        if self.idcs:
            for k in self.idcs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['idcs'] = []
        if self.idcs is not None:
            for k in self.idcs:
                result['idcs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.idcs = []
        if m.get('idcs') is not None:
            for k in m.get('idcs'):
                temp_model = Idc()
                self.idcs.append(temp_model.from_map(k))
        return self


class AddDssScheduleRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        cronexp: str = None,
        divide_count: int = None,
        instance_id: str = None,
        max_load: int = None,
        name: str = None,
        priority: str = None,
        strategy_name: str = None,
        task_idcs: str = None,
        task_state: str = None,
        task_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.cronexp = cronexp
        self.divide_count = divide_count
        self.instance_id = instance_id
        self.max_load = max_load
        self.name = name
        self.priority = priority
        self.strategy_name = strategy_name
        self.task_idcs = task_idcs
        self.task_state = task_state
        self.task_type = task_type

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.cronexp, 'cronexp')
        self.validate_required(self.divide_count, 'divide_count')
        self.validate_required(self.max_load, 'max_load')
        self.validate_required(self.name, 'name')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.strategy_name, 'strategy_name')
        self.validate_required(self.task_idcs, 'task_idcs')
        self.validate_required(self.task_state, 'task_state')
        self.validate_required(self.task_type, 'task_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.cronexp is not None:
            result['cronexp'] = self.cronexp
        if self.divide_count is not None:
            result['divide_count'] = self.divide_count
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.max_load is not None:
            result['max_load'] = self.max_load
        if self.name is not None:
            result['name'] = self.name
        if self.priority is not None:
            result['priority'] = self.priority
        if self.strategy_name is not None:
            result['strategy_name'] = self.strategy_name
        if self.task_idcs is not None:
            result['task_idcs'] = self.task_idcs
        if self.task_state is not None:
            result['task_state'] = self.task_state
        if self.task_type is not None:
            result['task_type'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('cronexp') is not None:
            self.cronexp = m.get('cronexp')
        if m.get('divide_count') is not None:
            self.divide_count = m.get('divide_count')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('max_load') is not None:
            self.max_load = m.get('max_load')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('strategy_name') is not None:
            self.strategy_name = m.get('strategy_name')
        if m.get('task_idcs') is not None:
            self.task_idcs = m.get('task_idcs')
        if m.get('task_state') is not None:
            self.task_state = m.get('task_state')
        if m.get('task_type') is not None:
            self.task_type = m.get('task_type')
        return self


class AddDssScheduleResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateDssScheduleRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        cronexp: str = None,
        divide_count: int = None,
        id: str = None,
        instance_id: str = None,
        max_load: int = None,
        name: str = None,
        priority: str = None,
        strategy_name: str = None,
        task_idcs: str = None,
        task_state: str = None,
        task_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.cronexp = cronexp
        self.divide_count = divide_count
        self.id = id
        self.instance_id = instance_id
        self.max_load = max_load
        self.name = name
        self.priority = priority
        self.strategy_name = strategy_name
        self.task_idcs = task_idcs
        self.task_state = task_state
        self.task_type = task_type

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.cronexp, 'cronexp')
        self.validate_required(self.divide_count, 'divide_count')
        self.validate_required(self.max_load, 'max_load')
        self.validate_required(self.name, 'name')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.strategy_name, 'strategy_name')
        self.validate_required(self.task_idcs, 'task_idcs')
        self.validate_required(self.task_state, 'task_state')
        self.validate_required(self.task_type, 'task_type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.cronexp is not None:
            result['cronexp'] = self.cronexp
        if self.divide_count is not None:
            result['divide_count'] = self.divide_count
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.max_load is not None:
            result['max_load'] = self.max_load
        if self.name is not None:
            result['name'] = self.name
        if self.priority is not None:
            result['priority'] = self.priority
        if self.strategy_name is not None:
            result['strategy_name'] = self.strategy_name
        if self.task_idcs is not None:
            result['task_idcs'] = self.task_idcs
        if self.task_state is not None:
            result['task_state'] = self.task_state
        if self.task_type is not None:
            result['task_type'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('cronexp') is not None:
            self.cronexp = m.get('cronexp')
        if m.get('divide_count') is not None:
            self.divide_count = m.get('divide_count')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('max_load') is not None:
            self.max_load = m.get('max_load')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('strategy_name') is not None:
            self.strategy_name = m.get('strategy_name')
        if m.get('task_idcs') is not None:
            self.task_idcs = m.get('task_idcs')
        if m.get('task_state') is not None:
            self.task_state = m.get('task_state')
        if m.get('task_type') is not None:
            self.task_type = m.get('task_type')
        return self


class UpdateDssScheduleResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDssScheduleRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        name: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.instance_id = instance_id
        self.name = name
        self.page_num = page_num
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryDssScheduleResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        page_num: int = None,
        page_size: int = None,
        tasks: List[ScheduleTask] = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        self.page_num = page_num
        self.page_size = page_size
        self.tasks = tasks
        self.total_count = total_count

    def validate(self):
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['tasks'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.tasks = []
        if m.get('tasks') is not None:
            for k in m.get('tasks'):
                temp_model = ScheduleTask()
                self.tasks.append(temp_model.from_map(k))
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class PersistpushDdcsDataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        operator: str = None,
        region: str = None,
        resource_id: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        # 属性名称，长度50以内
        self.attribute_name = attribute_name
        # 实例标识，通常在中间件门户首页获取，长度50以内
        self.instance_id = instance_id
        # 操作人，可以定义为系统或者实际操作人，用于推送源追溯，长度50以内
        self.operator = operator
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id
        # 推送值，长度10240以内
        self.value = value

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.operator, 'operator')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class PersistpushDdcsDataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        version: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 推送成功数据版本，有效值为1~Long最大值
        self.version = version

    def validate(self):
        self.validate_required(self.version, 'version')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class QueryDdcsClientsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        # 属性名称，长度50以内
        self.attribute_name = attribute_name
        # 实例标识，通常在中间件门户首页获取，长度50以内
        self.instance_id = instance_id
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class QueryDdcsClientsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        clients: List[ClientInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 订阅客户端列表
        self.clients = clients

    def validate(self):
        self.validate_required(self.clients, 'clients')
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['clients'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.clients = []
        if m.get('clients') is not None:
            for k in m.get('clients'):
                temp_model = ClientInfo()
                self.clients.append(temp_model.from_map(k))
        return self


class AddDdcsResourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attributes: List[Attribute] = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        # 属性列表，类型是数组
        self.attributes = attributes
        self.instance_id = instance_id
        # 资源描述，长度150以内
        self.name = name
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        if self.attributes:
            for k in self.attributes:
                if k:
                    k.validate()
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        result['attributes'] = []
        if self.attributes is not None:
            for k in self.attributes:
                result['attributes'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        self.attributes = []
        if m.get('attributes') is not None:
            for k in m.get('attributes'):
                temp_model = Attribute()
                self.attributes.append(temp_model.from_map(k))
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class AddDdcsResourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求是否执行成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class UpdateDdcsResourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        new_app_name: str = None,
        new_name: str = None,
        new_region: str = None,
        new_resource_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        self.instance_id = instance_id
        # 应用名称，长度50以内
        self.new_app_name = new_app_name
        # 资源描述，长度150以内
        self.new_name = new_name
        # 机构名称，长度20以内
        self.new_region = new_region
        # 配置类名称，长度150以内
        self.new_resource_id = new_resource_id
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.new_app_name is not None:
            result['new_app_name'] = self.new_app_name
        if self.new_name is not None:
            result['new_name'] = self.new_name
        if self.new_region is not None:
            result['new_region'] = self.new_region
        if self.new_resource_id is not None:
            result['new_resource_id'] = self.new_resource_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('new_app_name') is not None:
            self.new_app_name = m.get('new_app_name')
        if m.get('new_name') is not None:
            self.new_name = m.get('new_name')
        if m.get('new_region') is not None:
            self.new_region = m.get('new_region')
        if m.get('new_resource_id') is not None:
            self.new_resource_id = m.get('new_resource_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class UpdateDdcsResourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteDdcsResourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，长度50以内
        self.app_name = app_name
        self.instance_id = instance_id
        # 机构名称，长度20以内
        self.region = region
        # 配置类名称，长度150以内
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class DeleteDdcsResourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class AddDdcsAttributeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.attribute_name = attribute_name
        self.instance_id = instance_id
        # 属性描述
        self.name = name
        self.region = region
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class AddDdcsAttributeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行结果
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class UpdateDdcsAttributeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        new_attribute_name: str = None,
        new_name: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.attribute_name = attribute_name
        self.instance_id = instance_id
        self.new_attribute_name = new_attribute_name
        self.new_name = new_name
        self.region = region
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.new_attribute_name is not None:
            result['new_attribute_name'] = self.new_attribute_name
        if self.new_name is not None:
            result['new_name'] = self.new_name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('new_attribute_name') is not None:
            self.new_attribute_name = m.get('new_attribute_name')
        if m.get('new_name') is not None:
            self.new_name = m.get('new_name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class UpdateDdcsAttributeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteDdcsAttributeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.attribute_name = attribute_name
        self.instance_id = instance_id
        self.region = region
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class DeleteDdcsAttributeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class SearchDdcsResourceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.app_name = app_name
        self.instance_id = instance_id
        self.keyword = keyword
        self.page_size = page_size
        self.start = start

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class SearchDdcsResourceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current: int = None,
        data: List[Resource] = None,
        page_size: int = None,
        success: bool = None,
        total: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        self.current = current
        self.data = data
        self.page_size = page_size
        # 请求执行是否成功
        self.success = success
        self.total = total

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current is not None:
            result['current'] = self.current
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current') is not None:
            self.current = m.get('current')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = Resource()
                self.data.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        return self


class AddDssTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cron: str = None,
        instance_id: str = None,
        name: str = None,
        system: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.cron = cron
        self.instance_id = instance_id
        self.name = name
        self.system = system

    def validate(self):
        self.validate_required(self.cron, 'cron')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.system, 'system')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cron is not None:
            result['cron'] = self.cron
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.system is not None:
            result['system'] = self.system
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cron') is not None:
            self.cron = m.get('cron')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('system') is not None:
            self.system = m.get('system')
        return self


class AddDssTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class UpdateDssTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        new_cron: str = None,
        new_name: str = None,
        new_system: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id
        self.name = name
        self.new_cron = new_cron
        self.new_name = new_name
        self.new_system = new_system

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.new_cron is not None:
            result['new_cron'] = self.new_cron
        if self.new_name is not None:
            result['new_name'] = self.new_name
        if self.new_system is not None:
            result['new_system'] = self.new_system
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('new_cron') is not None:
            self.new_cron = m.get('new_cron')
        if m.get('new_name') is not None:
            self.new_name = m.get('new_name')
        if m.get('new_system') is not None:
            self.new_system = m.get('new_system')
        return self


class UpdateDssTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class DeleteDssTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id
        self.name = name

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class DeleteDssTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class SearchDssTaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
        page_size: int = None,
        start: int = None,
        system: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id
        self.name = name
        self.page_size = page_size
        self.start = start
        self.system = system

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        if self.system is not None:
            result['system'] = self.system
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('system') is not None:
            self.system = m.get('system')
        return self


class SearchDssTaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[Task] = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        self.data = data
        # 请求执行是否成功
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = Task()
                self.data.append(temp_model.from_map(k))
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class QueryDssStrategyRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class QueryDssStrategyResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        strategies: List[Strategy] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        self.strategies = strategies

    def validate(self):
        if self.strategies:
            for k in self.strategies:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['strategies'] = []
        if self.strategies is not None:
            for k in self.strategies:
                result['strategies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.strategies = []
        if m.get('strategies') is not None:
            for k in m.get('strategies'):
                temp_model = Strategy()
                self.strategies.append(temp_model.from_map(k))
        return self


class DeleteDssScheduleRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.id = id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteDssScheduleResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ExecuteDssSwitchoverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        dest_cell: str = None,
        instance_id: str = None,
        source_cell: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.dest_cell = dest_cell
        self.instance_id = instance_id
        self.source_cell = source_cell

    def validate(self):
        self.validate_required(self.dest_cell, 'dest_cell')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.source_cell, 'source_cell')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.dest_cell is not None:
            result['dest_cell'] = self.dest_cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('dest_cell') is not None:
            self.dest_cell = m.get('dest_cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        return self


class ExecuteDssSwitchoverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否达到预期切换状态
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class CancelDssSwitchoverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        dest_cell: str = None,
        instance_id: str = None,
        source_cell: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.dest_cell = dest_cell
        self.instance_id = instance_id
        self.source_cell = source_cell

    def validate(self):
        self.validate_required(self.dest_cell, 'dest_cell')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.source_cell, 'source_cell')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.dest_cell is not None:
            result['dest_cell'] = self.dest_cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.source_cell is not None:
            result['source_cell'] = self.source_cell
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('dest_cell') is not None:
            self.dest_cell = m.get('dest_cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('source_cell') is not None:
            self.source_cell = m.get('source_cell')
        return self


class CancelDssSwitchoverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        success: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 请求执行是否成功
        self.success = success

    def validate(self):
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class QueryDssSwitchoverRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryDssSwitchoverResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        actions: List[SwitchoverAction] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 单元切换状态列表
        self.actions = actions

    def validate(self):
        self.validate_required(self.actions, 'actions')
        if self.actions:
            for k in self.actions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['actions'] = []
        if self.actions is not None:
            for k in self.actions:
                result['actions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.actions = []
        if m.get('actions') is not None:
            for k in m.get('actions'):
                temp_model = SwitchoverAction()
                self.actions.append(temp_model.from_map(k))
        return self


class LogoutRegistryServiceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        server_ips: List[str] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id
        # 服务器 IP
        self.server_ips = server_ips

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.server_ips, 'server_ips')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.server_ips is not None:
            result['server_ips'] = self.server_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('server_ips') is not None:
            self.server_ips = m.get('server_ips')
        return self


class LogoutRegistryServiceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class OnlineRegistryServiceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        server_ips: List[str] = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # instance_id
        self.instance_id = instance_id
        # server_ips
        self.server_ips = server_ips

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.server_ips, 'server_ips')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.server_ips is not None:
            result['server_ips'] = self.server_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('server_ips') is not None:
            self.server_ips = m.get('server_ips')
        return self


class OnlineRegistryServiceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSofaOspInstanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        tenant: str = None,
        workspace: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.tenant = tenant
        self.workspace = workspace

    def validate(self):
        self.validate_required(self.tenant, 'tenant')
        self.validate_required(self.workspace, 'workspace')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.workspace is not None:
            result['workspace'] = self.workspace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('workspace') is not None:
            self.workspace = m.get('workspace')
        return self


class ListSofaOspInstanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        instances: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 实例标识列表
        self.instances = instances

    def validate(self):
        self.validate_required(self.instances, 'instances')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.instances is not None:
            result['instances'] = self.instances
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('instances') is not None:
            self.instances = m.get('instances')
        return self


class AddSofaOspCellRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.cell = cell
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class AddSofaOspCellResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteSofaOspCellRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cell: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.cell = cell
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.cell, 'cell')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cell is not None:
            result['cell'] = self.cell
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cell') is not None:
            self.cell = m.get('cell')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSofaOspCellResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySofaOspCellRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySofaOspCellResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        cells: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前生效的单元列表
        self.cells = cells

    def validate(self):
        self.validate_required(self.cells, 'cells')

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.cells is not None:
            result['cells'] = self.cells
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('cells') is not None:
            self.cells = m.get('cells')
        return self


class QueryServiceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # middleware instance id
        self.instance_id = instance_id
        # num of page
        self.page_num = page_num
        # size of page
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryServiceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        page_num: int = None,
        page_size: int = None,
        services: List[ServiceRecord] = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Page number
        self.page_num = page_num
        # Page size
        self.page_size = page_size
        # Result of service records.
        self.services = services
        # Total item number
        self.total_count = total_count

    def validate(self):
        if self.services:
            for k in self.services:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['services'] = []
        if self.services is not None:
            for k in self.services:
                result['services'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.services = []
        if m.get('services') is not None:
            for k in m.get('services'):
                temp_model = ServiceRecord()
                self.services.append(temp_model.from_map(k))
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryServicePublisherRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        data_id: str = None,
        page_num: int = None,
        page_size: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # middleware instance id
        self.instance_id = instance_id
        # app name
        self.data_id = data_id
        # num of page
        self.page_num = page_num
        # size of page
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryServicePublisherResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        publishers: List[ServicePublisher] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Result of service publishers.
        self.publishers = publishers
        # Page number
        self.page_num = page_num
        # Page size
        self.page_size = page_size
        # Total item number
        self.total_count = total_count

    def validate(self):
        if self.publishers:
            for k in self.publishers:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['publishers'] = []
        if self.publishers is not None:
            for k in self.publishers:
                result['publishers'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.publishers = []
        if m.get('publishers') is not None:
            for k in m.get('publishers'):
                temp_model = ServicePublisher()
                self.publishers.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryServiceSubscriberRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        data_id: str = None,
        page_num: int = None,
        page_size: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # middleware instance id
        self.instance_id = instance_id
        # app name
        self.data_id = data_id
        # num of page
        self.page_num = page_num
        # size of page
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryServiceSubscriberResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        subscribers: List[ServiceSubscriber] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Result of service subcribers.
        self.subscribers = subscribers
        # Page number
        self.page_num = page_num
        # Page size
        self.page_size = page_size
        # Total item number
        self.total_count = total_count

    def validate(self):
        if self.subscribers:
            for k in self.subscribers:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['subscribers'] = []
        if self.subscribers is not None:
            for k in self.subscribers:
                result['subscribers'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.subscribers = []
        if m.get('subscribers') is not None:
            for k in m.get('subscribers'):
                temp_model = ServiceSubscriber()
                self.subscribers.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class AddServiceClientRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        server_ips: str = None,
        operation_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # middleware instance id
        self.instance_id = instance_id
        # 服务器 IP 列表，多个 IP 间以英文逗号分隔
        self.server_ips = server_ips
        # Client operation type: (logout)
        self.operation_type = operation_type

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.server_ips, 'server_ips')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.server_ips is not None:
            result['server_ips'] = self.server_ips
        if self.operation_type is not None:
            result['operation_type'] = self.operation_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('server_ips') is not None:
            self.server_ips = m.get('server_ips')
        if m.get('operation_type') is not None:
            self.operation_type = m.get('operation_type')
        return self


class AddServiceClientResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryDdcsResourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
        page_num: int = None,
        page_size: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 系统字段：环境实例 ID
        self.instance_id = instance_id
        # 资源 ID 模糊查询关键字
        self.keyword = keyword
        # 分页参数，第几页
        self.page_num = page_num
        # 分页参数，分页大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryDdcsResourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        page_num: int = None,
        page_size: int = None,
        resources: List[Resource] = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 分页参数，第几页
        self.page_num = page_num
        # 分页参数，分页大小
        self.page_size = page_size
        # 模糊查询资源结果
        self.resources = resources
        # 满足模糊查询条件的结果总条数
        self.total_count = total_count

    def validate(self):
        if self.resources:
            for k in self.resources:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['resources'] = []
        if self.resources is not None:
            for k in self.resources:
                result['resources'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.resources = []
        if m.get('resources') is not None:
            for k in m.get('resources'):
                temp_model = Resource()
                self.resources.append(temp_model.from_map(k))
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class AddDdcsDataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_id: int = None,
        cells: str = None,
        data: str = None,
        instance_id: str = None,
        operator: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性自增长 ID
        self.attribute_id = attribute_id
        # 需要发布的单元列表，英文逗号隔开，为空表示推送到所有单元
        self.cells = cells
        # 推送的属性值
        self.data = data
        # 系统字段：环境实例 ID
        # 
        self.instance_id = instance_id
        # 操作人
        self.operator = operator

    def validate(self):
        self.validate_required(self.attribute_id, 'attribute_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_id is not None:
            result['attribute_id'] = self.attribute_id
        if self.cells is not None:
            result['cells'] = self.cells
        if self.data is not None:
            result['data'] = self.data
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_id') is not None:
            self.attribute_id = m.get('attribute_id')
        if m.get('cells') is not None:
            self.cells = m.get('cells')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class AddDdcsDataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class AddDdcsResourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attributes: str = None,
        desc: str = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 资源的属性信息，以 JSON 字符串格式传入
        self.attributes = attributes
        # 资源描述信息
        self.desc = desc
        # 系统字段：环境实例 ID
        # 
        self.instance_id = instance_id
        # 资源类所属的域
        self.region = region
        # 资源 ID，类似于配置文件的文件名
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.desc is not None:
            result['desc'] = self.desc
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class AddDdcsResourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        resource: Resource = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 创建成功的资源信息
        self.resource = resource

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.resource is not None:
            result['resource'] = self.resource.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('resource') is not None:
            temp_model = Resource()
            self.resource = temp_model.from_map(m['resource'])
        return self


class UpdateDdcsResourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attributes: str = None,
        desc: str = None,
        id: int = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
        update_attribute: bool = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 资源的属性信息，以 JSON 字符串格式传入
        self.attributes = attributes
        # 资源描述信息
        self.desc = desc
        # 更新的资源自增长 ID
        self.id = id
        # 系统字段：环境实例 ID
        self.instance_id = instance_id
        # 资源搜索的域
        self.region = region
        # 资源唯一标识
        self.resource_id = resource_id
        # 是否全量更新属性，默认为 false
        self.update_attribute = update_attribute

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.desc is not None:
            result['desc'] = self.desc
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.update_attribute is not None:
            result['update_attribute'] = self.update_attribute
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('update_attribute') is not None:
            self.update_attribute = m.get('update_attribute')
        return self


class UpdateDdcsResourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteDdcsResourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 资源自增长 ID
        self.id = id
        # 系统字段：环境实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteDdcsResourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class GetDdcsResourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 资源自增长 ID
        self.id = id
        # 系统字段：环境实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetDdcsResourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        resource: Resource = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 资源信息
        self.resource = resource

    def validate(self):
        if self.resource:
            self.resource.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.resource is not None:
            result['resource'] = self.resource.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('resource') is not None:
            temp_model = Resource()
            self.resource = temp_model.from_map(m['resource'])
        return self


class AddDdcsAttributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_name: str = None,
        desc: str = None,
        instance_id: str = None,
        resource_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性名称
        self.attribute_name = attribute_name
        # 属性描述信息
        self.desc = desc
        # 环境实例 ID
        self.instance_id = instance_id
        # 所属的资源自增长 ID
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.desc is not None:
            result['desc'] = self.desc
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class AddDdcsAttributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        attribute: Attribute = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 添加成功的属性结构体
        self.attribute = attribute

    def validate(self):
        if self.attribute:
            self.attribute.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.attribute is not None:
            result['attribute'] = self.attribute.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('attribute') is not None:
            temp_model = Attribute()
            self.attribute = temp_model.from_map(m['attribute'])
        return self


class UpdateDdcsAttributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_name: str = None,
        desc: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性名称
        self.attribute_name = attribute_name
        # 属性描述信息
        self.desc = desc
        # 属性自增长 ID
        self.id = id
        # 系统字段：环境实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.desc is not None:
            result['desc'] = self.desc
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class UpdateDdcsAttributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteDdcsAttributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性自增长 ID
        self.id = id
        # 系统字段：环境实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteDdcsAttributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class GetDdcsAttributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性自增长 ID
        self.id = id
        # 系统字段：环境实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetDdcsAttributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        attribute: Attribute = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 属性信息
        self.attribute = attribute

    def validate(self):
        if self.attribute:
            self.attribute.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.attribute is not None:
            result['attribute'] = self.attribute.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('attribute') is not None:
            temp_model = Attribute()
            self.attribute = temp_model.from_map(m['attribute'])
        return self


class QueryDdcsAttributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attribute_name: str = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 属性名称
        self.attribute_name = attribute_name
        # 系统字段：环境实例 ID
        self.instance_id = instance_id
        # 资源所属域
        self.region = region
        # 资源 ID，类似于文件名
        self.resource_id = resource_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        return self


class QueryDdcsAttributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        attribute: Attribute = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 属性信息
        self.attribute = attribute

    def validate(self):
        if self.attribute:
            self.attribute.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.attribute is not None:
            result['attribute'] = self.attribute.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('attribute') is not None:
            temp_model = Attribute()
            self.attribute = temp_model.from_map(m['attribute'])
        return self


class GetDdsJobRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # job id
        self.id = id
        # middleware instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetDdsJobResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        job: Job = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 任务信息
        self.job = job

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.job is not None:
            result['job'] = self.job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('job') is not None:
            temp_model = Job()
            self.job = temp_model.from_map(m['job'])
        return self


class AddDdsJobRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        app: str = None,
        name: str = None,
        cron: str = None,
        sharding_count: int = None,
        custom_params: List[str] = None,
        status: str = None,
        des: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # middleware instance id
        self.instance_id = instance_id
        # 任务所属APP
        self.app = app
        # 任务名字
        self.name = name
        # 任务CRON表达式
        self.cron = cron
        # 任务分片数量
        self.sharding_count = sharding_count
        # 任务自定义参数
        self.custom_params = custom_params
        # 任务状态
        self.status = status
        # 任务描述信息
        self.des = des

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.app, 'app')
        self.validate_required(self.name, 'name')
        self.validate_required(self.cron, 'cron')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app is not None:
            result['app'] = self.app
        if self.name is not None:
            result['name'] = self.name
        if self.cron is not None:
            result['cron'] = self.cron
        if self.sharding_count is not None:
            result['sharding_count'] = self.sharding_count
        if self.custom_params is not None:
            result['custom_params'] = self.custom_params
        if self.status is not None:
            result['status'] = self.status
        if self.des is not None:
            result['des'] = self.des
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('cron') is not None:
            self.cron = m.get('cron')
        if m.get('sharding_count') is not None:
            self.sharding_count = m.get('sharding_count')
        if m.get('custom_params') is not None:
            self.custom_params = m.get('custom_params')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('des') is not None:
            self.des = m.get('des')
        return self


class AddDdsJobResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        job: Job = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 操作返回信息
        self.job = job

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.job is not None:
            result['job'] = self.job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('job') is not None:
            temp_model = Job()
            self.job = temp_model.from_map(m['job'])
        return self


class UpdateDdsJobRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
        cron: str = None,
        sharding_count: int = None,
        custom_params: List[str] = None,
        des: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # job id
        self.id = id
        # middleware instance id
        self.instance_id = instance_id
        # 任务CRON表达式
        self.cron = cron
        # 任务分片数量
        self.sharding_count = sharding_count
        # 任务自定义参数
        self.custom_params = custom_params
        # 任务描述信息
        self.des = des

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.cron, 'cron')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.cron is not None:
            result['cron'] = self.cron
        if self.sharding_count is not None:
            result['sharding_count'] = self.sharding_count
        if self.custom_params is not None:
            result['custom_params'] = self.custom_params
        if self.des is not None:
            result['des'] = self.des
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('cron') is not None:
            self.cron = m.get('cron')
        if m.get('sharding_count') is not None:
            self.sharding_count = m.get('sharding_count')
        if m.get('custom_params') is not None:
            self.custom_params = m.get('custom_params')
        if m.get('des') is not None:
            self.des = m.get('des')
        return self


class UpdateDdsJobResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        job: Job = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 操作返回信息
        self.job = job

    def validate(self):
        if self.job:
            self.job.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.job is not None:
            result['job'] = self.job.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('job') is not None:
            temp_model = Job()
            self.job = temp_model.from_map(m['job'])
        return self


class DeleteDdsJobRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # job id
        self.id = id
        # middleware instance id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteDdsJobResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateDdsJobStatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        id: int = None,
        status: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # middleware instance id
        self.instance_id = instance_id
        # job id
        self.id = id
        # 任务状态
        self.status = status

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.id, 'id')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class UpdateDdsJobStatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class AddDdcsGraydataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_id: int = None,
        data: str = None,
        hosts: str = None,
        instance_id: str = None,
        operator: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性自增长 ID，可以通过查询属性接口获取 ID
        self.attribute_id = attribute_id
        # 属性推送值
        self.data = data
        # 灰度推送的机器列表，多个 IP 之间英文逗号隔开
        self.hosts = hosts
        # 系统字段：环境实例 ID
        self.instance_id = instance_id
        # 操作人
        self.operator = operator

    def validate(self):
        self.validate_required(self.attribute_id, 'attribute_id')
        self.validate_required(self.hosts, 'hosts')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_id is not None:
            result['attribute_id'] = self.attribute_id
        if self.data is not None:
            result['data'] = self.data
        if self.hosts is not None:
            result['hosts'] = self.hosts
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_id') is not None:
            self.attribute_id = m.get('attribute_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('hosts') is not None:
            self.hosts = m.get('hosts')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class AddDdcsGraydataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        push_result: List[GrayPublishResultItem] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 推送结果列表
        self.push_result = push_result

    def validate(self):
        if self.push_result:
            for k in self.push_result:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['push_result'] = []
        if self.push_result is not None:
            for k in self.push_result:
                result['push_result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.push_result = []
        if m.get('push_result') is not None:
            for k in m.get('push_result'):
                temp_model = GrayPublishResultItem()
                self.push_result.append(temp_model.from_map(k))
        return self


class QueryDdcsDataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性自增长 ID，可以通过查询属性接口获取 ID
        self.attribute_id = attribute_id
        # 系统字段：环境实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.attribute_id, 'attribute_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_id is not None:
            result['attribute_id'] = self.attribute_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_id') is not None:
            self.attribute_id = m.get('attribute_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryDdcsDataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        query_result: List[PublishDataItem] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询推送值结果，数组中每一项表示具体的单元，DEFAULT_ZONE 表示所有单元。
        self.query_result = query_result

    def validate(self):
        if self.query_result:
            for k in self.query_result:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['query_result'] = []
        if self.query_result is not None:
            for k in self.query_result:
                result['query_result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.query_result = []
        if m.get('query_result') is not None:
            for k in m.get('query_result'):
                temp_model = PublishDataItem()
                self.query_result.append(temp_model.from_map(k))
        return self


class QueryDdsJobsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        app: str = None,
        name: str = None,
        page_num: int = None,
        page_size: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # middleware instance id
        self.instance_id = instance_id
        # 任务所属APP
        self.app = app
        # 任务名字
        self.name = name
        # num of page
        self.page_num = page_num
        # size of page
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_num, 'page_num')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app is not None:
            result['app'] = self.app
        if self.name is not None:
            result['name'] = self.name
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryDdsJobsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        jobs: List[Job] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 任务信息
        self.jobs = jobs
        # Page number
        self.page_num = page_num
        # Page size
        self.page_size = page_size
        # Total item number
        self.total_count = total_count

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['jobs'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_count is not None:
            result['total_count'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.jobs = []
        if m.get('jobs') is not None:
            for k in m.get('jobs'):
                temp_model = Job()
                self.jobs.append(temp_model.from_map(k))
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_count') is not None:
            self.total_count = m.get('total_count')
        return self


class QueryDdcsClientvalueRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_id: int = None,
        instance_id: str = None,
        ips: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性自增长 ID，可以通过查询属性接口获取 ID
        self.attribute_id = attribute_id
        # 系统字段：环境实例 ID
        self.instance_id = instance_id
        # 查询的 IP 列表，英文逗号隔开
        self.ips = ips

    def validate(self):
        self.validate_required(self.attribute_id, 'attribute_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ips, 'ips')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_id is not None:
            result['attribute_id'] = self.attribute_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ips is not None:
            result['ips'] = self.ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_id') is not None:
            self.attribute_id = m.get('attribute_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ips') is not None:
            self.ips = m.get('ips')
        return self


class QueryDdcsClientvalueResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        clients: List[ClientValue] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户端信息，包含内存值
        self.clients = clients

    def validate(self):
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['clients'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.clients = []
        if m.get('clients') is not None:
            for k in m.get('clients'):
                temp_model = ClientValue()
                self.clients.append(temp_model.from_map(k))
        return self


class QueryDdcsPushhistoryRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        end_time: int = None,
        instance_id: str = None,
        size: int = None,
        start_id: int = None,
        start_time: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 需要查询的 dataId，可不填。
        self.data_id = data_id
        # 查询的推送记录的介绍时间，值为 1970到现在的毫秒数，用毫秒数为了避免时区问题
        self.end_time = end_time
        # instance id
        self.instance_id = instance_id
        # 限时返回条数
        self.size = size
        # 从哪个id开始查询，不建议使用
        self.start_id = start_id
        # 查询的开始时间，值为 1970到现在的毫秒数，用毫秒数为了避免时区问题
        self.start_time = start_time

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.size is not None:
            result['size'] = self.size
        if self.start_id is not None:
            result['start_id'] = self.start_id
        if self.start_time is not None:
            result['start_time'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('size') is not None:
            self.size = m.get('size')
        if m.get('start_id') is not None:
            self.start_id = m.get('start_id')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        return self


class QueryDdcsPushhistoryResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        history: List[DDCSPushHistoryItem] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 推送记录列表
        self.history = history

    def validate(self):
        if self.history:
            for k in self.history:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['history'] = []
        if self.history is not None:
            for k in self.history:
                result['history'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.history = []
        if m.get('history') is not None:
            for k in m.get('history'):
                temp_model = DDCSPushHistoryItem()
                self.history.append(temp_model.from_map(k))
        return self


class QueryDssZoneRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例Id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryDssZoneResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 所有zone信息
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class RollbackDdcsDataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        attribute_id: int = None,
        unique_id: str = None,
        force_rollback: bool = None,
        operator: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 当前租户 instanceId
        self.instance_id = instance_id
        # 回滚的属性的id
        self.attribute_id = attribute_id
        # 再需要强制回滚的时候，需要通过指定 uniqueId 来强制回滚哪一次推送
        self.unique_id = unique_id
        # 默认情况下，只能回滚最后一次推送。
        # 
        # 但是通过 force_rollback + unique_id 可以强制指定回滚某一次推送。风险较高，不建议使用。
        self.force_rollback = force_rollback
        # 回滚操作人
        self.operator = operator

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.attribute_id, 'attribute_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.attribute_id is not None:
            result['attribute_id'] = self.attribute_id
        if self.unique_id is not None:
            result['unique_id'] = self.unique_id
        if self.force_rollback is not None:
            result['force_rollback'] = self.force_rollback
        if self.operator is not None:
            result['operator'] = self.operator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('attribute_id') is not None:
            self.attribute_id = m.get('attribute_id')
        if m.get('unique_id') is not None:
            self.unique_id = m.get('unique_id')
        if m.get('force_rollback') is not None:
            self.force_rollback = m.get('force_rollback')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        return self


class RollbackDdcsDataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSgAuthrulegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListSgAuthrulegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        auth_rule_groups: List[AuthRuleGroupVO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 鉴权规则组，黑白名单
        self.auth_rule_groups = auth_rule_groups

    def validate(self):
        if self.auth_rule_groups:
            for k in self.auth_rule_groups:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['auth_rule_groups'] = []
        if self.auth_rule_groups is not None:
            for k in self.auth_rule_groups:
                result['auth_rule_groups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.auth_rule_groups = []
        if m.get('auth_rule_groups') is not None:
            for k in m.get('auth_rule_groups'):
                temp_model = AuthRuleGroupVO()
                self.auth_rule_groups.append(temp_model.from_map(k))
        return self


class QuerySgFormconfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户instanceId
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySgFormconfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        auth_rule_config: AuthRuleConfig = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 所有配置信息
        self.auth_rule_config = auth_rule_config

    def validate(self):
        if self.auth_rule_config:
            self.auth_rule_config.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.auth_rule_config is not None:
            result['auth_rule_config'] = self.auth_rule_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('auth_rule_config') is not None:
            temp_model = AuthRuleConfig()
            self.auth_rule_config = temp_model.from_map(m['auth_rule_config'])
        return self


class ReinitSgAuthrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        auth_group_id: int = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务鉴权黑白名单id
        self.auth_group_id = auth_group_id
        # 服务id
        self.data_id = data_id
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.auth_group_id, 'auth_group_id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ReinitSgAuthrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SaveSgAuthrulegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        auth_rule_group: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # {"type":"WHITELIST","enabled":0,"instanceId":"000001","dataId":"com.alipay.antcloud.drmdata.facade.PushFacade:1.0@DEFAULT","rules":[{"ruleItems":[{"type":"SYSTEM","operation":"EQUAL","field":"source.application.id","value":"app1"}],"enabled":0,"name":"rule1"}]}
        self.auth_rule_group = auth_rule_group
        # 服务鉴权接口id
        self.data_id = data_id
        # 租户instanceId
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.auth_rule_group, 'auth_rule_group')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.auth_rule_group is not None:
            result['auth_rule_group'] = self.auth_rule_group
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('auth_rule_group') is not None:
            self.auth_rule_group = m.get('auth_rule_group')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class SaveSgAuthrulegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        auth_rule_groups: List[AuthRuleGroup] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 一个服务接口的白名单和黑名单
        self.auth_rule_groups = auth_rule_groups

    def validate(self):
        if self.auth_rule_groups:
            for k in self.auth_rule_groups:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['auth_rule_groups'] = []
        if self.auth_rule_groups is not None:
            for k in self.auth_rule_groups:
                result['auth_rule_groups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.auth_rule_groups = []
        if m.get('auth_rule_groups') is not None:
            for k in m.get('auth_rule_groups'):
                temp_model = AuthRuleGroup()
                self.auth_rule_groups.append(temp_model.from_map(k))
        return self


class SyncSgServicepublishersRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data: str = None,
        data_id: str = None,
        group: str = None,
        instance_id: str = None,
        ip: str = None,
        process_id: str = None,
        timestamp: int = None,
        zone: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称
        self.app_name = app_name
        # 服务发布数据
        self.data = data
        # 服务唯一ID
        self.data_id = data_id
        # 分组
        self.group = group
        # 金融云实例ID
        self.instance_id = instance_id
        # 发布者IP
        self.ip = ip
        # 进程ID
        self.process_id = process_id
        # 数据产生时间戳
        self.timestamp = timestamp
        # 逻辑机房
        self.zone = zone

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.process_id, 'process_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data is not None:
            result['data'] = self.data
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.process_id is not None:
            result['process_id'] = self.process_id
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.zone is not None:
            result['zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('process_id') is not None:
            self.process_id = m.get('process_id')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        return self


class SyncSgServicepublishersResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SyncSgServicesubscribersRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        process_id: str = None,
        data_id: str = None,
        group: str = None,
        instance_id: str = None,
        app_name: str = None,
        zone: str = None,
        ip: str = None,
        scope: str = None,
        timestamp: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 进程ID
        self.process_id = process_id
        # 服务唯一ID
        self.data_id = data_id
        # 分组
        self.group = group
        # 金融云实例ID
        self.instance_id = instance_id
        # 应用名称
        self.app_name = app_name
        # 逻辑机房
        self.zone = zone
        # 订阅者IP
        self.ip = ip
        # 订阅维度
        self.scope = scope
        # 数据产生时间戳
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.process_id, 'process_id')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.process_id is not None:
            result['process_id'] = self.process_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.group is not None:
            result['group'] = self.group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.zone is not None:
            result['zone'] = self.zone
        if self.ip is not None:
            result['ip'] = self.ip
        if self.scope is not None:
            result['scope'] = self.scope
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('process_id') is not None:
            self.process_id = m.get('process_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('zone') is not None:
            self.zone = m.get('zone')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class SyncSgServicesubscribersResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SyncSgServiceclientsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        process_id: str = None,
        timestamp: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 进程ID
        self.process_id = process_id
        # 数据产生时间戳
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.process_id, 'process_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.process_id is not None:
            result['process_id'] = self.process_id
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('process_id') is not None:
            self.process_id = m.get('process_id')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class SyncSgServiceclientsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SyncSgServiceheartbeatsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        process_id_list: List[str] = None,
        timestamp: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 进程唯一值集合
        self.process_id_list = process_id_list
        # 本次心跳产生时间
        self.timestamp = timestamp

    def validate(self):
        self.validate_required(self.process_id_list, 'process_id_list')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.process_id_list is not None:
            result['process_id_list'] = self.process_id_list
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('process_id_list') is not None:
            self.process_id_list = m.get('process_id_list')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class SyncSgServiceheartbeatsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySgServicepublishersRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        instance_id: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 服务接口信息
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 每页条数
        self.page_size = page_size
        # 分页开始数
        self.start = start

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QuerySgServicepublishersResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        publishers: List[Publisher] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 分页一页大小
        self.page_size = page_size
        # 服务提供者信息集合
        self.publishers = publishers
        # start_index
        self.start_index = start_index
        # total_size
        self.total_size = total_size

    def validate(self):
        if self.publishers:
            for k in self.publishers:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['publishers'] = []
        if self.publishers is not None:
            for k in self.publishers:
                result['publishers'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.publishers = []
        if m.get('publishers') is not None:
            for k in m.get('publishers'):
                temp_model = Publisher()
                self.publishers.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class QuerySgServicesubscribersRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        instance_id: str = None,
        page_size: str = None,
        start: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 分页开始数
        # 
        self.page_size = page_size
        # 每页条数
        # 
        self.start = start

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QuerySgServicesubscribersResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        start_index: int = None,
        subscribers: List[Subscriber] = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 分页大小
        self.page_size = page_size
        # 开始索引
        self.start_index = start_index
        # 消费者分页列表
        self.subscribers = subscribers
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.subscribers:
            for k in self.subscribers:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        result['subscribers'] = []
        if self.subscribers is not None:
            for k in self.subscribers:
                result['subscribers'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        self.subscribers = []
        if m.get('subscribers') is not None:
            for k in m.get('subscribers'):
                temp_model = Subscriber()
                self.subscribers.append(temp_model.from_map(k))
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class QuerySgServiceratelimitrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 租户实例id
        self.instance_id = instance_id
        # 分页参数
        self.page_size = page_size
        # 分页参数
        self.start = start

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QuerySgServiceratelimitrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        service_rate_limit_rules: List[ServiceRateLimitRule] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 分页大小
        self.page_size = page_size
        # 服务限流规则列表
        self.service_rate_limit_rules = service_rate_limit_rules
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.service_rate_limit_rules:
            for k in self.service_rate_limit_rules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['service_rate_limit_rules'] = []
        if self.service_rate_limit_rules is not None:
            for k in self.service_rate_limit_rules:
                result['service_rate_limit_rules'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.service_rate_limit_rules = []
        if m.get('service_rate_limit_rules') is not None:
            for k in m.get('service_rate_limit_rules'):
                temp_model = ServiceRateLimitRule()
                self.service_rate_limit_rules.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class AddSgServiceratelimitrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        enable: bool = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
        service_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 是否开启
        self.enable = enable
        # 租户实例id
        self.instance_id = instance_id
        # 规则名
        self.name = name
        # 操作人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # {"limitStrategy":"ScaledRateLimiter","actionConfig":{"actionType":"LIMIT_EXCEPTION","responseContent":"ssssssssssddd"},"maxBurstRatio":"1","resourceConfigs":[{"method":"方法名","interface":"接口名","baseName":"com.alipay.uctcloud.service.IndicatorClient:1.0@DEFAULT.query","resourceType":"DATA_ID_METHOD"}],"runMode":"CONTROL","calculationConfigs":[{"calculationType":"INVOKE_BY_TIME","period":1000,"trafficType":"ALL","maxAllow":0}],"desc":"测试规则2","resourceType":"DATA_ID_METHOD"}
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode
        # 服务框架类型
        self.service_type = service_type

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.enable, 'enable')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.rule_config, 'rule_config')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.enable is not None:
            result['enable'] = self.enable
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        if self.service_type is not None:
            result['service_type'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        return self


class AddSgServiceratelimitrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        rule_id: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 创建成功的限流规则id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        return self


class UpdateSgServiceratelimitrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        enable: bool = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
        service_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 是否启用
        self.enable = enable
        # id
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 限流规则名
        self.name = name
        # 操作者
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # {"limitStrategy":"ScaledRateLimiter","actionConfig":{"actionType":"LIMIT_EXCEPTION","responseContent":"ssssssssssddd"},"maxBurstRatio":"1","resourceConfigs":[{"method":"方法名","interface":"接口名","baseName":"com.alipay.uctcloud.service.IndicatorClient:1.0@DEFAULT.query","resourceType":"DATA_ID_METHOD"}],"runMode":"CONTROL","calculationConfigs":[{"calculationType":"INVOKE_BY_TIME","period":1000,"trafficType":"ALL","maxAllow":0}],"desc":"测试规则2","resourceType":"DATA_ID_METHOD"}
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode
        # 服务框架类型
        self.service_type = service_type

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.rule_config, 'rule_config')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.enable is not None:
            result['enable'] = self.enable
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        if self.service_type is not None:
            result['service_type'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        return self


class UpdateSgServiceratelimitrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 更新成功的条数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteSgServiceratelimitrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        enable: bool = None,
        id: str = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
        service_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 是否启用
        self.enable = enable
        # 限流规则id
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 限流规则名称
        self.name = name
        # 操作人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # {"limitStrategy":"ScaledRateLimiter","actionConfig":{"actionType":"LIMIT_EXCEPTION","responseContent":"ssssssssssddd"},"maxBurstRatio":"1","resourceConfigs":[{"method":"方法名","interface":"接口名","baseName":"com.alipay.uctcloud.service.IndicatorClient:1.0@DEFAULT.query","resourceType":"DATA_ID_METHOD"}],"runMode":"CONTROL","calculationConfigs":[{"calculationType":"INVOKE_BY_TIME","period":1000,"trafficType":"ALL","maxAllow":0}],"desc":"测试规则2","resourceType":"DATA_ID_METHOD"}
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode
        # 服务框架类型
        self.service_type = service_type

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.enable is not None:
            result['enable'] = self.enable
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        if self.service_type is not None:
            result['service_type'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        return self


class DeleteSgServiceratelimitrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 删除数目，1表示成功
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class UpdateSgServiceratelimitrulestatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        enable: bool = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
        service_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 是否启用
        self.enable = enable
        # 限流规则id
        self.id = id
        # 租户实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 操作人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # {"limitStrategy":"ScaledRateLimiter","actionConfig":{"actionType":"LIMIT_EXCEPTION","responseContent":"ssssssssssddd"},"maxBurstRatio":"1","resourceConfigs":[{"method":"方法名","interface":"接口名","baseName":"com.alipay.uctcloud.service.IndicatorClient:1.0@DEFAULT.query","resourceType":"DATA_ID_METHOD"}],"runMode":"CONTROL","calculationConfigs":[{"calculationType":"INVOKE_BY_TIME","period":1000,"trafficType":"ALL","maxAllow":0}],"desc":"测试规则2","resourceType":"DATA_ID_METHOD"}
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode
        # 服务框架类型
        self.service_type = service_type

    def validate(self):
        self.validate_required(self.enable, 'enable')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.enable is not None:
            result['enable'] = self.enable
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        if self.service_type is not None:
            result['service_type'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        return self


class UpdateSgServiceratelimitrulestatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # result
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class AddSgRouterrulegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        dispatch_version: str = None,
        enabled: int = None,
        id: int = None,
        instance_id: str = None,
        operator: str = None,
        rules: str = None,
        type: str = None,
        name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 下发版本
        self.dispatch_version = dispatch_version
        # 是否生效，1 生效，0 未生效。默认未生效
        self.enabled = enabled
        # id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 编辑人
        self.operator = operator
        # JSON格式：路由规则
        self.rules = rules
        # dataID的类型，应用/服务；默认为0，服务级
        self.type = type
        # 规则组名称
        self.name = name

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rules, 'rules')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.dispatch_version is not None:
            result['dispatch_version'] = self.dispatch_version
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.rules is not None:
            result['rules'] = self.rules
        if self.type is not None:
            result['type'] = self.type
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('dispatch_version') is not None:
            self.dispatch_version = m.get('dispatch_version')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('rules') is not None:
            self.rules = m.get('rules')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class AddSgRouterrulegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class GetSgRouterrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # dataID的类型，应用/服务；默认为0，服务级
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetSgRouterrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        router_rule_group_model: RouterRuleGroupModel = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 路由规则
        self.router_rule_group_model = router_rule_group_model

    def validate(self):
        if self.router_rule_group_model:
            self.router_rule_group_model.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.router_rule_group_model is not None:
            result['router_rule_group_model'] = self.router_rule_group_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('router_rule_group_model') is not None:
            temp_model = RouterRuleGroupModel()
            self.router_rule_group_model = temp_model.from_map(m['router_rule_group_model'])
        return self


class UpdateSgRouterrulegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        dispatch_version: int = None,
        enabled: int = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        rules: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 下发的版本
        self.dispatch_version = dispatch_version
        # 是否生效，1 生效，0 未生效。默认未生效
        self.enabled = enabled
        # 路由规则id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 规则名称
        self.name = name
        # 编辑人
        self.operator = operator
        # 路由规则
        self.rules = rules
        # dataID的类型，应用/服务
        self.type = type

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rules, 'rules')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.dispatch_version is not None:
            result['dispatch_version'] = self.dispatch_version
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.rules is not None:
            result['rules'] = self.rules
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('dispatch_version') is not None:
            self.dispatch_version = m.get('dispatch_version')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('rules') is not None:
            self.rules = m.get('rules')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class UpdateSgRouterrulegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class EnableSgRouterrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        data_id: str = None,
        dispatch_version: int = None,
        enabled: str = None,
        id: int = None,
        operator: str = None,
        rules: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app_name
        self.app_name = app_name
        # 服务id
        self.data_id = data_id
        # 下发版本
        self.dispatch_version = dispatch_version
        # 是否生效，1 生效，0 未生效。默认未生效
        self.enabled = enabled
        # id
        self.id = id
        # 编辑人
        self.operator = operator
        # RouterRuleModel
        self.rules = rules
        # 类型
        self.type = type

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.dispatch_version, 'dispatch_version')
        self.validate_required(self.id, 'id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.dispatch_version is not None:
            result['dispatch_version'] = self.dispatch_version
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.id is not None:
            result['id'] = self.id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.rules is not None:
            result['rules'] = self.rules
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('dispatch_version') is not None:
            self.dispatch_version = m.get('dispatch_version')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('rules') is not None:
            self.rules = m.get('rules')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class EnableSgRouterrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSgRouterruleversionsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 路由类型，service表示服务
        self.type = type

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ListSgRouterruleversionsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        versions: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # versions
        self.versions = versions

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.versions is not None:
            result['versions'] = self.versions
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('versions') is not None:
            self.versions = m.get('versions')
        return self


class QuerySgRouterrulestatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # serivce表示服务
        self.type = type

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QuerySgRouterrulestatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        config_map: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Map<String, Object>
        self.config_map = config_map

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.config_map is not None:
            result['config_map'] = self.config_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('config_map') is not None:
            self.config_map = m.get('config_map')
        return self


class DeleteSgAuthrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        rule_id: int = None,
        auth_group_id: int = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 规则id
        self.rule_id = rule_id
        # 规则所属的 group id
        self.auth_group_id = auth_group_id
        # 服务id
        self.data_id = data_id
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.auth_group_id, 'auth_group_id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSgAuthrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ListSgRouterruleappnamesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        type: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 类型
        self.type = type
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.type is not None:
            result['type'] = self.type
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListSgRouterruleappnamesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        app_names: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # app name list
        self.app_names = app_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.app_names is not None:
            result['app_names'] = self.app_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        return self


class EnableSgAuthrulegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        data_id: str = None,
        auth_group_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 服务接口id
        self.data_id = data_id
        # 服务鉴权黑、白名单 id
        self.auth_group_id = auth_group_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.auth_group_id, 'auth_group_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        return self


class EnableSgAuthrulegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class GetSgRouterrulesnapshotsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        type: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 类型
        self.type = type
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.type is not None:
            result['type'] = self.type
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetSgRouterrulesnapshotsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        config_snapshot_model: ConfigSnapshotModel = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # ConfigSnapshotModel
        self.config_snapshot_model = config_snapshot_model

    def validate(self):
        if self.config_snapshot_model:
            self.config_snapshot_model.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.config_snapshot_model is not None:
            result['config_snapshot_model'] = self.config_snapshot_model.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('config_snapshot_model') is not None:
            temp_model = ConfigSnapshotModel()
            self.config_snapshot_model = temp_model.from_map(m['config_snapshot_model'])
        return self


class RollbackSgRouterrulesnapshotsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        config_snapshot: str = None,
        router_rule_group: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # ConfigSnapshotModel
        self.config_snapshot = config_snapshot
        # RouterRuleGroupModel
        self.router_rule_group = router_rule_group
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.config_snapshot, 'config_snapshot')
        self.validate_required(self.router_rule_group, 'router_rule_group')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.config_snapshot is not None:
            result['config_snapshot'] = self.config_snapshot
        if self.router_rule_group is not None:
            result['router_rule_group'] = self.router_rule_group
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('config_snapshot') is not None:
            self.config_snapshot = m.get('config_snapshot')
        if m.get('router_rule_group') is not None:
            self.router_rule_group = m.get('router_rule_group')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class RollbackSgRouterrulesnapshotsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySgRouterruledispatchlogsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        limit: int = None,
        start: int = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 分页参数
        self.limit = limit
        # 分页参数
        self.start = start
        # 类型
        self.type = type

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.limit is not None:
            result['limit'] = self.limit
        if self.start is not None:
            result['start'] = self.start
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QuerySgRouterruledispatchlogsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        config_dispatch_logs: List[ConfigDispatchLogDO] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # List<ConfigDispatchLogDO>
        self.config_dispatch_logs = config_dispatch_logs

    def validate(self):
        if self.config_dispatch_logs:
            for k in self.config_dispatch_logs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['config_dispatch_logs'] = []
        if self.config_dispatch_logs is not None:
            for k in self.config_dispatch_logs:
                result['config_dispatch_logs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.config_dispatch_logs = []
        if m.get('config_dispatch_logs') is not None:
            for k in m.get('config_dispatch_logs'):
                temp_model = ConfigDispatchLogDO()
                self.config_dispatch_logs.append(temp_model.from_map(k))
        return self


class AddSgAuthrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        auth_group_id: int = None,
        data_id: str = None,
        auth_rule: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 规则所属的白、黑名单id
        self.auth_group_id = auth_group_id
        # 服务接口id
        self.data_id = data_id
        # 待新增的鉴权规则，json 格式字符串
        self.auth_rule = auth_rule

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.auth_group_id, 'auth_group_id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.auth_rule, 'auth_rule')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.auth_rule is not None:
            result['auth_rule'] = self.auth_rule
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('auth_rule') is not None:
            self.auth_rule = m.get('auth_rule')
        return self


class AddSgAuthrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        auth_rule: AuthRule = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 创建成功后的鉴权规则
        self.auth_rule = auth_rule

    def validate(self):
        if self.auth_rule:
            self.auth_rule.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.auth_rule is not None:
            result['auth_rule'] = self.auth_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('auth_rule') is not None:
            temp_model = AuthRule()
            self.auth_rule = temp_model.from_map(m['auth_rule'])
        return self


class UpdateSgAuthrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        auth_group_id: int = None,
        data_id: str = None,
        auth_rule: str = None,
        rule_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 所属黑白名单规则组id
        self.auth_group_id = auth_group_id
        # 服务接口id
        self.data_id = data_id
        # 更新的规则数据
        self.auth_rule = auth_rule
        # 更新的规则id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.auth_group_id, 'auth_group_id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.auth_rule, 'auth_rule')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.auth_rule is not None:
            result['auth_rule'] = self.auth_rule
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('auth_rule') is not None:
            self.auth_rule = m.get('auth_rule')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        return self


class UpdateSgAuthrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DisableSgAuthrulegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        data_id: str = None,
        auth_group_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 服务接口id
        self.data_id = data_id
        # 服务鉴权黑、白名单id
        self.auth_group_id = auth_group_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.auth_group_id, 'auth_group_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        return self


class DisableSgAuthrulegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySgApprelationsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySgApprelationsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        graph_data: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 应用关系数据
        self.graph_data = graph_data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.graph_data is not None:
            result['graph_data'] = self.graph_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('graph_data') is not None:
            self.graph_data = m.get('graph_data')
        return self


class EnableSgAuthrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        auth_group_id: int = None,
        data_id: str = None,
        rule_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 所属的鉴权规则黑、白名单id
        self.auth_group_id = auth_group_id
        # 服务接口id
        self.data_id = data_id
        # 启用的规则id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.auth_group_id, 'auth_group_id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        return self


class EnableSgAuthrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DisableSgAuthrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        data_id: str = None,
        auth_group_id: int = None,
        rule_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 服务接口id
        self.data_id = data_id
        # 所属的服务鉴权黑、白名单id
        self.auth_group_id = auth_group_id
        # 规则id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.auth_group_id, 'auth_group_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        return self


class DisableSgAuthrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySgServicepubrelationsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySgServicepubrelationsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        service_relations: List[ServiceRelation] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 发布服务数据
        self.service_relations = service_relations

    def validate(self):
        if self.service_relations:
            for k in self.service_relations:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['service_relations'] = []
        if self.service_relations is not None:
            for k in self.service_relations:
                result['service_relations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.service_relations = []
        if m.get('service_relations') is not None:
            for k in m.get('service_relations'):
                temp_model = ServiceRelation()
                self.service_relations.append(temp_model.from_map(k))
        return self


class RetrySgAuthrulegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        auth_group_id: int = None,
        data_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 服务鉴权黑、白名单 id
        self.auth_group_id = auth_group_id
        # 服务接口 id
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.auth_group_id, 'auth_group_id')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.auth_group_id is not None:
            result['auth_group_id'] = self.auth_group_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('auth_group_id') is not None:
            self.auth_group_id = m.get('auth_group_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        return self


class RetrySgAuthrulegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySgServicesubrelationsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySgServicesubrelationsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        service_relations: List[ServiceRelation] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 服务订阅者数据
        self.service_relations = service_relations

    def validate(self):
        if self.service_relations:
            for k in self.service_relations:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['service_relations'] = []
        if self.service_relations is not None:
            for k in self.service_relations:
                result['service_relations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.service_relations = []
        if m.get('service_relations') is not None:
            for k in m.get('service_relations'):
                temp_model = ServiceRelation()
                self.service_relations.append(temp_model.from_map(k))
        return self


class GetSgRelationswitchRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetSgRelationswitchResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        resp: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 显示关系切换
        self.resp = resp

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.resp is not None:
            result['resp'] = self.resp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('resp') is not None:
            self.resp = m.get('resp')
        return self


class GetMiddlewareInstanceRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        tenant_id: str = None,
        workspace_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户Id
        self.tenant_id = tenant_id
        # 环境id
        self.workspace_id = workspace_id

    def validate(self):
        self.validate_required(self.tenant_id, 'tenant_id')
        self.validate_required(self.workspace_id, 'workspace_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        if self.workspace_id is not None:
            result['workspace_id'] = self.workspace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        if m.get('workspace_id') is not None:
            self.workspace_id = m.get('workspace_id')
        return self


class GetMiddlewareInstanceResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        instance_id: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetSgEnvconfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetSgEnvconfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        config_map: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Map<String, Object>
        self.config_map = config_map

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.config_map is not None:
            result['config_map'] = self.config_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('config_map') is not None:
            self.config_map = m.get('config_map')
        return self


class ListSgServiceappsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListSgServiceappsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        app_names: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 应用列表
        self.app_names = app_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.app_names is not None:
            result['app_names'] = self.app_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        return self


class QuerySgServicekeywordRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 实例id
        self.instance_id = instance_id
        # 搜索词
        self.keyword = keyword

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        return self


class QuerySgServicekeywordResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        app_names: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 应用列表
        self.app_names = app_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.app_names is not None:
            result['app_names'] = self.app_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        return self


class QuerySgServicesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
        page_size: int = None,
        start: int = None,
        tenant_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app_name
        self.app_name = app_name
        # 实例id
        self.instance_id = instance_id
        # keyword
        self.keyword = keyword
        # 分页参数
        self.page_size = page_size
        # 分页参数
        self.start = start
        # 区域ID
        self.tenant_id = tenant_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        return self


class QuerySgServicesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        simple_service_infos: List[SimpleServiceInfo] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # current_page
        self.current_page = current_page
        # page_size
        self.page_size = page_size
        # List<SimpleServiceInfo>
        self.simple_service_infos = simple_service_infos
        # start_index
        self.start_index = start_index
        # total_size
        self.total_size = total_size

    def validate(self):
        if self.simple_service_infos:
            for k in self.simple_service_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['simple_service_infos'] = []
        if self.simple_service_infos is not None:
            for k in self.simple_service_infos:
                result['simple_service_infos'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.simple_service_infos = []
        if m.get('simple_service_infos') is not None:
            for k in m.get('simple_service_infos'):
                temp_model = SimpleServiceInfo()
                self.simple_service_infos.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class QuerySgServicepubkeysRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        ip: str = None,
        page_size: int = None,
        start: int = None,
        tenant_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # ip
        self.ip = ip
        # 分页参数
        self.page_size = page_size
        # 分页参数
        self.start = start
        # 区域ID
        self.tenant_id = tenant_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ip, 'ip')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        return self


class QuerySgServicepubkeysResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        simple_service_infos: List[SimpleServiceInfo] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 分页大小
        self.page_size = page_size
        # 服务信息
        self.simple_service_infos = simple_service_infos
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.simple_service_infos:
            for k in self.simple_service_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['simple_service_infos'] = []
        if self.simple_service_infos is not None:
            for k in self.simple_service_infos:
                result['simple_service_infos'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.simple_service_infos = []
        if m.get('simple_service_infos') is not None:
            for k in m.get('simple_service_infos'):
                temp_model = SimpleServiceInfo()
                self.simple_service_infos.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class QuerySgServicesubkeysRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        ip: str = None,
        page_size: str = None,
        start: int = None,
        tenant_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # ip
        self.ip = ip
        # 分页参数
        self.page_size = page_size
        # 分页参数
        self.start = start
        # 区域ID
        self.tenant_id = tenant_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ip, 'ip')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        if self.tenant_id is not None:
            result['tenant_id'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('tenant_id') is not None:
            self.tenant_id = m.get('tenant_id')
        return self


class QuerySgServicesubkeysResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        simple_service_infos: List[SimpleServiceInfo] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 分页大小
        self.page_size = page_size
        # 服务信息
        self.simple_service_infos = simple_service_infos
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.simple_service_infos:
            for k in self.simple_service_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['simple_service_infos'] = []
        if self.simple_service_infos is not None:
            for k in self.simple_service_infos:
                result['simple_service_infos'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.simple_service_infos = []
        if m.get('simple_service_infos') is not None:
            for k in m.get('simple_service_infos'):
                temp_model = SimpleServiceInfo()
                self.simple_service_infos.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class QuerySgServicepubsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        page_size: str = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 分页参数
        self.page_size = page_size
        # 分页参数
        self.start = start

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QuerySgServicepubsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        publishers: List[Publisher] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 页大小
        self.page_size = page_size
        # [
        # {
        # "gmtModified":"2019-12-12T20:58:26+08:00",
        # "alive":true,
        # "hostIp":"10.15.228.102",
        # "appName":"aliyun-demo",
        # "weight":100,
        # "gmtCreate":"2019-12-12T20:58:26+08:00",
        # "content":"10.15.228.96:12200?rpcVer=50303&serialization=hessian2&weight=100&timeout=3000&appName=aliyun-demo&warmupTime=0&warmupWeight=10&p=1&v=4.0&_SERIALIZETYPE=hessian2&_WEIGHT=100&_TIMEOUT=3000&app_name=aliyun-demo&startTime=1576047463993",
        # "mosn":false,
        # "timeout":3000,
        # "serviceIp":"10.15.228.96",
        # "protocol":"bolt",
        # "instanceId":"0SGTOGOOLRD8",
        # "dataId":"com.antfin.demo.endpoint.facade.SampleRestFacade:1.0@DEFAULT",
        # "processId":"10.15.228.102:64638",
        # "zone":"DEFAULT_ZONE",
        # "checkSum":"d7e0e231f57d1156fe4a4f0979231fe5",
        # "vmMode":false,
        # "id":969,
        # "servicePort":12200,
        # "status":true
        # }
        self.publishers = publishers
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.publishers:
            for k in self.publishers:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['publishers'] = []
        if self.publishers is not None:
            for k in self.publishers:
                result['publishers'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.publishers = []
        if m.get('publishers') is not None:
            for k in m.get('publishers'):
                temp_model = Publisher()
                self.publishers.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class QuerySgServicesubsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 分页大小
        self.page_size = page_size
        # 起始页
        self.start = start

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QuerySgServicesubsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        start_index: int = None,
        subscribers: List[Subscriber] = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 分页大小
        self.page_size = page_size
        # 起始索引
        self.start_index = start_index
        # [
        # {
        # "gmtModified":"2019-12-12T20:58:22+08:00",
        # "instanceId":"0SGTOGOOLRD8",
        # "alive":true,
        # "dataId":"com.antfin.demo.endpoint.facade.SampleRestFacade:1.0@DEFAULT",
        # "hostIp":"10.15.228.102",
        # "processId":"10.15.228.102:64588",
        # "zone":"DEFAULT_ZONE",
        # "appName":"consumer-demo",
        # "scope":"global",
        # "checkSum":"86f4f564ef778386998b4b19098f5c77",
        # "id":7977,
        # "gmtCreate":"2019-12-12T20:58:22+08:00"
        # }
        # ]
        self.subscribers = subscribers
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.subscribers:
            for k in self.subscribers:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        result['subscribers'] = []
        if self.subscribers is not None:
            for k in self.subscribers:
                result['subscribers'].append(k.to_map() if k else None)
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        self.subscribers = []
        if m.get('subscribers') is not None:
            for k in m.get('subscribers'):
                temp_model = Subscriber()
                self.subscribers.append(temp_model.from_map(k))
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class ListSgServicepubsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        ip: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # ip
        self.ip = ip
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.ip, 'ip')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListSgServicepubsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        publishers: List[Publisher] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # List<Publisher>
        self.publishers = publishers

    def validate(self):
        if self.publishers:
            for k in self.publishers:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['publishers'] = []
        if self.publishers is not None:
            for k in self.publishers:
                result['publishers'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.publishers = []
        if m.get('publishers') is not None:
            for k in m.get('publishers'):
                temp_model = Publisher()
                self.publishers.append(temp_model.from_map(k))
        return self


class ListSgServicesubsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        ip: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # ip
        self.ip = ip
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.ip, 'ip')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListSgServicesubsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        subscribers: List[Subscriber] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # List<Subscriber>
        self.subscribers = subscribers

    def validate(self):
        if self.subscribers:
            for k in self.subscribers:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['subscribers'] = []
        if self.subscribers is not None:
            for k in self.subscribers:
                result['subscribers'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.subscribers = []
        if m.get('subscribers') is not None:
            for k in m.get('subscribers'):
                temp_model = Subscriber()
                self.subscribers.append(temp_model.from_map(k))
        return self


class QuerySgServicesummarysRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QuerySgServicesummarysResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        service_summary: ServiceSummary = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # ServiceSummary
        self.service_summary = service_summary

    def validate(self):
        if self.service_summary:
            self.service_summary.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.service_summary is not None:
            result['service_summary'] = self.service_summary.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('service_summary') is not None:
            temp_model = ServiceSummary()
            self.service_summary = temp_model.from_map(m['service_summary'])
        return self


class DisableSgServiceparamsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # JSON字符串，禁用的IP信息
        self.data = data
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data, 'data')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DisableSgServiceparamsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class EnableSgServiceparamsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 启动的服务提供者信息
        self.data = data
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data, 'data')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class EnableSgServiceparamsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class SetSgServiceparamweightRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
        data_id: str = None,
        instance_id: str = None,
        weight: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # SON字符串，服务提供者信息
        self.data = data
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 权重
        self.weight = weight

    def validate(self):
        self.validate_required(self.data, 'data')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.weight, 'weight')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class SetSgServiceparamweightResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ReinitSgServiceparamsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # JSON格式，服务提供者信息
        self.data = data
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data, 'data')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ReinitSgServiceparamsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class BatchquerySgServiceparamRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class BatchquerySgServiceparamResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        config_map: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Map<String, String>
        self.config_map = config_map

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.config_map is not None:
            result['config_map'] = self.config_map
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('config_map') is not None:
            self.config_map = m.get('config_map')
        return self


class QueryMeshSidecarRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_service_name: str = None,
        cluster_name: str = None,
        namespace: str = None,
        page_index: int = None,
        page_size: str = None,
        pod_ip: str = None,
        pod_status: str = None,
        sidecar_status: str = None,
        sidecar_version: str = None,
        sort_field: str = None,
        sort_order: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 查询指定应用服务的
        self.app_service_name = app_service_name
        # 查询指定集群的，如果未设置，则根据tenant + workspace获取
        self.cluster_name = cluster_name
        # 查询指定命名空间的，如果未指定，默认值为default
        self.namespace = namespace
        # 分页查询索引页，默认0
        self.page_index = page_index
        # 分页查询单页大小，默认10
        self.page_size = page_size
        # 查询指定podIp(英文半角逗号分割)的
        self.pod_ip = pod_ip
        # 查询指定pod状态的
        self.pod_status = pod_status
        # 查询指定sidecar状态的
        self.sidecar_status = sidecar_status
        # 查询注入指定版本sidecar的
        self.sidecar_version = sidecar_version
        # 排序字段，默认pod创建时间
        self.sort_field = sort_field
        # 升序(ascend) 或 降序(descend)
        self.sort_order = sort_order
        # sidecar类型(mosn/odp/mist)
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_service_name is not None:
            result['app_service_name'] = self.app_service_name
        if self.cluster_name is not None:
            result['cluster_name'] = self.cluster_name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.page_index is not None:
            result['page_index'] = self.page_index
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.pod_ip is not None:
            result['pod_ip'] = self.pod_ip
        if self.pod_status is not None:
            result['pod_status'] = self.pod_status
        if self.sidecar_status is not None:
            result['sidecar_status'] = self.sidecar_status
        if self.sidecar_version is not None:
            result['sidecar_version'] = self.sidecar_version
        if self.sort_field is not None:
            result['sort_field'] = self.sort_field
        if self.sort_order is not None:
            result['sort_order'] = self.sort_order
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_service_name') is not None:
            self.app_service_name = m.get('app_service_name')
        if m.get('cluster_name') is not None:
            self.cluster_name = m.get('cluster_name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('page_index') is not None:
            self.page_index = m.get('page_index')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('pod_ip') is not None:
            self.pod_ip = m.get('pod_ip')
        if m.get('pod_status') is not None:
            self.pod_status = m.get('pod_status')
        if m.get('sidecar_status') is not None:
            self.sidecar_status = m.get('sidecar_status')
        if m.get('sidecar_version') is not None:
            self.sidecar_version = m.get('sidecar_version')
        if m.get('sort_field') is not None:
            self.sort_field = m.get('sort_field')
        if m.get('sort_order') is not None:
            self.sort_order = m.get('sort_order')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QueryMeshSidecarResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        total_cnt: int = None,
        items: List[SideCarDetailModel] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 总结果数
        self.total_cnt = total_cnt
        # SideCar实例列表
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.total_cnt is not None:
            result['total_cnt'] = self.total_cnt
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('total_cnt') is not None:
            self.total_cnt = m.get('total_cnt')
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = SideCarDetailModel()
                self.items.append(temp_model.from_map(k))
        return self


class GetGuardianGuardianconfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetGuardianGuardianconfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: bool = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 控制表单展示
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class AllGuardianGuardianappsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class AllGuardianGuardianappsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        guardian_apps: List[GuardianApp] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 监控app列表
        self.guardian_apps = guardian_apps

    def validate(self):
        if self.guardian_apps:
            for k in self.guardian_apps:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['guardian_apps'] = []
        if self.guardian_apps is not None:
            for k in self.guardian_apps:
                result['guardian_apps'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.guardian_apps = []
        if m.get('guardian_apps') is not None:
            for k in m.get('guardian_apps'):
                temp_model = GuardianApp()
                self.guardian_apps.append(temp_model.from_map(k))
        return self


class AllGuardianGuardianappnamesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class AllGuardianGuardianappnamesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        app_names: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # app name list
        self.app_names = app_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.app_names is not None:
            result['app_names'] = self.app_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        return self


class QueryGuardianGuardianappsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 实例id
        self.instance_id = instance_id
        # 关键词
        self.keyword = keyword
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start = start

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.keyword, 'keyword')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QueryGuardianGuardianappsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        guardian_apps: List[GuardianApp] = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 监控app列表
        self.guardian_apps = guardian_apps
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.guardian_apps:
            for k in self.guardian_apps:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['guardian_apps'] = []
        if self.guardian_apps is not None:
            for k in self.guardian_apps:
                result['guardian_apps'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.guardian_apps = []
        if m.get('guardian_apps') is not None:
            for k in m.get('guardian_apps'):
                temp_model = GuardianApp()
                self.guardian_apps.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class GetGuardianGuardianappsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetGuardianGuardianappsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        guardian_app: GuardianApp = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 监控app实例
        self.guardian_app = guardian_app

    def validate(self):
        if self.guardian_app:
            self.guardian_app.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.guardian_app is not None:
            result['guardian_app'] = self.guardian_app.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('guardian_app') is not None:
            temp_model = GuardianApp()
            self.guardian_app = temp_model.from_map(m['guardian_app'])
        return self


class AddGuardianGuardianappsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        enable: bool = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        run_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否可用
        self.enable = enable
        # 监控id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        self.validate_required(self.enable, 'enable')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.run_mode, 'run_mode')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.enable is not None:
            result['enable'] = self.enable
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class AddGuardianGuardianappsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class UpdateGuardianGuardianappsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        enable: bool = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        run_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否可用
        self.enable = enable
        # 监控id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        self.validate_required(self.enable, 'enable')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.run_mode, 'run_mode')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.enable is not None:
            result['enable'] = self.enable
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class UpdateGuardianGuardianappsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteGuardianGuardianappsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        enable: bool = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        run_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否可用
        self.enable = enable
        # 监控id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        self.validate_required(self.enable, 'enable')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.enable is not None:
            result['enable'] = self.enable
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class DeleteGuardianGuardianappsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class QueryGuardianGuardianrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
        page_size: str = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 实例id
        self.instance_id = instance_id
        # 关键词
        self.keyword = keyword
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start = start

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QueryGuardianGuardianrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        guardian_rules: List[GuardianRule] = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 监控规则列表
        self.guardian_rules = guardian_rules
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.guardian_rules:
            for k in self.guardian_rules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['guardian_rules'] = []
        if self.guardian_rules is not None:
            for k in self.guardian_rules:
                result['guardian_rules'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.guardian_rules = []
        if m.get('guardian_rules') is not None:
            for k in m.get('guardian_rules'):
                temp_model = GuardianRule()
                self.guardian_rules.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class GetGuardianGuardianrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        rule_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # 规则id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        return self


class GetGuardianGuardianrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        guardian_rule: GuardianRule = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 监控规则实例
        self.guardian_rule = guardian_rule

    def validate(self):
        if self.guardian_rule:
            self.guardian_rule.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.guardian_rule is not None:
            result['guardian_rule'] = self.guardian_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('guardian_rule') is not None:
            temp_model = GuardianRule()
            self.guardian_rule = temp_model.from_map(m['guardian_rule'])
        return self


class AddGuardianGuardianrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        enable: bool = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 是否可用
        self.enable = enable
        # 创建
        self.gmt_create = gmt_create
        # 更新
        self.gmt_modified = gmt_modified
        # 监控实例id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 编辑人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # 规则配置
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.enable, 'enable')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.rule_config, 'rule_config')
        self.validate_required(self.run_mode, 'run_mode')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.enable is not None:
            result['enable'] = self.enable
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class AddGuardianGuardianrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class UpdateGuardianGuardianrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        enable: bool = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 是否可用
        self.enable = enable
        # 创建
        self.gmt_create = gmt_create
        # 更新
        self.gmt_modified = gmt_modified
        # 监控规则id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 编辑人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # 规则配置
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.rule_config, 'rule_config')
        self.validate_required(self.run_mode, 'run_mode')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.enable is not None:
            result['enable'] = self.enable
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class UpdateGuardianGuardianrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        # 
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class UpdateGuardianGuardianrulestatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        enable: bool = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 是否可用
        self.enable = enable
        # 创建
        self.gmt_create = gmt_create
        # 更新
        self.gmt_modified = gmt_modified
        # 监控规则id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 编辑人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # 规则配置
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.enable, 'enable')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.enable is not None:
            result['enable'] = self.enable
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class UpdateGuardianGuardianrulestatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteGuardianGuardianrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        enable: bool = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        operator: str = None,
        resource_type: str = None,
        rule_config: str = None,
        run_mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 是否可用
        self.enable = enable
        # 创建
        self.gmt_create = gmt_create
        # 更新
        self.gmt_modified = gmt_modified
        # 监控规则id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 编辑人
        self.operator = operator
        # 资源类型
        self.resource_type = resource_type
        # 规则配置
        self.rule_config = rule_config
        # 运行模式
        self.run_mode = run_mode

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        if self.gmt_create is not None:
            self.validate_pattern(self.gmt_create, 'gmt_create', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        if self.gmt_modified is not None:
            self.validate_pattern(self.gmt_modified, 'gmt_modified', '\\d{4}[-]\\d{1,2}[-]\\d{1,2}[T]\\d{2}:\\d{2}:\\d{2}([Z]|([\\.]\\d{1,9})?[\\+]\\d{2}[\\:]?\\d{2})')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.enable is not None:
            result['enable'] = self.enable
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.resource_type is not None:
            result['resource_type'] = self.resource_type
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        if self.run_mode is not None:
            result['run_mode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('enable') is not None:
            self.enable = m.get('enable')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('resource_type') is not None:
            self.resource_type = m.get('resource_type')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        if m.get('run_mode') is not None:
            self.run_mode = m.get('run_mode')
        return self


class DeleteGuardianGuardianrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class QueryGuardianGuardianrulepushhistorysRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
        page_size: str = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 实例id
        self.instance_id = instance_id
        # keyword
        self.keyword = keyword
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start = start

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QueryGuardianGuardianrulepushhistorysResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        push_histories: List[PushHistory] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 页大小
        self.page_size = page_size
        # 推送历史列表
        self.push_histories = push_histories
        # 起始索引
        self.start_index = start_index
        # 总页数
        self.total_size = total_size

    def validate(self):
        if self.push_histories:
            for k in self.push_histories:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['push_histories'] = []
        if self.push_histories is not None:
            for k in self.push_histories:
                result['push_histories'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.push_histories = []
        if m.get('push_histories') is not None:
            for k in m.get('push_histories'):
                temp_model = PushHistory()
                self.push_histories.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class ListGuardianGuardianrulepushhistorysRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        id: int = None,
        instance_id: str = None,
        rule_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 规则id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        return self


class ListGuardianGuardianrulepushhistorysResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        rule_config: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 规则配置
        self.rule_config = rule_config

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.rule_config is not None:
            result['rule_config'] = self.rule_config
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('rule_config') is not None:
            self.rule_config = m.get('rule_config')
        return self


class AddGuardianGuardiangrayrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        guardian_rule: str = None,
        ip_list: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 监控规则
        self.guardian_rule = guardian_rule
        # ip 列表
        self.ip_list = ip_list
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.guardian_rule, 'guardian_rule')
        self.validate_required(self.ip_list, 'ip_list')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.guardian_rule is not None:
            result['guardian_rule'] = self.guardian_rule
        if self.ip_list is not None:
            result['ip_list'] = self.ip_list
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('guardian_rule') is not None:
            self.guardian_rule = m.get('guardian_rule')
        if m.get('ip_list') is not None:
            self.ip_list = m.get('ip_list')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class AddGuardianGuardiangrayrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateGuardianGuardiangrayrulestatusRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        ip_list: str = None,
        rule_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # ip 列表
        self.ip_list = ip_list
        # 规则id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ip_list, 'ip_list')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ip_list is not None:
            result['ip_list'] = self.ip_list
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ip_list') is not None:
            self.ip_list = m.get('ip_list')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        return self


class UpdateGuardianGuardiangrayrulestatusResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class AllDrmDrmappsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class AllDrmDrmappsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        app_names: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # app name list
        self.app_names = app_names

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.app_names is not None:
            result['app_names'] = self.app_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        return self


class QueryDrmDrmresourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        keyword: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 实例id
        self.instance_id = instance_id
        # 关键词
        self.keyword = keyword
        # 每页条数
        self.page_size = page_size
        # 分页起始索引
        self.start = start

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QueryDrmDrmresourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        drm_resources: List[DrmResource] = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # Drm资源列表
        self.drm_resources = drm_resources
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.drm_resources:
            for k in self.drm_resources:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['drm_resources'] = []
        if self.drm_resources is not None:
            for k in self.drm_resources:
                result['drm_resources'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.drm_resources = []
        if m.get('drm_resources') is not None:
            for k in m.get('drm_resources'):
                temp_model = DrmResource()
                self.drm_resources.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class AddDrmDrmresourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attributes: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_domain: str = None,
        resource_id: str = None,
        resource_version: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 资源属性列表
        self.attributes = attributes
        # drm资源id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 资源域
        self.region = region
        # 资源域和应用名
        self.resource_domain = resource_domain
        # 资源类路径
        self.resource_id = resource_id
        # 资源版本
        self.resource_version = resource_version
        # type
        self.type = type

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_domain is not None:
            result['resource_domain'] = self.resource_domain
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.resource_version is not None:
            result['resource_version'] = self.resource_version
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_domain') is not None:
            self.resource_domain = m.get('resource_domain')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('resource_version') is not None:
            self.resource_version = m.get('resource_version')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AddDrmDrmresourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功条数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class UpdateDrmDrmresourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_domain: str = None,
        resource_id: str = None,
        resource_version: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # drm资源id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 资源域
        self.region = region
        # 资源域和应用名
        self.resource_domain = resource_domain
        # 资源类路径
        self.resource_id = resource_id
        # 资源版本
        self.resource_version = resource_version
        # type
        self.type = type

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_domain is not None:
            result['resource_domain'] = self.resource_domain
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.resource_version is not None:
            result['resource_version'] = self.resource_version
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_domain') is not None:
            self.resource_domain = m.get('resource_domain')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('resource_version') is not None:
            self.resource_version = m.get('resource_version')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class UpdateDrmDrmresourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 成功条数
        # 
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class AddDrmDrmattributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_name: str = None,
        data_id: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        parent: str = None,
        parent_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性名称
        self.attribute_name = attribute_name
        # 服务id
        self.data_id = data_id
        # 资源属性id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 父节点数据
        self.parent = parent
        # 父节点ID，冗余字段
        self.parent_id = parent_id

    def validate(self):
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.parent_id, 'parent_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.parent is not None:
            result['parent'] = self.parent
        if self.parent_id is not None:
            result['parent_id'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('parent') is not None:
            self.parent = m.get('parent')
        if m.get('parent_id') is not None:
            self.parent_id = m.get('parent_id')
        return self


class AddDrmDrmattributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class UpdateDrmDrmattributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_name: str = None,
        data_id: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        parent: str = None,
        parent_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性名称
        self.attribute_name = attribute_name
        # 资源id
        self.data_id = data_id
        # 属性id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 父节点信息
        self.parent = parent
        # 父节点ID，冗余字段
        self.parent_id = parent_id

    def validate(self):
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.parent_id, 'parent_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.parent is not None:
            result['parent'] = self.parent
        if self.parent_id is not None:
            result['parent_id'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('parent') is not None:
            self.parent = m.get('parent')
        if m.get('parent_id') is not None:
            self.parent_id = m.get('parent_id')
        return self


class UpdateDrmDrmattributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        # 
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteDrmDrmresourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        region: str = None,
        resource_domain: str = None,
        resource_id: str = None,
        resource_version: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # drm资源id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 资源域
        self.region = region
        # 资源域和应用名
        self.resource_domain = resource_domain
        # 资源类路径
        self.resource_id = resource_id
        # 资源版本
        self.resource_version = resource_version
        # type
        self.type = type

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        if self.resource_domain is not None:
            result['resource_domain'] = self.resource_domain
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.resource_version is not None:
            result['resource_version'] = self.resource_version
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_domain') is not None:
            self.resource_domain = m.get('resource_domain')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('resource_version') is not None:
            self.resource_version = m.get('resource_version')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class DeleteDrmDrmresourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteDrmDrmattributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        attribute_name: str = None,
        data_id: str = None,
        id: int = None,
        instance_id: str = None,
        name: str = None,
        parent: str = None,
        parent_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 属性名称
        self.attribute_name = attribute_name
        # 资源id
        self.data_id = data_id
        # 属性id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 描述字段
        self.name = name
        # 父节点信息
        self.parent = parent
        # 父节点ID，冗余字段
        self.parent_id = parent_id

    def validate(self):
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.attribute_name is not None:
            result['attribute_name'] = self.attribute_name
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.name is not None:
            result['name'] = self.name
        if self.parent is not None:
            result['parent'] = self.parent
        if self.parent_id is not None:
            result['parent_id'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('attribute_name') is not None:
            self.attribute_name = m.get('attribute_name')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('parent') is not None:
            self.parent = m.get('parent')
        if m.get('parent_id') is not None:
            self.parent_id = m.get('parent_id')
        return self


class DeleteDrmDrmattributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class GetDrmDrmattributesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class GetDrmDrmattributesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        drm_attribute: DrmAttribute = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 资源属性
        self.drm_attribute = drm_attribute

    def validate(self):
        if self.drm_attribute:
            self.drm_attribute.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.drm_attribute is not None:
            result['drm_attribute'] = self.drm_attribute.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('drm_attribute') is not None:
            temp_model = DrmAttribute()
            self.drm_attribute = temp_model.from_map(m['drm_attribute'])
        return self


class QueryDrmDrmclientsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start = start

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QueryDrmDrmclientsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        client_infos: List[ClientInfo] = None,
        current_page: int = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户资料列表
        self.client_infos = client_infos
        # 当前页
        self.current_page = current_page
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.client_infos:
            for k in self.client_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['client_infos'] = []
        if self.client_infos is not None:
            for k in self.client_infos:
                result['client_infos'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.client_infos = []
        if m.get('client_infos') is not None:
            for k in m.get('client_infos'):
                temp_model = ClientInfo()
                self.client_infos.append(temp_model.from_map(k))
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class QueryDrmDrmhostsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryDrmDrmhostsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        client_infos: List[ClientInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 客户端资料列表
        self.client_infos = client_infos

    def validate(self):
        if self.client_infos:
            for k in self.client_infos:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['client_infos'] = []
        if self.client_infos is not None:
            for k in self.client_infos:
                result['client_infos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.client_infos = []
        if m.get('client_infos') is not None:
            for k in m.get('client_infos'):
                temp_model = ClientInfo()
                self.client_infos.append(temp_model.from_map(k))
        return self


class ListDrmDrmpushlogsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start = start

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class ListDrmDrmpushlogsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        drm_logs: List[DrmLog] = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # drm日志列表
        self.drm_logs = drm_logs
        # 每页大小
        self.page_size = page_size
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.drm_logs:
            for k in self.drm_logs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['drm_logs'] = []
        if self.drm_logs is not None:
            for k in self.drm_logs:
                result['drm_logs'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.drm_logs = []
        if m.get('drm_logs') is not None:
            for k in m.get('drm_logs'):
                temp_model = DrmLog()
                self.drm_logs.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class QueryDrmDrmpushlogsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        end_time: int = None,
        instance_id: str = None,
        operator: str = None,
        page_size: int = None,
        push_result: str = None,
        start: int = None,
        start_time: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 资源标识
        self.data_id = data_id
        # 时间结束
        self.end_time = end_time
        # 实例id
        self.instance_id = instance_id
        # 操作人
        self.operator = operator
        # 页大小
        self.page_size = page_size
        # 推送结果
        self.push_result = push_result
        # 起始索引
        self.start = start
        # 开始时间
        self.start_time = start_time

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.operator is not None:
            result['operator'] = self.operator
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.push_result is not None:
            result['push_result'] = self.push_result
        if self.start is not None:
            result['start'] = self.start
        if self.start_time is not None:
            result['start_time'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('push_result') is not None:
            self.push_result = m.get('push_result')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        return self


class QueryDrmDrmpushlogsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        drm_logs: List[DrmLog] = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # drm日志列表
        self.drm_logs = drm_logs
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.drm_logs:
            for k in self.drm_logs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['drm_logs'] = []
        if self.drm_logs is not None:
            for k in self.drm_logs:
                result['drm_logs'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.drm_logs = []
        if m.get('drm_logs') is not None:
            for k in m.get('drm_logs'):
                temp_model = DrmLog()
                self.drm_logs.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class AddDrmDrmdataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        push_cells: str = None,
        push_target_type: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 资源标识
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id
        # 推送目标Cell列表,英文逗号隔开
        self.push_cells = push_cells
        # 推送目标类型
        self.push_target_type = push_target_type
        # 数据值
        self.value = value

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.push_cells is not None:
            result['push_cells'] = self.push_cells
        if self.push_target_type is not None:
            result['push_target_type'] = self.push_target_type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('push_cells') is not None:
            self.push_cells = m.get('push_cells')
        if m.get('push_target_type') is not None:
            self.push_target_type = m.get('push_target_type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class AddDrmDrmdataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class AddDrmDrmgraydataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        hosts: str = None,
        instance_id: str = None,
        value: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 资源ID
        self.data_id = data_id
        # 主机列表, 英文逗号隔开
        self.hosts = hosts
        # 实例id
        self.instance_id = instance_id
        # 推送值
        self.value = value

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.hosts, 'hosts')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.hosts is not None:
            result['hosts'] = self.hosts
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('hosts') is not None:
            self.hosts = m.get('hosts')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class AddDrmDrmgraydataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class AllDrmDrmcellsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class AllDrmDrmcellsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        cells: List[str] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # workspace下所有的cell信息
        self.cells = cells

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.cells is not None:
            result['cells'] = self.cells
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('cells') is not None:
            self.cells = m.get('cells')
        return self


class ListDrmDrmdatacellsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 资源ID
        self.data_id = data_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ListDrmDrmdatacellsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        drm_data_cell_info: DrmDataCellInfo = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # Drm数据单元信息
        self.drm_data_cell_info = drm_data_cell_info

    def validate(self):
        if self.drm_data_cell_info:
            self.drm_data_cell_info.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.drm_data_cell_info is not None:
            result['drm_data_cell_info'] = self.drm_data_cell_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('drm_data_cell_info') is not None:
            temp_model = DrmDataCellInfo()
            self.drm_data_cell_info = temp_model.from_map(m['drm_data_cell_info'])
        return self


class AddDrmDrmresourcetplsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attributes: str = None,
        desc: str = None,
        has_instance: bool = None,
        id: int = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
        tpl_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 属性列表
        self.attributes = attributes
        # 描述
        self.desc = desc
        # 所有单元中是否存在有特殊推送过值的单元
        self.has_instance = has_instance
        # 资源id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 资源域
        self.region = region
        # 资源类路径
        self.resource_id = resource_id
        # tpl_id
        self.tpl_id = tpl_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.desc is not None:
            result['desc'] = self.desc
        if self.has_instance is not None:
            result['has_instance'] = self.has_instance
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.tpl_id is not None:
            result['tpl_id'] = self.tpl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('has_instance') is not None:
            self.has_instance = m.get('has_instance')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('tpl_id') is not None:
            self.tpl_id = m.get('tpl_id')
        return self


class AddDrmDrmresourcetplsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功条数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class UpdateDrmDrmresourcetplsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        attributes: str = None,
        desc: str = None,
        has_instance: bool = None,
        id: int = None,
        instance_id: str = None,
        region: str = None,
        resource_id: str = None,
        tpl_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # app name
        self.app_name = app_name
        # 资源属性列表
        self.attributes = attributes
        # 描述
        self.desc = desc
        # 所有单元中是否存在有特殊推送过值的单元
        self.has_instance = has_instance
        # drm资源id
        self.id = id
        # 实例id
        self.instance_id = instance_id
        # 资源域
        self.region = region
        # 资源类路径
        self.resource_id = resource_id
        # tpl_id
        self.tpl_id = tpl_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region, 'region')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.attributes is not None:
            result['attributes'] = self.attributes
        if self.desc is not None:
            result['desc'] = self.desc
        if self.has_instance is not None:
            result['has_instance'] = self.has_instance
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.region is not None:
            result['region'] = self.region
        if self.resource_id is not None:
            result['resource_id'] = self.resource_id
        if self.tpl_id is not None:
            result['tpl_id'] = self.tpl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('attributes') is not None:
            self.attributes = m.get('attributes')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('has_instance') is not None:
            self.has_instance = m.get('has_instance')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('resource_id') is not None:
            self.resource_id = m.get('resource_id')
        if m.get('tpl_id') is not None:
            self.tpl_id = m.get('tpl_id')
        return self


class UpdateDrmDrmresourcetplsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteDrmDrmresourcetplsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        tpl_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # tpl_id
        self.tpl_id = tpl_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.tpl_id is not None:
            result['tpl_id'] = self.tpl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('tpl_id') is not None:
            self.tpl_id = m.get('tpl_id')
        return self


class DeleteDrmDrmresourcetplsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class QueryDrmDrmresourcetplsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        page_size: int = None,
        search_key: str = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # 页大小
        self.page_size = page_size
        # 搜索键
        self.search_key = search_key
        # 起始索引
        self.start = start

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.search_key is not None:
            result['search_key'] = self.search_key
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('search_key') is not None:
            self.search_key = m.get('search_key')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QueryDrmDrmresourcetplsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        drm_resource_tpls: List[DrmResourceTpl] = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # Tpl类型drm资源列表
        self.drm_resource_tpls = drm_resource_tpls
        # 页大小
        self.page_size = page_size
        # 起始索引
        self.start_index = start_index
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.drm_resource_tpls:
            for k in self.drm_resource_tpls:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['drm_resource_tpls'] = []
        if self.drm_resource_tpls is not None:
            for k in self.drm_resource_tpls:
                result['drm_resource_tpls'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.drm_resource_tpls = []
        if m.get('drm_resource_tpls') is not None:
            for k in m.get('drm_resource_tpls'):
                temp_model = DrmResourceTpl()
                self.drm_resource_tpls.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class AddDrmDrmresourcetplinstancesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        params: str = None,
        tpl_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id
        # 资源信息列表
        self.params = params
        # tpl id
        self.tpl_id = tpl_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.params is not None:
            result['params'] = self.params
        if self.tpl_id is not None:
            result['tpl_id'] = self.tpl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('tpl_id') is not None:
            self.tpl_id = m.get('tpl_id')
        return self


class AddDrmDrmresourcetplinstancesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回成功数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class AddRcSyncbucketRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        auto_start: bool = None,
        cluster_task_unique_key: str = None,
        source_cluster: str = None,
        target_cluster: str = None,
        two_way_sync: bool = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 是否自动开启数据同步任务(默认不开启同步任务)
        self.auto_start = auto_start
        # 自己指定的生成集群任务的唯一 key，针对聚石塔的情况，与用户的环境一一映射(查询时使用)
        self.cluster_task_unique_key = cluster_task_unique_key
        # {  // 商户当前注册中心集群信息
        # "type": "EUREKA",   // 集群类型
        # "name": "xx_eureka", // 集群名字
        # "vip": "11.22.33.44;12.33.44.1",   // 集群入口地址，可以是 vip；也可以是 ip 列表(多个用分号 ; 间隔)
        # "extraParams": [{   //扩展参数，比如涉及到鉴权
        # "key": "user",
        # "value": "xx"
        # }, {
        # "key": "password",
        # "value": "xx"
        # }]
        # }
        self.source_cluster = source_cluster
        # {  // 商户当前注册中心集群信息
        # "type": "EUREKA",   // 集群类型
        # "name": "xx_eureka", // 集群名字
        # "vip": "11.22.33.44;12.33.44.1",   // 集群入口地址，可以是 vip；也可以是 ip 列表(多个用分号 ; 间隔)
        # "extraParams": [{   //扩展参数，比如涉及到鉴权
        # "key": "user",
        # "value": "xx"
        # }, {
        # "key": "password",
        # "value": "xx"
        # }]
        # }
        self.target_cluster = target_cluster
        # 是否开启双向同步(默认单向：从 source_cluster -> target_cluster)，聚石塔中传为 true
        self.two_way_sync = two_way_sync
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.auto_start, 'auto_start')
        self.validate_required(self.cluster_task_unique_key, 'cluster_task_unique_key')
        self.validate_required(self.source_cluster, 'source_cluster')
        self.validate_required(self.target_cluster, 'target_cluster')
        self.validate_required(self.two_way_sync, 'two_way_sync')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.auto_start is not None:
            result['auto_start'] = self.auto_start
        if self.cluster_task_unique_key is not None:
            result['cluster_task_unique_key'] = self.cluster_task_unique_key
        if self.source_cluster is not None:
            result['source_cluster'] = self.source_cluster
        if self.target_cluster is not None:
            result['target_cluster'] = self.target_cluster
        if self.two_way_sync is not None:
            result['two_way_sync'] = self.two_way_sync
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('auto_start') is not None:
            self.auto_start = m.get('auto_start')
        if m.get('cluster_task_unique_key') is not None:
            self.cluster_task_unique_key = m.get('cluster_task_unique_key')
        if m.get('source_cluster') is not None:
            self.source_cluster = m.get('source_cluster')
        if m.get('target_cluster') is not None:
            self.target_cluster = m.get('target_cluster')
        if m.get('two_way_sync') is not None:
            self.two_way_sync = m.get('two_way_sync')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class AddRcSyncbucketResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: SyncBucketAddResult = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 一键创建集群同步任务结果
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = SyncBucketAddResult()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryRcSyncclusterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster_task_unique_key: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集群同步唯一key
        self.cluster_task_unique_key = cluster_task_unique_key
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.cluster_task_unique_key, 'cluster_task_unique_key')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster_task_unique_key is not None:
            result['cluster_task_unique_key'] = self.cluster_task_unique_key
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster_task_unique_key') is not None:
            self.cluster_task_unique_key = m.get('cluster_task_unique_key')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class QueryRcSyncclusterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[SyncCluster] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 集群元信息
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = SyncCluster()
                self.data.append(temp_model.from_map(k))
        return self


class QueryRcSynctaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster_id: str = None,
        cluster_task_unique_key: str = None,
        instance_id: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集群id
        self.cluster_id = cluster_id
        # 集群任务唯一键
        self.cluster_task_unique_key = cluster_task_unique_key
        # 租户实例id
        self.instance_id = instance_id
        # 任务类型，up 或者 down
        self.type = type

    def validate(self):
        self.validate_required(self.cluster_id, 'cluster_id')
        self.validate_required(self.cluster_task_unique_key, 'cluster_task_unique_key')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster_id is not None:
            result['cluster_id'] = self.cluster_id
        if self.cluster_task_unique_key is not None:
            result['cluster_task_unique_key'] = self.cluster_task_unique_key
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster_id') is not None:
            self.cluster_id = m.get('cluster_id')
        if m.get('cluster_task_unique_key') is not None:
            self.cluster_task_unique_key = m.get('cluster_task_unique_key')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class QueryRcSynctaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[ServiceSyncStatus] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 所有服务的同步状态信息
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ServiceSyncStatus()
                self.data.append(temp_model.from_map(k))
        return self


class QueryRcSyncdataRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        service_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 服务id
        self.service_id = service_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.service_id, 'service_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.service_id is not None:
            result['service_id'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('service_id') is not None:
            self.service_id = m.get('service_id')
        return self


class QueryRcSyncdataResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: List[SyncData] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 查询某个服务具体同步的数据
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = SyncData()
                self.data.append(temp_model.from_map(k))
        return self


class StartRcSynctaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster_task_unique_key: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 自己指定的生成集群任务的唯一 key，针对聚石塔的情况，与用户的环境一一映射
        self.cluster_task_unique_key = cluster_task_unique_key
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.cluster_task_unique_key, 'cluster_task_unique_key')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster_task_unique_key is not None:
            result['cluster_task_unique_key'] = self.cluster_task_unique_key
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster_task_unique_key') is not None:
            self.cluster_task_unique_key = m.get('cluster_task_unique_key')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class StartRcSynctaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class StopRcSynctaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster_task_unique_key: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 自己指定的生成集群任务的唯一 key，针对聚石塔的情况，与用户的环境一一映射
        self.cluster_task_unique_key = cluster_task_unique_key
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.cluster_task_unique_key, 'cluster_task_unique_key')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster_task_unique_key is not None:
            result['cluster_task_unique_key'] = self.cluster_task_unique_key
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster_task_unique_key') is not None:
            self.cluster_task_unique_key = m.get('cluster_task_unique_key')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class StopRcSynctaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class ExportDrmDrmresourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ExportDrmDrmresourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        download_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 下载地址
        self.download_url = download_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.download_url is not None:
            result['download_url'] = self.download_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('download_url') is not None:
            self.download_url = m.get('download_url')
        return self


class ImportDrmDrmresourcesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        upload_type: str = None,
        file_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 上传类型。
        # data 表示上传带有推送值，空表示只传元数据
        self.upload_type = upload_type
        # oss 上下载的地址
        self.file_name = file_name

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.file_name, 'file_name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.upload_type is not None:
            result['upload_type'] = self.upload_type
        if self.file_name is not None:
            result['file_name'] = self.file_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('upload_type') is not None:
            self.upload_type = m.get('upload_type')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        return self


class ImportDrmDrmresourcesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        import_result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 导入结果
        self.import_result = import_result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.import_result is not None:
            result['import_result'] = self.import_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('import_result') is not None:
            self.import_result = m.get('import_result')
        return self


class ImportGuardianGuardianrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        file_name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 文件名
        self.file_name = file_name
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ImportGuardianGuardianrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        import_result: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 导入结果
        self.import_result = import_result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.import_result is not None:
            result['import_result'] = self.import_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('import_result') is not None:
            self.import_result = m.get('import_result')
        return self


class ExportGuardianGuardianrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_name = app_name
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class ExportGuardianGuardianrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        download_url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 下载地址
        self.download_url = download_url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.download_url is not None:
            result['download_url'] = self.download_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('download_url') is not None:
            self.download_url = m.get('download_url')
        return self


class GetDrmUploadurlRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        file_name: str = None,
        type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 文件名
        self.file_name = file_name
        # 上传类型
        self.type = type

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.file_name, 'file_name')
        self.validate_required(self.type, 'type')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.file_name is not None:
            result['file_name'] = self.file_name
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('file_name') is not None:
            self.file_name = m.get('file_name')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class GetDrmUploadurlResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        url: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 上传地址
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class CallbackSpiOmsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 数据
        self.data = data

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class CallbackSpiOmsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        code: str = None,
        data: str = None,
        message: str = None,
        success: bool = None,
        synchro: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 返回吗
        self.code = code
        # data
        self.data = data
        # message
        self.message = message
        # success
        self.success = success
        # synchro
        self.synchro = synchro

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data
        if self.message is not None:
            result['message'] = self.message
        if self.success is not None:
            result['success'] = self.success
        if self.synchro is not None:
            result['synchro'] = self.synchro
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('synchro') is not None:
            self.synchro = m.get('synchro')
        return self


class AllDrmDrmldccellsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class AllDrmDrmldccellsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        is_ldc: bool = None,
        old_cells: List[str] = None,
        new_cells: List[CellLdcInfo] = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 是否是LDC
        self.is_ldc = is_ldc
        # 如果不是LDC返回cells名称列表
        self.old_cells = old_cells
        # 如果是LDC单元反回name和type信息
        self.new_cells = new_cells

    def validate(self):
        if self.new_cells:
            for k in self.new_cells:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.is_ldc is not None:
            result['is_ldc'] = self.is_ldc
        if self.old_cells is not None:
            result['old_cells'] = self.old_cells
        result['new_cells'] = []
        if self.new_cells is not None:
            for k in self.new_cells:
                result['new_cells'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('is_ldc') is not None:
            self.is_ldc = m.get('is_ldc')
        if m.get('old_cells') is not None:
            self.old_cells = m.get('old_cells')
        self.new_cells = []
        if m.get('new_cells') is not None:
            for k in m.get('new_cells'):
                temp_model = CellLdcInfo()
                self.new_cells.append(temp_model.from_map(k))
        return self


class OfflineSgServicepublishersRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        ips: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 下线的机器IP列表,英文逗号隔开
        self.ips = ips

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ips, 'ips')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ips is not None:
            result['ips'] = self.ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('ips') is not None:
            self.ips = m.get('ips')
        return self


class OfflineSgServicepublishersResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteRcSynctaskRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster_task_unique_key: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # cluster_task_unique_key
        self.cluster_task_unique_key = cluster_task_unique_key
        # instance_id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.cluster_task_unique_key, 'cluster_task_unique_key')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster_task_unique_key is not None:
            result['cluster_task_unique_key'] = self.cluster_task_unique_key
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster_task_unique_key') is not None:
            self.cluster_task_unique_key = m.get('cluster_task_unique_key')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteRcSynctaskResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QuerySgDowngradegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        downgrade_service: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
        rule_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称
        self.app_name = app_name
        # 降级服务
        self.downgrade_service = downgrade_service
        # 租户实例id
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 页大小
        self.page_size = page_size
        # 规则名称
        self.rule_name = rule_name

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.downgrade_service is not None:
            result['downgrade_service'] = self.downgrade_service
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('downgrade_service') is not None:
            self.downgrade_service = m.get('downgrade_service')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        return self


class QuerySgDowngradegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        downgrade_rule_groups: List[DowngradeRuleGroupVo] = None,
        page_size: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 降级规则组列表
        self.downgrade_rule_groups = downgrade_rule_groups
        # 页大小
        self.page_size = page_size
        # 总条数
        self.total_size = total_size

    def validate(self):
        if self.downgrade_rule_groups:
            for k in self.downgrade_rule_groups:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['downgrade_rule_groups'] = []
        if self.downgrade_rule_groups is not None:
            for k in self.downgrade_rule_groups:
                result['downgrade_rule_groups'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.downgrade_rule_groups = []
        if m.get('downgrade_rule_groups') is not None:
            for k in m.get('downgrade_rule_groups'):
                temp_model = DowngradeRuleGroupVo()
                self.downgrade_rule_groups.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class DeleteSgDowngradesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        rule_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 降级规则id
        self.rule_id = rule_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        return self


class DeleteSgDowngradesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class AddSgDowngradesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        strategy: str = None,
        app_name: str = None,
        downgrade_method: str = None,
        downgrade_service: str = None,
        instance_id: str = None,
        mode: str = None,
        rule_name: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 处理动作 (返回为空 返回错误)
        self.strategy = strategy
        # 应用名称
        self.app_name = app_name
        # 降级方法
        self.downgrade_method = downgrade_method
        # 降级服务
        self.downgrade_service = downgrade_service
        # 租户实例id
        self.instance_id = instance_id
        # 运行模式
        self.mode = mode
        # 规则名称
        self.rule_name = rule_name

    def validate(self):
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.downgrade_method, 'downgrade_method')
        self.validate_required(self.downgrade_service, 'downgrade_service')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.rule_name, 'rule_name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.strategy is not None:
            result['strategy'] = self.strategy
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.downgrade_method is not None:
            result['downgrade_method'] = self.downgrade_method
        if self.downgrade_service is not None:
            result['downgrade_service'] = self.downgrade_service
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.mode is not None:
            result['mode'] = self.mode
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('strategy') is not None:
            self.strategy = m.get('strategy')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('downgrade_method') is not None:
            self.downgrade_method = m.get('downgrade_method')
        if m.get('downgrade_service') is not None:
            self.downgrade_service = m.get('downgrade_service')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        return self


class AddSgDowngradesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class UpdateSgDowngradesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_id: int = None,
        instance_id: str = None,
        rule_id: int = None,
        app_name: str = None,
        downgrade_service: str = None,
        rule_name: str = None,
        downgrade_method: str = None,
        mode: str = None,
        strategy: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 降级规则组id
        self.group_id = group_id
        # 租户实例id
        self.instance_id = instance_id
        # 降级规则id
        self.rule_id = rule_id
        # 应用名称
        self.app_name = app_name
        # 降级服务
        self.downgrade_service = downgrade_service
        # 规则名称
        self.rule_name = rule_name
        # 降级方法
        self.downgrade_method = downgrade_method
        # 运行模式
        self.mode = mode
        # 处理动作 (返回为空 返回错误)
        self.strategy = strategy

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.downgrade_service, 'downgrade_service')
        self.validate_required(self.rule_name, 'rule_name')
        self.validate_required(self.downgrade_method, 'downgrade_method')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.strategy, 'strategy')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.downgrade_service is not None:
            result['downgrade_service'] = self.downgrade_service
        if self.rule_name is not None:
            result['rule_name'] = self.rule_name
        if self.downgrade_method is not None:
            result['downgrade_method'] = self.downgrade_method
        if self.mode is not None:
            result['mode'] = self.mode
        if self.strategy is not None:
            result['strategy'] = self.strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('downgrade_service') is not None:
            self.downgrade_service = m.get('downgrade_service')
        if m.get('rule_name') is not None:
            self.rule_name = m.get('rule_name')
        if m.get('downgrade_method') is not None:
            self.downgrade_method = m.get('downgrade_method')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('strategy') is not None:
            self.strategy = m.get('strategy')
        return self


class UpdateSgDowngradesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class EnableSgDowngradegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        group_id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 降级规则组id
        self.group_id = group_id
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class EnableSgDowngradegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DisableSgDowngradegroupsRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        instance_id: str = None,
        group_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 租户实例id
        self.instance_id = instance_id
        # 降级规则组id
        self.group_id = group_id

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.group_id, 'group_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.group_id is not None:
            result['group_id'] = self.group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('group_id') is not None:
            self.group_id = m.get('group_id')
        return self


class DisableSgDowngradegroupsResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class EnableSgDowngradesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        rule_id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 降级规则id
        self.rule_id = rule_id
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class EnableSgDowngradesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DisableSgDowngradesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        rule_id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 降级规则id
        self.rule_id = rule_id
        # 租户实例id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.rule_id is not None:
            result['rule_id'] = self.rule_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('rule_id') is not None:
            self.rule_id = m.get('rule_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DisableSgDowngradesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class EnableSgCircuitbreakerrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        id: str = None,
        instance_id: str = None,
        status: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 熔断规则id
        self.id = id
        # 租户id
        self.instance_id = instance_id
        # 生效
        self.status = status

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class EnableSgCircuitbreakerrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 影响行数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class QuerySgCircuitbreakerrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        instance_id: str = None,
        orders: str = None,
        page_size: int = None,
        start: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务资源id
        self.data_id = data_id
        # 租户实例id
        self.instance_id = instance_id
        # 排序规则，JSON字符串,，数组形式
        self.orders = orders
        # 分页大小
        self.page_size = page_size
        # 当前页
        self.start = start

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.orders is not None:
            result['orders'] = self.orders
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('orders') is not None:
            self.orders = m.get('orders')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        return self


class QuerySgCircuitbreakerrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        rule_models: List[CircuitBreakerRuleModel] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 分页大小
        self.page_size = page_size
        # 结果信息
        self.rule_models = rule_models
        # 开始索引
        self.start_index = start_index
        # 总服务资源数
        self.total_size = total_size

    def validate(self):
        if self.rule_models:
            for k in self.rule_models:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['rule_models'] = []
        if self.rule_models is not None:
            for k in self.rule_models:
                result['rule_models'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.rule_models = []
        if m.get('rule_models') is not None:
            for k in m.get('rule_models'):
                temp_model = CircuitBreakerRuleModel()
                self.rule_models.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class ListSgCircuitbreakerrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_names: str = None,
        data_id: str = None,
        instance_id: str = None,
        mode: str = None,
        orders: str = None,
        page_size: int = None,
        start: int = None,
        status: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称，数组形式
        self.app_names = app_names
        # 服务id
        self.data_id = data_id
        # 租户id
        self.instance_id = instance_id
        # 
        # 熔断模式，目前有OBSERVER和REJECT两种
        self.mode = mode
        # 排序规则，JSON字符串
        self.orders = orders
        # 分页大小
        self.page_size = page_size
        # 当前页
        self.start = start
        # 生效状态，0为不生效，1为生效
        self.status = status

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.start, 'start')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_names is not None:
            result['app_names'] = self.app_names
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.mode is not None:
            result['mode'] = self.mode
        if self.orders is not None:
            result['orders'] = self.orders
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start is not None:
            result['start'] = self.start
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('orders') is not None:
            self.orders = m.get('orders')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class ListSgCircuitbreakerrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        page_size: int = None,
        rule_models: List[CircuitBreakerRuleResult] = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 分页大小
        self.page_size = page_size
        # 熔断规则结果
        self.rule_models = rule_models
        # 起始索引
        self.start_index = start_index
        # 总服务个数
        self.total_size = total_size

    def validate(self):
        if self.rule_models:
            for k in self.rule_models:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        result['rule_models'] = []
        if self.rule_models is not None:
            for k in self.rule_models:
                result['rule_models'].append(k.to_map() if k else None)
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        self.rule_models = []
        if m.get('rule_models') is not None:
            for k in m.get('rule_models'):
                temp_model = CircuitBreakerRuleResult()
                self.rule_models.append(temp_model.from_map(k))
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class UpdateSgCircuitbreakerrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_names: str = None,
        circuit_breaker_rule_items: str = None,
        conditions: str = None,
        config: str = None,
        data_id: str = None,
        http_method: str = None,
        http_path: str = None,
        id: int = None,
        instance_id: str = None,
        method_name: str = None,
        mode: str = None,
        name: str = None,
        resource: str = None,
        res_type: str = None,
        traffic_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称
        self.app_names = app_names
        # 熔断规则配置  [{
        # "ruleType": "",//熔断规则类型 ce,crt,pe,prt(c代表消费方,p代表服务方,e代表错误率,rt响应时间)
        # "configs": {
        # "errorPercentThreshold": 50,//请求错误率阈值
        # "requestVolumeThreshold": 100,//请求数阈值
        # "averageRtThreshold":50,//平均RT阈值
        # "providerTimeout": 100,//服务超时时间
        # "sleepWindow": 10000,//熔断时间段
        # "totalMetricWindow": 60,//熔断指标窗口
        # "codeType": "error/success",
        # "codes": [
        # "200",
        # "201",
        # "202"
        # ]
        # },
        # "trafficConditions": [{
        # "field": "sourceApp",//sourceApp,trafficType(此时value取online,test),header
        # "operation": "EQUAL",//EQUAL,NOT_EQUAL,IN,NOT_IN,REGEX
        # "type": "system",//system,tracer,header_info
        # "value": [//当field取trafficType时value取online,test
        # "cloudinc"
        # ]
        # }],
        # "action": {
        # "type": "REJECT/PASS"
        # }
        # }]
        self.circuit_breaker_rule_items = circuit_breaker_rule_items
        # 生效条件，JSON数组
        self.conditions = conditions
        # 熔断配置
        self.config = config
        # 资源id
        self.data_id = data_id
        # 当service_type的值为SPRINGCLOUD时必传，值取(GET、POST、PUT、DELETE)，后端拼接到trafficConditions中
        self.http_method = http_method
        # 当service_type的值为SPRINGCLOUD时必传，后端拼接到trafficConditions中
        self.http_path = http_path
        # 
        # 熔断规则id
        self.id = id
        # 租户id
        self.instance_id = instance_id
        # 方法名称，当service_type的值为SPRINGCLOUD时不传
        self.method_name = method_name
        # 熔断规则运行模式
        self.mode = mode
        # 规则名
        self.name = name
        # 资源标识，资源格式是serviceId:trafficType:resType
        self.resource = resource
        # res的type,组成resource，取值r-rpc(默认), g-gateway, q-mq
        self.res_type = res_type
        # 取值i-inbound, o-outbound,组成resource的部分
        # i代表服务端，o代表消费端
        self.traffic_type = traffic_type

    def validate(self):
        self.validate_required(self.app_names, 'app_names')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_names is not None:
            result['app_names'] = self.app_names
        if self.circuit_breaker_rule_items is not None:
            result['circuit_breaker_rule_items'] = self.circuit_breaker_rule_items
        if self.conditions is not None:
            result['conditions'] = self.conditions
        if self.config is not None:
            result['config'] = self.config
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.http_method is not None:
            result['http_method'] = self.http_method
        if self.http_path is not None:
            result['http_path'] = self.http_path
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.method_name is not None:
            result['method_name'] = self.method_name
        if self.mode is not None:
            result['mode'] = self.mode
        if self.name is not None:
            result['name'] = self.name
        if self.resource is not None:
            result['resource'] = self.resource
        if self.res_type is not None:
            result['res_type'] = self.res_type
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        if m.get('circuit_breaker_rule_items') is not None:
            self.circuit_breaker_rule_items = m.get('circuit_breaker_rule_items')
        if m.get('conditions') is not None:
            self.conditions = m.get('conditions')
        if m.get('config') is not None:
            self.config = m.get('config')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('http_method') is not None:
            self.http_method = m.get('http_method')
        if m.get('http_path') is not None:
            self.http_path = m.get('http_path')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('method_name') is not None:
            self.method_name = m.get('method_name')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('resource') is not None:
            self.resource = m.get('resource')
        if m.get('res_type') is not None:
            self.res_type = m.get('res_type')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class UpdateSgCircuitbreakerrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 影响行数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class DeleteSgCircuitbreakerrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        id: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 熔断规则id
        self.id = id
        # 租户id
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteSgCircuitbreakerrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 影响行数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class AddSgCircuitbreakerrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_names: str = None,
        circuit_breaker_rule_items: str = None,
        conditions: str = None,
        config: str = None,
        data_id: str = None,
        http_method: str = None,
        http_path: str = None,
        instance_id: str = None,
        method_name: str = None,
        mode: str = None,
        name: str = None,
        resource: str = None,
        res_type: str = None,
        service_type: str = None,
        traffic_type: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名
        self.app_names = app_names
        # 熔断配置信息，json串。例: [{
        # "ruleType": "",//熔断规则类型 ce,crt,pe,prt(c代表消费方,p代表服务方,e代表错误率,rt响应时间)
        # "configs": {
        # "errorPercentThreshold": 50,//请求错误率阈值
        # "requestVolumeThreshold": 100,//请求数阈值
        # "averageRtThreshold":50,//平均RT阈值
        # "providerTimeout": 100,//服务超时时间
        # "sleepWindow": 10000,//熔断时间段
        # "totalMetricWindow": 60,//熔断指标窗口
        # "codeType": "error/success",
        # "codes": [
        # "200",
        # "201",
        # "202"
        # ]
        # },
        # "trafficConditions": [{
        # "field": "sourceApp",//sourceApp,trafficType(此时value取online,test),header
        # "operation": "EQUAL",//EQUAL,NOT_EQUAL,IN,NOT_IN,REGEX
        # "type": "system",//system,tracer,header_info
        # "value": [//当field取trafficType时value取online,test
        # "cloudinc"
        # ]
        # }],
        # "action": {
        # "type": "REJECT/PASS"
        # }
        # }]
        self.circuit_breaker_rule_items = circuit_breaker_rule_items
        # 生效场景
        self.conditions = conditions
        # 熔断规则
        self.config = config
        # 服务id
        self.data_id = data_id
        # 当service_type的值为SPRINGCLOUD时必传，后端拼接到trafficCondition中。
        # 取值范围(GET,POST,PUT,DELETE)
        self.http_method = http_method
        # http的路径值，当service_type的值为SPRINGCLOUD时必填,后端拼接到trafficCondition中
        self.http_path = http_path
        # 租户id
        self.instance_id = instance_id
        # 方法名称，"*"代表全部方法,当serviceType为SPRINGCLOUD时不传
        self.method_name = method_name
        # 运行模式
        self.mode = mode
        # 规则名
        self.name = name
        # 资源标识，资源格式是serviceId:trafficType:resType
        self.resource = resource
        # resType，resource组成的一部分
        # r-rpc(默认), g-gateway, q-mq
        self.res_type = res_type
        # serviceType，取值(SPRINGCLOUD,SOFA,DUBBO)
        self.service_type = service_type
        # 流量方法(o-outbind消费端,i-inbind服务端)
        self.traffic_type = traffic_type

    def validate(self):
        self.validate_required(self.app_names, 'app_names')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_names is not None:
            result['app_names'] = self.app_names
        if self.circuit_breaker_rule_items is not None:
            result['circuit_breaker_rule_items'] = self.circuit_breaker_rule_items
        if self.conditions is not None:
            result['conditions'] = self.conditions
        if self.config is not None:
            result['config'] = self.config
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.http_method is not None:
            result['http_method'] = self.http_method
        if self.http_path is not None:
            result['http_path'] = self.http_path
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.method_name is not None:
            result['method_name'] = self.method_name
        if self.mode is not None:
            result['mode'] = self.mode
        if self.name is not None:
            result['name'] = self.name
        if self.resource is not None:
            result['resource'] = self.resource
        if self.res_type is not None:
            result['res_type'] = self.res_type
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_names') is not None:
            self.app_names = m.get('app_names')
        if m.get('circuit_breaker_rule_items') is not None:
            self.circuit_breaker_rule_items = m.get('circuit_breaker_rule_items')
        if m.get('conditions') is not None:
            self.conditions = m.get('conditions')
        if m.get('config') is not None:
            self.config = m.get('config')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('http_method') is not None:
            self.http_method = m.get('http_method')
        if m.get('http_path') is not None:
            self.http_path = m.get('http_path')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('method_name') is not None:
            self.method_name = m.get('method_name')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('resource') is not None:
            self.resource = m.get('resource')
        if m.get('res_type') is not None:
            self.res_type = m.get('res_type')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class AddSgCircuitbreakerrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 影响行数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class SetSgCircuitbreakerrulesRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        data_id: str = None,
        id: str = None,
        instance_id: str = None,
        mode: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 服务id
        self.data_id = data_id
        # 规则id
        self.id = id
        # 租户id
        self.instance_id = instance_id
        # 运行模式
        self.mode = mode

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.id, 'id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.mode, 'mode')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.data_id is not None:
            result['data_id'] = self.data_id
        if self.id is not None:
            result['id'] = self.id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.mode is not None:
            result['mode'] = self.mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('data_id') is not None:
            self.data_id = m.get('data_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        return self


class SetSgCircuitbreakerrulesResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        result: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 影响行数
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.result is not None:
            result['result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('result') is not None:
            self.result = m.get('result')
        return self


class ReinitRcSyncclusterRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        cluster_task_unique_key: str = None,
        instance_id: str = None,
        new_cluster: str = None,
        replace_cluster_enabled: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 集群唯一表示，大部分情况下等于 instanceId
        self.cluster_task_unique_key = cluster_task_unique_key
        # 租户实例id
        self.instance_id = instance_id
        # 新的集群信息.
        # { // 商户当前注册中心集群信息 "type": "EUREKA", // 集群类型 "name": "xx_eureka", // 集群名字 "vip": "11.22.33.44;12.33.44.1", // 集群入口地址，可以是 vip；也可以是 ip 列表(多个用分号 ; 间隔) "extraParams": [{ //扩展参数，比如涉及到鉴权 "key": "user", "value": "xx" }, { "key": "password", "value": "xx" }] }
        self.new_cluster = new_cluster
        # 是否允许集群切换
        self.replace_cluster_enabled = replace_cluster_enabled

    def validate(self):
        self.validate_required(self.cluster_task_unique_key, 'cluster_task_unique_key')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.new_cluster, 'new_cluster')
        self.validate_required(self.replace_cluster_enabled, 'replace_cluster_enabled')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.cluster_task_unique_key is not None:
            result['cluster_task_unique_key'] = self.cluster_task_unique_key
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.new_cluster is not None:
            result['new_cluster'] = self.new_cluster
        if self.replace_cluster_enabled is not None:
            result['replace_cluster_enabled'] = self.replace_cluster_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('cluster_task_unique_key') is not None:
            self.cluster_task_unique_key = m.get('cluster_task_unique_key')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('new_cluster') is not None:
            self.new_cluster = m.get('new_cluster')
        if m.get('replace_cluster_enabled') is not None:
            self.replace_cluster_enabled = m.get('replace_cluster_enabled')
        return self


class ReinitRcSyncclusterResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class AddTransparentproxyNodeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        nodes: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称
        self.app_name = app_name
        # 租户实例 ID
        self.instance_id = instance_id
        # 节点列表
        self.nodes = nodes

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.nodes, 'nodes')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.nodes is not None:
            result['nodes'] = self.nodes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('nodes') is not None:
            self.nodes = m.get('nodes')
        return self


class AddTransparentproxyNodeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class DeleteTransparentproxyAppRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_id: int = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用 ID
        self.app_id = app_id
        # 租户实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.app_id, 'app_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_id is not None:
            result['app_id'] = self.app_id
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_id') is not None:
            self.app_id = m.get('app_id')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class DeleteTransparentproxyAppResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryTransparentproxyAppRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称（模糊匹配）
        self.app_name = app_name
        # 租户实例 ID
        self.instance_id = instance_id
        # 页码
        self.page_num = page_num
        # 页大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class QueryTransparentproxyAppResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        list: List[TransparentProxyAppVo] = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 应用列表
        self.list = list
        # 页大小
        self.page_size = page_size
        # 开始位置
        self.start_index = start_index
        # 总数
        self.total_size = total_size

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['list'] = []
        if self.list is not None:
            for k in self.list:
                result['list'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.list = []
        if m.get('list') is not None:
            for k in m.get('list'):
                temp_model = TransparentProxyAppVo()
                self.list.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class UpdateTransparentproxyConfigRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_config: str = None,
        app_name: str = None,
        instance_id: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 透明劫持配置
        self.app_config = app_config
        # 应用名称
        self.app_name = app_name
        # 租户实例 ID
        self.instance_id = instance_id

    def validate(self):
        self.validate_required(self.app_config, 'app_config')
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_config is not None:
            result['app_config'] = self.app_config
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_config') is not None:
            self.app_config = m.get('app_config')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        return self


class UpdateTransparentproxyConfigResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryTransparentproxyLogRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        modify_name: str = None,
        page_num: int = None,
        page_size: int = None,
        time_sort: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称
        self.app_name = app_name
        # 租户实例 ID
        self.instance_id = instance_id
        # 修改人姓名
        self.modify_name = modify_name
        # 页码
        self.page_num = page_num
        # 页大小
        self.page_size = page_size
        # 排序策略，默认为 desc
        self.time_sort = time_sort

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.modify_name is not None:
            result['modify_name'] = self.modify_name
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.time_sort is not None:
            result['time_sort'] = self.time_sort
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('modify_name') is not None:
            self.modify_name = m.get('modify_name')
        if m.get('page_num') is not None:
            self.page_num = m.get('page_num')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('time_sort') is not None:
            self.time_sort = m.get('time_sort')
        return self


class QueryTransparentproxyLogResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        current_page: int = None,
        list: List[TransparentProxyOperatorLogVo] = None,
        page_size: int = None,
        start_index: int = None,
        total_size: int = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 当前页
        self.current_page = current_page
        # 日志列表
        self.list = list
        # 页大小
        self.page_size = page_size
        # 起始位置
        self.start_index = start_index
        # 总数
        self.total_size = total_size

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.current_page is not None:
            result['current_page'] = self.current_page
        result['list'] = []
        if self.list is not None:
            for k in self.list:
                result['list'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_index is not None:
            result['start_index'] = self.start_index
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('current_page') is not None:
            self.current_page = m.get('current_page')
        self.list = []
        if m.get('list') is not None:
            for k in m.get('list'):
                temp_model = TransparentProxyOperatorLogVo()
                self.list.append(temp_model.from_map(k))
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_index') is not None:
            self.start_index = m.get('start_index')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class AddTransparentproxyAppRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        nodes: str = None,
        support_protocols: str = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称
        self.app_name = app_name
        # 租户实例 ID
        self.instance_id = instance_id
        # 包含的节点
        self.nodes = nodes
        # 支持的协议
        self.support_protocols = support_protocols

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.support_protocols, 'support_protocols')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.nodes is not None:
            result['nodes'] = self.nodes
        if self.support_protocols is not None:
            result['support_protocols'] = self.support_protocols
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('nodes') is not None:
            self.nodes = m.get('nodes')
        if m.get('support_protocols') is not None:
            self.support_protocols = m.get('support_protocols')
        return self


class AddTransparentproxyAppResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
        data: TransparentProxyAppVo = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg
        # 应用结构体
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        if m.get('data') is not None:
            temp_model = TransparentProxyAppVo()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteTransparentproxyNodeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        node_id: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称
        self.app_name = app_name
        # 租户实例 ID
        self.instance_id = instance_id
        # 节点 ID
        self.node_id = node_id

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.node_id, 'node_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.node_id is not None:
            result['node_id'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = m.get('app_name')
        if m.get('instance_id') is not None:
            self.instance_id = m.get('instance_id')
        if m.get('node_id') is not None:
            self.node_id = m.get('node_id')
        return self


class DeleteTransparentproxyNodeResponse(TeaModel):
    def __init__(
        self,
        req_msg_id: str = None,
        result_code: str = None,
        result_msg: str = None,
    ):
        # 请求唯一ID，用于链路跟踪和问题排查
        self.req_msg_id = req_msg_id
        # 结果码，一般OK表示调用成功
        self.result_code = result_code
        # 异常信息的文本描述
        self.result_msg = result_msg

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.req_msg_id is not None:
            result['req_msg_id'] = self.req_msg_id
        if self.result_code is not None:
            result['result_code'] = self.result_code
        if self.result_msg is not None:
            result['result_msg'] = self.result_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('req_msg_id') is not None:
            self.req_msg_id = m.get('req_msg_id')
        if m.get('result_code') is not None:
            self.result_code = m.get('result_code')
        if m.get('result_msg') is not None:
            self.result_msg = m.get('result_msg')
        return self


class QueryTransparentproxyNodeRequest(TeaModel):
    def __init__(
        self,
        auth_token: str = None,
        product_instance_id: str = None,
        app_name: str = None,
        instance_id: str = None,
        ip: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # OAuth模式下的授权token
        self.auth_token = auth_token
        self.product_instance_id = product_instance_id
        # 应用名称
        self.app_name = app_name
        # 租户实例 ID
        self.instance_id = instance_id
        # IP 地址模糊匹配
        self.ip = ip
        # 页码
        self.page_num = page_num
        # 页大小
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = dict()
        if self.auth_token is not None:
            result['auth_token'] = self.auth_token
        if self.product_instance_id is not None:
            result['product_instance_id'] = self.product_instance_id
        if self.app_name is not None:
            result['app_name'] = self.app_name
        if self.instance_id is not None:
            result['instance_id'] = self.instance_id
        if self.ip is not None:
            result['ip'] = self.ip
        if self.page_num is not None:
            result['page_num'] = self.page_num
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('auth_token') is not None:
            self.auth_token = m.get('auth_token')
        if m.get('product_instance_id') is not None:
            self.product_instance_id = m.get('product_instance_id')
        if m.get('app_name') is not None:
            self.app_name = 