/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.genetic;

import java.util.ArrayList;
import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.ConfigurationImpl;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.PropertyImpl;
import no.priv.garshol.duke.genetic.ComparatorAspect;
import no.priv.garshol.duke.genetic.GeneticConfiguration;
import no.priv.garshol.duke.genetic.TestComparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComparatorAspectTest {
    private Configuration config1;
    private TestComparator comparator = new TestComparator();
    private String propName = "NAME";

    @Before
    public void setup() {
        this.config1 = new ConfigurationImpl();
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        props.add(new PropertyImpl("ID"));
        props.add(new PropertyImpl(this.propName, null, 0.3, 0.8));
        ((ConfigurationImpl)this.config1).setProperties(props);
        ((ConfigurationImpl)this.config1).setThreshold(0.85);
    }

    @Test
    public void canAddCustomComparator() {
        GeneticConfiguration conf = new GeneticConfiguration(this.config1);
        PropertyImpl aspectProp = new PropertyImpl(this.propName, null, 0.5, 0.5);
        ArrayList<TestComparator> compList = new ArrayList<TestComparator>();
        compList.add(this.comparator);
        ComparatorAspect aspect = new ComparatorAspect((Property)aspectProp, compList);
        aspect.setRandomly(conf);
        Property updatedProp = this.config1.getPropertyByName(this.propName);
        Comparator randomComparator = updatedProp.getComparator();
        Assert.assertTrue((String)("should have custom comparator set, but has : " + randomComparator.getClass()), (boolean)randomComparator.equals(this.comparator));
    }
}

