/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.databases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.databases.AbstractBlockingDatabase;
import no.priv.garshol.duke.databases.KeyFunction;

public class InMemoryBlockingDatabase
extends AbstractBlockingDatabase {
    public InMemoryBlockingDatabase() {
        this.idmap = new HashMap();
    }

    @Override
    public void index(Record record) {
        this.indexById(record);
        for (KeyFunction keyfunc : this.functions) {
            String key;
            NavigableMap blocks = this.getBlocks(keyfunc);
            ArrayList<Record> block = (ArrayList<Record>)blocks.get(key = keyfunc.makeKey(record));
            if (block == null) {
                block = new ArrayList<Record>();
                blocks.put(key, block);
            }
            block.add(record);
        }
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    public String toString() {
        return "InMemoryBlockingDatabase window_size=" + this.window_size + "\n  " + this.functions;
    }

    @Override
    protected int addBlock(Collection<Record> candidates, Map.Entry block) {
        Collection recs = (Collection)block.getValue();
        candidates.addAll(recs);
        return recs.size();
    }

    @Override
    protected NavigableMap makeMap(KeyFunction keyfunc) {
        return new TreeMap();
    }
}

