/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.Cleaner;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.utils.CSVReader;

public class MappingFileCleaner
implements Cleaner {
    private Map<String, String> mapping;

    @Override
    public String clean(String value) {
        String newvalue = this.mapping.get(value);
        if (newvalue == null) {
            return value;
        }
        return newvalue;
    }

    public void setMappingFile(String filename) {
        this.mapping = new HashMap<String, String>();
        try {
            CSVReader csv = new CSVReader(new FileReader(filename));
            String[] row = csv.next();
            while (row != null) {
                this.mapping.put(row[0], row[1]);
                row = csv.next();
            }
            csv.close();
        }
        catch (IOException e) {
            throw new DukeException("Error loading mapping file " + filename, e);
        }
    }
}

