/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.Property;

public class PropertyImpl
implements Property {
    private String name;
    private boolean id;
    private boolean analyzed;
    private boolean ignore;
    private Comparator comparator;
    private double high;
    private double low;
    private Property.Lookup lookup;

    public PropertyImpl(String name) {
        this.name = name;
        this.id = true;
        this.analyzed = false;
        this.lookup = Property.Lookup.FALSE;
    }

    public PropertyImpl(String name, Comparator comparator, double low, double high) {
        this.name = name;
        this.id = false;
        this.analyzed = comparator != null && comparator.isTokenized();
        this.comparator = comparator;
        this.high = high;
        this.low = low;
        this.lookup = Property.Lookup.DEFAULT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isIdProperty() {
        return this.id;
    }

    @Override
    public boolean isAnalyzedProperty() {
        return this.analyzed;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    @Override
    public double getHighProbability() {
        return this.high;
    }

    @Override
    public double getLowProbability() {
        return this.low;
    }

    @Override
    public Property.Lookup getLookupBehaviour() {
        return this.lookup;
    }

    @Override
    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public void setHighProbability(double high) {
        this.high = high;
    }

    @Override
    public void setLowProbability(double low) {
        this.low = low;
    }

    @Override
    public boolean isIgnoreProperty() {
        return this.ignore || this.high == 0.0;
    }

    @Override
    public void setIgnoreProperty(boolean ignore) {
        this.ignore = ignore;
    }

    @Override
    public void setLookupBehaviour(Property.Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public double compare(String v1, String v2) {
        if (this.comparator == null) {
            return 0.5;
        }
        double sim = this.comparator.compare(v1, v2);
        if (sim >= 0.5) {
            return (this.high - 0.5) * (sim * sim) + 0.5;
        }
        return this.low;
    }

    @Override
    public Property copy() {
        if (this.id) {
            return new PropertyImpl(this.name);
        }
        PropertyImpl p = new PropertyImpl(this.name, this.comparator, this.low, this.high);
        p.setIgnoreProperty(this.ignore);
        p.setLookupBehaviour(this.lookup);
        return p;
    }

    public String toString() {
        return "[Property " + this.name + "]";
    }
}

