*/* RMNLIB - Library of useful routines for C and FORTRAN programming
* * Copyright (C) 1975-2001  Division de Recherche en Prevision Numerique
* *                          Environnement Canada
* *
* * This library is free software; you can redistribute it and/or
* * modify it under the terms of the GNU Lesser General Public
* * License as published by the Free Software Foundation,
* * version 2.1 of the License.
* *
* * This library is distributed in the hope that it will be useful,
* * but WITHOUT ANY WARRANTY; without even the implied warranty of
* * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* * Lesser General Public License for more details.
* *
* * You should have received a copy of the GNU Lesser General Public
* * License along with this library; if not, write to the
* * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* * Boston, MA 02111-1307, USA.
* */

*
*  MACRO ICHAMP(MOT,FIN,LG)   EXTRAIT UN CHAMP D'UN MOT
*
*   MOT   MOT QUI CONTIENT LE CHAMP
*   FIN   NUMERO DU DERNIER BIT (A DROITE) DU CHAMP, EN NUMEROTATION
*         GAUCHE > DROITE (LE BIT 0 EST A DROITE DU MOT).
*   LG    LONGUEUR, EN BITS, DU CHAMP
*

*
*  MACRO IUNPAK(BASE, BITPOS, LG)  OBTENIR UN CHAMP D'UN TABLEAU
*
*  BASE    TABLEAU CONTENANT LE CHAMP A EXTRAIRE
*  BITPOS  POSITION DU BIT DE DROITE DU CHAMP A EXTRAIRE
*          LE BIT 0 EST LE BIT SIGNE DU PREMIER MOT DU TABLEAU.
*  LG      EST LE NOMBRE DE BITS QU'OCCUPE LE CHAMP. (MAX 32 BITS)
*

*
*
*  MACRO GETBIT(BASE, BITPOS, LG)  OBTENIR UN CHAMP D'UN TABLEAU
*
*  BASE    TABLEAU CONTENANT LE CHAMP A EXTRAIRE
*  BITPOS  POSITION DU BIT DE DROITE DU CHAMP A EXTRAIRE
*          LE BIT 0 EST LE BIT SIGNE DU PREMIER MOT DU TABLEAU.
*  LG      EST LE NOMBRE DE BITS QU'OCCUPE LE CHAMP. (MAX 32 BITS)
*

*
*
*  MACRO INSERT(TABL,KWA,BITPOS,LONG)  INSERER UN CHAMP DANS UN TABLEAU
*
*  TABL    TABLEAU QUI CONTIENDRA LE CHAMP APRES INSERTION
*  KWA     MOT QUI CONTIENT LE CHAMP A INSERER JUSTIFIE A DROITE
*  BITPOS  POSITION DU DERNIER BIT (A DROITE) DU CHAMP A INSERER
*          LE BIT 0 EST LE BIT SIGNE DU PREMIER MOT DU TABLEAU
*  LONG    LONGUEUR EN BIT DU CHAMP A INSERER (PAS PLUS DE 32 BITS)
*

*
*  MACRO PUTBIT(TABL,KWA,BITPOS,LONG)  INSERER UN CHAMP DANS UN TABLEAU
*
*  TABL    TABLEAU QUI CONTIENDRA LE CHAMP APRES INSERTION
*  KWA     MOT QUI CONTIENT LE CHAMP A INSERER JUSTIFIE A DROITE
*  BITPOS  POSITION DU DERNIER BIT (A DROITE) DU CHAMP A INSERER
*          LE BIT 0 EST LE BIT SIGNE DU PREMIER MOT DU TABLEAU
*  LONG    LONGUEUR EN BIT DU CHAMP A INSERER (PAS PLUS DE 32 BITS)
*

*
*  MACRO CLRBIT(TABL,BITPOS,LONG)  METTRE A ZERO UN CHAMP DANS UN TABLEAU
*
*  TABL    TABLEAU
*  BITPOS  POSITION DU DERNIER BIT (A DROITE) DU CHAMP A NETTOYER
*          LE BIT 0 EST LE BIT SIGNE DU PREMIER MOT DU TABLEAU
*  LONG    LONGUEUR EN BIT DU CHAMP A NETTOYER (PAS PLUS DE 32 BITS)
*

*
*  MACRO PUTBITC(TABL,KWA,BITPOS,LONG)  INSERER UN CHAMP DANS UN TABLEAU
*                                       AVEC NETTOYAGE PRELIMINAIRE
*  TABL    TABLEAU QUI CONTIENDRA LE CHAMP APRES INSERTION
*  KWA     MOT QUI CONTIENT LE CHAMP A INSERER JUSTIFIE A DROITE
*  BITPOS  POSITION DU DERNIER BIT (A DROITE) DU CHAMP A INSERER
*          LE BIT 0 EST LE BIT SIGNE DU PREMIER MOT DU TABLEAU
*  LONG    LONGUEUR EN BIT DU CHAMP A INSERER (PAS PLUS DE 32 BITS)
*

*----------------------------------------------------------------------
*

*----------------------------------------------------------------------

*----------------------------------------------------------------------

*
* POSITIONS DES CHAMPS DE L'ENTETE RANDOM
* UTILISABLES AVEC LES MACROS IUNPAK ET INSERT
*

*
*
*  ETIQET  EST L'ETIQUETTE AFFECTEE AU FORMAT
*  LISVAR  EST LA LISTE DE VARIABLES A IMPRIMER AVEC LE MESSAGE D'ERREUR
*  FORMAT  EST LE FORMAT D'IMPRESSION A UTILISER;  CE PARAMETRE CONTIENT
*          LE MESSAGE D'ERREUR ET LES SPECIFICATIONS D'IMPRESSION POUR LISVAR.
*
*         ERREUR MAJEURE FATALE DU SYSTEM
*
*  MACRO FSTSYST(ORIGINE,MESSAGE,CODE,STATUT)
*  CETTE MACRO REALISE LE TRAITEMENT D'ERREUR DU PROGICIEL DES FICHIERS
*  STANDARDS.
*

*
*
*         ERREUR MAJEURE FATALE
*
*  MACRO FSTFATA(ORIGINE,MESSAGE,CODE,STATUT)
*  CETTE MACRO REALISE LE TRAITEMENT D'ERREUR DU PROGICIEL DES FICHIERS
*  STANDARDS.
*

*
*
*       FSTERRO  ERREUR MAJEURE
*
*  MACRO FSTERRO(ORIGINE,MESSAGE,CODE,STATUT)
*  CETTE MACRO REALISE LE TRAITEMENT D'ERREUR DU PROGICIEL DES FICHIERS
*  STANDARDS.
*

*
*
*     WARNING  AVERTISSEMENT MESSAGE
*
*  MACRO FSTWARN(ORIGINE,MESSAGE,CODE,STATUT)
*  CETTE MACRO REALISE LE TRAITEMENT D'ERREUR DU PROGICIEL DES FICHIERS
*  STANDARDS.
*

*
*
*
*      ERREUR MESSAGE TYPE INFORMATIQUE
*
*  MACRO FSTINFO(ORIGINE,MESSAGE,CODE,STATUT)
*  CETTE MACRO REALISE LE TRAITEMENT D'ERREUR DU PROGICIEL DES FICHIERS
*  STANDARDS.
*

*
*    MESSAGE QUI PEUVENT SERVIR AU DEBUGGING
*
*
*  MACRO FSTTRIV(ORIGINE,MESSAGE,CODE,STATUT)
*  CETTE MACRO REALISE LE TRAITEMENT D'ERREUR DU PROGICIEL DES FICHIERS
*  STANDARDS.
*

*
*
*
*
*  MACRO STOVEC(VEC, ADR, DIMVEC) STOCKER UN VECTEUR A UNE ADRESSE
*

*
*  MACRO FETVEC(VEC, ADR, DIMVEC) OBTENIR UN VECTEUR D'UNE ADRESSE (SCM,LCM)
*

*
*  MACRO SEPARAT(INDESC)  UTILISE L'ESPACE DE NRECUP POUR LES SEPARATEURS DE
*                         FIN DE FICHIER
*
*  INDESC    INDICE DU FICHIER SEQUENTIEL STANDARD
*

*
*
*         VALID ARGUMENT %2 > %3  ET  ARGUMENT %2 < %4
*
*  MACRO VALID(NOM,I2,I3,I4)
*
*  NOM = NOM DE LA ROUTINE MAX 7 CARACTERES
*  I2  = ARGUMENT A VERIFIER
*  I3  = LA PLUS PETITE VALEUR DE I2
*  I4  = LA PLUS GRANDE VALEUR DE I2
*
*  NORMALEMENT CETTE MACRO VERIFIER LA VALEUR DE IP1 - IP2   FICHIERS
*  STANDARDS.
*

*
*** S/P A4R4A    TRANSFORMER A4 EN R4A
*
      SUBROUTINE A4R4A(R4A,A4,N)
      IMPLICIT NONE
      INTEGER R4A(*), A4(*), N
      INTEGER NBMOT,NI,ASC,I
*
*AUTEUR     M. LEPINE  MARS 85
*
*LANGAGE    RATFOR
*
*OBJET(A4R4A)
*     TRANSFORMER N CARACTERES CONTENUS DANS DES MOT A4 (4 CAR ALIGNES
*  A GAUCHE) EN N CARACTERES CONTENUS DANS DES MOT R4A (4 CAR DE 8 BITS
*  ALIGNES DANS LA PARTIE DROITE DU MOT)
*
*
*ARGUMENTS
*  IN    A4     TABLEAU D'ENTIERS CONTENANT LES CAR. DE TYPE A4
*  OUT   R4A    TABLEAU D'ENTIERS CONTENANT LES CAR. DE TYPE R4A
*  IN    N      NOMBRE DE CARACTERES A TRANSFORMER
*
**

      NBMOT = (N+3) / 4
      DO 23000 I = 1,NBMOT
         R4A(I) = A4(I)
*------------------------------------------------------------------------

23000 CONTINUE 
      RETURN
      END

***S/P FSTABT  FIN ANORMALE DU PROGICIEL FICHIER STANDARD
*
      SUBROUTINE FSTABT
      IMPLICIT NONE

*
*AUTEUR  M. VALIN MARS 1989
*
*REVISION   000 NOUVELLE VERSION MARS 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTABT)
*         ON TERMINE L'EXECUTION DU PROGRAM APRES UNE ERREUE FATALE
*         ON FERME TOUS LES FICHIERS STANDARD COURRAMMENT OUVERT
*         ET L'APPEL A ABORT DONNE UN TRACEBACK.
*
*ARGUMENTS
* NONE
*
*IMPLICITES
*
      EXTERNAL ABORT, FSTFRM
      INTEGER FSTFRM
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER INDESC,IERR
*

      DO 23000 INDESC = 0,40
         IF((IUNTAB(INDESC).NE. -1 ))THEN
            IERR = FSTFRM(IUNTAB(INDESC))
         ENDIF 

*
*       ERREUR FATALE
*
23000 CONTINUE 
      WRITE(LOGFIL,*)' *** ERREUR FATALE FICHIER STANDARDS ***'
*

      CALL ABORT
*

      RETURN
      END

***FONCTION FSTAPP  CHERCHER LA FIN DU FICHIER SEQ
*
      FUNCTION FSTAPP(IUN, OPTIONS )
      IMPLICIT NONE
      INTEGER FSTAPP
      CHARACTER *(*) OPTIONS
      INTEGER IUN
*
*AUTEUR  P. SARRAZIN 1990
*
*REVISION   000 NOUVELLE VERSION JANV 1990
*
*LANGAGE RATFOR
*
*OBJET(FSTAPP)
*         PERMET DE TROUVER LE DERNIER RECORD ECRIT SUR LE FICHIER
*         LA RECHERCHE D UN EOF > 14 INDIQUE LA FIN DU FICHIER [31]
*
*ARGUMENTS
*  IUN   - NUMERO D UNITE FORTRAN
*
*IMPLICITES
*

      EXTERNAL QSTINT, FSTOUV, QSTUPA, WAREAD, QSTEOI
      INTEGER  QSTINT, FSTOUV, QSTEOI
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER INDESC, RHEAD(30), BUFFER(512), IGET, I
      INTEGER IEOI, NREC
*

      FSTAPP = 0
      NREC = 1
      IF((IUN.LT. 1 .OR. IUN.GT. 99 ))THEN
         FSTAPP=QDRERR('FSTAPP',' NUMERO D UNITE INVALIDE', 31,4)
         RETURN

*
      ENDIF 
      INDESC = QSTINT(IUN)
      IF((INDESC.GT.40))THEN
         FSTAPP=QDRERR('FSTAPP',' FILE NOT OPEN', 15,4)
         RETURN

*
*      ---------------------------------------------------------------
      ENDIF 
      IF((DIRSIZ(INDESC).EQ.0 .AND. NBCORR(INDESC).EQ.0))THEN

*         BACKSPACE(IUN)
1000     READ(IUN,ERR=99, END=100) (RHEAD(I),I=1,30)
         GO TO 1000

*      ---------------------------------------------------------------
      ELSE 
         IF((DIRSIZ(INDESC).EQ.0 .AND. NBCORR(INDESC).EQ. -1)
     %   )THEN
            CALL WAREAD(IUN, BUFFER, 1,30)
            IF((SQSYNC.NE. BUFFER(30)))THEN
               GO TO 1900
            ENDIF 
            IGET =IAND(ishft(BUFFER((1+ishft( 639,-(5)))),-((31-IAND
     %      ( 639,31)))),ishft(-1,-(32-( 32))))
            IF((IGET.EQ. 0 ))THEN
               GO TO 1900
            ENDIF 
            CALL WAREAD(IUN, BUFFER, (1+IGET*30),30)
            NXTSEQ(INDESC) = 1+IGET*30
            CURSEQ(INDESC) = NXTSEQ(INDESC)
            RETURN
*
*         ON NE PEUT SE RENDRE A LA FIN DU FICHIER ON VERIFI CHAQUE RECORD
*

1900        CURSEQ(INDESC) = 1
            NXTSEQ(INDESC) = 1
2000        CALL WAREAD(IUN, BUFFER, NXTSEQ(INDESC),30)
            NREC = NREC +1
            IF((BUFFER(30).NE. SQSYNC))THEN
               GOTO 190
            ENDIF 
            IGET =IAND(ishft(BUFFER((1+ishft( 511,-(5)))),-((31-IAND
     %      ( 511,31)))),ishft(-1,-(32-( 32))))
            IF((IGET.EQ. 31 ))THEN
               GO TO 200
            ENDIF 
            IF((IGET.GT. 14 ))THEN
               GO TO 210
            ENDIF 
            IGET =IAND(ishft(BUFFER((1+ishft( 575,-(5)))),-((31-IAND
     %      ( 575,31)))),ishft(-1,-(32-( 32))))
            IF(((1+IGET*30).NE. CURSEQ(INDESC)))THEN
               GOTO 190
            ENDIF 
            CALL QSTUPA(BUFFER)
            CURSEQ(INDESC) = NXTSEQ(INDESC)
            NXTSEQ(INDESC)=CURSEQ(INDESC)+30*((LNG+30-1)/30+1)
            GO TO 2000

*      ---------------------------------------------------------------
         ELSE 
            NUMREC(INDESC) = -1
            WRITE(LOGFIL,*)' AUCUN EFFET SUR FICHIER RANDOM FSTAPP'

*
         ENDIF 
      ENDIF 
      RETURN
*      ----------------------------------------------------------------
*

99    CONTINUE
      FSTAPP=QDRERR('FSTAPP',' ERREUR SUR READ SEQ/FTN I/O', 25,6)
      RETURN
*

100   WRITE(6,*)' FIN DU FICHIER SEQ/FTN'
      RETURN
*

190   CONTINUE
      WRITE(6,*)' RECOVERED REC # =',NREC,'    UNIT # = ',IUN
      IEOI = QSTEOI(INDESC)
      FSTAPP=QDRERR('FSTAPP',' RECOVER  FICHIER ENDOMMAGE',21 ,4)
      WRITE(LOGFIL,*)' RECORD AVEC HEADER NORMAL RETENU '
      RETURN
*

200   WRITE(6,*)' FIN DU FICHIER SEQ/RND NIVEAU= ',IGET
      WRITE(6,*)' RECOVERED REC # =',NREC,'    UNIT # = ',IUN
      RETURN
*

210   WRITE(6,*)' FIN DE FICHIER SEQ NIVEAU = ', IGET
      WRITE(6,*)' RECOVERED REC # =',NREC,'    UNIT # = ',IUN
      RETURN
      END

***FONCTION FSTCVT  HOLLERITH A CARACTERE OU L'INVERSE
*
      FUNCTION FSTCVT( NOM, TYP, ETIK, GRTP, CNOM, CTYP,CETIK, CGRTP
     %, HOLACAR)
      IMPLICIT NONE
      INTEGER FSTCVT
      INTEGER NOM, TYP, ETIK(2), GRTP
      CHARACTER *(*) CNOM
      CHARACTER *(*) CTYP, CGRTP
      CHARACTER *(*) CETIK
      LOGICAL HOLACAR
*
*AUTEUR  P. SARRAZIN   NOV  1989
*
*REVISION   000 NOUVELLE VERSION NOVEMBRE 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTCVT)
*         VARIABLE UTILISEE COMME HOLLERITH SERA TRANSFORME EN CARACTERE
*         OU L'INVERSE POUR NOMVAR,TYPVAR,GRID TYPE, ET ETIKET LE MOT
*         ETIKET AURA 2 LOCATIONS SUR LE SUN
*
*ARGUMENTS
*  IN OUT    NOM       HOLLERITH *2                       [NOMVAR]
*  IN OUT    TYP       HOLLERITH *1                       [TYPVAR]
*  IN OUT    ETIK      HOLLERITH *8   2 MOTS A4 POUR SUN  [ETIKET]
*  IN OUT    GRTP      HOLLERITH *1                       [GRTYP]
*  OUT IN    CNOM      CARACTERE *2
*  OUT IN    CTYP      CARACTERE *1
*  OUT IN    CETIK     CARACTERE *8
*  OUT IN    CGRTP     CARACTRE *1
*  IN        HOLACAR   LOGICAL .TRUE.  HOLLERITH A CARATERE
*                      LOGICAL .FALSE. CARACTERE A HOLLERITH
*
*IMPLICITES
*
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER I
*

      FSTCVT = 0
      IF((HOLACAR))THEN

*
*       TRANSFER STRING D'UNE LOCATION HOLLERITH EN CARACTERE
*
         IF((NOM.EQ. -1))THEN
            CNOM = ' '
         ELSE 
            WRITE(CNOM,'(A2)') NOM
         ENDIF 
         IF((TYP.EQ. -1))THEN
            CTYP = ' '
         ELSE 
            WRITE(CTYP,'(A1)') TYP
         ENDIF 
         IF((GRTP.EQ. -1))THEN
            CGRTP = ' '
         ELSE 
            WRITE(CGRTP,'(A1)') GRTP
         ENDIF 
         CETIK = ' '
         IF((ETIK(1).EQ. -1))THEN
            CETIK = ' '
         ELSE 
            WRITE(CETIK,600)(ETIK(I),I=1,10/04)
*
*       WRITE(6,668)NOM,TYP,GRTP,ETIK(1),ETIK(2)
*       WRITE(6,666)NOM,TYP,GRTP,ETIK(1)
*       WRITE(6,667)CNOM,CTYP,CGRTP,CETIK

         ENDIF 
      ELSE 

*
*       TRANSFER STRING D'UNE LOCATION CARACTERE EN HOLLERITH
*
         READ(CNOM,'(A2)') NOM
         IF((CNOM.EQ. ' '))THEN
            NOM = -1
*

         ENDIF 
         READ(CTYP,'(A1)') TYP
         IF((CTYP.EQ. ' '))THEN
            TYP = -1
*

         ENDIF 
         READ(CGRTP,'(A1)') GRTP
         IF((CGRTP.EQ. ' '))THEN
            GRTP = -1
*

         ENDIF 
         READ(CETIK,600) (ETIK(I),I=1,10/04)
         IF((CETIK.EQ. ' '))THEN
            ETIK(1) = -1
*       WRITE(6,668)NOM,TYP,GRTP,ETIK(1),ETIK(2)
*
*       WRITE(6,666)NOM,TYP,GRTP,ETIK(1)
*       WRITE(6,667)CNOM,CTYP,CGRTP,CETIK

         ENDIF 

*
      ENDIF 
600   FORMAT(2A04)
666   FORMAT(' HOLLERITH NOM=',A2,' TYP=',A1,' GRTP=',A1,' ETIK= ',
     %A8)
668   FORMAT(' HOLLERITH NOM=',A2,' TYP=',A1,' GRTP=',A1,' ETIK= ',
     %A4,A4)
667   FORMAT(' CARACTERE NOM=',A2,' TYP=',A1,' GRTP=',A10,'ETIK= ',
     %A8)
      RETURN
      END

***FONCTION FSTECR ECRIRE UN ENREGISTREMENT DANS UN FICHIER STANDARD
*
      FUNCTION FSTECR(F,WORK,NPAK,IUN,ICDATE,CDEET,CNPAS,CNI,CNJ,CNK
     %,CIP1,CIP2,CIP3,CTYPVAR,CNOMVAR,CETIKET,CGRTYP,CIG1,CIG2,CIG3,
     %CIG4,CDATYP,REWRIT)
*

      IMPLICIT NONE
      INTEGER FSTECR
      INTEGER F(*),  NPAK, IUN,ICDATE,CDEET,CNPAS,CNI,CNJ,CNK,CIP1,
     %CIP2,CIP3,CIG1,CIG2,CIG3,CIG4,CDATYP
      REAL   WORK(*)
      CHARACTER *(*) CTYPVAR,CNOMVAR,CETIKET,CGRTYP
      CHARACTER *9   ECRIUN
      LOGICAL   REWRIT
*
*AUTEUR   M. VALIN AVRIL 1989 DORVAL DRPN CANADA P.Q.
*
*REVISION 0.0.0  (AUTREFOIS STDECR - STDECX)
*         1.0.1  MODIFICATION POUR ECRIRE DANS UN FICHIER RANDOM/SEQ STANDARD
*         1.0.2  M. Lepine - bug fix pour ICDATE (input only) - fev 1991
*         1.0.3  M. Lepine - Allocation dynamique du champ de travail work
*                            sept 1991
*         1.0.4  M. Lepine - Bug fix reecriture quand ind =0 (mars 1992)
*         1.0.5  M. Lepine - Ajout du format ieee (mai 1992)
*         1.0.6  M. Lepine - Bug fix allocation memoire +dimchk (avril 1997)
*
*
*LANGAGE  RATFOR
*
*OBJET(FSTECR)
*         ECRIRE UN ENREGISTREMENT DANS UN FICHIER STANDARD
*         PLUSIEURS TYPES DE CHAMPS ET DE COMPACTION SONT PERMIS.
*         CETTE ROUTINE PEUT REECRIRE PAR-DESSUS UN ENREGISTREMENT
*         DEJA EXISTANT AVEC REWRIT=.TRUE.
*
*ALGORITHME
*         POUR UN FICHIER RANDOM, ON TENTE D'ECRIRE DANS UN ESPACE LIBRE
*         DE MEME TAILLE (EVENTUELLEMENT PLUS GROS), SINON ON INSERE A LA FIN.
*         SI CES DEUX TENTATIVES ECHOUENT, ON UTILISE L'ENTREE DU DIRECTEUR
*         CORRESPONDANT AU PLUS PETIT ESPACE LIBRE (DONT ON PERD A JAMAIS LA
*         DESCRIPTION).  LE DIRECTEUR SUR DISQUE EST AGRANDI LORSQUE NECESSAIRE.
*         POUR UN FICHIER SEQUENTIEL, ON ECRIT A LA POSITION COURANTE.
*
*
*ARGUMENTS
*  IN    F          CHAMP A ECRIRE
*  IN    WORK       CHAMP DE TRAVAIL DIMENSION(NI*NJ*MAX(1,NK)+NPAK-1)/NPAK+2
*  IN    NPAK       RAPPORT DE COMPACTION COURRANT (0,1,2,3,4,5,6,10,12,15,30)
*  IN    IUN        UNITE FORTRAN
*  IN    CDATE      DATE TIME STAMP CMC ENTIER, SMMJJAAZZR TEMPS ZERO PREVISION
*  IN    CDEET      PAS DE TEMPS ENTIER (SECONDES, MAX 32767)
*  IN    CNPAS      NUMERO DU PAS DE TEMPS ENTIER, MAX 32767
*  IN    CNI        PREMIERE DIMENSION DU CHAMP, MAX 32767
*  IN    CNJ        DEUXIEME DIMENSION, MAX 32767
*  IN    CNK        TROISIEME DIMENSION, MAX 4095
*  IN    CIP1       DESCRIPTEUR 1, MAX 32767 (NORMALEMENT NIVEAU)
*  IN    CIP2       DESCRIPTEUR 2, MAX 32767
*  IN    CIP3       DESCRIPTEUR 3, MAX 4095
*  IN    CTYPVAR    TYPE DE CHAMP, 1 CARACTERE FORMAT L (HOLLERITH)
*  IN    CNOMVAR    NOM DU CHAMP, 2 CARACTERES FORMAT L (HOLLERITH)
*  IN    CETIKET    ETIQUETTE, 8 CARACTERES, SENS DEFINI PAR USAGER
*  IN    CGRTYP     TYPE DE GRILLE, 1 CARACTERE FORMAT L (HOLLERITH)
*  IN    CIG1       DESCRIPTEUR DE GRILLE 1, ENTIER, MAX 2047
*  IN    CIG2       DESCRIPTEUR DE GRILLE 2, ENTIER, MAX 2047
*  IN    CIG3       DESCRIPTEUR DE GRILLE 3, ENTIER, MAX 65535
*  IN    CIG4       DESCRIPTEUR DE GRILLE 4, ENTIER, MAX 65535
*  IN    CDATYP     TYPE DU CHAMP (POUR LA COMPRESSION), SOIT
*                   0=BINAIRE,1=REEL,2=ENTIER,3=CARACTERE
*  IN    REWRIT     .TRUE. EFFACE L'ENREGISTREMENT ECRIT MEME PLACE
*                          SI POSSIBLE
*                   .FALSE. ECRIT SEULEMENT A LA FIN
*
*MESSAGES
*
*       FSTERRO('FSTECR',' NO PERMISSION TO WRITE ',ERRNPW, FSTECR )
*       VALID  ('LOGFIL',' ERREUR IP1 IP2 IP3 DOIT ETRE ENTRE')
*       LOGFIL 'ERROR DANS FSTEFF (QDRGET - QSTWDE)'
*       LOGFIL 605 ' EFFACE IUN L ENREGISTREMENT EST EFFACE'
*       LOGFIL 630 'FSTECR IUN EST ETENDU'
*       LOGFIL 640 ' ECRIT IUN'
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*MODULES
*

      EXTERNAL FSTINF, FSTEFF,QSTEOI
      INTEGER  FSTINF, FSTEFF,QSTEOI,IEOI
      EXTERNAL QDRGET,QSTWDE,QSTWHD,QSTRHD,QSTWDR,QSTRDR
      EXTERNAL QSTINT,INCDAT,XXPAK,IIPAK,QSTPKA,QSTPKC,QSTWPM,QSTARG
      EXTERNAL QSTUPC,WAREAD,WAWRIT,MOVLEV
      INTEGER  QSTWDE,QSTINT,QDRGET,QSTWHD,QSTRHD,QSTWDR,QSTRDR
**

      INTEGER DATNEG, NIOUT, NJOUT, NKOUT, IKEY, IEFF
      INTEGER DESCRI(30), INDESC, DATEV, KEY, NZROS, NCHK, IDLTF
      INTEGER NWR, IMOT, IER, I, IBEST, IQGET, LGBLOC, CHBLOC, IDEB
      INTEGER IND, INDREC, LIMIND, CHREC, CHBEST, CHPTIT, IPTIT,IWDR
      INTEGER SWADEB, RESTE, ADRLIR, ADRECR, MOTSWA, IWDE, CDATE
      INTEGER LGBUF, DIMREG, PKMODE, LNGCHK, SWALOC, SWABST, IREC
      INTEGER BUFFER(512),SAVDIR( 12),EOD(30)
      INTEGER IABT
      REAL WK
      POINTER (PTW,WK(*))
      SAVE DESCRI,EOD
      DATA (DESCRI(IMOT),IMOT=1,30) /28*0,O"25252525252",O
     %"25252525252"/
      DATA (EOD(IMOT),IMOT=1,30) /28*0,O"25252525252",O"25252525252"
     %/
*          ------------------------------------------------------------

      CDATE = ICDATE
*

      DO 23000 I = 1,28
         DESCRI(I) = 0
         EOD(I) = 0

*
23000 CONTINUE 
      FSTECR =0
      INDESC = QSTINT(IUN)
      IF( (INDESC.GE.40))THEN
         FSTECR=QDRERR('FSTECR',' FILE NOT OPEN ',15,4)
         RETURN

*
      ENDIF 
      IF( (.NOT. PRMECR(INDESC)))THEN
         FSTECR =QDRERR('FSTECR',' NO PERMISSION TO WRITE ',33,6)
         FSTECR = -33
         RETURN

*          --------------------------------------------------------------
*    MACRO(VALID,[
*    $( IF (%2 < %3 .OR. %2 > %4)
*        $( WRITE(LOGFIL, 610) IUN,'%1', '%2', %2, %3, %4
*            %1 = -ERRIVP      # INVALIDE PARAMETRE
*            RETURN
*        $)
*    $)
*  ]);
*--------------------------------------------------------------------------
      ENDIF 
      IF((  CIP1.LT.  0 .OR.  CIP1.GT.  32767))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CIP1',  CIP1,  0,
     %     32767
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CIP2.LT.  0 .OR.  CIP2.GT.  32767))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CIP2',  CIP2,  0,
     %     32767
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CIP3.LT.  0 .OR.  CIP3.GT.  4095))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CIP3',  CIP3,  0,  4095
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CDEET.LT.  0 .OR.  CDEET.GT.  32767))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CDEET',  CDEET,  0,
     %     32767
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CNPAS.LT.  0 .OR.  CNPAS.GT.  2**24-1))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CNPAS',  CNPAS,  0,  2*
     %   *24-1
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CNI.LT.  1 .OR.  CNI.GT.  32767))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CNI ',  CNI ,  1,
     %     32767
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CNJ.LT.  1 .OR.  CNJ.GT.  32767))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CNJ ',  CNJ ,  1,
     %     32767
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CNK.LT.  0 .OR.  CNK.GT.  4095))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CNK ',  CNK ,  0,  4095
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CIG1.LT.  0 .OR.  CIG1.GT.  2047))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CIG1 ',  CIG1 ,  0,
     %     2047
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CIG2.LT.  0 .OR.  CIG2.GT.  2047))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CIG2 ',  CIG2 ,  0,
     %     2047
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CIG3.LT.  0 .OR.  CIG3.GT.  65535))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CIG3 ',  CIG3 ,  0,
     %     65535
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CIG4.LT.  0 .OR.  CIG4.GT.  65535))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CIG4 ',  CIG4 ,  0,
     %     65535
         FSTECR = -24
         RETURN
      ENDIF 
      IF((  CDATYP.LT.  0 .OR.  CDATYP.GT.  5))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CDATYP',  CDATYP,  0,
     %     5
         FSTECR = -24
         RETURN
      ENDIF 
      CDATE = MOD(CDATE, 1000000000)
      IF((  CDATE.LT.  0 .OR.  CDATE.GT.  999999999))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTECR', ' CDATE',  CDATE,  0,
     %     999999999
         FSTECR = -24
         RETURN
      ENDIF 

*    ------------------------------------------------------------------
*
*           SI REWRIT=.TRUE. ON EFFACE L'ENREGISTREMENT AVEC DATE=-1
*
*     ---------------------------------------------------------------------
      IF(( REWRIT.AND.NUTIL(INDESC).GT. 0 .AND. DIRSIZ(INDESC).GT. 0
     % ))THEN

*
         DATNEG = -1
         IKEY = FSTINF(IUN, NIOUT, NJOUT, NKOUT, DATNEG, CETIKET,
     %   CIP1,CIP2, CIP3, CTYPVAR, CNOMVAR)
         IF((IKEY.LT. 0))THEN
            GO TO 1
*

         ENDIF 
         IEFF = FSTEFF(IKEY)
         IF((IEFF.LT. 0 ))THEN
            WRITE(LOGFIL,*)' ERROR DANS FSTEFF (QDRGET - QSTWDE)'
            RETURN

*
         ENDIF 
         NBRECR(INDESC) = NBRECR(INDESC) + 1
         IREC =ishft(IKEY,-( 8))
         WRITE(LOGFIL,605)IUN,IREC

*          ---------------------------------------------------------------
*
*          VERIFICATION DE LA DATE ET TYPE DE COMPACTION
*
*          -----------------------------------------------------------
      ENDIF 
1     CONTINUE
      DATEV = CDATE
      IF((CDEET*CNPAS.GT.0))THEN
         CALL INCDAT(DATEV,DATEV,(CDEET*CNPAS+1800)/3600)
      ENDIF 
      IF((32.GT. 32))THEN
         DATEV = MOD(DATEV,1000000000)
*          -----------------------------------------------------------
*          ARGUMENT TO COMMON BLOCK    ARGTCOM=.TRUE.
*

      ENDIF 
      SWA = 1
      CALL QSTARG(DATEV,CDEET,CNPAS,CNI,CNJ,MAX(1,CNK),CIP1,CIP2,
     %CIP3, CTYPVAR,CNOMVAR,CETIKET,CGRTYP,CIG1,CIG2,CIG3,CIG4,
     %CDATYP,SWA,LNG,DLTF,UBC,NBITS,.TRUE.)
*

      DATYP = CDATYP
      IF( ((NPAK.EQ.0.OR.NPAK.EQ.1) .AND. (.NOT. DATYP.EQ.3))
     %)THEN
         DATYP = 0

*          -----------------------------------------------------------
*
*          CONVERSION DE NPAK SI >=0 EN BIT
*
      ENDIF 
      IF((NPAK.LT.0))THEN
         NBITS = -NPAK
      ELSE 
         NBITS=MAX(1,32/MAX(1,NPAK))
*          -----------------------------------------------------------
*

      ENDIF 
      DLTF  = 0
      UBC   = 0
*
*               COMPRIMER SELON LE TYPE DE DONNEES
*

      NWR = (NI*NJ*MAX(1,NK)*NBITS+120+32-1)/32
*           CALL MEMOIRH(WK,PTW,NWR)
*          on alloue DIMCHK de plus car on arrondi au prochain multiple
*          de DIMCHK pour ecrire

      CALL HPALLOC(PTW,NWR+30,IER,IABT)
      GO TO (10, 20, 30, 40, 50, 60)  DATYP+1
*

10    CONTINUE
      LNG = NI*NJ*MAX(1,NK)*NBITS
      NWR = (LNG+32-1)/32
      IF((loc(F).NE.loc(WK)))THEN
         CALL MOVLEV(F,WK,NWR)
      ENDIF 
      GO TO 75
20    CONTINUE
      IF( (.NOT. COPYMOD))THEN
         CALL XXPAK(F, WK, NI, NJ*MAX(1,NK), -NBITS, 0, 1)
      ENDIF 
      LNG = NI*NJ*MAX(1,NK)*NBITS + 120
      GO TO 75
30    CONTINUE
      IF( (.NOT. COPYMOD))THEN
         CALL IIPAK(F, WK, NI, NJ*MAX(1,NK), -NBITS, 0, 1)
      ENDIF 
      LNG = NI*NJ*MAX(1,NK)*NBITS
      GO TO 75
40    CONTINUE
      IF( (.NOT. COPYMOD))THEN
         CALL IIPAK(F,WK,(NI*NJ+3)/4,1,-32,0,1)
      ENDIF 
      LNG = NI*NJ *8
      NBITS = 8
      GO TO 75
50    CONTINUE
      IF( (.NOT. COPYMOD))THEN
         CALL IIPAK(F,WK,NI,NJ*MAX(1,NK),-NBITS,0,3)
      ENDIF 
      LNG = NI*NJ*MAX(1,NK)*NBITS
      GOTO 75
60    CONTINUE
      IF( (.NOT. COPYMOD))THEN
         CALL IEEEPAK(F, WK, NI, NJ*MAX(1,NK), -NBITS, 0, 1)
      ENDIF 
      LNG = NI*NJ*MAX(1,NK)*NBITS
      GO TO 75
*

75    CONTINUE
*
*          -----------------------------------------------------------

      LNG = (LNG+32-1)/32
      IF( ( COPYMOD .AND. (loc(F).NE.loc(WK))))THEN
         CALL MOVLEV(F,WK,LNG)
*

      ENDIF 
      CALL QSTPKC(SAVDIR)
*
*          -----------------------------------------------------------

      IF( (DIRSIZ(INDESC).EQ. 0))THEN
         IF((NBCORR(INDESC).EQ. -1))THEN
            SWA = NXTSEQ(INDESC)
         ENDIF 
         NUMREC(INDESC) = -1
         CALL QSTPKA(DESCRI(1))
         IF((NBCORR(INDESC).EQ. -1))THEN
            DESCRI((1+ishft(575,-(5))))=IOR(DESCRI((1+ishft(575,-(5)
     %      ))),ishft(IAND(((CURSEQ(INDESC)-1)/30),ishft(-1,-(32-(32
     %      )))),(31-IAND(575,31))))

*
*                       ECRIRE UN NOMBRE ENTIER DE CHUNKS
*                       ON COMPLETE LE DERNIER CHUNK AVEC DES 0
         ENDIF 
         NCHK = (LNG +30 - 1)/30
         NZROS = NCHK*30 - LNG
*

         IF((NBCORR(INDESC).EQ. 0))THEN
            WRITE(IUN) DESCRI,(WK(I),I=1,LNG),(0,I=1,NZROS)

*             -----------------------------------------------------------
         ELSE 
            IF((NBCORR(INDESC).EQ. -1))THEN
               CALL WAWRIT(IUN, DESCRI, NXTSEQ(INDESC),30)
               CALL WAWRIT(IUN, WK, NXTSEQ(INDESC)+30, LNG+NZROS)
               NBRECR(INDESC)=NBRECR(INDESC) + 1
               CURSEQ(INDESC)=NXTSEQ(INDESC)
               NXTSEQ(INDESC)=NXTSEQ(INDESC)+30*((LNG+30-1)/30+1)
               IEOI = QSTEOI(INDESC)
               NXTADR(INDESC) = NXTSEQ(INDESC)

*             ------------------------------------------------------------
            ELSE 
               WRITE(LOGFIL,*)' FICHIER  NON STANDARD FSTECR ???'
               STOP

*             -------------------------------------------------------------
            ENDIF 
         ENDIF 
         DO 23072 I=1, 12
            CURSLT(I,INDESC) = SAVDIR(I)
23072    CONTINUE 
         IF((NBCORR(INDESC).EQ. 0))THEN
            KEY = INDESC
         ENDIF 
         IF((NBCORR(INDESC).EQ. -1 ))THEN
            KEY = INDESC +ishft((CURSEQ(INDESC)-1)/30, 8)
         ENDIF 

*
*          --------------------------------------------------------
*
      ELSE 

*                    ECRIRE DANS UN FICHIER STANDARD RANDOM
*                    --------------------------------------
*
*                     - PARCOURIR LE DIRECTEUR (BLOCS LIBRES) ET RETENIR
*                     - LE BEST FIT
*                     - LE PLUS PETIT ESPACE LIBRE
*                     - L'ADRESSE LA + BASSE
*
         IBEST = -1
         IPTIT = -1
         IDEB = -1
         IDLTF = 0
         SWADEB =2147483647
         CHREC  = (LNG +30-1) /30
         CHBEST =2147483647
         CHPTIT =2147483647
         SWABST = 0
         LIMIND = NUTIL(INDESC)
*             -------------------------------------------------------------

         DO 23078 IND = 0, LIMIND-1

*                        SI IND N'EST PAS UN BLOC LIBRE, ON L'IGNORE
            KEY   = IOR(ishft(IND, 8), INDESC)
            IQGET  = QDRGET(BUFFER, KEY, 1)
            IF((IQGET.LT. 0))THEN
               FSTECR = IQGET
               GOTO 888

*
            ENDIF 
            DLTF   =IAND(ishft(BUFFER((1+ishft( 060,-(5)))),-((31-
     %      IAND( 060,31)))),ishft(-1,-(32-( 01))))
            SWALOC =IAND(ishft(BUFFER((1+ishft( 343,-(5)))),-((31-
     %      IAND( 343,31)))),ishft(-1,-(32-( 24))))
            SWALOC = SWALOC *30 + 1
            IF((SWALOC.LT. SWADEB))THEN
               SWADEB = SWALOC
               IDEB = IND
            ENDIF 
            IF(( DLTF.EQ.0 ))THEN
               GOTO 23078

*
*                      OBTENIR LA LONGUEUR DU BLOC LIBRE, TRAITER  LNG
*
            ENDIF 
            LGBLOC =IAND(ishft(BUFFER((1+ishft( 319,-(5)))),-((31-
     %      IAND( 319,31)))),ishft(-1,-(32-( 20))))
            CHBLOC = (LGBLOC +30 - 1) /30
            IF((CHBLOC.EQ. CHREC))THEN
               IBEST = IND
               SWABST = SWALOC
               CHBEST = CHBLOC
               GOTO 23079
            ELSE 
               IF( (CHBLOC.LT. CHREC))THEN
                  IF( (CHBLOC.LT. CHPTIT))THEN
                     CHPTIT = CHBLOC
                     IPTIT = IND
                  ENDIF 
               ELSE 
                  IF( (CHBLOC.LT. CHBEST))THEN
                     SWABST = SWALOC
                     CHBEST = CHBLOC
                     IBEST = IND
                  ENDIF 
               ENDIF 
            ENDIF 

*            -------------------------------------------------------------
*
*                     A DEFAUT D'AUTRE CHOSE, ON CHOISIT LE BEST FIT.
*                     CEPENDANT, SI LE NOMBRE DE CHUNKS N'EST PAS
*                     EXACTEMENT LE BON, ON TENTE D'AJOUTER A LA FIN.
*
23078    CONTINUE 
23079    CONTINUE 
         INDREC = IBEST
         IF( (CHBEST.NE. CHREC.AND.LIMIND.LT. DIRSIZ(INDESC))
     %   )THEN
            INDREC=LIMIND
*


*
         ENDIF 
         IF((INDREC.EQ. -1))THEN
            INDREC = IBEST
         ENDIF 
         IF((INDREC.EQ. -1))THEN
            INDREC = IPTIT
*                # SI ON A TOUJOURS RIEN, LE DIRECTEUR EST PLEIN
*

         ENDIF 
         IF( (INDREC.EQ. -1))THEN
            INDREC = LIMIND
*
*                      FAUT-IL FAIRE UNE EXTENSION?
*

         ENDIF 
         IF( (INDREC.GE. DIRSIZ(INDESC)))THEN

*                               '  DIRSIZ(INDESC)=',DIRSIZ(INDESC)
*             -------------------------------------------------------------
            IF( (FASTIO))THEN
               IWDR = QSTWDR(INDESC)
               IF((IWDR.NE. 0 ))THEN
                  FSTECR = IWDR
                  GOTO 888
               ENDIF 

*             -------------------------------------------------------------
*
*                DEMENAGER L'ENREGISTREMENT LE PLUS BAS
*
            ENDIF 
            KEY   = IOR(ishft(IDEB, 8), INDESC)
            IQGET  = QDRGET(BUFFER, KEY, 1)
            IF((IQGET.NE. 0 ))THEN
               FSTECR = IQGET
               GOTO 888
            ENDIF 
            CALL QSTUPC(BUFFER)
*

            LNGCHK=30*((LNG +30-1)/30)
*
*                IDEB POINTE MAINTENANT LE PREMIER ENREGISTREMENT DU FICHIER
*                SWA EST SON ADRESSE, ET LNG SA LONGUEUR.
*                SI L'ENREGISTREMENT EST ACTIF, IL FAUT LE DEPLACER
*                (A LA FIN) ET ENREGISTRER SA NOUVELLE POSITION DANS LES
*                DIRECTEURS (MEMOIRE ET DISQUE).
*

            IDLTF   = DLTF
            IF((DLTF.EQ. 0))THEN
               RESTE  = LNG
               ADRLIR = SWA
               ADRECR = NXTADR(INDESC)
               SWA = ADRECR
23112          IF( (RESTE.GT. 0))THEN
                  LGBUF = MIN(RESTE,512)
                  CALL WAREAD(IUN, BUFFER, ADRLIR, LGBUF)
                  CALL WAWRIT(IUN, BUFFER, ADRECR, LGBUF)
                  ADRLIR = ADRLIR + LGBUF
                  ADRECR = ADRECR + LGBUF
                  RESTE = RESTE - LGBUF
                  GOTO 23112
               ENDIF 
               IWDE = QSTWDE(KEY, .TRUE., .TRUE.)
               IF((IWDE.NE. 0 ))THEN
                  FSTECR = IWDE
                  GOTO 888

*                L'ENREGISTREMENT EST TRANSFERE; IL FAUT METTRE A JOUR
*                LES DIRECTEURS MEMOIRE ET DISQUE, DE MEME QUE NXTADR.
*                SEUL SWA CHANGE (POSITION 0 A 31 D'UNE ENTREE)
               ENDIF 
               NXTADR(INDESC) = NXTADR(INDESC) + LNGCHK

*
*                DEPACTER FORMAT INTERNE EN MEMOIRE
*
            ENDIF 
            CALL QSTUPC(SAVDIR)
*                ------------------------------------------------------
*                ON PEUT MAINTENANT ETENDRE LE DIRECTEUR.
*                IL FAUT METTRE LA REGION D'EXTENSION A 0
*                PUIS METTRE DIRSIZ A JOUR (MEMOIRE ET DISQUE).

            ADRECR =30 +30*(DIRSIZ(INDESC)/2) + 1
            DIMREG = (SWADEB + LNGCHK) - ADRECR
            RESTE = DIMREG
*

            DO 23116 IMOT =1,512
               BUFFER(IMOT) = 0
*                -----------------------------------------------------------

23116       CONTINUE 
23118       IF( (RESTE.GT. 0))THEN
               LGBUF = MIN(RESTE,512)
               CALL WAWRIT(IUN, BUFFER, ADRECR, LGBUF)
               ADRECR = ADRECR + LGBUF
               RESTE = RESTE - LGBUF

*                ------------------------------------------------------------
               GOTO 23118
            ENDIF 
            DIRSIZ(INDESC) = DIRSIZ(INDESC) + (DIMREG/30) * 2
            NBEXT(INDESC) = NBEXT(INDESC) + 1
            IF( (2.GE. MSGLVL))THEN
               WRITE(LOGFIL,630) IUN
*
*            SI L'ENREGISTREMENT IDEB ETAIT INACTIF, IL FAUT REUTILISER SON
*            ENTREE DANS LE DIRECTEUR (QUI AUTREMENT NE POINTERAIT PLUS RIEN)
*            POUR STOCKER LE DESCRIPTEUR DU NOUVEL ENREGISTREMENT.  DANS CE
*            CAS, CEPENDANT, L'ENREGISTREMENT N'EST PAS ECRIT PAR-DESSUS CE
*            BLOC, MAIS BIEN A LA FIN DU FICHIER.
*

            ENDIF 
            IF((IDLTF.NE. 0))THEN
               INDREC = IDEB
            ENDIF 

*
*                DEPACTER FORMAT INTERNE EN MEMOIRE
*
         ENDIF 
         CALL QSTUPC(SAVDIR)
*
*            -------------------------------------------------------------
*
*                        SI ON N'A PAS AJOUTE A LA FIN,
*                        C'EST QU'ON RECUPERE UN ESPACE LIBRE
*                        DETERMINER L'ADRESSE OU ECRIRE L'ENREGISTREMENT
*

         IF((INDREC.LT.LIMIND.AND.INDREC.NE.IPTIT.AND.IDLTF.EQ.0)
     %   )THEN
            SWA   = SWABST
            NRECUP(INDESC) = NRECUP(INDESC) + 1
         ELSE 
            SWA = NXTADR(INDESC)
            NXTADR(INDESC)=NXTADR(INDESC)+30*((LNG +30-1)/30)

*
*             ECRIRE L'ENREGISTREMENT, PUIS LE DESCRIPTEUR
         ENDIF 
         CALL WAWRIT(IUN, WK, SWA,30 * ((LNG +30-1)/30))
         NUMREC(INDESC) = -1
         MODIFS(INDESC) = .TRUE.
         NUTIL(INDESC) = MAX(NUTIL(INDESC),INDREC + 1)
         KEY   = IOR(ishft(INDREC, 8), INDESC)
*

         IER= QSTWDE(KEY, .TRUE., .NOT.FASTIO)
         IF((IER.LT. 0))THEN
            FSTECR = IER
            GOTO 888

*
         ENDIF 

*
*          ----------------------------------------------------------
*
*          TERMINER OPERATION D'ECRITURE
*
      ENDIF 
      NBECR(INDESC) = NBECR(INDESC) + 1
*

      IF((DIRSIZ(INDESC).EQ.0.AND.NBCORR(INDESC).EQ.-1.AND.NBECR(
     %INDESC).EQ.1))THEN
         CALL WAREAD(IUN, BUFFER, 1,30)
         BUFFER((1+ishft( 639,-(5))))=IAND(BUFFER((1+ishft( 639,-(5)
     %   ))),NOT(ishft(ishft(-1,-(32-( 32))),(31-IAND( 639,31)))))
         CALL WAWRIT(IUN, BUFFER, 1,30)

*
      ENDIF 
      IF( (2.GE. MSGLVL))THEN
         WRITE(ECRIUN,640) IUN
         CALL QSTWPM(KEY,ECRIUN)

*
      ENDIF 
      FSTECR = KEY
*
*--------------------------------------------------------------------
*

600   FORMAT(' FSTECR-IUN=',I3,
     %' , PAS TROUVER ENREGISTREMENT ETIQUETTE=',A8,' NOM=',A2,
     %' TYPE=',A1,' IP1=',I5,' IP2=',I5,' IP3=',I4)
601   FORMAT(' FSTECR-IUN=',I3,
     %' , AVANT FSTEFF ENREGISTREMENT ETIQUETTE=',A8,' NOM=',A2,
     %' TYPE=',A1,' IP1=',I5,' IP2=',I5,' IP3=',I4)
605   FORMAT(' EFFACE - IUN=',I3,',L ENREGISTREMENT',I6,
     %' EST EFFACE')
610   FORMAT(' ERREUR  IUN=',I3,3X,A7,3X,A7,'(',O11,
     %'B) DOIT ETRE ENTRE',I9,' ET ',I9)
630   FORMAT(' FSTECR-IUN=',I3, ' EST ETENDU')
*

640   FORMAT('ECRIT(',I2,')')
*
*

888   CONTINUE
*       CALL MEMOIRH(WK,PTW,0)

      CALL HPDEALLC(PTW,IER,IABT)
      RETURN
      END

***FONCTION FSTEFF  EFFACER UN ENREGISTREMENT D'UN FICHIER STANDARD
*
      FUNCTION FSTEFF ( KEY )
*

      IMPLICIT NONE
      INTEGER FSTEFF
      INTEGER KEY
*
*AUTEUR   M. VALIN  MAI 89
*
*REVISION  000 NOUVELLE VERSION FEV 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTEFF)
*           EFFACER UN ENREGISTREMENT D'UN FICHIER STANDARD RANDOM
*           ILLEGAL D'EFFACER UN ENREGISTREMENT SUR FICHIER SEQUENTIEL
*
*ARGUMENTS
*  IN       KEY      RESULTAT DE LA FONCTION FSTINF >= 0
*
*MESSAGES
*        FSTERRO  ' KEY NOT VALID'
*        FSTERRO  ' FILE NOT OPEN '
*        FSTERRO  ' FILE NOT RANDOM'
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
**
*
*--------------------------------------------------------------------------
*

      EXTERNAL QSTUPC
      EXTERNAL QDRGET, QSTINT, QSTWDE
      INTEGER  QDRGET, QSTINT, QSTWDE, INDESC, IWDE  ,IGET
*

      FSTEFF = 0
      IF((KEY.LT. 0 ))THEN
         FSTEFF=QDRERR('FSTEFF',' KEY NOT VALID  ', 29,6)
         RETURN

*
      ENDIF 
      INDESC = IAND(KEY,255)
*

      IF((INDESC.GE.40))THEN
         FSTEFF=QDRERR('FSTEFF',' FILE NOT OPEN ', 15,6)
         RETURN

*
      ENDIF 
      IF((DIRSIZ(INDESC).EQ. 0))THEN
         FSTEFF=QDRERR('FSTEFF',' FILE NOT RANDOM ', 16,6)
         RETURN

*
      ENDIF 
      MODIFS(INDESC) = .TRUE.
      NBEFF(INDESC) = NBEFF(INDESC) + 1
*

      IGET = QDRGET(CURSLT(1,INDESC), KEY, 1)
      IF((IGET.NE. 0))THEN
         FSTEFF = IGET
         RETURN

*
      ENDIF 
      CALL QSTUPC(CURSLT(1,INDESC))
*

      DLTF = 1
      IWDE = QSTWDE(KEY, .TRUE., .NOT.FASTIO)
      IF((IWDE.NE.0))THEN
         FSTEFF = IWDE
         RETURN

*
      ENDIF 
      RETURN
      END

***FONCTION FSTEOF , RETOURNE LA VALEUR DU SEPARATEUR LOGIQUE DU FICHIER
*
      FUNCTION FSTEOF( IUN )
*

      IMPLICIT NONE
      INTEGER FSTEOF
      INTEGER IUN
*
*AUTEUR   M. VALIN  -  JUILLET 89  ( AUTREFOIS STDEOF )
*
*REVISION  000 NOUVELLE VERSION JANV 1989
*
*LANGAGE RATFOR
*
*OBJET (FSTEOF)
*           CETTE FUNCTION RETOURNE LA VALEUR DU NIVEAU DE FIN DE FICHIER
*           LOGIQUE POUR UN FICHIER STD SEQUENTIEL PREALABLEMENT ECRIT
*           PAE STDWOF.
*
*ARGUMENTS
*  IN       IUN      NUMERO D'UNITE FORTRAN
*
*MESSAGES
*          FSTWARN  'FICHIER PAS OUVERT'
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL QSTINT
      INTEGER  QSTINT
**

      INTEGER INDESC, JUNK
*-----------------------------------------------------------------------
*
*    VA CHERCHE L'INDEX DU FICHIER IUN (FICHIER DOIT ETRE OUVERT)
*

      INDESC = QSTINT(IUN)
      IF(( INDESC.GT.40  ))THEN
         FSTEOF =QDRERR('FSTEOF','FICHIER PAS OUVERT', 15,4)
         RETURN

*
*-----------------------------------------------------------------------
      ENDIF 
      IF((DIRSIZ(INDESC).EQ. 0))THEN
         IF((NRECUP(INDESC).EQ. -1))THEN
            FSTEOF = 15
            NRECUP(INDESC) = 15
            JUNK = IUN
         ELSE 
            FSTEOF = MIN(15,NRECUP(INDESC))
         ENDIF 
      ELSE 
         FSTEOF =0
*

      ENDIF 
      RETURN
      END

***FUNCTION FSTFRM  FERMER UN FICHIER STANDARD
*
      FUNCTION FSTFRM ( IUN )
*

      IMPLICIT NONE
      INTEGER FSTFRM
      INTEGER IUN
*
*AUTEUR   P. SARRAZIN  MARS 89
*
*REVISION  0.0.0 -    NOUVELLE VERSION FEV 1989
*          1.0.1 -    MODIFICATION POUR LES FICHIERS SEQ/RANDOM
*
*LANGAGE RATFOR
*
*OBJET(FSTFRM)
*           FERMER UN FICHIER.
*
*ARGUMENTS
*  IN       IUN      NUMERO D UNITE FORTRAN
*
*MESSAGES
*        FSTERRO  ' NUMERO IUN INVALIDE'
*        FSTWARN  ' FILE NOT OPEN'
*        LOGFIL   ' UNIT FORTRAN IUN EST FERME'
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
**
*
*--------------------------------------------------------------------------
*

      EXTERNAL QDRRLS, QSTINT, WACLOS, QSTWDR, QSTWHD,WAREAD,WAWRIT
      INTEGER INDESC,QDRRLS,QSTINT,QSTWDR,IWDR,QSTWHD,IRLS,IWHD,
     %FSTCKP
      INTEGER BUFFER(30), I, NEXTIND
      LOGICAL CHKPT
*
*    NOTE- IL FAUT VALIDER IUN AVANT D'APPELER FSTCKP, CAR IUN ERRONNE
*          PROVOQUE UN APPEL A FSTABT QUI LUI APPELLE FSTFRM, RECURSION !
*
*          IUN LEGAL ???
*          IUN EST-IL OUVERT ???
*

      FSTFRM = 0
      CHKPT = .FALSE.
100   CONTINUE
*

      IUNTAB(41) = IUN
      INDESC = 0
23000 IF((IUNTAB(INDESC).NE. IUN ))THEN
         INDESC = INDESC + 1
*

         GOTO 23000
      ENDIF 
      IF((INDESC.GE.40))THEN
         IF((CHKPT))THEN
            FSTFRM=QDRERR('FSTCKP',' FILE NOT OPEN ', 15,4)
         ELSE 
            FSTFRM=QDRERR('FSTFRM',' FILE NOT OPEN ', 15,4)
         ENDIF 
         RETURN

*
      ENDIF 
      IF( (CHAINE(INDESC) .NE. 0))THEN
         NEXTIND = CHAINE(INDESC)
         CHAINE(INDESC) = 0
         I = 0
23008    IF( ((CHAINE(I) .NE. INDESC) .AND. (I.LT.41)))THEN
            I = I + 1
            GOTO 23008
         ENDIF 
         IF( (CHAINE(I) .EQ. INDESC))THEN
            CHAINE(I) = NEXTIND
         ENDIF 

*
      ENDIF 
      IF((DIRSIZ(INDESC).NE. 0))THEN
         IF((FASTIO.AND.MODIFS(INDESC)))THEN
            IWDR = QSTWDR(INDESC)
            IF((IWDR.NE.0))THEN
               FSTFRM = IWDR
               RETURN
            ENDIF 

*
*       ECRIRE L'ENTETE
*
         ENDIF 
         IF((MODIFS(INDESC)))THEN
            IWHD = QSTWHD(INDESC)
            IF((IWHD.NE.0))THEN
               FSTFRM = IWHD
               RETURN
            ENDIF 

*-------------------------------------------------------------------
*
*        SI ON FAIT UN CHECK POINT PAS DE RELEASE NI DE WACLOS
*
         ENDIF 
         IF((CHKPT))THEN
            MODIFS(INDESC) = .FALSE.
            RETURN

*--------------------------------------------------------------------
*
         ENDIF 
         IRLS = QDRRLS(INDESC)
         IF((IRLS.NE.0))THEN
            FSTFRM = IRLS
            RETURN
         ENDIF 
         IF( (.NOT. CHKPT))THEN
            CALL WACLOS(IUN)
         ENDIF 

*
      ELSE 
         IF((DIRSIZ(INDESC).EQ.0.AND.NBCORR(INDESC).EQ.-1)
     %   )THEN
            IF((NBRECR(INDESC).GT. 0))THEN
               CALL WAREAD(IUN, BUFFER, 1,30)
               BUFFER((1+ishft(639,-(5))))=IOR(BUFFER((1+ishft(639,-
     %         (5)))),ishft(IAND(((NXTADR(INDESC)-1)/30),ishft(-1,-(
     %         32-( 32)))),(31-IAND(639,31))))
               CALL WAWRIT(IUN, BUFFER, 1,30)
            ENDIF 
            IF( (.NOT. CHKPT))THEN
               CALL WACLOS(IUN)
            ENDIF 

*
*      SI ON FAIT UN CHECK POINT RETURN
*
         ENDIF 
      ENDIF 
      IF((CHKPT))THEN
         RETURN
*
*
*      FERMETURE REUSSIE
*

      ENDIF 
      IF((MSGLVL.LE.2))THEN
         WRITE(LOGFIL,600) IUN
*

      ENDIF 
      IUNTAB(INDESC) = -1
      RETURN
*------------------------------------------------------------------
***FONCTION FSTCKP VERIFICATION DU DIRECTEUR FICHIER RANDOM
*
*
*AUTEUR   P. SARRAZIN  DEC 89
*
*REVISION  000 NOUVELLE VERSION DEC 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTCKP)
*           VERIFICATION DU DIRECTEUR FICHIER RANDOM
*
*ARGUMENTS
*  IN       IUN      NUMERO D UNITE FORTRAN
*

      ENTRY FSTCKP(IUN)
      FSTCKP = 0
      CHKPT = .TRUE.
      GO TO 100
*---------------------------------------------------------------------------
*

600   FORMAT( ' UNITE FORTRAN IUN= ',I3,' EST FERME')
*

      END

***FONCTION FSTINF , TROUVER UN ENREGISTREMENT SUR FICHIER IUN
*
      FUNCTION FSTINF( IUN, NIOUT, NJOUT, NKOUT,DATEIN, ETIKIN,
     % IP1IN, IP2IN, IP3IN, TYPVIN, NOMVIN )
*

      IMPLICIT NONE
      INTEGER FSTINF
      CHARACTER *(*) ETIKIN, TYPVIN, NOMVIN
      INTEGER IUN, NIOUT, NJOUT, NKOUT, DATEIN, IP1IN, IP2IN, IP3IN
*
*AUTEUR   M. VALIN  -  FEV 89  ( AUTREFOIS INFO )
*
*REVISION  0.0.0 NOUVELLE VERSION JANV 1989
*          0.0.1 AJOUTER UN ENTRY FSTSEL
*
*LANGAGE RATFOR
*
*OBJET (FSTINF)
*           CETTE FUNCTION CHERCHE LE PREMIER ENREGISTREMENT SATISFAISANT
*           LES CRITERES DE RECHERCHE (SPECIFIES PAR LES ARGUMENTS DE
*           LA FUNCTION FSTINF).
*           FSTSEL ENTRY POUR FAIRE UNE SELECTION DES CRITERES DU PROCHAIN
*           RECORD.  UTILISE AVEC FSTPOS - FSTSKP - FSTSEL - FSTSUI
*
*MESSAGES   PAR FSTERR  CODE[14]   'INVALID PARAMETER'
*                       CODE[ 5]   'FILE NOT OPEN'
*
*ARGUMENTS
*  OUT      NIOUT    PREMIERE DIMENSION
*  OUT      NJOUT    DEUXIEME DIMENSION
*  OUT      NKOUT    TROISIEME DIMENSION
*  IN       IUN      NUMERO D'UNITE FORTRAN
*  IN       DATEIN   CMC STAMP  FORMAT I10 [ RUN # ET DAY OF WEEK NON UTLISE]
*  IN       ETIKIN   ETIQUETTE CHARACTER * 8
*  IN       IP1IN    NIVEAU DE PRESSION DESCRIPTEUR <= 32767
*  IN       IP2IN    NORMALEMENT HEURE  DESCRIPTEUR <= 32767
*  IN       IP3IN    OUVERT POUR UTILISATION PAR USAGER <= 4095
*  IN       TYPVIN   TYPE DE CHAMP CHARACTER * 1
*  IN       NOMVIN   NOM DU CHAMP  CHARACTER * 2
*
*MESSAGES
*         FSTERRO ' FICHIER PAS OUVERT'
*         FSTWARN ' INVALID PARAMETER '
*         LOGFIL  ' DATE DANS FSTINF='
*         LOGFIL  ' IP1 DANS FSTINF='
*         LOGFIL  ' IP2 DANS FSTINF='
*         LOGFIL  ' IP3 DANS FSTINF='
*         LOGFIL  ' ETIQUETTE DANS FSTINF='
*         LOGFIL  ' NOMVAR DANS FSTINF='
*         LOGFIL  ' TYPVAR DANS FSTINF='
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL FSTNBR,FSTOUV,QSTINT,QDRGET,QSTSUI,QSTUPA,QSTPKC
      INTEGER  FSTNBR,FSTOUV,QSTINT,QDRGET,QSTSUI,FSTSEL
**

      CHARACTER *8 ETIKL
      CHARACTER *2 NOMVL
      CHARACTER *1 TYPVL
*

      LOGICAL CLEF, MATCH
      INTEGER MSQ( 6), SRCH( 6), ETKL14, ETKL56, ETKL78
      INTEGER BUFFER(30), INDESC, NOMVINT, TYPVINT
      INTEGER KEY,I, II, IDATET, I0, ISEQ, IGET, ISELE
*
*    VA CHERCHE L'INDEX DU FICHIER IUN (FICHIER DOIT ETRE OUVERT)
*

      ISELE  = 0
1000  FSTINF = 0
      INDESC = QSTINT( IUN )
      IF(( INDESC.GT.40 ))THEN
         FSTINF =QDRERR('FSTINF','FICHIER PAS OUVERT', 15,6)
         RETURN
      ENDIF 
      EFFDSC(INDESC) = INDESC
*--------------------------------------------------------------------------
*
*    TRANSFER LES PARAMETRES CHARACTER *(*)  DANS UNE GRANDEUR
*    PREDEFINIE ETIKL *8, NOMVL *2,  TYPVL *1
*

      ETIKL = ETIKIN
      NOMVL = NOMVIN
      TYPVL = TYPVIN
*--------------------------------------------------------------------------
*
*    VERIFICATION DE IP1IN, IP2IN, IP3IN
*

      CLEF =(   IP1IN.GE. -1  .AND.  IP1IN.LE. 32767   .AND.   IP2IN
     %.GE. -1  .AND.  IP2IN.LE. 32767   .AND.   IP3IN.GE. -1  .AND.
     %  IP3IN.LE. 4095   .AND.  DATEIN.GE. -1   )
*

      IF( ( .NOT. CLEF ))THEN
         FSTINF =QDRERR('FSTINF','INVALID PARAMETER', 24,4)
         RETURN

*---------------------------------------------------------------------------
*
*    ZERO CHAMP  MSQ, SRCH
*
      ENDIF 
      DO 23004 I = 1 , 6
         MSQ(I) = 0
         SRCH(I)= 0

*
*---------------------------------------------------------------------------
*
*    VERIFIER LA VALEUR DE  DATEIN
*
23004 CONTINUE 
      IF((MSGLVL.LE.0 ))THEN
         WRITE(LOGFIL,*)' DATE DANS FSTINF= ',DATEIN
*

      ENDIF 
      IF( ( DATEIN.NE. -1 ))THEN
         IDATET = DATEIN
         IF((32.GT. 32 ))THEN
            IDATET = MOD(IDATET,1000000000)
         ENDIF 
         IDATET = 8 * (IDATET/10) + MOD(IDATET,10)
         MSQ((1+ishft( 223-64-3,-(5))))=IOR( MSQ((1+ishft( 223-64-3,
     %   -(5)))),ishft(IAND( ishft(-1,-(32-(29))),ishft(-1,-(32-( 29
     %    )))),(31-IAND( 223-64-3,31))))
         SRCH((1+ishft( 223-64 ,-(5))))=IOR( SRCH((1+ishft( 223-64 ,
     %   -(5)))),ishft(IAND( IDATET,ishft(-1,-(32-( 32 )))),(31-IAND
     %   ( 223-64 ,31))))

*--------------------------------------------------------------------------
*
*    VERIFIER LA VALEUR DE IP1IN
*
      ENDIF 
      IF((MSGLVL.LE.0 ))THEN
         WRITE(LOGFIL,*)' IP1 DANS FSTINF= ',IP1IN
*

      ENDIF 
      IF( ( IP1IN.NE. -1 ))THEN
         SRCH((1+ishft( 175-64,-(5))))=IOR( SRCH((1+ishft( 175-64,-(
     %   5)))),ishft(IAND( IP1IN,ishft(-1,-(32-( 16 )))),(31-IAND(
     %    175-64,31))))
         MSQ ((1+ishft( 175-64,-(5))))=IOR( MSQ ((1+ishft( 175-64,-(
     %   5)))),ishft(IAND( ishft(-1,-(32-(16))),ishft(-1,-(32-( 16 )
     %   ))),(31-IAND( 175-64,31))))

*--------------------------------------------------------------------------
*
*    VERIFIER LA VALEUR DE IP2IN
*
      ENDIF 
      IF((MSGLVL.LE.0 ))THEN
         WRITE(LOGFIL,*)' IP2 DANS FSTINF= ',IP2IN
*

      ENDIF 
      IF( ( IP2IN.NE. -1 ))THEN
         SRCH((1+ishft( 111-64,-(5))))=IOR( SRCH((1+ishft( 111-64,-(
     %   5)))),ishft(IAND( IP2IN,ishft(-1,-(32-( 16 )))),(31-IAND(
     %    111-64,31))))
         MSQ ((1+ishft( 111-64,-(5))))=IOR( MSQ ((1+ishft( 111-64,-(
     %   5)))),ishft(IAND( ishft(-1,-(32-(16))),ishft(-1,-(32-( 16 )
     %   ))),(31-IAND( 111-64,31))))

*-------------------------------------------------------------------------
*
*    VERIFIER LA VALEUR DE IP3IN
*
      ENDIF 
      IF((MSGLVL.LE.0 ))THEN
         WRITE(LOGFIL,*)' IP3 DANS FSTINF= ',IP3IN
*

      ENDIF 
      IF( ( IP3IN.NE. -1 ))THEN
         SRCH((1+ishft( 191-64,-(5))))=IOR( SRCH((1+ishft( 191-64,-(
     %   5)))),ishft(IAND( IP3IN,ishft(-1,-(32-( 12 )))),(31-IAND(
     %    191-64,31))))
         MSQ ((1+ishft( 191-64,-(5))))=IOR( MSQ ((1+ishft( 191-64,-(
     %   5)))),ishft(IAND( ishft(-1,-(32-(12))),ishft(-1,-(32-( 12))
     %   )),(31-IAND( 191-64,31))))

*-------------------------------------------------------------------------
*
*    VERIFIER LA VALEUR DE ETIQIN *(*)  DANS  ETIKL *8
*
      ENDIF 
      IF((MSGLVL.LE.0 ))THEN
         WRITE(LOGFIL,600) ETIKL
      ENDIF 
600   FORMAT(' ETIQUETTE DANS FSTINF= ',A8)
*

      IF( ( ETIKL.NE. ' '))THEN
         READ  (ETIKL,'(A4,A2,A2)')ETKL14,ETKL56,ETKL78
*

         ETKL14 =ishft( ETKL14,-( 0 ))
         ETKL56 =ishft( ETKL56,-( 16 ))
         ETKL78 =ishft( ETKL78,-( 16 ))
*

         SRCH((1+ishft( 095-64,-(5))))=IOR( SRCH((1+ishft( 095-64,-(
     %   5)))),ishft(IAND( ETKL14,ishft(-1,-(32-( 32 )))),(31-IAND(
     %    095-64,31))))
         SRCH((1+ishft( 143-64,-(5))))=IOR( SRCH((1+ishft( 143-64,-(
     %   5)))),ishft(IAND( ETKL56,ishft(-1,-(32-( 16 )))),(31-IAND(
     %    143-64,31))))
         SRCH((1+ishft( 159-64,-(5))))=IOR( SRCH((1+ishft( 159-64,-(
     %   5)))),ishft(IAND( ETKL78,ishft(-1,-(32-( 16 )))),(31-IAND(
     %    159-64,31))))
*

         MSQ ((1+ishft( 095-64,-(5))))=IOR( MSQ ((1+ishft( 095-64,-(
     %   5)))),ishft(IAND( ishft(-1,-(32-(32))),ishft(-1,-(32-( 32 )
     %   ))),(31-IAND( 095-64,31))))
         MSQ ((1+ishft( 143-64,-(5))))=IOR( MSQ ((1+ishft( 143-64,-(
     %   5)))),ishft(IAND( ishft(-1,-(32-(16))),ishft(-1,-(32-( 16 )
     %   ))),(31-IAND( 143-64,31))))
         MSQ ((1+ishft( 159-64,-(5))))=IOR( MSQ ((1+ishft( 159-64,-(
     %   5)))),ishft(IAND( ishft(-1,-(32-(16))),ishft(-1,-(32-( 16 )
     %   ))),(31-IAND( 159-64,31))))

*-------------------------------------------------------------------------
*
*    VERIFIER LA VALEUR DE NOMVIN *(*) DANS NOMVL *2
*
      ENDIF 
      IF((MSGLVL.LE.0 ))THEN
         WRITE(LOGFIL,601) NOMVL
      ENDIF 
601   FORMAT(' NOMVAR DANS FSTINF= ',A2)
*

      IF( ( NOMVL.NE. ' ' ))THEN
         READ  (NOMVL,'(A2)') NOMVINT
         NOMVINT =ishft( NOMVINT,-( 16 ))
         SRCH((1+ishft( 239-64,-(5))))=IOR( SRCH((1+ishft( 239-64,-(
     %   5)))),ishft(IAND( NOMVINT,ishft(-1,-(32-( 16 )))),(31-IAND(
     %    239-64,31))))
         MSQ ((1+ishft( 239-64,-(5))))=IOR( MSQ ((1+ishft( 239-64,-(
     %   5)))),ishft(IAND( ishft(-1,-(32-(16))),ishft(-1,-(32-( 16 )
     %   ))),(31-IAND( 239-64,31))))

*-------------------------------------------------------------------------
*
*    VERIFIER LA VALEUR DE TYPVIN *(*) DANS TYPVL *1
*
      ENDIF 
      IF((MSGLVL.LE.0 ))THEN
         WRITE(LOGFIL,602) TYPVL
      ENDIF 
602   FORMAT(' TYPVAR DANS FSTINF= ',A1)
*

      IF( ( TYPVL.NE. ' ' ))THEN
         READ  (TYPVL,'(A1)')  TYPVINT
         TYPVINT =ishft( TYPVINT,-( 24 ))
         SRCH((1+ishft( 127-64,-(5))))=IOR( SRCH((1+ishft( 127-64,-(
     %   5)))),ishft(IAND( TYPVINT,ishft(-1,-(32-( 08 )))),(31-IAND(
     %    127-64,31))))
         MSQ ((1+ishft( 127-64,-(5))))=IOR( MSQ ((1+ishft( 127-64,-(
     %   5)))),ishft(IAND( ishft(-1,-(32-(08))),ishft(-1,-(32-( 08 )
     %   ))),(31-IAND( 127-64,31))))

*-------------------------------------------------------------------------
*
      ENDIF 
      DO 23036 I = 1 , 6
         SEARCH(I,INDESC) =  SRCH(I)
         MASQUE(I,INDESC) =  IAND(MSQ(I),NOT(MSKPRT(I,INDESC)))

*
23036 CONTINUE 
      NUMREC(INDESC) = 0
      IF((ISELE.EQ. 1 ))THEN
         RETURN
*
*    INTERNE UTILISATION DE INDESC POUR IUN DANS QSTSUI(INDESC,...
*

      ENDIF 
      FSTINF = QSTSUI( INDESC, NIOUT, NJOUT, NKOUT )
*

      RETURN
*
***FONCTION FSTSEL, SELECTION DES CRITERES D UN ENREGISTREMENT
*

      ENTRY FSTSEL ( IUN, NIOUT, NJOUT, NKOUT, DATEIN,ETIKIN, IP1IN,
     % IP2IN, IP3IN, TYPVIN, NOMVIN )
*
*AUTEUR   M. VALIN FEVRIER 90  NOUVELLE FONCTION
*
*REVISION  0.0.0. NOUVELLE VERSION FEVRIER 1990
*
*LANGAGE RATFOR
*
*OBJET(FSTSEL)
*        SELECTION DES CRITERES DU PROCHAIN ENREGITREMENT QUI SERA
*        RECONNU PAR FSTSUI
*

      FSTSEL = 0
      ISELE = 1
      GO TO 1000
*

      END

***FONCTION FSTINL , TROUVER UN OU DES ENREGISTREMENTS SUR FICHIER STD
*
      FUNCTION FSTINL( IUN, NIOUT, NJOUT, NKOUT,DATEIN, ETIKIN,
     % IP1IN, IP2IN, IP3IN, TYPVIN, NOMVIN,LISTE, INFON, NMAX )
*

      IMPLICIT NONE
      INTEGER FSTINL
      CHARACTER *(*) ETIKIN, TYPVIN, NOMVIN
      INTEGER IUN, NIOUT, NJOUT, NKOUT, DATEIN, IP1IN, IP2IN, IP3IN,
     %LISTE(*), INFON, NMAX
*
*AUTEUR   M. VALIN  -  JUIN 89  ( AUTREFOIS INFOL)
*
*REVISION  000 NOUVELLE VERSION JANV 1989
*
*LANGAGE RATFOR
*
*OBJET (FSTINL)
*           CETTE FUNCTION CHERCHE TOUS LES ENREGISTREMENTS SATISFAISANT
*           LES CRITERES DE RECHERCHE. LA FONCTION RETOURNE LES CLEFS
*           DES ENREGISTREMENTS DANS LA LISTE.
*
*MESSAGES   FSTERRO  'FICHIER PAS OUVERT'
*                    'DIMENSION LISTE NEGATIVE'
*
*ARGUMENTS
*  OUT      NIOUT    PREMIERE DIMENSION
*  OUT      NJOUT    DEUXIEME DIMENSION
*  OUT      NKOUT    TROISIEME DIMENSION
*  IN       IUN      NUMERO D'UNITE FORTRAN
*  IN       DATEIN   CMC STAMP  FORMAT I10 [ RUN # ET DAY OF WEEK NON UTLISE]
*  IN       ETIKIN   ETIQUETTE CHARACTER * 8
*  IN       IP1IN    NIVEAU DE PRESSION DESCRIPTEUR <= 32767
*  IN       IP2IN    NORMALEMENT HEURE  DESCRIPTEUR <= 32767
*  IN       IP3IN    OUVERT POUR UTILISATION PAR USAGER <= 4095
*  IN       TYPVIN   TYPE DE CHAMP CHARACTER * 1
*  IN       NOMVIN   NOM DU CHAMP  CHARACTER * 2
*  OUT      LISTE    LISTE DES CLEFS D ENREGISTREMENTS
*  OUT      INFON    NOMBRE DE CLEFS DANS LA LISTE
*  IN       NMAX     DIMENSION MAXIMUM DANS LA LISTE
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL FSTINF,QSTSUI,QSTINT
      INTEGER  FSTINF,QSTSUI,QSTINT,INDESC,INDLIS,INDREC
**

      INTEGER NIMAX,NJMAX,NKMAX,NIJKMAX
      NIJKMAX = 0
      NIMAX = 0
      NJMAX = 0
      NKMAX = 0
      FSTINL = 0
*
*    VA CHERCHE L'INDEX DU FICHIER IUN (FICHIER DOIT ETRE OUVERT)
*

      INDESC = QSTINT( IUN )
      IF(( INDESC.GT.40 ))THEN
         FSTINL =QDRERR('FSTINL','FICHIER PAS OUVERT', 15,6)
         RETURN
      ENDIF 
      IF(( NMAX.LT. 1 ))THEN
         FSTINL =QDRERR('FSTINL','DIMENSION LISTE NEGATIVE',40,6)
         RETURN

*--------------------------------------------------------------------------
*
      ENDIF 
      INDLIS = 1
      INDREC = FSTINF(IUN, NIOUT, NJOUT, NKOUT, DATEIN, ETIKIN,IP1IN
     %, IP2IN, IP3IN, TYPVIN, NOMVIN)
      NIMAX = NIOUT
      NJMAX = NJOUT
      NKMAX = NKOUT
*

23004 IF( (INDREC.GE. 0 .AND. INDLIS.LE. NMAX))THEN
         LISTE(INDLIS) = INDREC
         INDLIS = INDLIS + 1
         INDREC = QSTSUI( INDESC, NIOUT, NJOUT, NKOUT)
         IF( (NIOUT*NJOUT*NKOUT.GT. NIJKMAX))THEN
            NIJKMAX = NIOUT*NJOUT*NKOUT
            NIMAX = NIOUT
            NJMAX = NJOUT
            NKMAX = NKOUT
         ENDIF 

*
         GOTO 23004
      ENDIF 
      INFON = INDLIS - 1
      NIOUT = NIMAX
      NJOUT = NJMAX
      NKOUT = NKMAX
*

      RETURN
*

      END

*
***FONCTION FSTLIC  VERIFIER ARGUMENTS(LISTE) ET LIRE CHAMP
*
      FUNCTION FSTLIC(F,IUN,NIIN,NJIN,NKIN,DATE,CETIKET,IP1,IP2,IP3,
     %CTYPVAR,CNOMVAR,IG1IN,IG2IN,IG3IN,IG4IN,CGRDTYP)
      INTEGER FSTLIC
*
*AUTEUR   P. SARRAZIN   DRPN DORVAL QUE CANADA DEC 83
*
*REVISION 001
*REVISION 002  MODIFIER POUR FICHIER STANDARD 89
*
*LANGAGE  RATFOR
*
*OBJET(FSTLIC)
*          VERIFIER DIMENSION NI,NJ,NK DU CHAMP D'UN ENREGISTREMENT STD
*          VERIFIER LE TYPE DE GRILLE ET SES ARGUMENTS
*          LIRE UN ENREGISTREMENT DANS UN FICHIER STANDARD
*
*          CETTE FONCTION LIT LE PREMIER ENREGISTREMENT SATISFAISANT LES
*          CRITERES DE RECHERCHE (SPECIFIES PAR LES PARAMETRES, ET EGALEMENT
*         PAR LES MASQUES PARTIELS COURANTS (VOIR FSTMSQ)).
*
*         -POUR UN FICHIER RANDOM, ON CHERCHE DANS LE DIRECTEUR EN MEMOIRE
*         A PARTIR DU DEBUT; CECI N'IMPLIQUE AUCUNE ENTREE/SORTIE.
*
*         -POUR UN FICHIER SEQUENTIEL, ON EFFECTUE UNE RECHERCHE A PARTIR
*         DE LA POSITION COURANTE (ET NON A PARTIR DU DEBUT).  DANS CE CAS,
*         LA FONCTION DOIT LIRE SEQUENTIELLEMENT LES ENREGISTREMENTS POUR
*         S'ARRETER LORSQUE LES CRITERES DE RECHERCHE SONT SATISFAITS (OU
*         A LA FIN DE FICHIER).
*
*         LA VALEUR DE LA FONCTION EST LE NUMERO DE L'ENREGISTREMENT TROUVE,
*         QUI DEVIENT LA CLEF DE L'ENREGISTREMENT COURANT E
*         LA VALEUR EST NEGATIVE SI AUCUN ENREGISTREMENT N'EST TROUVE.
*
*MESSAGES
*         SUR L'UNITE FORTRAN 6
*                   (' FSTLIC  IUN=',I3,' *** ERREUR NI, NJ OU NK ***',/,
*             '                USAGER NI=',I5,'    FICHIER NI=',I5,/,
*             '                USAGER NJ=',I5,'    FICHIER NJ=',I5,/,
*             '                USAGER NK=',I5,'    FICHIER NK=',I5)
*              (' FSTLIC  IUN=',I3,' *** ERREUR GRTYP,IG1,IG2,IG3 OU IG4 ***',/,
*             '                USAGER GRTYPE=',A1,'     FICHIER GRTYPE=',A1,/,
*             '                USAGER IG1=',I5,'    FICHIER IG1=',I5,/,
*             '                USAGER IG2=',I5,'    FICHIER IG2=',I5,/,
*             '                USAGER IG3=',I5,'    FICHIER IG3=',I5,/,
*             '                USAGER IG4=',I5,'    FICHIER IG4=',I5)
*
*APPEL    IER=FSTLIC(F,IUN,NIIN,NJIN,NKIN,DATE,ETIKET,IP1,IP2,IP3,
*                   TYPVAR,NOMVAR,IG1IN,IG2IN,IG3IN,IG4IN,IGRTIN)
*
*ARGUMENTS
*  OUT    IER       ENREGISTREMENT IER < 0  ERREUR
*  OUT    F         TABLEAU QUI CONTIENDRA LE CHAMP SI LECTURE
*  IN     IUN       UNITE FORTRAN SUR LAQUELLE ON VEUT LIRE
*  IN     NIIN      1-ERE DIMENSION DU CHAMP
*  IN     NJIN      2-IEME DIMENSION DU CHAMP
*  IN     NKIN      3-IEME DIMENSION DU CHAMP
*  IN     DATE      DATE DE VALIDATION, DATE TIME STAMP CMC (SMMJJAAZZR)
*  IN     CETIKET   ETIQUETTE DE 8 CARACTERES  CHARACTER *8
*  IN     IP1       ENTIER DE 15 BITS (VOIR OUVRIR)
*  IN     IP2       ENTIER DE 15 BITS (VOIR OUVRIR)
*  IN     IP3       ENTIER DE 12 BITS (VOIR OUVRIR)
*  IN     CTYPVAR   TYPE DE LA VARIABLE CHARACTER *1
*  IN     CNOMVAR   NOM DE LA VARIABLE CHARACTER *2
*  IN     IG1IN     DESCRIPTEUR DE LA GRILLE VOIR OUVRIR RMNLIB(USAGER)  IG1
*  IN     IG2IN     DESCRIPTEUR DE LA GRILLE VOIR OUVRIR RMNLIB(USAGER)  IG2
*  IN     IG3IN     DESCRIPTEUR DE LA GRILLE VOIR OUVRIR RMNLIB(USAGER)  IG3
*  IN     IG4IN     DESCRIPTEUR DE LA GRILLE VOIR OUVRIR RMNLIB(USAGER)  IG4
*  IN     CGRDTYP   TYPE DE GRILLE DEFINI PAR USAGER CHARACTER *1
*
*MODULES
*

      EXTERNAL FSTPRM, FSTINF, FSTLIR, FSTCVT
      INTEGER  FSTPRM, FSTINF, FSTLIR, FSTCVT
*
*NOTES
*         SI LA VALEUR D'UNE CLEF DE RECHERCHE EST -1 OU ' '  , ELLE SERA
*         IGNOREE DANS LA RECHERCHE.  LA RECHERCHE EST EGALEMENT AFFECTEE
*         PAR LES MASQUES SPECIFIES A FSTMSQ.
*
*IMPLICITES
**
*

      REAL F
      CHARACTER *8 CETIKET,CETIKE
      CHARACTER *2 CNOMVAR,CNOMV
      CHARACTER *1 CTYPVAR, CGRDTYP,CTYPVA,CGRTP
      INTEGER IUN, NI, NJ, NK, DATE, IP1, IP2, IP3,IG1IN, IG2IN,
     % IG3IN, IG4IN,IER, KEY
      INTEGER IREC, IDA, IDEE, NPA, JP1, JP2, JP3, NIIN, NJIN, NKIN,
     %IG1, IG2, IG3, IG4, CNBITS,CDATYP
*

      IARRET = 1
*
*   CONVERSION CHARACTER A HOLLERITH
*

      IREC=FSTINF(IUN,NI,NJ,NK,DATE,CETIKET,IP1,IP2,IP3,CTYPVAR,
     %CNOMVAR)
      IF((IREC.LT.  0))THEN
         WRITE(6,*)'RECORD N EXISTE PAS FSTLIC  FICHIER=',IUN
         FSTLIC  = IREC
         RETURN

*
      ENDIF 
      IF((NIIN.NE.NI.OR.NJIN.NE.NJ.OR.NKIN.NE.NK))THEN
         WRITE(6,602)IUN,NIIN,NI,NJIN,NJ,NKIN,NK
*

      ENDIF 
      IF((IREC.GE. 0))THEN
         IER = FSTPRM(IREC,IDA,IDEE,NPA,NI,NJ,NK,CNBITS,CDATYP,JP1,
     %   JP2,JP3,CTYPVA,CNOMV,CETIKE,CGRTP,IG1,IG2,IG3,IG4,CSWA,CLNG
     %   ,CDLTF,CUBC,EXTRA1,EXTRA2,EXTRA3)
*

         IF((CGRTP.NE.CGRDTYP.OR.IG1.NE.IG1IN.OR.IG2.NE.IG2IN)
     %   )THEN
            IARRET=0
         ENDIF 
         IF((IG3.NE.IG3IN.OR.IG4.NE.IG4IN))THEN
            IARRET=0
         ENDIF 
         IF((IARRET.EQ. 0))THEN
            WRITE(6,603)IUN,CGRDTYP,CGRTP,IG1IN,IG1,IG2IN,IG2,IG3IN,
     %      IG3,IG4IN,IG4
         ENDIF 
         IF((IARRET.EQ. 0))THEN
            RETURN
*

         ENDIF 
         FSTLIC=FSTLIR(F,IUN,NI,NJ,NK,DATE,CETIKE,JP1,JP2,JP3,CTYPVA
     %   ,CNOMV)
      ENDIF 
602   FORMAT(' FSTLIC IUN=',I3,' *** ERREUR NI, NJ OU NK ***',/,
     %'                USAGER NI=',I5,'    FICHIER NI=',I5,/,
     %'                USAGER NJ=',I5,'    FICHIER NJ=',I5,/,
     %'                USAGER NK=',I5,'    FICHIER NK=',I5)
603   FORMAT(' FSTLIC  IUN=',I3,
     %' *** ERREUR GRTYP,IG1,IG2,IG3 OU IG4 ***',/,
     %'                USAGER GRTYPE=',A1,'     FICHIER GRTYPE=',A1,
     %/,'                USAGER IG1=',I5,'    FICHIER IG1=',I5,/,
     %'                USAGER IG2=',I5,'    FICHIER IG2=',I5,/,
     %'                USAGER IG3=',I5,'    FICHIER IG3=',I5,/,
     %'                USAGER IG4=',I5,'    FICHIER IG4=',I5)
*
*

      RETURN
      END

***FONCTION FSTLIR, LIRE UN RECORD SUR FICHIER STANDARD (SEQ OU RND)
*
      FUNCTION FSTLIR( BUFFER, IUNK, NIOUT, NJOUT, NKOUT,DATEIN,
     % ETIKIN, IP1IN, IP2IN, IP3IN, TYPVIN, NOMVIN )
*

      IMPLICIT NONE
      INTEGER FSTLIR
      CHARACTER *6 LUIUN
      CHARACTER *(*) ETIKIN, TYPVIN, NOMVIN
      INTEGER BUFFER(*), IUNK, NIOUT,NJOUT,NKOUT, DATEIN,IP1IN,IP2IN
     %,IP3IN
      INTEGER TAMPON(1),PTAMP
      INTEGER FSTLIS, FSTLUK
*
*AUTEUR   M. VALIN  -  FEV 89  ( AUTREFOIS LIRE )
*
*REVISION  000 NOUVELLE VERSION MARS 1989
*
*LANGAGE RATFOR
*
*OBJET (FSTLIR)
*           CETTE FUNCTION CHERCHE ET LIT  LE PREMIER ENREGISTREMENT
*           SATISFAISANT LES CRITERES DE RECHERCHE SPECIFIES PAR LES
*           ARGUMENTS DE LA FUNCTION FSTLIR EN UTILISANT [FSTINF/FSTSUI]
*
*MESSAGES   FSTWARN  CODE[15]  'FIN DU FICHIER SEQ'
*           FSTERRO  CODE[16]  'ERREUR SUR I/O'
*           FSTWARN  CODE[18]  'NO VALID RECORD AVAILABLE'
*           FSTERRO  CODE[19]  ' KEY NOT VALID '
*           620      'LU IUN'
*           FSTWARN  'BAD DATYP (ECRIT PAR FSTECR) '
*           600      'FSTLIR PAS TROUVER CHAMP DATE ETIQUET.....'
*           610      ' FSTLIR IUN   PAS TROUVER CHAMP'
*ARGUMENTS
*  OUT      BUFFER   CHAMP(NIOUT,NJOUT,NKOUT)
*  OUT      NIOUT    PREMIERE DIMENSION
*  OUT      NJOUT    DEUXIEME DIMENSION
*  OUT      NKOUT    TROISIEME DIMENSION
*  IN       IUNK     NUMERO D'UNITE FORTRAN [ REC # POUR FSTLUK ]
*  IN       DATEIN   CMC STAMP  FORMAT I10
*  IN       ETIKIN   ETIQUETTE CHARACTER * 8
*  IN       IP1IN    NIVEAU DE PRESSION DESCRIPTEUR <= 32767    OU -1
*  IN       IP2IN    NORMALEMENT HEURE  DESCRIPTEUR <= 32767    OU -1
*  IN       IP3IN    OUVERT POUR UTILISATION PAR USAGER <= 4095 OU -1
*  IN       TYPVIN   TYPE DE CHAMP CHARACTER * 1
*  IN       NOMVIN   NOM DU CHAMP  CHARACTER * 2
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL IIPAK,XXPAK, QSTUPC,QSTWPM,WAREAD
      EXTERNAL FSTINF,FSTSUI,QSTINT,QDRGET,QSTSUI,MEMOIR,MOVLEV
      INTEGER  FSTINF,FSTSUI,QSTINT,QDRGET,QSTSUI
**

      CHARACTER *8 ETIK
      CHARACTER *1 TYPV
      CHARACTER *2 NOMV
*

      INTEGER INDESC, SCRHEAD(30)
      INTEGER IUN,   KEY,   I,   IGET,   II
*--------------------------------------------------------------------------
*

      FSTLIR = 0
      ETIK = ETIKIN
      TYPV = TYPVIN
      NOMV = NOMVIN
      IUN  = IUNK
*
*    FAIRE UN FSTINF POUR IDENTIFIER LE RECORD SI EXISTANT
*

      KEY = FSTINF( IUN, NIOUT, NJOUT, NKOUT,DATEIN, ETIKIN, IP1IN,
     % IP2IN, IP3IN, TYPVIN, NOMVIN )
      FSTLIR = KEY
*

      IF( (KEY.LT. 0  ))THEN
         IF((MSGLVL.LE.4 ))THEN
            WRITE(LOGFIL,600) IUN, DATEIN, ETIK, NOMV, TYPV,IP1IN,
     %       IP2IN, IP3IN

*
         ENDIF 
         FSTLIR = -27
         RETURN

*
      ENDIF 
      GO TO 1
*--------------------------------------------------------------------------
*
***FONCTION FSTLIS, LIRE UN RECORD SUR FICHIER STANDARD (SEQ - RND)
*

      ENTRY FSTLIS( BUFFER, IUNK, NIOUT, NJOUT, NKOUT )
*
*AUTEUR   M. VALIN  -  MARS 89  ( AUTREFOIS LIRSUI )
*
*REVISION  000 NOUVELLE VERSION MARS 1989
*
*LANGAGE RATFOR
*
*OBJET (FSTLIS)
*           CETTE FUNCTION CHERCHE ET LIT  LE PROCHAIN ENREGISTREMENT
*           SATISFAISANT LES CRITERES DE RECHERCHE SPECIFIES PAR LES
*           ARGUMENTS DE LA FUNCTION FSTLIR/FSTINF/FSTSUI DEJA UTILISE
*           DANS UN APPEL PRECEDANT FSTLIS.
*
*MESSAGES   PAR FSTERR   CODE[15]  'FIN DU FICHIER SEQ'
*                        CODE[16]  'ERREUR SUR I/O'
*                        CODE[18]  'NO VALID RECORD AVAILABLE'
*                        CODE[19]  ' KEY NOT VALID '
*
*ARGUMENTS
*  OUT      NIOUT    PREMIERE DIMENSION
*  OUT      NJOUT    DEUXIEME DIMENSION
*  OUT      NKOUT    TROISIEME DIMENSION
*  IN       IUNK     NUMERO D'UNITE FORTRAN [ REC # POUR FSTLUK ]
*
*--------------------------------------------------------------------------
**

      IUN  = IUNK
*
*    FAIRE UN FSTSUI POUR IDENTIFIER LE RECORD SI EXISTANT
*

      KEY = FSTSUI( IUN, NIOUT, NJOUT, NKOUT)
*

      FSTLIR = KEY
*

      IF( (KEY.LT. 0  ))THEN
         IF((MSGLVL.LE.4 ))THEN
            WRITE(LOGFIL,610) IUN
         ENDIF 
         FSTLIR = -27
         RETURN

*
      ENDIF 
      GO TO 1
*
*--------------------------------------------------------------------------
*
***FONCTION FSTLUK, LIRE UN RECORD SUR FICHIER (SEQ - RND)
*

      ENTRY FSTLUK( BUFFER, IUNK, NIOUT, NJOUT, NKOUT)
*
*
*AUTEUR   M. VALIN  -  MARS 89  ( AUTREFOIS GETFLD )
*
*REVISION  000 NOUVELLE VERSION MARS 1989
*          001 ajout du format ieee (mai 1992)
*
*LANGAGE RATFOR
*
*OBJET (FSTLUK)
*           CETTE FUNCTION CHERCHE UN ENREGISTREMENT DONT LE CONTROL
*           EST UNE KEY RESULTANTE DE LA FUNCTION  KEY=FSTINF(.....)
*
*MESSAGES   PAR FSTERR   CODE[15]  'FIN DU FICHIER SEQ'
*                        CODE[16]  'ERREUR SUR I/O'
*                        CODE[18]  'NO VALID RECORD AVAILABLE'
*                        CODE[19]  ' KEY NOT VALID '
*
*ARGUMENTS
*  OUT      BUFFER   CHAMP(NI,NJ,NK)
*  OUT      NIOUT    PREMIERE DIMENSION
*  OUT      NJOUT    DEUXIEME DIMENSION
*  OUT      NKOUT    TROISIEME DIMENSION
*  IN       IUNK     NUMERO DU RECORD QUI SERT DE KEY
*
**

      KEY = IUNK
      IF((KEY.LT. 0  ))THEN
         FSTLIR =QDRERR('FSTLUK',' KEY NOT VALID [ VOIR IUN ] ', 29,
     %   6)
         RETURN

*
      ENDIF 
      INDESC = IAND(KEY,255)
      IUN = IUNTAB(INDESC)
*

      IF((DIRSIZ(INDESC).NE. 0 ))THEN
         IGET = QDRGET(CURSLT(1,INDESC), KEY ,1)
         IF((IGET.NE. 0))THEN
            FSTLIR = IGET
            RETURN
         ENDIF 
         CALL QSTUPC(CURSLT(1,INDESC) )
* BUG   NUMREC(INDESC) = RSHIFT(KEY, SLOTBIT)

      ELSE 
         IF((NUMREC(INDESC).NE. 1))THEN
            NUMREC(INDESC) = -1
         ENDIF 

*----------------------------------------------------------------------------
*
      ENDIF 
1     CONTINUE
*

      INDESC = IAND(KEY,255)
      IUN = IUNTAB(INDESC)
      IF((NUMREC(INDESC).NE. 1 .AND. DIRSIZ(INDESC).EQ. 0)
     %)THEN
         FSTLIR =QDRERR('FSTLIR','NO VALID RECORD AVAILABLE', 28,4)
         RETURN

*
*     RESERVER DE L'ESPACE TEMPORAIRE POUR LA LECTURE
*
      ENDIF 
      CALL MEMOIR(TAMPON,PTAMP,LNG)
*
*---------------------------------------------------------------------------
*    FICHIER SEQ
*

      IF((DIRSIZ(INDESC).EQ. 0))THEN
         IF((NBCORR(INDESC).EQ. 0))THEN
            BACKSPACE IUN
            READ(IUN, ERR=99, END=100)  (SCRHEAD(I),I=1,30),(TAMPON(
     %      I+PTAMP-1),I=1,LNG)
         ELSE 
            IF((NBCORR(INDESC).EQ. -1))THEN
               CALL WAREAD(IUN, TAMPON(PTAMP), CURSEQ(INDESC)+30,
     %          LNG)
            ELSE 
               FSTLIR =QDRERR('FSTLIR',' FILE NOT SEQUENTIAL', 41,4)
               RETURN
            ENDIF 
         ENDIF 
         NUMREC(INDESC) = 2
      ELSE 

*---------------------------------------------------------------------------

*
*       CALL WAREAD( UNIT NUMBER, CHAMP, ADRESSE DU DEBUT, LONGUEUR CHAMP )
*       CALL WAWRIT........................................................
*
         CALL WAREAD(IUN, TAMPON(PTAMP), SWA, LNG )

*
*--------------------------------------------------------------------------
*
*      IMPRIME AVEC QSTWPM
*
      ENDIF 
      IF((MSGLVL.LE.2 ))THEN
         WRITE(LUIUN,620)IUN
620      FORMAT('LU(',I2,')')
         CALL QSTWPM(KEY, LUIUN )
      ENDIF 
      FSTLIR = KEY
      NIOUT = NI
      NJOUT = NJ
      nKOUT = NK
*
*    CONVERSION DES VALEURS CONTENUES DANS LE CHAMP BUFFER DEFINI PAR
*    LE PARAMETRE "DATYP" COMMON BLOCK FSTC88
*


*
      IF( ( (DATYP.EQ. 0) .OR. COPYMOD ))THEN
         CALL MOVLEV(TAMPON(PTAMP),BUFFER,LNG)
*

      ELSE 
         IF((DATYP.EQ.1))THEN
            CALL XXPAK(BUFFER, TAMPON(PTAMP), NI, NJ*NK, -NBITS, 0,
     %       2 )

*
         ELSE 
            IF((DATYP.EQ.2))THEN
               CALL IIPAK(BUFFER, TAMPON(PTAMP), NI, NJ*NK, -NBITS,
     %          0, 2 )

*
            ELSE 
               IF((DATYP.EQ.4))THEN
                  CALL IIPAK(BUFFER, TAMPON(PTAMP), NI, NJ*NK, -
     %            NBITS, 0, 4 )

*
               ELSE 
                  IF((DATYP.EQ.5))THEN
                     CALL IEEEPAK(BUFFER, TAMPON(PTAMP), NI, NJ*NK,
     %                -NBITS, 0, 2 )

*
                  ELSE 
                     IF((DATYP.EQ.3))THEN
                        CALL IIPAK(BUFFER, TAMPON(PTAMP), (NI*NJ+3)/
     %                  4, 1, -32, 0, 2 )

*
                     ELSE 
                        FSTLIR=QDRERR('FSTLIR',
     %                  'BAD DATYP [ECRIT PAR FSTECR]',30,4)

*
                     ENDIF 
                  ENDIF 
               ENDIF 
            ENDIF 
         ENDIF 
      ENDIF 
      CALL MEMOIR(TAMPON,PTAMP,0)
      RETURN
*
*--------------------------------------------------------------------------

99    CONTINUE
      FSTLIR =QDRERR('FSTLIR','ERREUR SUR READ SEQ I/O ', 25,6)
      CALL MEMOIR(TAMPON,PTAMP,0)
      RETURN
*

100   NUMREC(INDESC) = -1
      FSTLIR =QDRERR('FSTLIR','FIN DU FICHIER ', 26,2)
      CALL MEMOIR(TAMPON,PTAMP,0)
      RETURN
*
*--------------------------------------------------------------------------
*

600   FORMAT(' FSTLIR-IUN=',I3,' , PAS TROUVE CHAMP -->  DATE=',I10,
     %' ETIQUETTE=',A8,' NOM=',A2,' TYPE= ',A1,' IP1=',I5,' IP2=',I5
     %,' IP3=',I4)
*

610   FORMAT(' FSTLIR-IUN=',I3,' , PAS TROUVE CHAMP ')
*

      END

*** FUNCTION FSTLNK - LIER UNE LISTE DE FICHIERS STANDARDS
*
      FUNCTION FSTLNK(LISTE,N)
      IMPLICIT NONE
      INTEGER FSTLNK,FSTUNL
      INTEGER N, LISTE(N)
*
*AUTEUR   M. LEPINE  -  JAN 91
*
*OBJET(FSTLNK)
*     CHAINER UNE LISTE DE FICHIERS (STD RND) DE SORTE QU'UNE RECHERCHE
*     PUISSE SE POURSUIVRE AU DELA DE LA FIN D'UN FICHIER.
*     ON NE PEUT CHAINER QUE DES FICHIERS DEJA OUVERTS ET "RANDOM".
*     ON NE PEUT PAS ECRIRE SUR UN FICHIER CHAINE.
*
*ARGUMENTS
*     IN    LISTE    LISTE DES NUMEROS D'UNITE ASSOCIES AUX FICHIERS A CHAINER
*     IN    N        NOMBRE D'ELEMENTS DANS LA LISTE
*
*IMPLICITES
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*MODULES

      INTEGER QSTINT,QDRERR
      EXTERNAL QSTINT,QDRERR
*
**

      INTEGER I,NEXTIND,INDESC
*

      DO 23000 I = 1,N-1
         INDESC = QSTINT(LISTE(I))
         NEXTIND = QSTINT(LISTE(I+1))
         IF( ((INDESC.GT.40) .OR. (NEXTIND.GT.40)))THEN
            FSTLNK=QDRERR('FSTLNK',
     %      'UN DES FICHIERS N''EST PAS OUVERT',15,4)
            RETURN
         ENDIF 
         IF( (DIRSIZ(INDESC).LE. 0))THEN
            FSTLNK=QDRERR('FSTLNK',
     %      'UN DES FICHIERS N''EST PAS RANDOM',16,4)
            RETURN
         ENDIF 
         CHAINE(INDESC) = NEXTIND
         PRMECR(INDESC) = .FALSE.
23000 CONTINUE 
      RETURN
*

      ENTRY FSTUNL
*
*OBJET(FSTUNL)
*     "UNLINK" DES FICHIERS
*

      DO 23006 I = 1,40
         CHAINE(I) = 0
23006 CONTINUE 
      RETURN
      END

***FONCTION FSTMSQ   BATIR OU EXTRAIRE MASQUE PARTIEL FICHIERS STANDARDS
*
      FUNCTION FSTMSQ ( IUN, MIP1, MIP2, MIP3, METIK, GETSET  )
      IMPLICIT NONE
      INTEGER FSTMSQ
      INTEGER IUN, MIP1, MIP2, MIP3
      CHARACTER *(*) METIK
      LOGICAL GETSET
*
*AUTEUR  M. VALIN JUILLET 1989
*
*REVISION   000 NOUVELLE VERSION JUILLET 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTMSQ)
*         DONNER LA POSSIBILITE DE DESACTIVER DE FACON SELECTIVE
*         CERTAINES PORTIONS DES CLEFS DE RECHERCHE IP1, IP2, IP3
*         ET ETIQUETTE QUI SERA DIVISE EN TROIS MOTS DE [A4,A2,A2].
*         MIP1 - MIP2 SONT DES MASQUES DE 15 BITS  MIP3 EST UN MASQUE
*         DE 12 BITS ET METIK UNE CHAINE DE 8 CARACTERES.
*         PARTOUT OU IL Y A UN BIT A ZERO DANS MIP1, MIP2, OU MIP3
*         LE BIT CORRESPONDANT DE LA CLE IP1, IP2, OU IP3 SERA IGNORE
*         LORS DES RECHERCHES. EN CE QUI CONCERNE METIK PARTOUT OU IL
*         Y A LE CARACTERE * (ETOILE) DANS METIK, LE CARACTERE
*         CORRESPONDANT DE ETIKET SE VERRA IGNORE POUR LES RECHERCHES.
*         AVEC GETSET .FALSE ON EXTRAIT LE MASQUE EXISTANT (MSKPRT)
*
*ARGUMENTS
*  IN   IUN     UNITE FORTRAN DU FICHIER STANDARD CORRESPONDANT
*  IN   MIP1    MASQUE PARTIEL (15 BITS)    CORRESPONDANT A IP1
*  IN   MIP2    MASQUE PARTIEL (15 BITS)    CORRESPONDANT A IP2
*  IN   MIP3    MASQUE PARTIEL (12 BITS)    CORRESPONDANT A IP3
*  IN   METIK   MASQUE PARTIEL 8 CARACTERES CORRESPONDANT A ETIKET
*  IN   GETSET  .FALSE. SET MASQUE PARTIEL .TRUE. GET MASQUE PARTIEL
*
*MESSAGES
*        FSTERRO ' FICHIER PAS OUVERT'
*        LOGFIL  '***ERREUR*** IUN IP1 IP2 IP3 DOIT ETRE ENTRE'
*
*NOTES
*       POUR LES PARAMETRES MIP1, MIP2, MIP3 LA VALEUR -1 INDIQUE
*       QU'ON NE DESIRE PAS SPECIFIER DE MASQUE PARTIEL. LE CHAMP
*       CORRESPONDANT (IP1,IP2,IP3) SERA DONC UTILISE ENTIEREMENT
*       POUR LES RECHERCHES [ A MOINS DE SPECIFIER -1 A FSTINF,FSTLIR...
*

      EXTERNAL QSTINT
      INTEGER  QSTINT
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER INDESC, I,  MSQ( 6), IET14, IET56, IET78
      INTEGER MP1, MP2, MP3
*
*-------------------------------------------------------------------------
*       MACRO(VALID,[
*       $( IF (%2 < %3 .OR. %2 > %4)
*           $( WRITE(LOGFIL, 610) IUN, '%1', '%2', %2, %3, %4
*               FSTMSQ = -ERRIVP      # INVALIDE PARAMETRE
*               RETURN
*           $)
*       $)
*       ]);
*-------------------------------------------------------------------------
*

      FSTMSQ = 0
      INDESC =QSTINT( IUN )
      IF(( INDESC.GT.40 ))THEN
         FSTMSQ=QDRERR('FSTMSQ',' FICHIER PAS OUVERT ', 15,6)
         RETURN
      ENDIF 
      DO 23002 I = 1, 6
         MSQ(I) = 0
*

23002 CONTINUE 
      IET14 = 0
      IET56 = 0
      IET78 = 0
*       -------------------------------------------------------------------
*

      IF((.NOT.GETSET))THEN
         IF((  MIP1.LT.  -1 .OR.  MIP1.GT.  32767))THEN
            WRITE(LOGFIL, 610) IUN, 'FSTMSQ', ' MIP1',  MIP1,  -1,
     %        32767
            FSTMSQ = -24
            RETURN
         ENDIF 
         IF((  MIP2.LT.  -1 .OR.  MIP2.GT.  32767))THEN
            WRITE(LOGFIL, 610) IUN, 'FSTMSQ', ' MIP2',  MIP2,  -1,
     %        32767
            FSTMSQ = -24
            RETURN
         ENDIF 
         IF((  MIP3.LT.  -1 .OR.  MIP3.GT.  4095))THEN
            WRITE(LOGFIL, 610) IUN, 'FSTMSQ', ' MIP3',  MIP3,  -1,
     %        4095
            FSTMSQ = -24
            RETURN
         ENDIF 

*
         DO 23012 I = 1,4
            IET14 =ishft(IET14,8)
            IF((METIK(I:I).EQ. '*'))THEN
               IET14 = IET14 + 255
            ENDIF 
23012    CONTINUE 
         IF((METIK(5:5).EQ. '*'))THEN
            IET56 = IET56 + 256*255
         ENDIF 
         IF((METIK(6:6).EQ. '*'))THEN
            IET56 = IET56 + 255
         ENDIF 
         IF((METIK(7:7).EQ. '*'))THEN
            IET78 = IET78 + 256*255
         ENDIF 
         IF((METIK(8:8).EQ. '*' ))THEN
            IET78 = IET78 + 255
*
*                          #   MASQUE PARTIEL DES 3 ETIKETS DEFINI

         ENDIF 
         MP1 = MIP1
         MP2 = MIP2
         MP3 = MIP3
         IF((MP1.EQ. -1))THEN
            MP1 = 32767
         ENDIF 
         IF((MP2.EQ. -1))THEN
            MP2 = 32767
         ENDIF 
         IF((MP3.EQ. -1))THEN
            MP3 =  4095
*

         ENDIF 
         MSQ((1+ishft( 175-64,-(5))))=IOR(MSQ((1+ishft( 175-64,-(5))
     %   )),ishft(IAND(MP1 ,ishft(-1,-(32-( 16)))),(31-IAND( 175-64,
     %   31))))
         MSQ((1+ishft( 111-64,-(5))))=IOR(MSQ((1+ishft( 111-64,-(5))
     %   )),ishft(IAND(MP2 ,ishft(-1,-(32-( 16)))),(31-IAND( 111-64,
     %   31))))
         MSQ((1+ishft( 191-64,-(5))))=IOR(MSQ((1+ishft( 191-64,-(5))
     %   )),ishft(IAND(MP3 ,ishft(-1,-(32-( 12)))),(31-IAND( 191-64,
     %   31))))
         MSQ((1+ishft( 095-64,-(5))))=IOR(MSQ((1+ishft( 095-64,-(5))
     %   )),ishft(IAND(IET14 ,ishft(-1,-(32-( 32)))),(31-IAND( 095-
     %   64,31))))
         MSQ((1+ishft( 143-64,-(5))))=IOR(MSQ((1+ishft( 143-64,-(5))
     %   )),ishft(IAND(IET56 ,ishft(-1,-(32-( 16)))),(31-IAND( 143-
     %   64,31))))
         MSQ((1+ishft( 159-64,-(5))))=IOR(MSQ((1+ishft( 159-64,-(5))
     %   )),ishft(IAND(IET78 ,ishft(-1,-(32-( 16)))),(31-IAND( 159-
     %   64,31))))
*

         DO 23030 I = 1, 6
            MSKPRT(I,INDESC) = MSQ(I)
*
*

23030    CONTINUE 

*
      ELSE 

*

*
         DO 23032 I = 1, 6
            MSQ(I) =  MSKPRT(I,INDESC)
*

23032    CONTINUE 
         MIP1  =IAND(ishft(MSQ((1+ishft( 175-64,-(5)))),-((31-IAND(
     %    175-64,31)))),ishft(-1,-(32-( 16))))
         MIP2  =IAND(ishft(MSQ((1+ishft( 111-64,-(5)))),-((31-IAND(
     %    111-64,31)))),ishft(-1,-(32-( 16))))
         MIP3  =IAND(ishft(MSQ((1+ishft( 191-64,-(5)))),-((31-IAND(
     %    191-64,31)))),ishft(-1,-(32-( 12))))
         IET14 =IAND(ishft(MSQ((1+ishft( 095-64,-(5)))),-((31-IAND(
     %    095-64,31)))),ishft(-1,-(32-( 32))))
         IET56 =IAND(ishft(MSQ((1+ishft( 143-64,-(5)))),-((31-IAND(
     %    143-64,31)))),ishft(-1,-(32-( 16))))
         IET78 =IAND(ishft(MSQ((1+ishft( 159-64,-(5)))),-((31-IAND(
     %    159-64,31)))),ishft(-1,-(32-( 16))))
*

         METIK = '        '
         DO 23034 I = 4,1,-1
            IF((IAND(IET14, 255).NE. 0))THEN
               METIK(I:I) = '*'
            ENDIF 
            IET14 =ishft(IET14,-( 8 ))

*
23034    CONTINUE 
         IF((IAND(IET56, 255).NE. 0))THEN
            METIK(6:6) = '*'
         ENDIF 
         IF((IAND(IET78, 255).NE. 0))THEN
            METIK(8:8) = '*'
         ENDIF 
         IF((   IET56 / 256.NE. 0))THEN
            METIK(5:5) = '*'
         ENDIF 
         IF((   IET78 / 256.NE. 0))THEN
            METIK(7:7) = '*'
*

         ENDIF 

*
      ENDIF 
      RETURN
*
*-----------------------------------------------------------

610   FORMAT(' ***ERREUR***   IUN=',I3,3X,A7,3X,A7,'(',O11,
     %'B) DOIT ETRE ENTRE',I6,' ET ',I6)
*

      END

***FONCTION FSTNBR , TROUVER LA TAILLE D'UN FICHIER STANDARD
*
      FUNCTION FSTNBR( IUN)
      IMPLICIT NONE
      INTEGER FSTNBR
      INTEGER IUN
*
*AUTEUR   M. VALIN  -  JAN 89  ( AUTREFOIS NOMBRE)
*
*REVISION
*         1.0.1-   SI LE FICHIER EST UN FICHIER RANDOM/SEQ IDENTIFIER
*                  LE FICHIER EN RETOURNANT  FSTNBR = -1.
*LANGAGE RATFOR
*
*OBJET (FSTNBR)
*           TROUVE LE NOMBRE D'ENREGISTREMENTS ACTIFS CONTENUS
*           DANS UN FICHIER RANDOM OU RANDOM/SEQ.  OUVRE LE FICHIER
*           ET LIT LE NOMBRE D'ENREGISTREMENTS ACTIFS DANS LE PREFIXE.
*           APPELER FSTNBR AVEC UN FICHIER SEQUENTIEL EST UNE ERREUR.
*
*MODULES
*

      EXTERNAL QSTINT, FSTABT, WAOPEN, WAREAD, WACLOS, NUMBLKS, FNOM
      INTEGER  QSTINT, NUMBLKS
*
*ARGUMENTS
*  OUT      FSTNBR NOMBRE D'ENREGISTREMENTS
*  IN       IUN    NUMERO D'UNITE FORTRAN
*
*MESSAGES
*        LOGFIL   ' FICHIER STD OUVERT DANS FSTNBR'
*        FSTWARN  ' FILE IS SEQUENTIEL'
*        LOGFIL   ' FICHIER PAS OUVERT MAIS EXISTANT DANS FSTNBR'
*        FSTWARN  ' FILE IS NOT STANDARD RANDOM'
*        FSTWARN  ' FILE DO NOT EXIST'
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER INDESC, PREFIX(30), IGET
*

      FSTNBR = 0
      INDESC = QSTINT(IUN)
      IGET = NUMBLKS(IUN)
*--------------------------------------------------------------------------

      IF( (INDESC .LE.40))THEN
         IF((MSGLVL.LE.0))THEN
            WRITE(LOGFIL,*)' FICHIER STANDARD OUVERT DANS FSTNBR '
         ENDIF 
         IF( (DIRSIZ(INDESC) .EQ. 0  ))THEN
            IF( (NBCORR(INDESC) .EQ. -1))THEN
               FSTNBR = -1
            ELSE 
               FSTNBR=QDRERR('FSTNBR','FILE IS SEQUENTIAL',17,4)
            ENDIF 
            RETURN
         ELSE 
            FSTNBR = NUTIL(INDESC)
         ENDIF 

*--------------------------------------------------------------------------
      ELSE 
         IF((NUMBLKS(IUN).GT. 0))THEN
            IF((MSGLVL.LE.0))THEN
               WRITE(LOGFIL,*)
     %         ' FICHIER PAS OUVERT MAIS EXISTANT DANS FSTNBR'
            ENDIF 
            CALL WAOPEN(IUN)
            CALL WAREAD(IUN, PREFIX, 1,30)
*

            IF( (PREFIX(1) .EQ. RDSYNC  ))THEN
               IGET   = (IAND(ishft(PREFIX((1+ishft(159,-(5)))),-((
     %         31-IAND(159,31)))),ishft(-1,-(32-(32)))))
               FSTNBR = IGET

*
            ELSE 
               IF( (PREFIX(30) .EQ. SQSYNC))THEN
                  FSTNBR = -1

*
               ELSE 
                  IF( (PREFIX(1) .NE. RDSYNC  ))THEN
                     FSTNBR=QDRERR('FSTNBR',
     %               'FILE IS NOT STANDARD RANDOM',16,4)
                     CALL WACLOS(IUN)
                     RETURN

*
                  ENDIF 
               ENDIF 
            ENDIF 
            CALL WACLOS(IUN)

*--------------------------------------------------------------------------
         ELSE 

*     FSTWARN('FSTNBR','FILE DOES NOT EXIST',ERRFNE,FSTNBR)
*
            FSTNBR = 0

*
*     SPECIAL POUR CREE UN FICHIER SEQ/RND
*
            RETURN

*
*--------------------------------------------------------------------------
         ENDIF 
      ENDIF 
      RETURN
      END

***FONCTION FSTOPC  MODIFIE LE NIVEAU D UNE OPTION TYPE CARACTERE
*
      FUNCTION FSTOPC( OPTION, NIVEAU ,GETSET)
      IMPLICIT NONE
      INTEGER FSTOPC
      CHARACTER *(*) OPTION, NIVEAU
      LOGICAL GETSET
*
*AUTEUR  M. VALIN MAI 1989
*
*REVISION   000 NOUVELLE VERSION MARS 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTOPC)
*         PERMET DE MODIFIER LE NIVEAU DE L OPTION TYPE CARACTERE
*         AVEC UN NIVEAU DE TYPE CARACTERE.
*
*ARGUMENTS
* IN  OPTION  MSGLVL  OPTION NIVEAU DES MESSAGES A IMPRIMER
*
* IN  NIVEAU  DEBUGS  IMPRIME TOUS LES MESSAGES A L INTERIEUR [DANGER]
*                     [DEBUGS] PEUT CAUSE DE TRES LONGS LISTINGS
*             INFORM  IMPRIME MESSAGES QUI INDIQUENT OU LE PGM SE TROUVE
*             WARNIN  IMPRIME MESSAGES QUE L USAGER DOIT SAVOIR
*             ERRORS  IMPRIME MESSAGES IMPORTANT QUI PEUVENT ETRE FATALE
*             FATALE  IMPRIME MESSAGES QUI SERONT FATALS ET APPEL FSTABT
*             SYSTEM  IMPRIME MESSAGES CAUSE PAR LE SYSTEM
*------------------------------------------------------------------------
* IN  OPTION  TOLRNC  TOLERANCE POUR MESSAGES DU FICHIER STANDARD
*
* IN  NIVEAU  DEBUGS  NE TOLERE AUCUN MESSAGES
*             INFORM  TOLERE TOUS LES MESSAGES NIVEAU NIVMES=DEBUGS
*             WARNIN  TOLERE TOUS LES MESSAGES NIVEAU NIVMES=DEBUGS,INFORM
*             ERRORS  TOLERE NIVEAU NIVMES=DEBUGS,INFORM,WARNING
*             FATALE  TOLERE NIVEAU NIVMES=DEBUGS,INFORM,WARNING,ERROR
*             SYSTEM  TOLERE NIVEAU NIVMES=DEBUGS,INFORM,WARNING,ERROR,FATAL
*------------------------------------------------------------------------
*MESSAGES
*         600     ' FSTOPC OPTION      NIVEAU     DEFAUT MSGLVL'
*         610     ' FSTOPC OPTION      NIVEAU     DEFAUT TOLRNC'
*         FSTWARN ' OPTION NOT VALID'
*
*IMPLICITES
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
**

      CHARACTER *6 TABMESS(6)
      INTEGER NIVMESS(6), I, ENTIER
      LOGICAL YESNO
      REAL  REEL, DUMMY
      INTEGER FSTOPL, FSTOPR, FSTOPI
*

      SAVE TABMESS, NIVMESS
      DATA TABMESS /'DEBUGS','INFORM','WARNIN','ERRORS','FATALE',
     %'SYSTEM'/
      DATA NIVMESS / 0,   2,   4,   6,   8,   10 /
*

      FSTOPC = 0
*

      IF((OPTION.EQ. 'MSGLVL'))THEN
         IF((GETSET))THEN
            WRITE(LOGFIL,601) TABMESS(MSGLVL/2 +1 ),MSGLVL
            RETURN

*
         ENDIF 
         MSGLVL = -1
         DO 23004 I= 1, 6
            IF((TABMESS(I).EQ. NIVEAU))THEN
               MSGLVL = NIVMESS(I)
            ENDIF 

*
23004    CONTINUE 
         IF(( MSGLVL.EQ. -1 ))THEN
            MSGLVL = 2
            WRITE(LOGFIL,600) OPTION, NIVEAU, MSGLVL

*
         ENDIF 
         RETURN

*----------------------------------------------------------------------
      ELSE 
         IF((OPTION.EQ. 'TOLRNC'))THEN
            IF((GETSET))THEN
               WRITE(LOGFIL,602) TABMESS(TOLRNC/2 +1 ),TOLRNC
               RETURN

*
            ENDIF 
            TOLRNC = -1
            DO 23014 I= 1, 6
               IF((TABMESS(I).EQ. NIVEAU))THEN
                  TOLRNC = NIVMESS(I)
               ENDIF 

*
23014       CONTINUE 
            IF(( TOLRNC.EQ. -1 ))THEN
               TOLRNC = 6
               WRITE(LOGFIL,610) OPTION, NIVEAU, TOLRNC
            ENDIF 
            RETURN

*---------------------------------------------------------------------------
*
         ELSE 
            FSTOPC =QDRERR('FSTOPC',' OPTION NOT VALID',36,4)
            RETURN

*
         ENDIF 
      ENDIF 
600   FORMAT(' FSTOPC OPTION= ',A6,'   NIVEAU= ',A6,
     %' DEFAUT  MSGLVL=',I6)
601   FORMAT(' FSTOPC OPTION= ',A6,'  MSGLVL=',I6)
602   FORMAT(' FSTOPC OPTION= ',A6,'  TOLRNC=',I6)
610   FORMAT(' FSTOPC OPTION= ',A6,'   NIVEAU= ',A6,
     % '  DEFAUT TOLRNC=',I6)
*--------------------------------------------------------------------------
*
***FONCTION FSTOPL  MODIFICATION DE LA VALEUR FASTIO  DEFAUT .FALSE.
*

      ENTRY FSTOPL( OPTION, YESNO, GETSET )
*
*AUTEUR  M. VALIN MAI 1989
*
*REVISION   000 NOUVELLE VERSION MARS 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTOPL)
*         PERMET DE MODIFIER LA VALEUR D'UNE VARIABLE LOGICAL COMMON FSTC88
*         OU DE VERIFIER LA VALEUR DE L'OPTION OPTION.
*
*ARGUMENTS
*
* IN  OPTION  NOM DE LA VARIABLE LOGICAL DANS COMMON FSTC88   EX:FASTIO
*
*     YESNO   .TRUE. .FALSE. VALEUR A ECRIRE OU VALEUR EXTRAITE
*
*     GETSET  .TRUE.  IMPRIME VALEUR DE L'OPTION OPTION
*             .FALSE. ECRIT VALEUR YESNO DANS VARIABLE OPTION COMMON FSTC88
*-------------------------------------------------------------------------
*

      IF((OPTION.EQ. 'FASTIO'))THEN
         IF((GETSET))THEN
            WRITE(LOGFIL,603) FASTIO
         ELSE 
            FASTIO = YESNO
            WRITE(LOGFIL,604) FASTIO
         ENDIF 
      ELSE 
         IF((OPTION.EQ. 'IMAGE'))THEN
            IF((GETSET))THEN
               WRITE(LOGFIL,703) COPYMOD
            ELSE 
               COPYMOD = YESNO
               WRITE(LOGFIL,704) COPYMOD
            ENDIF 

*
         ENDIF 
      ENDIF 
      RETURN
*

603   FORMAT(' VALEUR FASTIO EXTRAITE DU COMMON= ',L8)
604   FORMAT(' USAGER INITIALISE FASTIO A   ',L8)
703   FORMAT(' VALEUR IMAGE EXTRAITE DU COMMON= ',L8)
704   FORMAT(' USAGER INITIALISE IMAGE A   ',L8)
*----------------------------------------------------------------------------
*
***FONCTION FSTOPR  MODIFICATION D UNE VALEUR REEL  FSTC88 COMMON
*

      ENTRY FSTOPR( OPTION, REEL, GETSET)
*
*AUTEUR  M. VALIN MAI 1989
*
*REVISION   000 NOUVELLE VERSION MARS 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTOPR)
*         PERMET DE MODIFIER LA VALEUR D UNE LOCATION REELLE DANS LE
*         COMMON FSTC88
*
*ARGUMENTS
*
* IN       OPTION  EST LA VALEUR DE L OPTION EN  CARACTERE(S)
*
* IN OUT   REEL    VALEUR A ECRIRE DANS OPTION  VALEUR EXTRAIT DE L'OPTIONN
*
* IN       GETSET  .TRUE. LIRE VALEUR DE OPTION
*                  .FALSE. ECRIRE VALEUR REEL DANS OPTION
*
*---------------------------------------------------------------------
*
*

      IF((OPTION.EQ. 'DUMMY'))THEN

*        LIRE DANS UNE LOCATION DU COMMON FSTC88 AUCUNE VARIABLE POUR
*        MAINTENANT
*
         IF((GETSET))THEN
            REEL = DUMMY
            WRITE(LOGFIL,605) REEL

*
*     ECRIRE DANS UNE LOCATION DU COMMON FSTC88 AUCUNE VARIABLE POUR
*     MAINTENANT
*
         ELSE 
            DUMMY = REEL
            WRITE(LOGFIL,606) DUMMY
         ENDIF 

*
      ENDIF 
      RETURN
*

605   FORMAT(' EXTRAIRE VALEUR REEL = ', E14.7)
606   FORMAT(' INITIALISE VALEUR REEL = ',E14.7)
*
*
***FONCTION FSTOPI  MODIFICATION D UNE VARIABLE VALEUR ENTIERE
*

      ENTRY FSTOPI( OPTION, ENTIER, GETSET)
*
*AUTEUR  M. VALIN MAI 1989
*
*REVISION   000 NOUVELLE VERSION MARS 1989
*
*LANGAGE RATFOR
*
*OBJET(FSTOPI)
*         PERMET DE MODIFIER LA VALEUR D UNE LOCATION TYPE ENTIER
*
*ARGUMENTS
*
* IN      OPTION  NOM DE LA VARIABLE ENTIERE EN CARACTERE DU COMMON FSTC88
*
* IN OUT  ENTIER  VALEUR NOUVELLE DE LA LOCATION
*
* IN      GETSET  .TRUE. LIRE VALEUR DE OPTION
*                 .FALSE. ECRIRE VALEUR ENTIERE DANS OPTION
*-------------------------------------------------------------------------
*

      IF((OPTION.EQ. 'MSGLVL'))THEN

*
*     LIRE DANS UNE LOCATION DU COMMON FSTC88
*
         IF((GETSET))THEN
            WRITE(LOGFIL,607) MSGLVL

*
*     ECRIRE DANS UNE LOCATION DU COMMON FSTC88
*
         ELSE 
            MSGLVL = ENTIER
            WRITE(LOGFIL,608) MSGLVL
         ENDIF 
         RETURN

*
      ENDIF 
607   FORMAT(' EXTRAIRE VALEUR DE MSGLVL = ', I20)
608   FORMAT(' INITIALISE MSGLVL = ', I20)
*

      IF((OPTION.EQ. 'TOLRNC'))THEN

*
*     LIRE DANS UNE LOCATION DU COMMON FSTC88
*
         IF((GETSET))THEN
            ENTIER = TOLRNC
            WRITE(LOGFIL,607) ENTIER

*
*     ECRIRE DANS UNE LOCATION DU COMMON FSTC88
*
         ELSE 
            TOLRNC = ENTIER
            WRITE(LOGFIL,608) TOLRNC
         ENDIF 
         RETURN

*
*
      ENDIF 
609   FORMAT(' EXTRAIRE VALEUR DE TOLRNC = ', I20)
611   FORMAT(' INITIALISE TOLRNC = ', I20)
*
*

      RETURN
*--------------------------------------------------------------------------

      END

***FONCTION FSTOUV , OUVRIR UN FICHIER STANDARD
*
      FUNCTION FSTOUV( IUN, OPTIONS )
      IMPLICIT NONE
      INTEGER FSTOUV
      CHARACTER *(*) OPTIONS
      INTEGER IUN
*
*AUTEUR   M. VALIN  -  JAN 89  ( AUTREFOIS OUVRIR )
*
*REVISION  0.0.0 NOUVELLE VERSION JANV 1989
*          1.0.1 MODIFICATION POUR OUVRIR FICHIER SEQ/RND
*
*LANGAGE RATFOR
*
*OBJET (FSTOUV)
*           OUVRIR UN FICHIER STANDARD QUI PEUT CONTENIR DES CHAMPS
*           DE UNE DEUX OU TROIS DIMENSIONS.
*
*MESSAGES   FSTWARN CODE[8]    'FICHIER DEJA OUVERT'
*           FSTERRO CODE[9]    'TROP DE FICHIERS STANDARDS OUVERTS'
*           FSTERRO            'FILE NOT RANDOM STANDARD'
*           FSTWARN            'INVALID MODE APPEL DE FSTOUV'
*           FSTWARN CODE[10]   ' DIRECTEUR IMPAIR'
*           FSTWARN CODE[11]   'FILE PROBABLY DAMAGED'
*           LOGFIL             ' 1 > NPAIRE > 200 REINITIALISE 50 FSTOUV'
*           904                'UNIT RANDOM EST CREE'
*           905                'UNIT IUN EST OUVERT [SEQ RND]'
*
*
*ARGUMENTS
*  OUT      FSTOUV
*  IN       IUN      NUMERO D'UNITE FORTRAN
*  IN       OPTIONS  'SEQ' = SEQUENTIEL  'RND' = RANDOM
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL QSTUPA,QSTUPB,QSTPKC,QSTWHD,QSTRHD,QSTRDR
      EXTERNAL FSTNBR,QDROPN,QDRPUT,QSTINT
      EXTERNAL WAOPEN,WAREAD,WAWRIT,NUMBLKS,QSTEOI
      INTEGER  FSTNBR,QDROPN,QDRPUT,QSTINT,QSTWHD,QSTRHD,QSTRDR
      INTEGER  QSTEOI,NUMBLKS
**

      INTEGER  PREFIX(30), TABLE(12,2), BUFFER(30)
      INTEGER  INDESC,  NREC,  ADRBUF,  IMOT,  INX,  I, IERR
      INTEGER  KEY,   IPUT,  NBMOTS,  IPAGE, NOM,  LFN
*

      CHARACTER * 10 MODACC
      DATA   IUNTAB/41*-1,-1/, FASTIO/.FALSE./,   DIAGP/.TRUE./,
     %LOGFIL/6/,   DEBUG/0/   ,   TOLRNC /6/,MSGLVL/2/,   NPAIRE/50/
     %   ,   COPYMOD/.FALSE./,CHAINE/41 * 0/,   EFFDSC/41 * -1/
      DATA RDSYNC /1431655765 /
      DATA RDSYN2 /1431655765 /
      DATA SQSYNC /O"25252525252" /
      DATA SQSYN2 /O"25252525252" /
*--------------------------------------------------------------------------
*

      FSTOUV = 0
*

      INDESC = QSTINT(IUN)
      IF( (INDESC.LE.40  ))THEN
         FSTOUV =QDRERR('FSTOUV','FICHIER DEJA OUVERT', 18,4)
         RETURN

*-------------------------------------------------------------------------
*
*      FICHIER PAS OUVERT  TROUVER UNE PLACE LIBRE
*
      ENDIF 
      INDESC = 0
      IUNTAB(41) = -1
23002 IF( (IUNTAB(INDESC) .NE. -1))THEN
         INDESC = INDESC + 1
*

         GOTO 23002
      ENDIF 
      IF( (INDESC.GT.40 ))THEN
         FSTOUV =QDRERR('FSTOUV','TROP DE FICHIERS OUVERTS', 19,6)
         RETURN

*-------------------------------------------------------------------------
*
*     LES INFORMATIONS CONCERNANT CE FICHIER SERONT ENREGISTREES
*     DANS L'ENTREE INDESC DES TABLES. IUN SERA STOCKE DANS IUNTAB(INDESC)
*     LORSQUE TOUT AURA ETE VERIFIE.
*
      ENDIF 
      EFFDSC(INDESC) = INDESC
      CHAINE(INDESC) = 0
      DIRSIZ(INDESC) = 0
      NUTIL (INDESC) = 0
      NXTADR(INDESC) = 0
      NBECR (INDESC) = 0
      NBRECR(INDESC) = 0
      NRECUP(INDESC) = 0
      NBEFF (INDESC) = 0
      NBEXT (INDESC) = 0
      CURSEQ(INDESC) = 1
      NXTSEQ(INDESC) = 1
      NBCORR(INDESC) = 0
      NRECUP(INDESC) = 0
      NUMREC(INDESC) = -1
      MODIFS(INDESC) = .FALSE.
      PRMECR(INDESC) = .TRUE.
*
*-------------------------------------------------------------------------
*

      DO 23006 I=1, 6
         MSKPRT(I,INDESC)=  0
*
*                      # FICHIER SEQUENTIEL FORTRAN
*     ---------------------------------------------------------------------

23006 CONTINUE 
      IF((INDEX(OPTIONS,'SEQ').NE.0 .AND.INDEX(OPTIONS,'FTN').NE.0)
     %)THEN
         GO TO 500

*                                            FICHIER SEQ/RND
*     ---------------------------------------------------------------------
      ELSE 
         IF((INDEX(OPTIONS,'SEQ').NE.0))THEN
            GO TO 600

*     ----------------------------------------------------------------------
         ELSE 
            IF((INDEX(OPTIONS,'RND').NE.0 .OR.INDEX(OPTIONS,' ').NE.
     %      0))THEN
               NREC = FSTNBR(IUN)
               IF((NREC.EQ. -1))THEN
                  GO TO 600
*

               ENDIF 
               IF((NREC.LT. -1 ))THEN
                  FSTOUV =QDRERR('FSTOUV','FILE NOT RANDOM STANDARD'
     %            , 16,6)
                  RETURN

*
               ELSE 
                  IF((NREC.EQ. 0))THEN
                     GO TO 400

*
                  ELSE 
                     IF(( NREC.GT. 0 ))THEN
                        FSTOUV = NREC
                        GO TO 200
                     ENDIF 
                  ENDIF 
               ENDIF 

*-------------------------------------------------------------------------
*
            ELSE 
               IF( (INDESC.LE.40 ))THEN
                  FSTOUV =QDRERR('FSTOUV',
     %            ' INVALID MODE   APPEL DE FSTOUV',22,4)
                  RETURN

*
               ENDIF 
            ENDIF 
         ENDIF 
      ENDIF 
200   CONTINUE
*
*-------------------------------------------------------------------------

      CALL WAOPEN ( IUN )
      CALL WAREAD ( IUN, PREFIX, 1,30 )
*

      DIRSIZ(INDESC) =IAND(ishft(PREFIX((1+ishft( 095,-(5)))),-((31-
     %IAND( 095,31)))),ishft(-1,-(32-( 32))))
      NUTIL (INDESC) =IAND(ishft(PREFIX((1+ishft( 159,-(5)))),-((31-
     %IAND( 159,31)))),ishft(-1,-(32-( 32))))
      NBECR (INDESC) =IAND(ishft(PREFIX((1+ishft( 223 ,-(5)))),-((31
     %-IAND( 223 ,31)))),ishft(-1,-(32-( 32))))
      NBRECR(INDESC) =IAND(ishft(PREFIX((1+ishft( 287,-(5)))),-((31-
     %IAND( 287,31)))),ishft(-1,-(32-( 32))))
      NBEXT (INDESC) =IAND(ishft(PREFIX((1+ishft( 351 ,-(5)))),-((31
     %-IAND( 351 ,31)))),ishft(-1,-(32-( 32))))
      NRECUP(INDESC) =IAND(ishft(PREFIX((1+ishft( 415,-(5)))),-((31-
     %IAND( 415,31)))),ishft(-1,-(32-( 32))))
      NBEFF (INDESC) =IAND(ishft(PREFIX((1+ishft( 479 ,-(5)))),-((31
     %-IAND( 479 ,31)))),ishft(-1,-(32-( 32))))
      NBCORR(INDESC) =IAND(ishft(PREFIX((1+ishft( 543,-(5)))),-((31-
     %IAND( 543,31)))),ishft(-1,-(32-( 32))))
*
*     VERIFIER QUE LE DIRECTEUR CONTIENT UN NOMBRE PAIR D'ENTREES
*

      IF( (MOD(DIRSIZ(INDESC),2) .NE. 0  ))THEN
         FSTOUV =QDRERR('FSTOUV','DIRECTEUR IMPAIR ', 20,4)
         RETURN

*
*     VERIFIER POUR EXTENSION DEFECTUEUSE
*
      ENDIF 
      IF( (NBEXT(INDESC).GT. 0 .AND. NBEXT(INDESC).LT. 32768)
     %)THEN
         FSTOUV =QDRERR('FSTOUV',' FILE PROBABLY DAMAGED', 21,4)
         RETURN

*
      ENDIF 
      NBEXT(INDESC) = MOD(NBEXT(INDESC), 32768)
*
*     LE DIRECTEUR EST LU AU COMPLET INDIQUE PAR SWA=1. CECI PERMET DE
*     DETERMINER NUTIL CORRECTEMENT MEME SI LE FICHIER N'A PAS ETE FERME
*     PRECEDEMMENT.  POUR MINIMISER LES APPEL AU SUPERVISEUR LES ENTREES
*     SONT LUES EN GROUPE  AVEC L'AIDE DE BUFFER.  LES GROUPES DOIVENT
*     CONTENIR UN NOMBRE PAIR D'ENTREES.
*
*     NXTADR EST INITIALEMENT APRES LE DIRECTEUR AU DEBUT D'UN CHUNK.
*

      NXTADR(INDESC) =30 + ((DIRSIZ(INDESC) + 1)/2)*30
      NXTADR(INDESC) = 1 +30*((NXTADR(INDESC) +30 - 1)/30)
*

      IPAGE = QDROPN(INDESC)
      IF((IPAGE.LT. 0))THEN
         FSTOUV = IPAGE
         RETURN

*
      ENDIF 
      IUNTAB(INDESC) = IUN
      INX = QSTRDR(INDESC)
      IF((INX.LT. 0))THEN
         FSTOUV = INX
         RETURN

*
*     VERIFIER SI NUTIL ETAIT CORRECT
*
      ENDIF 
      IF((NUTIL(INDESC) .NE. INX + 1))THEN
         FSTOUV=QDRERR('FSTOUV','FILE PROBABLY DAMAGED', 21,4)

*

*
         NUTIL(INDESC) = INX + 1
         IF((PRMECR(INDESC)))THEN
            NBCORR(INDESC) = NBCORR(INDESC) + 1
            MODIFS(INDESC) = .TRUE.

*
         ENDIF 

*
*     LA PROCHAINE ADRESSE DISPONIBLE DOIT ETRE AU DEBUT D'UN CHUNK
*
      ENDIF 
      NXTADR(INDESC) = 1 +30*( (NXTADR(INDESC)-1 +30-1) /30)
*

      GO TO 1000
*
*-------------------------------------------------------------------------

400   CONTINUE
*
*  CREER FICHIER RANDOM
*
*--------------------------------------------------------------------------

      IPAGE = QDROPN(INDESC)
      IF((IPAGE.LT. 0))THEN
         FSTOUV = IPAGE
         RETURN

*---------------------------------------------------------------------------
*
*     L'ALLOCATION INITIALE D'ESPACE AU DIRECTEUR OBEIT AUX REGLES SUIVANTES:
*
*     ON ALLOUE TOUJOURS UN NOMBRE PAIR D'ENTREES (50)
*
      ENDIF 
      CALL WAOPEN ( IUN )
*

      PRMECR(INDESC) = .TRUE.
      IF((NPAIRE.LT. 1 .OR. NPAIRE.GT. 200))THEN
         WRITE(LOGFIL,*)' 1 > NPAIRE > 200 REINITIALISE A 50 FSTOUV'
         NPAIRE = 50
      ENDIF 
      NBMOTS = NPAIRE*30 +30
      NBMOTS =30*((NBMOTS +30 - 1)/30)
      DIRSIZ(INDESC) = ((NBMOTS -30) /30)*2
      NXTADR(INDESC) = NBMOTS + 1
*
*     PREPARER ET ECRIRE L'ENTETE
*

      DO 23040 I = 1,30
         BUFFER(I) = 0
*
*     FUNCTION QSTWHD VA ECRIRE L'ENTETE
*

23040 CONTINUE 
      IUNTAB(INDESC) = IUN
      IERR = QSTWHD(INDESC)
*
*--------------------------------------------------------------------------
*
*     ECRIRE DES 0 DE DIMPRO+1 A DIMCHK
*

      DO 23042 I=30 + 1, NBMOTS,30
         CALL WAWRIT( IUN, BUFFER, I,30 )
*

23042 CONTINUE 
      IF( (MSGLVL.LE.2 ))THEN
         WRITE(LOGFIL,904) IUN
      ENDIF 
904   FORMAT(' UNIT =',I3,' RANDOM EST CREE')
*

      GO TO 1000
*
*-------------------------------------------------------------------------
*

500   CONTINUE
*
*     FICHIER SEQUENTIEL
*
*     RIEN A FAIRE LES FICHIERS STANDARDS SEQUENTIELS N'ONT PAS D'ENTETE
*     ET SONT TRAITES COMME DES FICHIERS SEQUENTIELS HABITUELS DE FORTRAN
*

      NUTIL (INDESC) =32767
      GO TO 1000
*

600   CONTINUE
      CURSEQ(INDESC) = 1
      NXTSEQ(INDESC) = 1
      NBCORR(INDESC) = -1
      NUTIL (INDESC) =32767
      CALL WAOPEN(IUN)
      IF( (NUMBLKS(IUN).LE.0))THEN
         IUNTAB(INDESC) = IUN
         I = QSTEOI(INDESC)

*
      ENDIF 
1000  CONTINUE
*-------------------------------------------------------------------------
*
*   OUVERTURE REUSSIE
*

      IUNTAB(INDESC) = IUN
*-------------------------------------------------------------------------

      IF( (MSGLVL.LE.2))THEN
         IF((DIRSIZ(INDESC).GT. 0))THEN
            MODACC = 'RANDOM    '
*

         ELSE 
            MODACC = 'SEQUENTIEL'
*

         ENDIF 
         WRITE(LOGFIL,905) IUN, MODACC
905      FORMAT(' UNIT =',I3,' EST OUVERT  ',A10)

*-------------------------------------------------------------------------
*
      ENDIF 
      RETURN
      END

***FONCTION FSTPOS   POSITIONNE FICHIER SEQ/RND SEULEMENT
*
      FUNCTION FSTPOS(IUN, KEY )
      IMPLICIT NONE
      INTEGER FSTPOS
      INTEGER IUN, KEY
*
*AUTEUR  M. VALIN FEV 1990
*
*REVISION   000 NOUVELLE VERSION FEV 1990
*
*LANGAGE RATFOR
*
*OBJET(FSTPOS)
*         FICHIER SEQ/RND SERA POSITIONNE PAR LA VALEUR DE KEY
*         AUCUN POSITINNEMENT POUR FICHIER SEQ/FTN OU RND
*
*
*ARGUMENTS
*  IUN   - NUMERO D UNITE FORTRAN
*  KEY   - POSITION DU RECORD DANS LE FICHIER
*
*IMPLICITES
*

      EXTERNAL QSTINT,QDRERR
      INTEGER  QSTINT,QDRERR
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER INDESC
      FSTPOS = 0
*                                    VALIDER IUN

      IF(( IUN.LT. 0 .OR. IUN.GT. 99 ))THEN
         FSTPOS=QDRERR('FSTPOS',' NUMERO IUN INVALIDE', 31,6)
         RETURN

*
      ENDIF 
      INDESC = QSTINT(IUN)
      IF((INDESC.GT.40))THEN
         FSTPOS=QDRERR('FSTPOS',' FICHIER PAS OUVERT' , 15,6)
         RETURN

*
*
*      ---------------------------------------------------------------
      ENDIF 
      IF((DIRSIZ(INDESC).EQ.0 .AND. NBCORR(INDESC).EQ.0))THEN
         WRITE(LOGFIL,*)' PAS DE POSITIONNEMENT FILE SEQ/FTN '
         RETURN

*      ---------------------------------------------------------------
      ELSE 
         IF((DIRSIZ(INDESC).EQ.0 .AND. NBCORR(INDESC).EQ.-1)
     %   )THEN
            IF((KEY.LT.  0 ))THEN
               FSTPOS=QDRERR('FSTPOS',' KEY NOT VALID ',29,6)
               RETURN
            ELSE 
               NXTSEQ(INDESC) = 1 +30*(ishft(KEY,-( 8)))
               CURSEQ(INDESC) = NXTSEQ(INDESC)
            ENDIF 
         ELSE 
            WRITE(LOGFIL,*)' PAS DE POSITIONNEMENT FILE RANDOM STD '
            RETURN

*
         ENDIF 
      ENDIF 
      NUMREC(INDESC) = -1
*      ----------------------------------------------------------------

      RETURN
      END

***FONCTION FSTPRM OBTENIR L'INFORMATION RELIEE A L ENREGISTREMENT
*
      FUNCTION FSTPRM( KEY,CDATE,CDEET,CNPAS,CNI,CNJ,CNK,CNBITS,
     %CDATYP,CIP1,CIP2,CIP3,CTYPVAR,CNOMVAR,CETIKET,CGRTYP,CIG1,CIG2
     %,CIG3,CIG4,CSWA,CLNG,CDLTF,CUBC,EXTRA1,EXTRA2,EXTRA3)
*

      IMPLICIT NONE
      INTEGER FSTPRM
      INTEGER   KEY,CDATE,CDEET,CNPAS,CNI,CNJ,CNK,CDATYP,CNBITS,CIP1
     %,CIP2,CIP3,CIG1,CIG2,CIG3,CIG4,CSWA,CLNG,CDLTF,CUBC,EXTRA1,
     %EXTRA2,EXTRA3
      CHARACTER *(*) CTYPVAR,CNOMVAR,CETIKET,CGRTYP
*
*
*AUTEUR   M. VALIN JUILLET 1989 DORVAL DRPN CANADA P.Q.
*
*REVISION 000  (AUTREFOIS PARAMS - PARAMX)
*         001  MODIFICATION DU TEST DE KEY NOT VALID
*
*LANGAGE  RATFOR
*
*OBJET(FSTPRM)
*         CETTE FONCTION RETOURNE SOUS FORME DECOMPACTEE L'INFORMATION
*         CONTENUE DANS L ENTREE DU DIRECTEUR ASSOCIE A UN ENREGISTREMENT
*         PARTICULIER D UN FICHIER STANDARD 89. IUN ET KEY SPECIFIENT
*         LE FICHIER ET L ENREGISTREMENT. SI SEQUENTIEL L'INFORMATION
*         RETOURNEE CONCERNE L'ENREGISTREMENT COURANT.
*
*
*ARGUMENTS
*  IN    KEY        POSITION DE L'ENREGISTREMENT [POSITIF]
*  OUT   CDATE      DATE TIME STAMP CMC ENTIER, SMMJJAAZZR TEMPS ZERO PREVISION
*  OUT   CDEET      PAS DE TEMPS ENTIER (SECONDES, MAX 32767)
*  OUT   CNPAS      NUMERO DU PAS DE TEMPS ENTIER, MAX 32767
*  OUT   CNI        PREMIERE DIMENSION DU CHAMP, MAX 32767
*  OUT   CNJ        DEUXIEME DIMENSION, MAX 32767
*  OUT   CNK        TROISIEME DIMENSION, MAX 4095
*  OUT   CNBITS     NOMBRE DE BITS QU'OCCUPE CHAQUE DONNEE.
*  OUT   CDATYP     TYPE DES DONNEES POUR COMPRESSION 0=BINAIRE  1=REEL
*                   2=ENTIER  3=CARACTERE
*  OUT   CIP1       DESCRIPTEUR 1, MAX 32767 (NORMALEMENT NIVEAU)
*  OUT   CIP2       DESCRIPTEUR 2, MAX 32767    HEURE
*  OUT   CIP3       DESCRIPTEUR 3, MAX 4095     LIBRE
*  OUT   CTYPVAR    TYPE DE CHAMP, 1 CARACTERE FORMAT L (HOLLERITH)
*  OUT   CNOMVAR    NOM DU CHAMP, 2 CARACTERES FORMAT L (HOLLERITH)
*  OUT   CETIKET    ETIQUETTE, 8 CARACTERES, SENS DEFINI PAR USAGER
*  OUT   CGRTYP     TYPE DE GRILLE, 1 CARACTERE FORMAT L (HOLLERITH)
*  OUT   CIG1       DESCRIPTEUR DE GRILLE 1, ENTIER, MAX 2047
*  OUT   CIG2       DESCRIPTEUR DE GRILLE 2, ENTIER, MAX 2047
*  OUT   CIG3       DESCRIPTEUR DE GRILLE 3, ENTIER, MAX 65535
*  OUT   CIG4       DESCRIPTEUR DE GRILLE 4, ENTIER, MAX 65535
*  OUT   CSWA       ADRESSE EN MOTS DISQUE (16 BITS) DES DONNEES ORG=0
*  OUT   CLNG       LONGUEUR EN MOTS DISQUE DES DONNEES
*  OUT   CDLTF      MARQUEUR D'EFFACEMENT  1= EFFACE
*  OUT   CUBC       'UNUSED BIT COUNT'
*  OUT   EXTRA1     PARAMETRE DE SORTIE POUR EXTENSION[NOS]   NOSVE=0
*  OUT   EXTRA2     PARAMETRE DE SORTIE POUR EXTENSION[NOS]   NOSVE=0
*  OUT   EXTRA3     PARAMETRE DE SORTIE POUR EXTENSION[NOS]   NOSVE=0
*
*MESSAGES
*
*       FSTERRO('FSTPRM',' KEY NOT VALID  ', ERRKNV, FSTPRM )
*       FSTERRO('FSTPRM','FILE NOT OPEN', ERRFNO, FSTPRM )
*
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*MODULES
*

      EXTERNAL  QDRGET, QSTUPC, QSTARG, INCDAT
      INTEGER   QDRGET
**

      INTEGER IQGET, INDESC, I, NHOURS
*------------------------------------------------------------------------

      FSTPRM = 0
      INDESC = IAND(KEY,255)
      IF((KEY.LT. 0 .OR. INDESC.GT.40 ))THEN
         FSTPRM =QDRERR('FSTPRM',' KEY NOT VALID  ', 29,6)
         RETURN

*
*
      ENDIF 
      IF(( IUNTAB(INDESC).EQ. -1))THEN
         FSTPRM =QDRERR('FSTPRM','FILE NOT OPEN', 15,6)
         RETURN

*
*-------------------------------------------------------------------
*
      ENDIF 
      IF((DIRSIZ(INDESC).NE. 0))THEN
         IQGET = QDRGET(CURSLT(1,INDESC), KEY ,1)
         IF((IQGET.NE. 0))THEN
            FSTPRM = IQGET
            RETURN
         ENDIF 
      ELSE 
         IF((NUMREC(INDESC).LE. 0 ))THEN
            FSTPRM =QDRERR('FSTPRM',' NO VALID RECORD AVAILABLE', 28
     %      ,4)
            RETURN

*-------------------------------------------------------------------------
*                                 #  SEQUENTIEL / RANDOM UNPACK MEMOIR
         ENDIF 
      ENDIF 
      CALL QSTUPC(CURSLT(1,INDESC))
*--------------------------------------------------------------------------
*

      FSTPRM = KEY
*
*     TRANSFER DU COMMON BLOCK FSTC88 AUX ARGUMENTS DE FSTPRM
*

      CALL QSTARG(CDATE,CDEET,CNPAS,CNI,CNJ,CNK,CIP1,CIP2,CIP3,
     % CTYPVAR,CNOMVAR,CETIKET,CGRTYP,CIG1,CIG2,CIG3,CIG4,CDATYP,
     %CSWA,CLNG,CDLTF,CUBC,CNBITS,.FALSE.)
      CNK = MAX(1,CNK)
*
*--------------------------------------------------------------------------
*
*
*     TRANSFORMER LA DATE EN DATE D ORIGINE
*

      NHOURS = (CDEET*CNPAS + 1800) / 3600
      IF((NHOURS.GT. 0 ))THEN
         CALL INCDAT(CDATE, CDATE, -NHOURS)
*
*

      ENDIF 
      RETURN
      END

***FONCTION FSTRWD  POSITIONNER LE FICHIER IUN AU DEBUT
*
      FUNCTION FSTRWD(IUN)
      IMPLICIT NONE
      INTEGER FSTRWD
      INTEGER IUN
*
*AUTEUR  M. VALIN JAN 1990
*
*REVISION   000 NOUVELLE VERSION JANV 1990
*
*LANGAGE RATFOR
*
*OBJET(FSTRWD)
*         FICHIER RANDOM AUCUN EXECUTION
*         FICHIER SEQ/FTN REWIND FICHIER AU DEBUT
*         FICHIER SQI METTRE LES POINTEURS AU DEBUT.
*
*ARGUMENTS
*
*  IUN   - NUMERO D UNITE FORTRAN
*
*IMPLICITES
*

      EXTERNAL QSTINT,FSTCKP,QDRERR
      INTEGER  QSTINT,FSTCKP,QDRERR
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER INDESC,IER
*

      FSTRWD = 0
      INDESC = QSTINT(IUN)
      IF( (INDESC.GE.40))THEN
         FSTRWD=QDRERR('FSTRWD',' FILE NOT OPEN ',15,4)
         RETURN

*      ---------------------------------------------------------------
      ENDIF 
      IF((DIRSIZ(INDESC).EQ.0 .AND. NBCORR(INDESC).EQ.0))THEN
         REWIND(IUN)
         NUMREC(INDESC) = -1

*      ---------------------------------------------------------------
      ELSE 
         IF((DIRSIZ(INDESC).EQ.0 .AND. NBCORR(INDESC).EQ.-1)
     %   )THEN
            CURSEQ(INDESC) = 1
            NXTSEQ(INDESC) = 1
            NUMREC(INDESC) = -1
*          IER = FSTCKP(IUN)


*      ---------------------------------------------------------------
         ELSE 
            NUMREC(INDESC) = -1

*      ----------------------------------------------------------------
*
         ENDIF 
      ENDIF 
      RETURN
*
*      ----------------------------------------------------------------
*

      END

***FONCTION FSTSKP   RECULE OU AVANCE DE X RECORD(S)
*
      FUNCTION FSTSKP(IUN, NREC)
      IMPLICIT NONE
      INTEGER FSTSKP
      INTEGER IUN, NREC
*
*AUTEUR  M. VALIN JAN 1990
*
*REVISION   000 NOUVELLE VERSION JANV 1990
*
*LANGAGE RATFOR
*
*OBJET(FSTSKP)
*         POUR UN FICHIER SEQ/FTN ON EXECUTE NREC X BACKSPACE POUR
*         RECCULER OU NREC X READ(IUN) SYSTEM RECULE OU AVANCE UN EOR
*         POUR UN FICHIER SEQ/RND METTRE LES POINTEURS AU RECORD DEMANDER
*         NE FAIT RIEN POUR UN FICHIER RANDOM.
*
*ARGUMENTS
*  IUN   - NUMERO D UNITE FORTRAN
*  NREC  - NOMBRE DE RECORDS SI NEGATIF RECULE POSITIF AVANCE (SEQ)
*
*IMPLICITES
*

      EXTERNAL QSTINT,QDRERR,FSTINF,FSTSUI,WAREAD,QSTUPA,QSTEOI,
     %FSTAPP
      INTEGER  QSTINT,QDRERR,FSTINF,FSTSUI,QSTEOI,IEOI,FSTAPP,IAPP
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER INDESC, BUFFER(30), I, IGET, NSKIP, IERR
      FSTSKP = 0
*                                    VALIDER IUN

      IF(( IUN.LT. 0 .OR. IUN.GT. 99 ))THEN
         FSTSKP=QDRERR('FSTSKP',' NUMERO IUN INVALIDE', 31,6)
         RETURN

*
      ENDIF 
      INDESC = QSTINT(IUN)
      IF((INDESC.GT.40))THEN
         FSTSKP=QDRERR('FSTSKP',' FICHIER PAS OUVERT' , 15,6)
         RETURN

*
      ENDIF 
      NSKIP = ABS(NREC)
*
*      ---------------------------------------------------------------

      IF((DIRSIZ(INDESC).EQ.0 .AND. NBCORR(INDESC).EQ.0))THEN
         IF((NREC.LT. 0 ))THEN
            DO 23008 I= 1, NSKIP
               BACKSPACE(IUN)
23008       CONTINUE 
         ELSE 
            DO 23010 I= 1,NSKIP
               READ(IUN,ERR=99,END=999 )
23010       CONTINUE 
         ENDIF 
         NUMREC(INDESC) = -1

*      ---------------------------------------------------------------
      ELSE 
         IF((DIRSIZ(INDESC).EQ.0 .AND. NBCORR(INDESC).EQ.-1)
     %   )THEN
            IF((NREC.LT.  0 ))THEN
               DO 23016 I=1,NSKIP
                  IF((NXTSEQ(INDESC).GT. CURSEQ(INDESC)))THEN
                     NXTSEQ(INDESC) = CURSEQ(INDESC)
                  ELSE 
                     IF((NXTSEQ(INDESC).GT. 1))THEN
                        CALL WAREAD(IUN, BUFFER, NXTSEQ(INDESC),30)
                        IF((BUFFER(30).NE. SQSYNC))THEN
                           IAPP = FSTAPP(INDESC)
                           WRITE(LOGFIL,*)
     %                     ' MAUVAIS RECORD LU FSTSKP BACKSPACE'
                           WRITE(LOGFIL,*)
     %                     ' RELIRE AVEC FSTAPP DU DEBUT ET QSTEOI '
                           FSTSKP=QDRERR('FSTSKP',
     %                     ' MAUVAIS RECORD LU' , 42,4)
                           RETURN
                        ENDIF 
                        CURSEQ(INDESC) =IAND(ishft(BUFFER((1+ishft(
     %                   575,-(5)))),-((31-IAND( 575,31)))),ishft(-1
     %                  ,-(32-( 32))))
                        CURSEQ(INDESC) = 1 + CURSEQ(INDESC)*30
                        NXTSEQ(INDESC) = CURSEQ(INDESC)
                     ENDIF 
                  ENDIF 
23016          CONTINUE 
            ELSE 
               DO 23024 I =1,NSKIP
                  CALL WAREAD(IUN, BUFFER, NXTSEQ(INDESC),30)
                  IF((BUFFER(30).NE. SQSYNC))THEN
                     IEOI = QSTEOI(INDESC)
                     WRITE(LOGFIL,*)' MAUVAIS RECORD LU FSTSKP '
                     WRITE(LOGFIL,*)' ECRIT FIN DE FICHIER QSTEOI '
                     FSTSKP=QDRERR('FSTSKP',' MAUVAIS RECORD LU' ,
     %                42,4)
                     RETURN
                  ENDIF 
                  CURSEQ(INDESC) = NXTSEQ(INDESC)
                  IGET =IAND(ishft(BUFFER((1+ishft( 511,-(5)))),-((
     %            31-IAND( 511,31)))),ishft(-1,-(32-( 32))))
                  IF((IGET.GT. 14))THEN
                     GOTO 23025
                  ENDIF 
                  IF((IGET.GT. 0 ))THEN
                     NXTSEQ(INDESC) = NXTSEQ(INDESC) +30
                     NRECUP(INDESC) = IGET
                  ENDIF 
                  CALL QSTUPA(BUFFER)
                  NXTSEQ(INDESC)=CURSEQ(INDESC)+30*((LNG+30-1)/30+1)
23024          CONTINUE 
23025          CONTINUE 
            ENDIF 
            NUMREC(INDESC) = -1

*      ---------------------------------------------------------------
         ELSE 
            NUMREC(INDESC) = -1

*
         ENDIF 
      ENDIF 
      RETURN
*

99    NUMREC(INDESC) = -1
      FSTSKP=QDRERR('FSTSKP',' ERREUR SUR READ SEQ I/O' , 25,4)
      RETURN
*

999   NUMREC(INDESC) = -1
      FSTSKP=QDRERR('FSTSKP',' FIN DU FICHIER' , 26,2)
      RETURN
      END

***FONCTION FSTSUI , TROUVER L' ENREGISTREMENT SUIVANT
*
      FUNCTION FSTSUI( IUN, NIOUT, NJOUT, NKOUT )
*

      IMPLICIT NONE
      INTEGER FSTSUI
      INTEGER IUN, NIOUT, NJOUT, NKOUT
      INTEGER QSTSUI
*
*AUTEUR   M. VALIN  -  FEV 89  ( AUTREFOIS INFSUI )
*
*REVISION  0.0.0 NOUVELLE VERSION JANV 1989
*          1.0.1 MODIFICATIONS POUR FICHIER SEQ/RND
*
*LANGAGE RATFOR
*
*OBJET (FSTSUI)
*           CETTE FUNCTION CHERCHE LE PROCHAIN ENREGISTREMENT SATISFAISANT
*           LES CRITERES DE RECHERCHE SPECIFIES PAR LES ARGUMENTS DE
*           LA FUNCTION [FSTINF, FSTSUI, FSTLIR, FSTLIS] DEJA APPELER.
*
*MESSAGES   FSTERRO CODE[ 5]   'FICHIER PAS OUVERT'
*           LOGFIL  ' GET REC DU FICHIER RANDOM DANS FSTSUI'
*           LOGFIL  ' UNPACK ENTRE PAIR DANS FICHIER SEQ DANS FSTSUI'
*           FSTWARN('FSTSUI','END OF FILE LOGIQUE', ERREOF, FSTSUI )
*           WRITE(LOGFIL,*)' FIN DU FICHIER SEQ UNIT= ',IUNTAB(INDESC)
*           FSTERRO('FSTSUI','ERREUR SUR READ SEQ  I/O  ', ERRIO, FSTSUI )
*
*ARGUMENTS
*  OUT      NIOUT    PREMIERE DIMENSION
*  OUT      NJOUT    DEUXIEME DIMENSION
*  OUT      NKOUT    TROISIEME DIMENSION
*  IN       IUN      NUMERO D'UNITE FORTRAN
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL QSTINT,QDRGET,QSTUPA,QSTPKC,QSTUPC,WAREAD
      INTEGER  QSTINT,QDRGET
**

      LOGICAL MATCH
      INTEGER BUFFER(30), INDESC
      INTEGER KEY, I, J, II, I0, ISEQ, IGET, INDESC0
*-----------------------------------------------------------------------
*
*    VA CHERCHE L'INDEX DU FICHIER IUN (FICHIER DOIT ETRE OUVERT)
*

      INDESC = QSTINT(IUN)
      INDESC0 = INDESC
      IF(( INDESC.GT.40  ))THEN
         FSTSUI =QDRERR('FSTSUI','FICHIER PAS OUVERT', 15,4)
         RETURN

*
*-----------------------------------------------------------------------
*
      ENDIF 
1000  I0 = 64 /32
      INDESC = EFFDSC(INDESC0)
*
*    SI NUMREC < 0  ON ESSAI DE FAIRE UN FSTSUI DIRECTEMENT
*    ON DOIT FAIRE UN FSTINF OU FSTLIR OU FSTLIS AVANT
*

      IF((NUMREC(INDESC).LT. 0  ))THEN
         FSTSUI =QDRERR('FSTSUI','NO VALID RECORD AVAILABLE', 28,4)
         NUMREC(INDESC) = -1
         RETURN

*-----------------------------------------------------------------------
      ENDIF 
      DO 23004 I = NUMREC(INDESC), NUTIL(INDESC) -1

*
         IF((DIRSIZ(INDESC).EQ. 0))THEN
            IF((NBCORR(INDESC).EQ. 0))THEN
               BUFFER(30) = 0
               ISEQ = 15
               READ( IUNTAB(INDESC), ERR=99, END=100) BUFFER
            ELSE 
               BUFFER(30) = 0
               CALL WAREAD(IUNTAB(INDESC), BUFFER, NXTSEQ(INDESC),30
     %         )

*
            ENDIF 
            IF((BUFFER(30).NE. SQSYNC))THEN
               GO TO 99
*
*          UNPACK ENREE PAIRE
*

            ENDIF 
            IF((MSGLVL.LE.0))THEN
               WRITE(LOGFIL,*)
     %         ' UNPACK ENTRE PAIR FICHIER SEQ DANS FSTSUI'
            ENDIF 
            CALL QSTUPA( BUFFER )
            KEY = INDESC
            ISEQ =IAND(ishft( BUFFER((1+ishft( 511,-(5)))),-((31-
     %      IAND( 511,31)))),ishft(-1,-(32-( 32 ))))
            IF((NBCORR(INDESC).EQ. -1 .AND. ISEQ.LT. 15 ))THEN
               CURSEQ(INDESC) = NXTSEQ(INDESC)
               NXTSEQ(INDESC) = NXTSEQ(INDESC)+30*((LNG+30-1)/30+1)
               KEY = INDESC +ishft((CURSEQ(INDESC)-1)/30, 8)
            ENDIF 
            IF( ( ISEQ.GT. 0 ))THEN
               GO TO 110
            ENDIF 
            CALL QSTPKC( CURSLT(1, INDESC ))
            NUMREC(INDESC) = 1

*-----------------------------------------------------------------------
         ELSE 
            IF((MSGLVL.LE.0))THEN
               WRITE(LOGFIL,*)
     %         ' GET REC DU FICHIER RANDOM DANS FSTSUI'
            ENDIF 
            NUMREC(INDESC) = I + 1
            KEY  =ishft( I,  8) + INDESC
            IGET = QDRGET(BUFFER, KEY, 1)
            IF((IGET.NE. 0 ))THEN
               FSTSUI = IGET
               RETURN
            ENDIF 
            IF(((IAND(ishft(BUFFER((1+ishft( 60,-(5)))),-((31-IAND(
     %       60,31)))),ishft(-1,-(32-( 1))))) .NE.0))THEN
               GOTO 23004
            ENDIF 
            DO 23024 J = 1, 12
               CURSLT(J, INDESC) = BUFFER(J)
23024       CONTINUE 

*----------------------------------------------------------------------
*
*       COMPARER CURSLT AVEC SEARCH POUR UN MATCH
*
         ENDIF 
         MATCH = .TRUE.
         DO 23026 II = 1, 6
            MATCH = MATCH .AND.   (IAND(IEOR(CURSLT(I0 + II, INDESC)
     %      ,SEARCH(II,INDESC)),MASQUE(II, INDESC)).EQ. 0 )

*
23026    CONTINUE 
         IF((MATCH ))THEN
            CALL QSTUPC(CURSLT(1,INDESC))
            NIOUT = NI
            NJOUT = NJ
            NKOUT = NK
            FSTSUI = KEY
            RETURN

*
*       PAS DE MATCH  VA CHERCHER UN AUTRE RECORD
*
         ENDIF 

*
23004 CONTINUE 
      IF( (CHAINE(INDESC) .NE. 0))THEN
         EFFDSC(INDESC0) = CHAINE(INDESC)
         NUMREC(CHAINE(INDESC)) = 0
         DO 23032 I = 1, 6
            SEARCH(I,CHAINE(INDESC)) = SEARCH(I,INDESC)
            MASQUE(I,CHAINE(INDESC)) = MASQUE(I,INDESC)
23032    CONTINUE 
         GOTO 1000

*
      ENDIF 
      FSTSUI = -27
      RETURN
*
*-----------------------------------------------------------------------
*

99    CONTINUE
      FSTSUI =QDRERR('FSTSUI','ERREUR SUR READ SEQ  I/O  ', 25,6)
      RETURN
*

100   NUMREC(INDESC) = -1
      WRITE(LOGFIL,*)' FIN DU FICHIER SEQ UNIT= ',IUNTAB(INDESC)
      NRECUP(INDESC) = -1
      FSTSUI = -1
      RETURN
*

110   NRECUP(INDESC) = ISEQ
      NUMREC(INDESC) = -1
      FSTSUI =QDRERR('FSTSUI','END OF FILE LOGIQUE', 26,2)
      RETURN
*
*-----------------------------------------------------------------------
*

      ENTRY QSTSUI(IUN, NIOUT, NJOUT, NKOUT)
      INDESC = IUN
      INDESC0 = INDESC
      GO TO 1000
*

      END

***FONCTION FSTVOI, VOIR UN FICHIER STANDARD
*
      FUNCTION FSTVOI( IUN, OPTIONS )
      IMPLICIT NONE
      INTEGER FSTVOI
      CHARACTER *(*) OPTIONS
      INTEGER IUN
*
*AUTEUR   M. VALIN  -  FEV 89  ( AUTREFOIS VOIR )
*
*
*REVISION  000 NOUVELLE VERSION FEV 1989
*
*LANGAGE RATFOR
*
*OBJET (FSTVOI)
*               IMPRIMER LE CONTENU DU DIRECTEUR D'UN FICHIER STANDARD
*
*MESSAGES
*         FSTWARN('FSTVOI',' FILE DOES NOT EXIST',ERRFNE,FSTVOI)
*         FSTWARN('FSTVOI',' INVALIDE PARAMETRE QQQFNOM',ERRIPQ,FSTVOI)
*         WRITE(LOGFIL,*)' FSTVOI APRES QDRGET FICHIER RANDOM'
*         WRITE(LOGFIL,*)' FSTVOI ENTREE PAIR FICHIER SEQUENTIEL'
*         WRITE(LOGFIL,902) FILNOM,FILTYP,DAT,TIM,NUMPAG
* 902 FORMAT('1',1X,'FILE=',A66,'TYPE=',A12,2X,A15,2X,A10,3X,'PAGE',I4,//,
*     '   KEY#  ID    IP1   IP2  IP3    NI    NJ   NK',
*     ' ETIQ.    DATE ORIG.  DEET  NPAS GR  IG1  IG2   IG3   IG4',
*     ' DTY     SWA   LNG')
*
* 904 FORMAT(//'0STATISTIQUES',/,/,' DIMENSION DU DIRECTEUR DISQUE',
*      I10,/,' NOMBRE D ENTREES UTILISEES   ', I10,/,
*     ' LONGUEUR DU FICHIER          ', I10, ' MOTS',/,
*     ' NOMBRE D ECRITURES           ', I10,/,
*     ' NOMBRE DE RE-ECRITURES       ', I10,/,
*     ' NOMBRE D EFFACAGES           ', I10,/,
*     ' NOMBRE D EXTENSIONS          ', I10,/,
*     ' NOMBRE DE CORRECTIONS        ', I10)
*
* 905 FORMAT(/,' ***   FICHIER VIDE  *** ')
*
*     FSTERRO('FSTVOI', 'ERREUR SUR READ SEQ I/O ', ERRIO, FSTVOI)
*        WRITE(LOGFIL,*)'  VOIR FICHIER IUN= ',IUN
*        WRITE(LOGFIL,*)' END OF FILE LOGIQUE  '
*
*
*ARGUMENTS
*  OUT      FSTVOI   0=OK ERREUR < 0
*  IN       IUN      NUMERO D'UNITE FORTRAN
*  IN       OPTIONS  'SEQ'= FICHIER SEQUENTIEL
*                    'RND'= FICHIER RANDOM
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*MODULES

      EXTERNAL FSTOUV,QSTUPA,QSTUPB,QSTUPC,QDRGET,QSTINT,SYSTMDT,
     %QSTWPM,QQQFNOM,FSTNBR,NUMBLKS,WAREAD
      INTEGER  FSTOUV,QDRGET,QQQFNOM,QSTINT,FSTNBR,NUMBLKS,IRECORD
**

      CHARACTER * 66 FILNOM
      CHARACTER * 12 FILTYP
      CHARACTER * 15 DAT
      CHARACTER * 10 TIM
      CHARACTER * 3 TYPE
      LOGICAL  ISRAND, ISEQRND, ISEQFTN
      INTEGER  INDESC, TABLE(30), IOUVR, IGET, I   , LREC
      INTEGER  KEY,   INX, IQF,   ISEQ,  IDIM, NUMPAG, NUMLIG
*

      DATA  TABLE(1)/-1/,   IOUVR/0/
*
*--------------------------------------------------------------------------
*

      FSTVOI = 0
*
*      VERIFIER SI FICHIER EXISTE AVANT DE L'OUVRIR SEULEMENT 'RND'
*

      IF((INDEX(OPTIONS,'RND') .NE. 0))THEN
         IF((NUMBLKS(IUN).LE.0))THEN
            FSTVOI=QDRERR('FSTVOI',' FILE EMPTY/DOES NOT EXIST', 12,
     %      4)
            RETURN
         ENDIF 

*-----------------------------------------------------------------------
      ENDIF 
      INDESC = QSTINT(IUN)
      IF( (INDESC.GT.40))THEN
         IOUVR = FSTOUV(IUN, OPTIONS)
         IF((IOUVR.LT. 0 ))THEN
            FSTVOI = IOUVR
            RETURN
         ENDIF 
         INDESC = QSTINT( IUN )

*--------------------------------------------------------------------------
*
*      EXTRAIRE LA DATE ET L HEURE DU SYSTEME AU MOMENT DE L'EXECUTION
*
      ENDIF 
      CALL SYSTMDT ( DAT, TIM )
      IF(( DIRSIZ(INDESC).GT. 0 ))THEN
         FILTYP ='RANDOM      '
      ELSE 
         FILTYP =' SEQUENTIEL '
*
*
*--------------------------------------------------------------------------
*
*      VA CHERCHER LE NOM DU FICHIER
*

      ENDIF 
      IQF = QQQFNOM(IUN, FILNOM, TYPE, LREC)
      IF((IQF.LT. 0))THEN
         FSTVOI=QDRERR('FSTVOI',' INVALIDE PARAMETRE QQQFNOM',32,4)
         RETURN

*---------------------------------------------------------------------------
      ENDIF 
      NUMPAG = 0
      NUMLIG = 0
      IRECORD = 0
*

      DO 23012 INX = 0, NUTIL(INDESC)-1

*         --------------------------------------------------------
         IF(( DIRSIZ(INDESC).GT. 0 ))THEN
            KEY =ishft(INX,  8) + INDESC
            ISEQ = 15
            IGET = QDRGET ( TABLE, KEY, 1 )
            IF((MSGLVL.LE.0))THEN
               WRITE(LOGFIL,*)' FSTVOI APRES QDRGET FICHIER RANDOM'
            ENDIF 
            CALL QSTUPC(TABLE)
            IF(( DLTF.NE. 0 ))THEN
               GOTO 23012
            ENDIF 
            IF(( SWA.EQ.1 ))THEN
               GOTO 23013

*
            ENDIF 

*         -----------------------------------------------------------------
         ELSE 
            IF((DIRSIZ(INDESC).EQ. 0 ))THEN
               ISEQ = 15
               TABLE(30) = 0
               IF(( NBCORR(INDESC).EQ.0))THEN
                  READ(IUN, ERR=99, END=1000) TABLE
                  IRECORD = IRECORD + 1
               ELSE 
                  CALL WAREAD(IUN, TABLE, NXTSEQ(INDESC),30)
                  IRECORD = IRECORD + 1
               ENDIF 
               IF((TABLE(30).NE. SQSYNC))THEN
                  GO TO 99
*
*            UNPACK ENTREE PAIRE
*

               ENDIF 
               IF((MSGLVL.LE.0))THEN
                  WRITE(LOGFIL,*)
     %            ' FSTVOI ENTREE PAIR FICHIER SEQUENTIEL'
               ENDIF 
               CALL QSTUPA ( TABLE(1) )
*

               IF((NBCORR(INDESC).EQ. -1))THEN
                  CURSEQ(INDESC)= NXTSEQ(INDESC)
                  NXTSEQ(INDESC)=NXTSEQ(INDESC)+30*((LNG+30-1)/30+1)

*
               ENDIF 
               KEY = 0
*

               ISEQ =IAND(ishft( TABLE((1+ishft( 511,-(5)))),-((31-
     %         IAND( 511,31)))),ishft(-1,-(32-( 32 ))))
               IF((ISEQ.GT. 0 ))THEN
                  GO TO 110
               ENDIF 

*            --------------------------------------------------------------
            ELSE 
               WRITE(LOGFIL,*)' FICHIER NON STANDARD FSTVOI'
               STOP

*---------------------------------------------------------------------------
*
            ENDIF 
         ENDIF 
         IF(( MOD(NUMLIG,60).EQ. 0 ))THEN
            NUMPAG = NUMPAG + 1
            IF((MSGLVL.LE.2 ))THEN
               WRITE(LOGFIL,902) FILNOM,FILTYP,DAT,TIM,NUMPAG
            ENDIF 
         ENDIF 
         IF(( MOD(NUMLIG,5).EQ. 0 ))THEN
            IF((MSGLVL.LE.2 ))THEN
               WRITE(LOGFIL,901)
            ENDIF 
            NUMLIG = NUMLIG + 1

*--------------------------------------------------------------------------
         ENDIF 
         NUMLIG = NUMLIG + 1
*

         IF((MSGLVL.LE.2 ))THEN
            CALL QSTWPM ( KEY, ' ' )

*
         ENDIF 

*----------------------------------------------------------------------
*
*     IMPRIMER LES STATISTIQUES
*
23012 CONTINUE 
23013 CONTINUE 
      IF((MSGLVL.LE.2 ))THEN
         IF((INX.EQ.0))THEN
            WRITE(LOGFIL,902) FILNOM,FILTYP,DAT,TIM,NUMPAG
         ENDIF 
         IF((INX.EQ.0))THEN
            WRITE(LOGFIL,905)
         ENDIF 
         IF((DIRSIZ(INDESC).GT. 0 ))THEN
            WRITE(LOGFIL,904) DIRSIZ(INDESC), NUTIL (INDESC),NXTADR(
     %      INDESC)-1,NBECR (INDESC), NBRECR(INDESC), NBEFF(INDESC),
     %      NBEXT(INDESC), NBCORR(INDESC)
         ELSE 
            IF((DIRSIZ(INDESC).EQ. 0 ))THEN
               WRITE(LOGFIL,906) IRECORD
            ENDIF 
         ENDIF 

*
      ENDIF 
      NUMREC(INDESC) = -1
      RETURN
*
*--------------------------------------------------------------------------

901   FORMAT(1X)
*

902   FORMAT('1',1X,'FILE=',A66,'TYPE=',A12,2X,A15,2X,A10,3X,'PAGE',
     %I4,//,'      KEY#  ID    IP1   IP2  IP3   NI    NJ   NK',
     %'  ETIQ.   DATE ORIG.   DEET    NPAS GR  IG1  IG2   IG3   IG4'
     %,' DTY     SWA   LNG')
*

906   FORMAT(//' STATISTIQUES',/,/,' FICHIER SEQUENTIEL  # RECS= ',
     %I10//,' *************************************** ')
*

904   FORMAT(//' STATISTIQUES',/,/,' DIMENSION DU DIRECTEUR DISQUE',
     %I10,/,' NOMBRE D ENTREES UTILISEES   ', I10,/,
     %' LONGUEUR DU FICHIER          ', I10, ' MOTS',/,
     %' NOMBRE D ECRITURES           ', I10,/,
     %' NOMBRE DE RE-ECRITURES       ', I10,/,
     %' NOMBRE D EFFACAGES           ', I10,/,
     %' NOMBRE D EXTENSIONS          ', I10,/,
     %' NOMBRE DE CORRECTIONS        ', I10,//,
     %' ***************************************** ')
905   FORMAT(/,' ***   FICHIER VIDE  *** ')
*

99    CONTINUE
      FSTVOI=QDRERR('FSTVOI', 'ERREUR SUR READ SEQ I/O ', 25,6)
      RETURN
*

1000  NUMREC(INDESC) = -1
      WRITE(LOGFIL,906) IRECORD
      IF((MSGLVL.LE.0))THEN
         WRITE(LOGFIL,*)' FIN DU FICHIER SEQUENTIEL'
      ENDIF 
      IF((MSGLVL.LE.4 .AND. INX.EQ.0))THEN
         WRITE(LOGFIL,902) FILNOM,FILTYP,DAT,TIM,NUMPAG
         WRITE(LOGFIL,905)
      ENDIF 
      FSTVOI = 0
      RETURN
*

110   CONTINUE
      IF((MSGLVL.LE.2 ))THEN
         IRECORD = IRECORD - 1
*        WRITE(LOGFIL,*)'  VOIR FICHIER IUN= ',IUN
*        WRITE(LOGFIL,*)' END OF FILE LOGIQUE  '

         WRITE(LOGFIL,906) IRECORD
      ENDIF 
      FSTVOI = 0
      RETURN
*

      END

***FONCTION FSTWEOF , ECRIRE UN SEPARATEUR LOGIQUE DE FICHIER.
*
      FUNCTION FSTWEO( IUN , NNIV)
*

      IMPLICIT NONE
      INTEGER FSTWEO
      INTEGER IUN, NNIV
      INTEGER QSTSUI
*
*AUTEUR   M. VALIN  -  JUILLET 89  ( AUTREFOIS STDWEOF )
*
*REVISION  000 NOUVELLE VERSION JANV 1989
*
*LANGAGE RATFOR
*
*OBJET (FSTWEO)
*           ECRIRE UN SEPARATEUR LOGIQUE (DE NIVEAU NNIV) DANS UN FICHIER
*           SEQUENTIEL STANDARD.
*
*MESSAGES   PAR FSTERR  CODE[ 5]   ' FICHIER PAS OUVERT'
*               FSTERR  CODE[40]   ' FILE NOT SEQUENTIAL'
*
*ARGUMENTS
*  IN       IUN      NUMERO D'UNITE FORTRAN ASSOCIE AU FICHIER SEQ STANDARD
*  IN      NNIV      VALEUR DU NIVEAU DE SEPARATEUR (CHOIX DE L'USAGER)
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*NOTE
*        LA VALEUR DU NIVEAU ECRIT DOIT ETRE ENTRE 1 ET 14 SEPARATEUR DE
*        NIVEAU 15 INDIQUE UNE FIN DE FICHIER PHYSIQUE.
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL QSTINT, WAWRIT
      INTEGER  QSTINT
**

      INTEGER INDESC, NIV, IMOT, HEAD(30), I, HEAD2(30)
      SAVE HEAD, HEAD2
      DATA (HEAD(IMOT),IMOT=1,30) /28*0,O"25252525252",O
     %"25252525252"/
      DATA (HEAD2(IMOT),IMOT=1,30) /28*0,O"25252525252",O
     %"25252525252"/
*-----------------------------------------------------------------------

      DO 23000 I=1,28
         HEAD(I) = 0
         HEAD2(I) = 0

*
23000 CONTINUE 
      FSTWEO = 0
*
*       VA CHERCHE L'INDEX DU FICHIER IUN (FICHIER DOIT ETRE OUVERT)
*

      INDESC = QSTINT(IUN)
      IF(( INDESC.GT.40  ))THEN
         FSTWEO =QDRERR('FSTWEO','FICHIER PAS OUVERT', 15,4)
         RETURN

*
*-----------------------------------------------------------------------
*
      ENDIF 
      NIV = MIN(NNIV,14)
      IF((DIRSIZ(INDESC).EQ. 0 .AND. NBCORR(INDESC).EQ.  0 )
     %)THEN
         HEAD((1+ishft( 511,-(5))))=IOR(HEAD((1+ishft( 511,-(5)))),
     %   ishft(IAND( NIV,ishft(-1,-(32-( 32 )))),(31-IAND( 511,31)))
     %   )
         NRECUP(INDESC) = NIV
         WRITE(IUN) HEAD

*
      ELSE 
         IF((DIRSIZ(INDESC).EQ. 0 .AND. NBCORR(INDESC).EQ. -1 )
     %   )THEN
            HEAD((1+ishft( 511,-(5))))=IOR(HEAD((1+ishft( 511,-(5)))
     %      ),ishft(IAND( NIV,ishft(-1,-(32-( 32)))),(31-IAND( 511,
     %      31))))
            HEAD((1+ishft( 575,-(5))))=IOR(HEAD((1+ishft( 575,-(5)))
     %      ),ishft(IAND( ((CURSEQ(INDESC)-1)/30),ishft(-1,-(32-( 32
     %      )))),(31-IAND( 575,31))))
            NRECUP(INDESC) = NIV
            CALL WAWRIT(IUN, HEAD, NXTSEQ(INDESC),30)
            CURSEQ(INDESC) = NXTSEQ(INDESC)
            NXTSEQ(INDESC) = NXTSEQ(INDESC) +30
            HEAD2((1+ishft( 511,-(5))))=IOR(HEAD2((1+ishft( 511,-(5)
     %      ))),ishft(IAND( 31,ishft(-1,-(32-( 32)))),(31-IAND( 511,
     %      31))))
            HEAD2((1+ishft( 575,-(5))))=IOR(HEAD2((1+ishft( 575,-(5)
     %      ))),ishft(IAND( ((CURSEQ(INDESC)-1)/30),ishft(-1,-(32-(
     %       32)))),(31-IAND( 575,31))))
            CALL WAWRIT(IUN, HEAD2, NXTSEQ(INDESC),30)

*
         ELSE 
            FSTWEO =QDRERR('FSTWEO','FILE NOT SEQUENTIAL', 41,4)
            RETURN

*
         ENDIF 
      ENDIF 
      RETURN
      END

***FONCTION FSTZAP MODIFIER UN OU PLUSIEURS ELEMENTS DESCRIPTEURS
*
      FUNCTION FSTZAP( KEY,ZDATE,ZDEET,ZNPAS,ZIP1,ZIP2,ZIP3,ZTYPVAR,
     %ZNOMVAR,ZETIKET,ZGRTYP,ZIG1,ZIG2,ZIG3,ZIG4)
*

      IMPLICIT NONE
      INTEGER FSTZAP
      INTEGER   KEY,ZDATE,ZDEET,ZNPAS,ZIP1,ZIP2,ZIP3,ZIG1,ZIG2,ZIG3,
     %ZIG4
      CHARACTER *(*) ZTYPVAR,ZNOMVAR,ZETIKET,ZGRTYP
*
*
*AUTEUR   M. LEPINE - FEVRIER 1994
*
*LANGAGE  RATFOR
*
*OBJET(FSTZAP)
*         CETTE FONCTION PERMET DE MODIFIER LES ELEMENTS DESCRIPTEURS
*         CONTENUS DANS L ENTREE DU DIRECTEUR ASSOCIE A UN ENREGISTREMENT
*         PARTICULIER D UN FICHIER STANDARD 89.
*         SI LE FICHIER EST SEQUENTIEL, AUCUNE MODIFICATION N'EST PERMISE
*         POUR L'INSTANT.
*
*
*ARGUMENTS
*  IN    KEY        POSITION DE L'ENREGISTREMENT [POSITIF]
*  IN    ZDATE      DATE TIME STAMP CMC ENTIER, SMMJJAAZZR TEMPS ZERO PREVISION
*  IN    ZDEET      PAS DE TEMPS ENTIER (SECONDES, MAX 32767)
*  IN    ZNPAS      NUMERO DU PAS DE TEMPS ENTIER, MAX 32767
*  IN    ZIP1       DESCRIPTEUR 1, MAX 32767 (NORMALEMENT NIVEAU)
*  IN    ZIP2       DESCRIPTEUR 2, MAX 32767    HEURE
*  IN    ZIP3       DESCRIPTEUR 3, MAX 4095     LIBRE
*  IN    ZTYPVAR    TYPE DE CHAMP, 1 CARACTERE FORMAT L (HOLLERITH)
*  IN    ZNOMVAR    NOM DU CHAMP, 2 CARACTERES FORMAT L (HOLLERITH)
*  IN    ZETIKET    ETIQUETTE, 8 CARACTERES, SENS DEFINI PAR USAGER
*  IN    ZGRTYP     TYPE DE GRILLE, 1 CARACTERE FORMAT L (HOLLERITH)
*  IN    ZIG1       DESCRIPTEUR DE GRILLE 1, ENTIER, MAX 2047
*  IN    ZIG2       DESCRIPTEUR DE GRILLE 2, ENTIER, MAX 2047
*  IN    ZIG3       DESCRIPTEUR DE GRILLE 3, ENTIER, MAX 65535
*  IN    ZIG4       DESCRIPTEUR DE GRILLE 4, ENTIER, MAX 65535
*
*MESSAGES
*
*       FSTERRO('FSTZAP',' KEY NOT VALID  ', ERRKNV, FSTZAP )
*       FSTERRO('FSTZAP','FILE NOT OPEN', ERRFNO, FSTZAP )
*
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*MODULES
*

      EXTERNAL  QDRGET, QSTUPC, QSTARG, INCDAT
      INTEGER   QDRGET
**

      INTEGER IQGET, INDESC
      INTEGER   CDATE,CDEET,CNPAS,CNI,CNJ,CNK,CDATYP,CNBITS,CIP1,
     %CIP2,CIP3,CIG1,CIG2,CIG3,CIG4,CSWA,CLNG,CDLTF,CUBC
      CHARACTER  CTYPVAR*1,CNOMVAR*2,CETIKET*8,CGRTYP*1
      INTEGER IUN,L,DATEV
*------------------------------------------------------------------------

      IUN = KEY
      FSTZAP = 0
      INDESC = IAND(KEY,255)
      IF((KEY.LT. 0 .OR. INDESC.GT.40 ))THEN
         FSTZAP =QDRERR('FSTZAP',' KEY NOT VALID  ', 29,6)
         RETURN

*
*
      ENDIF 
      IF(( IUNTAB(INDESC).EQ. -1))THEN
         FSTZAP =QDRERR('FSTZAP','FILE NOT OPEN', 15,6)
         RETURN

*
*-------------------------------------------------------------------
*
      ENDIF 
      IF((DIRSIZ(INDESC).NE. 0))THEN
         IQGET = QDRGET(CURSLT(1,INDESC), KEY ,1)
         IF((IQGET.NE. 0))THEN
            FSTZAP = IQGET
            RETURN
         ENDIF 
      ELSE 
         FSTZAP =QDRERR('FSTZAP',' NOT A STANDARD RANDOM FILE', 16,4
     %   )
         RETURN

*-------------------------------------------------------------------------
*                                RANDOM UNPACK MEMOIR
      ENDIF 
      CALL QSTUPC(CURSLT(1,INDESC))
*--------------------------------------------------------------------------
*

      FSTZAP = KEY
*
*     TRANSFER DU COMMON BLOCK FSTC88 AUX VARIABLES LOCALES
*

      CALL QSTARG(CDATE,CDEET,CNPAS,CNI,CNJ,CNK,CIP1,CIP2,CIP3,
     % CTYPVAR,CNOMVAR,CETIKET,CGRTYP,CIG1,CIG2,CIG3,CIG4,CDATYP,
     %CSWA,CLNG,CDLTF,CUBC,CNBITS,.FALSE.)
*
*     TRANSFER DES ARGUMENTS DE FSTZAP AU COMMON BLOCK FSTC88
*

      IF( (ZDEET.NE. -1))THEN
         CDEET = ZDEET
      ENDIF 
      IF( (ZNPAS.NE. -1))THEN
         CNPAS = ZNPAS
      ENDIF 
      IF( (ZDATE.NE. -1))THEN
         CDATE = ZDATE
         DATEV = CDATE
         IF((CDEET*CNPAS.GT.0))THEN
            CALL INCDAT(DATEV,DATEV,(CDEET*CNPAS+1800)/3600)
         ENDIF 
         IF((32.GT. 32))THEN
            DATEV = MOD(DATEV,1000000000)
         ENDIF 
      ELSE 
         DATEV = CDATE
      ENDIF 
      IF( (ZIP1.NE. -1))THEN
         CIP1  = ZIP1
      ENDIF 
      IF( (ZIP2.NE. -1))THEN
         CIP2  = ZIP2
      ENDIF 
      IF( (ZIP3.NE. -1))THEN
         CIP3  = ZIP3
      ENDIF 
      IF( (ZTYPVAR.NE. ' '))THEN
         CTYPVAR = ZTYPVAR(1:1)
      ENDIF 
      IF( (ZNOMVAR.NE. ' '))THEN
         CNOMVAR = ZNOMVAR(1:2)
      ENDIF 
      IF( (ZETIKET.NE. ' '))THEN
         CETIKET = '        '
         L = LEN(ZETIKET)
         CETIKET(1:L) = ZETIKET(1:L)
      ENDIF 
      IF( (ZGRTYP.NE. ' '))THEN
         CGRTYP = ZGRTYP(1:1)
      ENDIF 
      IF( (ZIG1.NE. -1))THEN
         CIG1  = ZIG1
      ENDIF 
      IF( (ZIG2.NE. -1))THEN
         CIG2  = ZIG2
      ENDIF 
      IF( (ZIG3.NE. -1))THEN
         CIG3  = ZIG3
      ENDIF 
      IF( (ZIG4.NE. -1))THEN
         CIG4  = ZIG4
      ENDIF 
      IF((  CIP1.LT.  0 .OR.  CIP1.GT.  32767))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CIP1',  CIP1,  0,
     %     32767
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CIP2.LT.  0 .OR.  CIP2.GT.  32767))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CIP2',  CIP2,  0,
     %     32767
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CIP3.LT.  0 .OR.  CIP3.GT.  4095))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CIP3',  CIP3,  0,  4095
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CDEET.LT.  0 .OR.  CDEET.GT.  32767))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CDEET',  CDEET,  0,
     %     32767
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CNPAS.LT.  0 .OR.  CNPAS.GT.  2**24-1))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CNPAS',  CNPAS,  0,  2*
     %   *24-1
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CIG1.LT.  0 .OR.  CIG1.GT.  2047))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CIG1 ',  CIG1 ,  0,
     %     2047
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CIG2.LT.  0 .OR.  CIG2.GT.  2047))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CIG2 ',  CIG2 ,  0,
     %     2047
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CIG3.LT.  0 .OR.  CIG3.GT.  65535))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CIG3 ',  CIG3 ,  0,
     %     65535
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CIG4.LT.  0 .OR.  CIG4.GT.  65535))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CIG4 ',  CIG4 ,  0,
     %     65535
         FSTZAP = -24
         RETURN
      ENDIF 
      IF((  CDATE.LT.  0 .OR.  CDATE.GT.  999999999))THEN
         WRITE(LOGFIL, 610) IUN, 'FSTZAP', ' CDATE',  CDATE,  0,
     %     999999999
         FSTZAP = -24
         RETURN
      ENDIF 
      CALL QSTARG(DATEV,CDEET,CNPAS,CNI,CNJ,CNK,CIP1,CIP2,CIP3,
     % CTYPVAR,CNOMVAR,CETIKET,CGRTYP,CIG1,CIG2,CIG3,CIG4,CDATYP,
     %CSWA,CLNG,CDLTF,CUBC,CNBITS,.TRUE.)
*
*--------------------------------------------------------------------------
*
*
*     MISE A JOUR DE L'ENTREE DU DIRECTEUR (DISQUE ET MEMOIRE)
*
*

      CALL QSTWDE(KEY,.TRUE.,.TRUE.)
610   FORMAT(' ERREUR  IUN=',I3,3X,A7,3X,A7,'(',O11,
     %'B) DOIT ETRE ENTRE',I9,' ET ',I9)
      RETURN
      END

***S/P QSTWPM  MANIPULATION DES PARAMETRES D'UN ENREGISTREMENT
*
      SUBROUTINE QSTWPM(TABL,MSG)
      IMPLICIT NONE
      INTEGER TABL(*)
      CHARACTER *(*) MSG
*
*AUTEUR   M.VALIN RPN AOUT 1988
*
*LANGAGE  RATFOR
*
*OBJET
*         PASSER D'UN ENSEMBLE DE PARAMETRES DESCRIPTEURS D'UN ENREGISTREMENT
*         DE FICHIER STANDARD EN FORMAT COMPACT DISQUE(8 MOTS) OU MEMOIRE
*         (6 MOTS) AU MEME ENSEMBLE SOUS FORME ETENDUE. LORSQUE LA DECOM-
*         PACTION SE FAIT A PARTIR DU FORMAT DISQUE, IL FAUT PROCEDER A
*         CERTAINES TRANSFORMATIONS. LES PARAMETRES DE TYPE CARACTERE SONT
*         TRANSFORMES EN DISPLAY CODE (SI CDC), ET LES ADRESSES ET LONGUEURS
*         D'ENREGISTREMENT SONT TRANSFORMEES DE MOTS DE BASE (16 BITS) A
*         DES NOMBRES DE MOTS HOTE (CDC OU AUTRE)
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*MODULES

      EXTERNAL INCDAT,DATMGP
*
*NOTES
*
*     FORMAT D'UN FICHIER STANDARD A ACCES DIRECT
*
*            ENTETE       960 PREMIERS BITS
*            DIRECTEUR    N PAIRES D'ENTREES (480 BITS PAR ENTREE)
*            DONNEES      CHAQUE ENREGISTREMENT OCCUPE UN MULTIPLE DE
*                         960 BITS
*
*     FICHIER STANDARD SEQUENTIEL
*            CHAQUE ENREGISTREMENT CONTIENT UN PROLOGUE DE 960 BITS SUIVI
*            D'UN MULTIPLE DE 960 BITS POUR LES DONNEES. LE FORMAT DES 480
*            PREMIERS BITS DU PROLOGUE EST IDENTIQUE AU FORMAT D'UNE ENTREE
*            DE DIRECTEUR DISQUE (SAUF QUE SWA = 0).  POUR LE RESTE,
*
*
*     FORMAT DE L'ENTETE DE 960 BITS D'UN FICHIER STANDARD A ACCES DIRECT
*
*     BITS    00- 63   0101010101...(PATRON BINAIRE ALTERNE)
*             64- 95   DIRSIZ      TAILLE DU DIRECTEUR DISQUE (TOUJOURS PAIR)
*             96-127   INUTILISE  (CONTIENT DES ZEROS)
*            128-159   NUTIL       NOMBRE D'ENTREES DU DIRECTEUR EN SERVICE
*            160-191   INUTILISE  (CONTIENT DES ZEROS)
*            192-223   NBECR       NOMBRE D'ECRITURES
*            224-255   INUTILISE  (CONTIENT DES ZEROS)
*            256-287   NBRECR      NOMBRE DE REECRITURES
*            288-319   INUTILISE  (CONTIENT DES ZEROS)
*            320-351   NBEXT       NOMBRE D'EXTENSIONS AU DIRECTEUR
*            352-383   INUTILISE  (CONTIENT DES ZEROS)
*            384-415   NRECUP      NOMBRE DE RECUPERATIONS D'ENTREES
*            416-447   INUTILISE  (CONTIENT DES ZEROS)
*            448-479   NBEFF       NOMBRE D'EFFACEMENTS
*            480-511   INUTILISE  (CONTIENT DES ZEROS)
*            512-543   NBCORR      NOMBRE DE CORRECTIONS AU DIRECTEUR
*            544-575   INUTILISE  (CONTIENT DES ZEROS)
*            576-607   INUTILISE  (CONTIENT DES ZEROS)
*            608-639   INUTILISE  (CONTIENT DES ZEROS)
*            640-671   INUTILISE  (CONTIENT DES ZEROS)
*            672-703   INUTILISE  (CONTIENT DES ZEROS)
*            704-735   INUTILISE  (CONTIENT DES ZEROS)
*            736-767   INUTILISE  (CONTIENT DES ZEROS)
*            768-799   INUTILISE  (CONTIENT DES ZEROS)
*            800-831   INUTILISE  (CONTIENT DES ZEROS)
*            832-865   INUTILISE  (CONTIENT DES ZEROS)
*            864-895   INUTILISE  (CONTIENT DES ZEROS)
*            896-927   INUTILISE  (CONTIENT DES ZEROS)
*            928-959   INUTILISE  (CONTIENT DES ZEROS)
*     FORMAT D'UNE ENTREE DU DIRECTEUR DISQUE (480 BITS)
*
*     BITS   0- 31   SWA      ADRESSE EN MOTS DISQUE (16 BITS) DES DONNEES
*                             (ORIGINE 0)
*           32- 47   NPAS1    NUMERO DU PAS TEMPOREL MODULO 65536 (0-65535)
*           48- 59   NK       TROISIEME DIMENSION DU CHAMP  (0-4095)
*           64- 79   NI       PREMIERE DIMENSION DU CHAMP   (0-32767)
*           80- 95   NJ       DEUXIEME DIMENSION DU CHAMP   (0-32767)
*           96-111   NOMVAR   NOM DU CHAMP (2 CARACTERES ASCII)
*          112-119   TYPVAR   TYPE DU CHAMP (1 CARACTERE ASCII)
*          120-127   NBITS    NOMBRE DE BITS PAR ITEM (1-64)
*          128-143   IP1      (0-32767)
*          144-159   IP2      (0-32767)
*          160-175   IP3      (0-4095)
*          183       DLTF     MARQUEUR D'EFFACEMENT ( 1=EFFACE )
*          184-191   NPAS2    NPAS / 65355
*          192-223   ETIQ14   CARACTERES 1 A 4 DE L'ETIQUETTE (ASCII)
*          224-239   ETIQ56   CARACTERES 5 A 6 DE L'ETIQUETTE (ASCII)
*          240-255   ETIQ78   CARACTERES 7 A 8 DE L'ETIQUETTE (ASCII)
*          304-319   IG2      (0-2047)
*          320-335   IG3      (0-65535)
*          336-351   IG4      (0-65535)
*          352-359   GRTYP    TYPE DE GRILLE (1 CARACTERE ASCII)
*          360-367   DATYP    TYPE DE DONNEES (0-4)
*          368-383   IG1      (0-2047)
*          384-415   DATE     (DATE TIME STAMP OCTALISE)
*          416-431   UBC      "UNUSED BITS COUNT"
*          432-447   DEET     PAS TEMPOREL (0-32767)
*          448-479   LNG      LONGUEUR (EN MOTS DISQUE) DES DONNEES
*
*     FORMAT DE BITS 480-959 SEQ/SQI
*
*          480-511   EOF      MARQUEUR 1-14 EOF LOGIQUE  31 EOD FIN DU DATA
*          512-543            INUTILISE  (CONTIENT DES ZEROS)
*          544-575            POINTEUR ARRIERE POUR FICHIER SQI
*          576-607            INUTILISE  (CONTIENT DES ZEROS)
*          608-639            DERNIERE ADRESSE EN CHUNK AVANT FERMETURE -SQI-
*          896-959            10101010... (PATRON BINAIRE ALTERNE) SERVANT A
*                             IDENTIFIER UN ENREGISTREMENT STANDARD
*
*     FORMAT D'UNE ENTREE DU DIRECTEUR EN MEMOIRE (384 BITS)
*
*     BITS   0- 15   NI       PREMIERE DIMENSION DU CHAMP   (0-32767)
*           16- 31   NJ       DEUXIEME DIMENSION DU CHAMP   (0-32767)
*           32- 47   IG4      (0-65535)
*           48- 59   IG2      (0-2047)
*           60       DLTF     MARQUEUR D'EFFACEMENT ( 1=EFFACE )
*           61- 63   LIBRE    ANCIENNEMENT TYPE DE DONNEES (0-4)
*           64- 95   ETIQ14   CARACTERES 1 A 4 DE L'ETIQUETTE
*           96-111   IP2      (0-32767)
*          112-119   GRTYP    TYPE DE GRILLE (1 CARACTERE )
*          120-127   TYPVAR   TYPE DU CHAMP (1 CARACTERE )
*          128-143   ETIQ56   CARACTERES 5 A 6 DE L'ETIQUETTE
*          144-159   ETIQ78   CARACTERES 7 A 8 DE L'ETIQUETTE
*          160-175   IP1      (0-32767)
*          176-179   IG1      (0-2047)  (EN FAIT MOD(IG1,16))
*          180-191   IP3      (0-4095)
*          192-223   DATE     (DATE TIME STAMP OCTALISE)
*          224-239   NOMVAR   NOM DU CHAMP (2 CARACTERES )
*          240-255   IG3      (0-65535)
*          256-271   DEET     PAS TEMPOREL (0-32767)
*          272-287   NPAS1    NUMERO DU PAS TEMPOREL MODULO 65536 (0-65535)
*          288-299   NK       TROISIEME DIMENSION DU CHAMP  (0-4095)
*          300-319   LNG      LONGUEUR (EN MOTS) DES DONNEES
*          320-343   SWA      ADRESSE EN CHUNKS (960 BITS) DES DONNEES
*                             (ORIGINE 1)
*          344-351   IG1      (0-2047)  (EN FAIT IG1/16)
*          352-359   NBITS    NOMBRE DE BITS PAR ITEM (1-64)
*          360-367   DATYP    TYPE DE DONNEES
*          368-375   NPAS2    NPAS / 65355
*
*     ON REMARQUERA QUE LES CLES DE RECHERCHE SE TROUVENT ENTRE
*     LES POSITIONS 64 ET 239
*
*
*
*ARGUMENTS
* IN/OUT  TABL    TABLE COMPACTEE (FORMAT MEMOIRE OU DISQUE A 2 ENTREES)
* IN      MSG     MESSAGE SUPPLEMENTAIRE POUR IMPRESSION
*
**

      CHARACTER *1 DTYP(0:5),IDLTF(0:1)
      SAVE DTYP, IDLTF
      INTEGER IREC, I, SWA1, LNG1, DATEXX, JOURS, IAR(14)
      INTEGER NPAS1, NPAS2
      DATA DTYP /'X','R','I','C','S','E'/
      DATA IDLTF /'-','*'/
      IREC  =ishft(TABL(1),-( 8))
      IF((DEET*NPAS .EQ. 0))THEN
         DATEXX = DATE
      ELSE 
         CALL INCDAT(DATEXX,DATE,-(DEET*NPAS+1800)/3600)
*

      ENDIF 
      IAR(14) = DATEXX
      CALL DATMGP(IAR)
      JOURS = IAR(1)
*

      WRITE(LOGFIL,903)MSG,IREC,IDLTF(DLTF),ishft(NOMVAR,32-2*08),
     %ishft(TYPVAR,32-08),IP1,IP2,IP3,NI,NJ,NK,ishft(ETIQ14,32-4*08)
     %,ishft(ETIQ58,32-4*08),JOURS,DATEXX,DEET,NPAS,ishft(GRTYP,32-
     %08),IG1,IG2,IG3,IG4,DTYP(DATYP),NBITS,SWA,LNG
903   FORMAT(1X,A,1X,I6,A1,A2,1X,A1,1X,2(2(I5,1X),I4,1X),2A4,1X,I1,
     %I9.9,2X,I5,1X,I8,1X,A1,1X,2(I4,1X),2(I5,1X),A1,I2.2,1X,I7,1X,
     %I5)
      RETURN
      ENTRY QSTUPC(TABL)
*
*    DEPAQUETER FORMAT INTERNE EN MEMOIRE
*

      SWA   =IAND(ishft(TABL((1+ishft( 343,-(5)))),-((31-IAND( 343,
     %31)))),ishft(-1,-(32-( 24))))
      SWA   = SWA *30 + 1
      NPAS1  =IAND(ishft(TABL((1+ishft( 287,-(5)))),-((31-IAND( 287,
     %31)))),ishft(-1,-(32-( 16))))
      NPAS2  =IAND(ishft(TABL((1+ishft( 375,-(5)))),-((31-IAND( 375,
     %31)))),ishft(-1,-(32-( 08))))
      NK   =IAND(ishft(TABL((1+ishft( 299,-(5)))),-((31-IAND( 299,31
     %)))),ishft(-1,-(32-( 12))))
      NI   =IAND(ishft(TABL((1+ishft( 015,-(5)))),-((31-IAND( 015,31
     %)))),ishft(-1,-(32-( 16))))
      NJ   =IAND(ishft(TABL((1+ishft( 031,-(5)))),-((31-IAND( 031,31
     %)))),ishft(-1,-(32-( 16))))
      NOMVAR =IAND(ishft(TABL((1+ishft( 239,-(5)))),-((31-IAND( 239,
     %31)))),ishft(-1,-(32-( 16))))
      TYPVAR =IAND(ishft(TABL((1+ishft( 127,-(5)))),-((31-IAND( 127,
     %31)))),ishft(-1,-(32-( 08))))
      NBITS  =IAND(ishft(TABL((1+ishft( 359,-(5)))),-((31-IAND( 359,
     %31)))),ishft(-1,-(32-( 08))))
      IP1   =IAND(ishft(TABL((1+ishft( 175,-(5)))),-((31-IAND( 175,
     %31)))),ishft(-1,-(32-( 16))))
      IP2   =IAND(ishft(TABL((1+ishft( 111,-(5)))),-((31-IAND( 111,
     %31)))),ishft(-1,-(32-( 16))))
      IP3   =IAND(ishft(TABL((1+ishft( 191,-(5)))),-((31-IAND( 191,
     %31)))),ishft(-1,-(32-( 12))))
      DLTF   =IAND(ishft(TABL((1+ishft( 060,-(5)))),-((31-IAND( 060,
     %31)))),ishft(-1,-(32-( 01))))
      ETIQ14 =IAND(ishft(TABL((1+ishft( 095,-(5)))),-((31-IAND( 095,
     %31)))),ishft(-1,-(32-( 32))))
      ETIQ56 =IAND(ishft(TABL((1+ishft( 143,-(5)))),-((31-IAND( 143,
     %31)))),ishft(-1,-(32-( 16))))
      ETIQ78 =IAND(ishft(TABL((1+ishft( 159,-(5)))),-((31-IAND( 159,
     %31)))),ishft(-1,-(32-( 16))))
      IG2   =IAND(ishft(TABL((1+ishft( 059,-(5)))),-((31-IAND( 059,
     %31)))),ishft(-1,-(32-( 12))))
      IG3   =IAND(ishft(TABL((1+ishft( 255,-(5)))),-((31-IAND( 255,
     %31)))),ishft(-1,-(32-( 16))))
      IG4   =IAND(ishft(TABL((1+ishft( 047,-(5)))),-((31-IAND( 047,
     %31)))),ishft(-1,-(32-( 16))))
      GRTYP  =IAND(ishft(TABL((1+ishft( 119,-(5)))),-((31-IAND( 119,
     %31)))),ishft(-1,-(32-( 08))))
      DATYP  =IAND(ishft(TABL((1+ishft( 367,-(5)))),-((31-IAND( 367,
     %31)))),ishft(-1,-(32-( 08))))
      IG1   =ishft(IAND(ishft(TABL((1+ishft( 351,-(5)))),-((31-IAND(
     % 351,31)))),ishft(-1,-(32-( 08)))),4)
      IG1   = IOR(IG1,IAND(ishft(TABL((1+ishft( 179,-(5)))),-((31-
     %IAND( 179,31)))),ishft(-1,-(32-( 04)))))
      DATE   =IAND(ishft(TABL((1+ishft( 223,-(5)))),-((31-IAND( 223,
     %31)))),ishft(-1,-(32-( 32))))
      DEET   =IAND(ishft(TABL((1+ishft( 271,-(5)))),-((31-IAND( 271,
     %31)))),ishft(-1,-(32-( 16))))
      LNG   =IAND(ishft(TABL((1+ishft( 319,-(5)))),-((31-IAND( 319,
     %31)))),ishft(-1,-(32-( 20))))
      GOTO 100
      ENTRY QSTUPA(TABL)
*
*    DEPAQUETER FORMAT DISQUE (ENTREE PAIRE)
*

      SWA   =IAND(ishft(TABL((1+ishft( 031,-(5)))),-((31-IAND( 031,
     %31)))),ishft(-1,-(32-( 32))))
      SWA = (16 * SWA)/32  + 1
      NPAS1  =IAND(ishft(TABL((1+ishft( 047,-(5)))),-((31-IAND( 047,
     %31)))),ishft(-1,-(32-( 16))))
      NPAS2  =IAND(ishft(TABL((1+ishft( 191,-(5)))),-((31-IAND( 191,
     %31)))),ishft(-1,-(32-( 08))))
      NK   =IAND(ishft(TABL((1+ishft( 059,-(5)))),-((31-IAND( 059,31
     %)))),ishft(-1,-(32-( 12))))
      NI   =IAND(ishft(TABL((1+ishft( 079,-(5)))),-((31-IAND( 079,31
     %)))),ishft(-1,-(32-( 16))))
      NJ   =IAND(ishft(TABL((1+ishft( 095,-(5)))),-((31-IAND( 095,31
     %)))),ishft(-1,-(32-( 16))))
      NOMVAR =IAND(ishft(TABL((1+ishft( 111,-(5)))),-((31-IAND( 111,
     %31)))),ishft(-1,-(32-( 16))))
      TYPVAR =IAND(ishft(TABL((1+ishft( 119,-(5)))),-((31-IAND( 119,
     %31)))),ishft(-1,-(32-( 08))))
      NBITS  =IAND(ishft(TABL((1+ishft( 127,-(5)))),-((31-IAND( 127,
     %31)))),ishft(-1,-(32-( 08))))
      IP1   =IAND(ishft(TABL((1+ishft( 143,-(5)))),-((31-IAND( 143,
     %31)))),ishft(-1,-(32-( 16))))
      IP2   =IAND(ishft(TABL((1+ishft( 159,-(5)))),-((31-IAND( 159,
     %31)))),ishft(-1,-(32-( 16))))
      IP3   =IAND(ishft(TABL((1+ishft( 175,-(5)))),-((31-IAND( 175,
     %31)))),ishft(-1,-(32-( 16))))
      DLTF   =IAND(ishft(TABL((1+ishft( 183,-(5)))),-((31-IAND( 183,
     %31)))),ishft(-1,-(32-( 01))))
      ETIQ14 =IAND(ishft(TABL((1+ishft( 223,-(5)))),-((31-IAND( 223,
     %31)))),ishft(-1,-(32-( 32))))
      ETIQ56 =IAND(ishft(TABL((1+ishft( 239,-(5)))),-((31-IAND( 239,
     %31)))),ishft(-1,-(32-( 16))))
      ETIQ78 =IAND(ishft(TABL((1+ishft( 255,-(5)))),-((31-IAND( 255,
     %31)))),ishft(-1,-(32-( 16))))
      IG2   =IAND(ishft(TABL((1+ishft( 319,-(5)))),-((31-IAND( 319,
     %31)))),ishft(-1,-(32-( 16))))
      IG3   =IAND(ishft(TABL((1+ishft( 335,-(5)))),-((31-IAND( 335,
     %31)))),ishft(-1,-(32-( 16))))
      IG4   =IAND(ishft(TABL((1+ishft( 351,-(5)))),-((31-IAND( 351,
     %31)))),ishft(-1,-(32-( 16))))
      GRTYP  =IAND(ishft(TABL((1+ishft( 359,-(5)))),-((31-IAND( 359,
     %31)))),ishft(-1,-(32-( 08))))
      DATYP  =IAND(ishft(TABL((1+ishft( 367,-(5)))),-((31-IAND( 367,
     %31)))),ishft(-1,-(32-( 08))))
      IG1   =IAND(ishft(TABL((1+ishft( 383,-(5)))),-((31-IAND( 383,
     %31)))),ishft(-1,-(32-( 16))))
      DATE   =IAND(ishft(TABL((1+ishft( 415,-(5)))),-((31-IAND( 415,
     %31)))),ishft(-1,-(32-( 32))))
      UBC   =IAND(ishft(TABL((1+ishft( 431,-(5)))),-((31-IAND( 431,
     %31)))),ishft(-1,-(32-( 12))))
      DEET   =IAND(ishft(TABL((1+ishft( 447,-(5)))),-((31-IAND( 447,
     %31)))),ishft(-1,-(32-( 16))))
      LNG   =IAND(ishft(TABL((1+ishft( 479,-(5)))),-((31-IAND( 479,
     %31)))),ishft(-1,-(32-( 32))))
      LNG = (16*LNG - UBC +32-1) /32
      GOTO 100
      ENTRY QSTUPB(TABL)
*
*    DEPAQUETER FORMAT DISQUE (ENTREE IMPAIRE)
*

      SWA   =IAND(ishft(TABL((1+ishft( 480+031,-(5)))),-((31-IAND(
     % 480+031,31)))),ishft(-1,-(32-( 32))))
      SWA = (16 * SWA)/32  + 1
      NPAS1  =IAND(ishft(TABL((1+ishft( 480+047,-(5)))),-((31-IAND(
     % 480+047,31)))),ishft(-1,-(32-( 16))))
      NPAS2  =IAND(ishft(TABL((1+ishft( 480+191,-(5)))),-((31-IAND(
     % 480+191,31)))),ishft(-1,-(32-( 08))))
      NK   =IAND(ishft(TABL((1+ishft( 480+059,-(5)))),-((31-IAND(
     % 480+059,31)))),ishft(-1,-(32-( 12))))
      NI   =IAND(ishft(TABL((1+ishft( 480+079,-(5)))),-((31-IAND(
     % 480+079,31)))),ishft(-1,-(32-( 16))))
      NJ   =IAND(ishft(TABL((1+ishft( 480+095,-(5)))),-((31-IAND(
     % 480+095,31)))),ishft(-1,-(32-( 16))))
      NOMVAR =IAND(ishft(TABL((1+ishft( 480+111,-(5)))),-((31-IAND(
     % 480+111,31)))),ishft(-1,-(32-( 16))))
      TYPVAR =IAND(ishft(TABL((1+ishft( 480+119,-(5)))),-((31-IAND(
     % 480+119,31)))),ishft(-1,-(32-( 08))))
      NBITS  =IAND(ishft(TABL((1+ishft( 480+127,-(5)))),-((31-IAND(
     % 480+127,31)))),ishft(-1,-(32-( 08))))
      IP1   =IAND(ishft(TABL((1+ishft( 480+143,-(5)))),-((31-IAND(
     % 480+143,31)))),ishft(-1,-(32-( 16))))
      IP2   =IAND(ishft(TABL((1+ishft( 480+159,-(5)))),-((31-IAND(
     % 480+159,31)))),ishft(-1,-(32-( 16))))
      IP3   =IAND(ishft(TABL((1+ishft( 480+175,-(5)))),-((31-IAND(
     % 480+175,31)))),ishft(-1,-(32-( 16))))
      DLTF   =IAND(ishft(TABL((1+ishft( 480+183,-(5)))),-((31-IAND(
     % 480+183,31)))),ishft(-1,-(32-( 01))))
      ETIQ14 =IAND(ishft(TABL((1+ishft( 480+223,-(5)))),-((31-IAND(
     % 480+223,31)))),ishft(-1,-(32-( 32))))
      ETIQ56 =IAND(ishft(TABL((1+ishft( 480+239,-(5)))),-((31-IAND(
     % 480+239,31)))),ishft(-1,-(32-( 16))))
      ETIQ78 =IAND(ishft(TABL((1+ishft( 480+255,-(5)))),-((31-IAND(
     % 480+255,31)))),ishft(-1,-(32-( 16))))
      IG2   =IAND(ishft(TABL((1+ishft( 480+319,-(5)))),-((31-IAND(
     % 480+319,31)))),ishft(-1,-(32-( 16))))
      IG3   =IAND(ishft(TABL((1+ishft( 480+335,-(5)))),-((31-IAND(
     % 480+335,31)))),ishft(-1,-(32-( 16))))
      IG4   =IAND(ishft(TABL((1+ishft( 480+351,-(5)))),-((31-IAND(
     % 480+351,31)))),ishft(-1,-(32-( 16))))
      GRTYP  =IAND(ishft(TABL((1+ishft( 480+359,-(5)))),-((31-IAND(
     % 480+359,31)))),ishft(-1,-(32-( 08))))
      DATYP  =IAND(ishft(TABL((1+ishft( 480+367,-(5)))),-((31-IAND(
     % 480+367,31)))),ishft(-1,-(32-( 08))))
      IG1   =IAND(ishft(TABL((1+ishft( 480+383,-(5)))),-((31-IAND(
     % 480+383,31)))),ishft(-1,-(32-( 16))))
      DATE   =IAND(ishft(TABL((1+ishft( 480+415,-(5)))),-((31-IAND(
     % 480+415,31)))),ishft(-1,-(32-( 32))))
      UBC   =IAND(ishft(TABL((1+ishft( 480+431,-(5)))),-((31-IAND(
     % 480+431,31)))),ishft(-1,-(32-( 12))))
      DEET   =IAND(ishft(TABL((1+ishft( 480+447,-(5)))),-((31-IAND(
     % 480+447,31)))),ishft(-1,-(32-( 16))))
      LNG   =IAND(ishft(TABL((1+ishft( 480+479,-(5)))),-((31-IAND(
     % 480+479,31)))),ishft(-1,-(32-( 32))))
      LNG = (16*LNG - UBC +32-1) /32
100   NK = MAX(1,NK)
      ETIQ58 = IOR(ishft(ETIQ56,2*08) , ETIQ78 )
      DATE = 10 * (DATE/8) + MOD(DATE,8)
      NPAS = IOR(NPAS1,ishft(NPAS2,16))
      RETURN
      ENTRY QSTPKC(TABL)
*
*    PAQUETER FORMAT INTERNE EN MEMOIRE
*

      DO 23002 I=1, 12
         TABL(I) = 0
*

23002 CONTINUE 
      LNG1   = NI * NJ * NK * NBITS
      IF((DATYP.EQ.1))THEN
         LNG1 = LNG1 + 120
      ENDIF 
      LNG   = (LNG1 +32 - 1)/32
      SWA1   = (SWA - 1)/30
      NPAS1 = MOD(NPAS,65536)
      NPAS2 = NPAS / 65536
      TABL((1+ishft( 343,-(5))))=IOR(TABL((1+ishft( 343,-(5)))),
     %ishft(IAND(SWA1 ,ishft(-1,-(32-( 24)))),(31-IAND( 343,31))))
      TABL((1+ishft( 287,-(5))))=IOR(TABL((1+ishft( 287,-(5)))),
     %ishft(IAND(NPAS1 ,ishft(-1,-(32-( 16)))),(31-IAND( 287,31))))
      TABL((1+ishft( 375,-(5))))=IOR(TABL((1+ishft( 375,-(5)))),
     %ishft(IAND(NPAS2 ,ishft(-1,-(32-( 08)))),(31-IAND( 375,31))))
      TABL((1+ishft( 299,-(5))))=IOR(TABL((1+ishft( 299,-(5)))),
     %ishft(IAND(NK ,ishft(-1,-(32-( 12)))),(31-IAND( 299,31))))
      TABL((1+ishft( 015,-(5))))=IOR(TABL((1+ishft( 015,-(5)))),
     %ishft(IAND(NI ,ishft(-1,-(32-( 16)))),(31-IAND( 015,31))))
      TABL((1+ishft( 031,-(5))))=IOR(TABL((1+ishft( 031,-(5)))),
     %ishft(IAND(NJ ,ishft(-1,-(32-( 16)))),(31-IAND( 031,31))))
      TABL((1+ishft( 239,-(5))))=IOR(TABL((1+ishft( 239,-(5)))),
     %ishft(IAND(NOMVAR ,ishft(-1,-(32-( 16)))),(31-IAND( 239,31))))
      TABL((1+ishft( 127,-(5))))=IOR(TABL((1+ishft( 127,-(5)))),
     %ishft(IAND(TYPVAR ,ishft(-1,-(32-( 08)))),(31-IAND( 127,31))))
      TABL((1+ishft( 359,-(5))))=IOR(TABL((1+ishft( 359,-(5)))),
     %ishft(IAND(NBITS ,ishft(-1,-(32-( 08)))),(31-IAND( 359,31))))
      TABL((1+ishft( 175,-(5))))=IOR(TABL((1+ishft( 175,-(5)))),
     %ishft(IAND(IP1 ,ishft(-1,-(32-( 16)))),(31-IAND( 175,31))))
      TABL((1+ishft( 111,-(5))))=IOR(TABL((1+ishft( 111,-(5)))),
     %ishft(IAND(IP2 ,ishft(-1,-(32-( 16)))),(31-IAND( 111,31))))
      TABL((1+ishft( 191,-(5))))=IOR(TABL((1+ishft( 191,-(5)))),
     %ishft(IAND(IP3 ,ishft(-1,-(32-( 12)))),(31-IAND( 191,31))))
      TABL((1+ishft( 060,-(5))))=IOR(TABL((1+ishft( 060,-(5)))),
     %ishft(IAND(DLTF ,ishft(-1,-(32-( 01)))),(31-IAND( 060,31))))
      TABL((1+ishft( 095,-(5))))=IOR(TABL((1+ishft( 095,-(5)))),
     %ishft(IAND(ETIQ14 ,ishft(-1,-(32-( 32)))),(31-IAND( 095,31))))
      TABL((1+ishft( 143,-(5))))=IOR(TABL((1+ishft( 143,-(5)))),
     %ishft(IAND(ETIQ56 ,ishft(-1,-(32-( 16)))),(31-IAND( 143,31))))
      TABL((1+ishft( 159,-(5))))=IOR(TABL((1+ishft( 159,-(5)))),
     %ishft(IAND(ETIQ78 ,ishft(-1,-(32-( 16)))),(31-IAND( 159,31))))
      TABL((1+ishft( 059,-(5))))=IOR(TABL((1+ishft( 059,-(5)))),
     %ishft(IAND(IG2 ,ishft(-1,-(32-( 12)))),(31-IAND( 059,31))))
      TABL((1+ishft( 255,-(5))))=IOR(TABL((1+ishft( 255,-(5)))),
     %ishft(IAND(IG3 ,ishft(-1,-(32-( 16)))),(31-IAND( 255,31))))
      TABL((1+ishft( 047,-(5))))=IOR(TABL((1+ishft( 047,-(5)))),
     %ishft(IAND(IG4 ,ishft(-1,-(32-( 16)))),(31-IAND( 047,31))))
      TABL((1+ishft( 119,-(5))))=IOR(TABL((1+ishft( 119,-(5)))),
     %ishft(IAND(GRTYP ,ishft(-1,-(32-( 08)))),(31-IAND( 119,31))))
      TABL((1+ishft( 367,-(5))))=IOR(TABL((1+ishft( 367,-(5)))),
     %ishft(IAND(DATYP ,ishft(-1,-(32-( 08)))),(31-IAND( 367,31))))
      TABL((1+ishft( 351,-(5))))=IOR(TABL((1+ishft( 351,-(5)))),
     %ishft(IAND(ishft(IG1,-(4)),ishft(-1,-(32-( 08)))),(31-IAND(
     % 351,31))))
      TABL((1+ishft( 179,-(5))))=IOR(TABL((1+ishft( 179,-(5)))),
     %ishft(IAND(IAND(IG1,15) ,ishft(-1,-(32-( 04)))),(31-IAND( 179,
     %31))))
*

      DATEXX = 8*(DATE/10) + MOD(DATE,10)
*

      TABL((1+ishft( 223,-(5))))=IOR(TABL((1+ishft( 223,-(5)))),
     %ishft(IAND(DATEXX ,ishft(-1,-(32-( 32)))),(31-IAND( 223,31))))
      TABL((1+ishft( 271,-(5))))=IOR(TABL((1+ishft( 271,-(5)))),
     %ishft(IAND(DEET ,ishft(-1,-(32-( 16)))),(31-IAND( 271,31))))
      TABL((1+ishft( 319,-(5))))=IOR(TABL((1+ishft( 319,-(5)))),
     %ishft(IAND(LNG ,ishft(-1,-(32-( 20)))),(31-IAND( 319,31))))
      GOTO 200
      ENTRY QSTPKA(TABL)
*
*    PAQUETER FORMAT DISQUE (ENTREE PAIRE)
*

      DO 23006 I=1,30/2
         TABL(I) = 0
23006 CONTINUE 
      IF((32.EQ.64))THEN
         TABL(8) = IAND(TABL(8),ishft(-1,-(32-(32))))
      ENDIF 
      SWA1 = ((SWA-1)*32)/16
*

      LNG1   = NI * NJ * NK * NBITS
      IF((DATYP.EQ.1))THEN
         LNG1 = LNG1 + 120
      ENDIF 
      LNG   = (LNG1 +32 - 1)/32
      UBC   = ((LNG1 +960 - 1)/960)*960 - LNG1
      LNG1   = ((LNG1 +960 - 1)/960)*960/16
      NPAS1 = MOD(NPAS,65536)
      NPAS2 = NPAS / 65536
*

      TABL((1+ishft( 031,-(5))))=IOR(TABL((1+ishft( 031,-(5)))),
     %ishft(IAND(SWA1 ,ishft(-1,-(32-( 32)))),(31-IAND( 031,31))))
      TABL((1+ishft( 047,-(5))))=IOR(TABL((1+ishft( 047,-(5)))),
     %ishft(IAND(NPAS1 ,ishft(-1,-(32-( 16)))),(31-IAND( 047,31))))
      TABL((1+ishft( 191,-(5))))=IOR(TABL((1+ishft( 191,-(5)))),
     %ishft(IAND(NPAS2 ,ishft(-1,-(32-( 08)))),(31-IAND( 191,31))))
      TABL((1+ishft( 059,-(5))))=IOR(TABL((1+ishft( 059,-(5)))),
     %ishft(IAND(NK ,ishft(-1,-(32-( 12)))),(31-IAND( 059,31))))
      TABL((1+ishft( 079,-(5))))=IOR(TABL((1+ishft( 079,-(5)))),
     %ishft(IAND(NI ,ishft(-1,-(32-( 16)))),(31-IAND( 079,31))))
      TABL((1+ishft( 095,-(5))))=IOR(TABL((1+ishft( 095,-(5)))),
     %ishft(IAND(NJ ,ishft(-1,-(32-( 16)))),(31-IAND( 095,31))))
      TABL((1+ishft( 127,-(5))))=IOR(TABL((1+ishft( 127,-(5)))),
     %ishft(IAND(NBITS ,ishft(-1,-(32-( 08)))),(31-IAND( 127,31))))
      TABL((1+ishft( 143,-(5))))=IOR(TABL((1+ishft( 143,-(5)))),
     %ishft(IAND(IP1 ,ishft(-1,-(32-( 16)))),(31-IAND( 143,31))))
      TABL((1+ishft( 159,-(5))))=IOR(TABL((1+ishft( 159,-(5)))),
     %ishft(IAND(IP2 ,ishft(-1,-(32-( 16)))),(31-IAND( 159,31))))
      TABL((1+ishft( 175,-(5))))=IOR(TABL((1+ishft( 175,-(5)))),
     %ishft(IAND(IP3 ,ishft(-1,-(32-( 16)))),(31-IAND( 175,31))))
      TABL((1+ishft( 183,-(5))))=IOR(TABL((1+ishft( 183,-(5)))),
     %ishft(IAND(DLTF ,ishft(-1,-(32-( 01)))),(31-IAND( 183,31))))
      TABL((1+ishft( 319,-(5))))=IOR(TABL((1+ishft( 319,-(5)))),
     %ishft(IAND(IG2 ,ishft(-1,-(32-( 16)))),(31-IAND( 319,31))))
      TABL((1+ishft( 335,-(5))))=IOR(TABL((1+ishft( 335,-(5)))),
     %ishft(IAND(IG3 ,ishft(-1,-(32-( 16)))),(31-IAND( 335,31))))
      TABL((1+ishft( 351,-(5))))=IOR(TABL((1+ishft( 351,-(5)))),
     %ishft(IAND(IG4 ,ishft(-1,-(32-( 16)))),(31-IAND( 351,31))))
      TABL((1+ishft( 367,-(5))))=IOR(TABL((1+ishft( 367,-(5)))),
     %ishft(IAND(DATYP ,ishft(-1,-(32-( 08)))),(31-IAND( 367,31))))
      TABL((1+ishft( 383,-(5))))=IOR(TABL((1+ishft( 383,-(5)))),
     %ishft(IAND(IG1 ,ishft(-1,-(32-( 16)))),(31-IAND( 383,31))))
*

      DATEXX = 8*(DATE/10) + MOD(DATE,10)
*

      TABL((1+ishft( 415,-(5))))=IOR(TABL((1+ishft( 415,-(5)))),
     %ishft(IAND(DATEXX ,ishft(-1,-(32-( 32)))),(31-IAND( 415,31))))
      TABL((1+ishft( 431,-(5))))=IOR(TABL((1+ishft( 431,-(5)))),
     %ishft(IAND(UBC ,ishft(-1,-(32-( 12)))),(31-IAND( 431,31))))
      TABL((1+ishft( 447,-(5))))=IOR(TABL((1+ishft( 447,-(5)))),
     %ishft(IAND(DEET ,ishft(-1,-(32-( 16)))),(31-IAND( 447,31))))
      TABL((1+ishft( 479,-(5))))=IOR(TABL((1+ishft( 479,-(5)))),
     %ishft(IAND(LNG1 ,ishft(-1,-(32-( 32)))),(31-IAND( 479,31))))
      TABL((1+ishft( 111,-(5))))=IOR(TABL((1+ishft( 111,-(5)))),
     %ishft(IAND(NOMVAR ,ishft(-1,-(32-( 16)))),(31-IAND( 111,31))))
      TABL((1+ishft( 119,-(5))))=IOR(TABL((1+ishft( 119,-(5)))),
     %ishft(IAND(TYPVAR ,ishft(-1,-(32-( 08)))),(31-IAND( 119,31))))
      TABL((1+ishft( 223,-(5))))=IOR(TABL((1+ishft( 223,-(5)))),
     %ishft(IAND(ETIQ14 ,ishft(-1,-(32-( 32)))),(31-IAND( 223,31))))
      TABL((1+ishft( 239,-(5))))=IOR(TABL((1+ishft( 239,-(5)))),
     %ishft(IAND(ETIQ56 ,ishft(-1,-(32-( 16)))),(31-IAND( 239,31))))
      TABL((1+ishft( 255,-(5))))=IOR(TABL((1+ishft( 255,-(5)))),
     %ishft(IAND(ETIQ78 ,ishft(-1,-(32-( 16)))),(31-IAND( 255,31))))
      TABL((1+ishft( 359,-(5))))=IOR(TABL((1+ishft( 359,-(5)))),
     %ishft(IAND(GRTYP ,ishft(-1,-(32-( 08)))),(31-IAND( 359,31))))
      GOTO 200
      ENTRY QSTPKB(TABL)
*
*    PAQUETER FORMAT DISQUE (ENTREE IMPAIRE)
*

      DO 23012 I=(30+3)/2,30
         TABL(I) = 0
23012 CONTINUE 
      IF((32.EQ.64))THEN
         TABL(8) = IAND(TABL(8),ishft(-1,32-(32)))
      ENDIF 
      SWA1 = ((SWA-1)*32)/16
*

      LNG1   = NI * NJ * NK * NBITS
      IF((DATYP.EQ.1))THEN
         LNG1 = LNG1 + 120
      ENDIF 
      LNG   = (LNG1 +32 - 1)/32
      UBC   = ((LNG1 +960 - 1)/960)*960 - LNG1
      LNG1   = ((LNG1 +960 - 1)/960)*960/16
      NPAS1 = MOD(NPAS,65536)
      NPAS2 = NPAS / 65536
*

      TABL((1+ishft( 480+031,-(5))))=IOR(TABL((1+ishft( 480+031,-(5)
     %))),ishft(IAND(SWA1 ,ishft(-1,-(32-( 32)))),(31-IAND( 480+031,
     %31))))
      TABL((1+ishft( 480+047,-(5))))=IOR(TABL((1+ishft( 480+047,-(5)
     %))),ishft(IAND(NPAS1 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+047
     %,31))))
      TABL((1+ishft( 480+191,-(5))))=IOR(TABL((1+ishft( 480+191,-(5)
     %))),ishft(IAND(NPAS2 ,ishft(-1,-(32-( 08)))),(31-IAND( 480+191
     %,31))))
      TABL((1+ishft( 480+059,-(5))))=IOR(TABL((1+ishft( 480+059,-(5)
     %))),ishft(IAND(NK ,ishft(-1,-(32-( 12)))),(31-IAND( 480+059,31
     %))))
      TABL((1+ishft( 480+079,-(5))))=IOR(TABL((1+ishft( 480+079,-(5)
     %))),ishft(IAND(NI ,ishft(-1,-(32-( 16)))),(31-IAND( 480+079,31
     %))))
      TABL((1+ishft( 480+095,-(5))))=IOR(TABL((1+ishft( 480+095,-(5)
     %))),ishft(IAND(NJ ,ishft(-1,-(32-( 16)))),(31-IAND( 480+095,31
     %))))
      TABL((1+ishft( 480+127,-(5))))=IOR(TABL((1+ishft( 480+127,-(5)
     %))),ishft(IAND(NBITS ,ishft(-1,-(32-( 08)))),(31-IAND( 480+127
     %,31))))
      TABL((1+ishft( 480+143,-(5))))=IOR(TABL((1+ishft( 480+143,-(5)
     %))),ishft(IAND(IP1 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+143,
     %31))))
      TABL((1+ishft( 480+159,-(5))))=IOR(TABL((1+ishft( 480+159,-(5)
     %))),ishft(IAND(IP2 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+159,
     %31))))
      TABL((1+ishft( 480+175,-(5))))=IOR(TABL((1+ishft( 480+175,-(5)
     %))),ishft(IAND(IP3 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+175,
     %31))))
      TABL((1+ishft( 480+183,-(5))))=IOR(TABL((1+ishft( 480+183,-(5)
     %))),ishft(IAND(DLTF ,ishft(-1,-(32-( 01)))),(31-IAND( 480+183,
     %31))))
      TABL((1+ishft( 480+319,-(5))))=IOR(TABL((1+ishft( 480+319,-(5)
     %))),ishft(IAND(IG2 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+319,
     %31))))
      TABL((1+ishft( 480+335,-(5))))=IOR(TABL((1+ishft( 480+335,-(5)
     %))),ishft(IAND(IG3 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+335,
     %31))))
      TABL((1+ishft( 480+351,-(5))))=IOR(TABL((1+ishft( 480+351,-(5)
     %))),ishft(IAND(IG4 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+351,
     %31))))
      TABL((1+ishft( 480+367,-(5))))=IOR(TABL((1+ishft( 480+367,-(5)
     %))),ishft(IAND(DATYP ,ishft(-1,-(32-( 08)))),(31-IAND( 480+367
     %,31))))
      TABL((1+ishft( 480+383,-(5))))=IOR(TABL((1+ishft( 480+383,-(5)
     %))),ishft(IAND(IG1 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+383,
     %31))))
*

      DATEXX = 8*(DATE/10) + MOD(DATE,10)
*

      TABL((1+ishft( 480+415,-(5))))=IOR(TABL((1+ishft( 480+415,-(5)
     %))),ishft(IAND(DATEXX ,ishft(-1,-(32-( 32)))),(31-IAND( 480+
     %415,31))))
      TABL((1+ishft( 480+431,-(5))))=IOR(TABL((1+ishft( 480+431,-(5)
     %))),ishft(IAND(UBC ,ishft(-1,-(32-( 12)))),(31-IAND( 480+431,
     %31))))
      TABL((1+ishft( 480+447,-(5))))=IOR(TABL((1+ishft( 480+447,-(5)
     %))),ishft(IAND(DEET ,ishft(-1,-(32-( 16)))),(31-IAND( 480+447,
     %31))))
      TABL((1+ishft( 480+479,-(5))))=IOR(TABL((1+ishft( 480+479,-(5)
     %))),ishft(IAND(LNG1 ,ishft(-1,-(32-( 32)))),(31-IAND( 480+479,
     %31))))
      TABL((1+ishft( 480+111,-(5))))=IOR(TABL((1+ishft( 480+111,-(5)
     %))),ishft(IAND(NOMVAR ,ishft(-1,-(32-( 16)))),(31-IAND( 480+
     %111,31))))
      TABL((1+ishft( 480+119,-(5))))=IOR(TABL((1+ishft( 480+119,-(5)
     %))),ishft(IAND(TYPVAR ,ishft(-1,-(32-( 08)))),(31-IAND( 480+
     %119,31))))
      TABL((1+ishft( 480+223,-(5))))=IOR(TABL((1+ishft( 480+223,-(5)
     %))),ishft(IAND(ETIQ14 ,ishft(-1,-(32-( 32)))),(31-IAND( 480+
     %223,31))))
      TABL((1+ishft( 480+239,-(5))))=IOR(TABL((1+ishft( 480+239,-(5)
     %))),ishft(IAND(ETIQ56 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+
     %239,31))))
      TABL((1+ishft( 480+255,-(5))))=IOR(TABL((1+ishft( 480+255,-(5)
     %))),ishft(IAND(ETIQ78 ,ishft(-1,-(32-( 16)))),(31-IAND( 480+
     %255,31))))
      TABL((1+ishft( 480+359,-(5))))=IOR(TABL((1+ishft( 480+359,-(5)
     %))),ishft(IAND(GRTYP ,ishft(-1,-(32-( 08)))),(31-IAND( 480+359
     %,31))))
200   CONTINUE
      RETURN
      ENTRY QSTGPT(TABL)
*
*    GET PARAMETER TABLE
*

      DO 23018 I=1,24
         TABL(I) = TABPRM(I)
23018 CONTINUE 
      RETURN
      ENTRY QSTSPT(TABL)
*
*    SET PARAMETER TABLE
*

      DO 23020 I = 1,24
         TABPRM(I) = TABL(I)
23020 CONTINUE 
      RETURN
      END
      FUNCTION QDRERR(FNAME, MSGERR, NOERR, ERRLVL)
*
*  ECRIT LE MESSAGE D'ERREUR DANS LE FICHIER D'ERREUR ET RETOURNE
*  UN CODE INDIQUANT LA CLASSE DE L'ERREUR.
*

      IMPLICIT NONE
      INTEGER QDRERR
*
*MESSAGES
*           WRITE(LOGFIL,666)FNAME,MSGERR,NOERR
*           666 FORMAT(1X,A,'-',A,2X,'ERR : ',I4)
*           WRITE(LOGFIL,*)' NIVEAU DU MESSAGE > TOLERANCE ERRLVL > TOLRNC'
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      EXTERNAL FSTABT
      CHARACTER *(*)  FNAME,MSGERR
*

      INTEGER NOERR, ERRLVL
*

      QDRERR = -NOERR
      IF((ERRLVL.GE. MSGLVL))THEN

*           WRITE(LOGFIL,'(1X,A,''-'',A,2X,A6,I4)')FNAME,MSGERR,'ERR : ',NOERR
         WRITE(LOGFIL,666)FNAME,MSGERR,NOERR
666      FORMAT(1X,A,'-',A,2X,'ERR : ',I4)

*
      ENDIF 
      IF((ERRLVL.GT. TOLRNC ))THEN
         WRITE(LOGFIL,*)
     %   ' NIVEAU DU MESSAGE > TOLERANCE ERRLVL > TOLRNC'
         CALL FSTABT

*
      ENDIF 
      RETURN
      END

***FONCTION QDRGET OBTENIR UNE OU PLUSIEURS "SLOTS" DANS UNE PAGE
      FUNCTION QDRGET(TEMPBUF, KEY, NBR)
      IMPLICIT NONE
      INTEGER QDRGET
      INTEGER NBR,TEMPBUF( 12,NBR),KEY
*OBJET(QDRGET)
*  OBTIENT L'ENREGISTREMENT SLOTI DE LA PAGE PAGEI, DU FICHIER INDEXE PAR
*  FILEI. LE L'ENREGISTREMENT DOIT EXISTER SINON UN CODE D'ERREUR APPROPRIE
*  EST RETOURNE.
*
*MESSAGES
*         FSTERRO('QDRGET', 'FILE DOES NOT EXIST',ERRFNE,QDRGET)
*         FSTERRO('QDRGET','PAGE NUMBER TOO BIG',ERRPTB,QDRGET)
*         FSTERRO('QDRGET','PAGE NUMBER TOO BIG',ERRPTB,QDRGET)
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
      INTEGER LASTE, FREE, BASE, TOP, PAGE, BUF
      INTEGER VEBASE
      COMMON /QQQDIR/ VEBASE
      COMMON /QQQDIR/LASTE,FREE,BASE(0:40),TOP(0:40),PAGE(1000),BUF(
     %1)
*     LASTE    INDEX OF LAST VALID PAGE IN PAGE TABLE (PAGE)
*     FREE     INDEX OF FIRST FREE PAGE IN PAGE TABLE (FREE > LASTE MEANS NONE)
*     BASE     INDEX OF FIRST PAGE ASSOCIATED WITH A FILE
*     TOP      INDEX OF LAST PAGE ASSOCIATED WITH A PAGE
*     BUF      PHONY ARRAY USED TO GET AT PAGES VIA ADDRESSES (INDEXES)
*              FROM PAGE TABLE  EX. BUF(PAGE(BASE(...)))
*NOTES
*     STRUCTURE DE LA TABLE PAGE (LISTE DES INDICES DES PAGES)
*        _____
*       \     \ (MAXPAGE)
*       \_____\
*       \     \ <--- LASTE (DERNIERE PAGE UTILISABLE)
*       \     \
*       \     \      ....  PAGES LIBRES ICI  ....
*       \     \
*       \_____\ <--- FREE  (PREMIERE PAGE LIBRE)
*       \     \      (SI FREE > LASTE, PAS DE PAGE LIBRE)
*       \     \
*       \     \      ....  PAGES UTILISEES ICI ....
*       \     \
*       \     \      LE FICHIER "N" UTILISE LES PAGES ENTRE
*       \     \         PAGE(BASE(N)) ET PAGE(TOP(N))
*       \     \
*       \     \
*       \_____\ (1)
*
*
*     STRUCTURE DE KEY
*     +---------------------------+----------------+--------------+
*     \       PAGE                \  SLOT          \      FILE    \
*     \       NUMBER              \  NUMBER        \      INDEX   \
*     \       (16 BITS)           \  (8 BITS)      \      (8 BITS)\
*     +---------------------------+----------------+--------------+
*
**
*

      INTEGER DEBSLOT, COUNT, INDPAGE, I, FILEI, PAGEI, SLOTI
      DATA VEBASE/1/, LASTE/0/, FREE/1/
      DATA BASE /41*-1/
      DATA TOP  /41*-1/
      DATA PAGE /1000*-1/
*

      QDRGET= 0
      FILEI = IAND(KEY,255)
      SLOTI = IAND(ishft(KEY,-( 8)),255)
      PAGEI = IAND(ishft(KEY,-( 16)),4095)
*
*  VERIFIE SI LE FICHIER EXISTE
*

      IF( (BASE(FILEI).EQ.-1))THEN
         QDRGET=QDRERR('QDRGET', 'FILE DOES NOT EXIST',12,6)
         RETURN

*
      ENDIF 
      INDPAGE=BASE(FILEI) + PAGEI
*
*  VERIFIE SI LA PAGE EXISTE
*

      IF( (INDPAGE.GT. TOP(FILEI)))THEN
         QDRGET=QDRERR('QDRGET','PAGE NUMBER TOO BIG',13,6)
         RETURN

*
      ENDIF 
      DO 23004 COUNT = 1, NBR
         DEBSLOT = PAGE(INDPAGE) + SLOTI* 12 - 1
         DO 23006 I = 1, 12
            TEMPBUF(I,COUNT)=BUF(DEBSLOT+I)
23006    CONTINUE 
         SLOTI = SLOTI + 1
         IF( (MOD(SLOTI, 256).EQ.0 .AND. COUNT.NE.NBR))THEN
            INDPAGE=INDPAGE + 1
            IF( (INDPAGE.GT. TOP(FILEI) ))THEN
               QDRGET=QDRERR('QDRGET','PAGE NUMBER TOO BIG',13,6)
               RETURN
            ELSE 
               DEBSLOT = PAGE(INDPAGE)
            ENDIF 
         ENDIF 

*
23004 CONTINUE 
      QDRGET = 0
      RETURN
      END

***FUNCTION QDROPN OBTENIR LA PREMIERE PAGE POUR UN FICHIER
      FUNCTION QDROPN(KEY)
      IMPLICIT NONE
      INTEGER QDROPN
      INTEGER  KEY
*
*MESSAGES
*        FSTERRO('QDROPN',' FILE INDEX INVALID',ERRFII,QDROPN)
*        FSTERRO('QDROPN','PAGE TABLE FULL',ERRPTF,QDROPN)
*        FSTERRO('QDROPN',' BASE(FILEI) NOT INITIALISED',ERRBNI,QDROPN)
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*

      INTEGER LASTE, FREE, BASE, TOP, PAGE, BUF
      INTEGER VEBASE
      COMMON /QQQDIR/ VEBASE
      COMMON /QQQDIR/LASTE,FREE,BASE(0:40),TOP(0:40),PAGE(1000),BUF(
     %1)
*     LASTE    INDEX OF LAST VALID PAGE IN PAGE TABLE (PAGE)
*     FREE     INDEX OF FIRST FREE PAGE IN PAGE TABLE (FREE > LASTE MEANS NONE)
*     BASE     INDEX OF FIRST PAGE ASSOCIATED WITH A FILE
*     TOP      INDEX OF LAST PAGE ASSOCIATED WITH A PAGE
*     BUF      PHONY ARRAY USED TO GET AT PAGES VIA ADDRESSES (INDEXES)
*              FROM PAGE TABLE  EX. BUF(PAGE(BASE(...)))
**

      INTEGER FILEI
*

      FILEI = IAND(KEY,255)
      IF((FILEI.LT. 0 .OR. FILEI.GT.40 ))THEN
         QDROPN=QDRERR('QDROPN',' FILE INDEX INVALID',11,6)
         RETURN

*
*  VERIFIER SI LA LISTE DES PAGES LIBRES EST VIDE POUR ALLOUER LA PAGE
*  DYNAMIQUEMENT.
*
      ENDIF 
      IF( (FREE.GT. LASTE))THEN
         LASTE =LASTE + 1
         IF( (LASTE.GT.1000))THEN
            QDROPN=QDRERR('QDROPN','PAGE TABLE FULL',14,6)
            RETURN
         ENDIF 
         CALL MEMOIRH(BUF,PAGE(LASTE), 256* 12)
      ENDIF 
      IF((BASE(FILEI).NE.-1))THEN
         QDROPN=QDRERR('QDROPN',' BASE(FILEI) NOT INITIALISED',35,6)
         RETURN

*
*  ON OBTIENT LA PAGE A PARTIR DE LA LISTE DES PAGES LIBRES.
*
      ENDIF 
      BASE(FILEI) = FREE
      TOP(FILEI) = FREE
      FREE = FREE + 1
      QDROPN = BASE(FILEI)
      RETURN
      END

***FUNCTION QDRPGE OBTENIR UNE PAGE LIBRE
      FUNCTION QDRPGE(FILEI)
*
*  OBTIENT UNE PAGE ET L'AJOUTE AU FICHIER INDEXE PAR FILEI.  LA PAGE EST
*  OBTENUE EN CONSULTANT LA LISTE DES PAGES LIBRES (FREE) OU DANS LE CAS OU
*  CETTE DERNIERE EST VIDE, ON ALLOUE UNE PAGE DYNAMIQUEMENT.
*

      IMPLICIT NONE
      INTEGER QDRPGE
*

      INTEGER  FILEI
*
*MESSAGES
*        FSTERRO('QDRPGE','PAGE TABLE FULL',ERRPTF,QDRPGE)
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
      INTEGER LASTE, FREE, BASE, TOP, PAGE, BUF
      INTEGER VEBASE
      COMMON /QQQDIR/ VEBASE
      COMMON /QQQDIR/LASTE,FREE,BASE(0:40),TOP(0:40),PAGE(1000),BUF(
     %1)
*     LASTE    INDEX OF LAST VALID PAGE IN PAGE TABLE (PAGE)
*     FREE     INDEX OF FIRST FREE PAGE IN PAGE TABLE (FREE > LASTE MEANS NONE)
*     BASE     INDEX OF FIRST PAGE ASSOCIATED WITH A FILE
*     TOP      INDEX OF LAST PAGE ASSOCIATED WITH A PAGE
*     BUF      PHONY ARRAY USED TO GET AT PAGES VIA ADDRESSES (INDEXES)
*              FROM PAGE TABLE  EX. BUF(PAGE(BASE(...)))
*

      INTEGER OLDFPGE, I, IND
*
*
*  VERIFIER SI LA LISTE DES PAGES LIBRES EST VIDE POUR ALLOUER LA PAGE
*  DYNAMIQUEMENT.
*

      IF( (FREE.GT. LASTE))THEN
         LASTE =LASTE + 1
         IF( (LASTE.GT.1000))THEN
            QDRPGE=QDRERR('QDRPGE','PAGE TABLE FULL',14,6)
            RETURN
         ENDIF 
         CALL MEMOIRH(BUF,PAGE(LASTE), 256* 12)

*
*  ON OBTIENT LA PAGE A PARTIR DE LA LISTE DES PAGES LIBRES.
*
      ENDIF 
      DO 23004 I=1,40
         IF( (BASE(I).NE.-1 .AND. BASE(I).GT.BASE(FILEI)))THEN
            BASE(I) = BASE(I) + 1
            TOP(I) = TOP(I) + 1
         ENDIF 
23004 CONTINUE 
      OLDFPGE  = PAGE(FREE)
      DO 23008 I = FREE-1,TOP(FILEI)+1,-1
         PAGE(I+1) = PAGE(I)
23008 CONTINUE 
      FREE = FREE + 1
      TOP(FILEI) = TOP(FILEI) + 1
      PAGE(TOP(FILEI)) = OLDFPGE
      RETURN
      END

***FONCTION QDRPUT REMPLIR UNE OU PLUSIEURS "SLOTS" DANS UNE PAGE
      FUNCTION QDRPUT(TEMPBUF, KEY, NBR)
      IMPLICIT NONE
      INTEGER QDRPUT
      INTEGER NBR, TEMPBUF( 12,NBR), KEY
*
*  ASSIGNE DES SLOTS A UN FICHIER A PARTIR DES VALEURS DU TABLEAU TEMPBUF. NBR
*  SLOTS SONT ASSIGNEES AU FICHIER FILEI, A LA PAGE PAGEI, A PARTIR DE LA SLOT
*  SLOTI.  SI CET INDEX REFERE A UNE SLOT EXISTANT DEJA, LES VALEURS EXISTANTES
*  SERONT REMPLACEES ET LES AUTRES AJOUTEES.  AUCUNE ASSIGNATION NON SEQUEN-
*  TIELLE N'EST PERMISE.  DONC, SI LA PAGE A AJOUTER N'EXISTE PAS, CETTE
*  DERNIERE DOIT SUIVRE SEQUENTIELLEMENT LA DERNIERE PAGE QUI ETAIT EN COURS
*  AU FICHIER DONNE.
*
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
      INTEGER LASTE, FREE, BASE, TOP, PAGE, BUF
      INTEGER VEBASE
      COMMON /QQQDIR/ VEBASE
      COMMON /QQQDIR/LASTE,FREE,BASE(0:40),TOP(0:40),PAGE(1000),BUF(
     %1)
*     LASTE    INDEX OF LAST VALID PAGE IN PAGE TABLE (PAGE)
*     FREE     INDEX OF FIRST FREE PAGE IN PAGE TABLE (FREE > LASTE MEANS NONE)
*     BASE     INDEX OF FIRST PAGE ASSOCIATED WITH A FILE
*     TOP      INDEX OF LAST PAGE ASSOCIATED WITH A PAGE
*     BUF      PHONY ARRAY USED TO GET AT PAGES VIA ADDRESSES (INDEXES)
*              FROM PAGE TABLE  EX. BUF(PAGE(BASE(...)))
*MODULES

      EXTERNAL QDRPGE
      INTEGER  QDRPGE
**

      INTEGER COUNT, INDPAGE, DEBSLOT, I, FILEI, SLOTI, PAGEI,
     % STATUS
*

      FILEI = IAND(KEY,255)
      SLOTI = IAND(ishft(KEY,-( 8)),255)
      PAGEI = IAND(ishft(KEY,-( 16)),4095)
*
*  VERIFIER SI LE TABLEAU PAGE N'EST PAS DEJA PLEIN.
*

      IF( (LASTE.EQ.1000))THEN
         QDRPUT=QDRERR('QDRPUT', 'PAGE TABLE CAPACITY EXCEEDED',23,6
     %   )
         RETURN

*
*  VERIFIER SI LE FICHIER EXISTE
*
      ENDIF 
      IF( (BASE(FILEI).EQ.-1))THEN
         QDRPUT=QDRERR('QDRPUT', 'FILE DOES NOT EXIST',12,6)
         RETURN

*
      ENDIF 
      INDPAGE = BASE(FILEI) + PAGEI
*
*  VERIFIER QUE LES SLOTS A AJOUTER LE SONT DE FACON SEQUENTIELLE I.E.
*  QUE LES PAGES SE SUIVENT ET QUE LES SLOTS SE SUIVENT A L'INTERIEUR D'UNE
*  PAGE.
*

      IF( ( (INDPAGE.GT. (TOP(FILEI) + 1)) .OR.   ((INDPAGE.EQ. TOP(
     %FILEI) + 1) .AND. (SLOTI.NE. 0)) ))THEN
         QDRPUT=QDRERR('QDRPUT','PAGE NUMBER TOO BIG',13,6)
         RETURN

*
      ENDIF 
      IF( (INDPAGE.EQ. TOP(FILEI) + 1))THEN
         STATUS=QDRPGE(FILEI)

*
      ENDIF 
      DO 23008 COUNT = 1, NBR
         DEBSLOT = PAGE(INDPAGE) + SLOTI* 12 - 1
         DO 23010 I = 1, 12
            BUF(DEBSLOT+I)=TEMPBUF(I,COUNT)
23010    CONTINUE 
         SLOTI = SLOTI + 1
         IF( (MOD(SLOTI, 256).EQ.0 .AND. COUNT.NE.NBR))THEN

*
*         ON PASSE A LA PAGE SUIVANTE
*
            INDPAGE = INDPAGE + 1
            IF( (INDPAGE.GT. TOP(FILEI)))THEN
               STATUS=QDRPGE(FILEI)
            ENDIF 
            DEBSLOT = PAGE(INDPAGE)

*
         ENDIF 
23008 CONTINUE 
      QDRPUT = 0
      RETURN
      END

***FONCTION QDRRLS RETOUR DES PAGES UTILISEES PAR UN FICHIER STANDARD
      FUNCTION QDRRLS(KEY)
      IMPLICIT NONE
      INTEGER QDRRLS
      INTEGER KEY
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
      INTEGER LASTE, FREE, BASE, TOP, PAGE, BUF
      INTEGER VEBASE
      COMMON /QQQDIR/ VEBASE
      COMMON /QQQDIR/LASTE,FREE,BASE(0:40),TOP(0:40),PAGE(1000),BUF(
     %1)
*     LASTE    INDEX OF LAST VALID PAGE IN PAGE TABLE (PAGE)
*     FREE     INDEX OF FIRST FREE PAGE IN PAGE TABLE (FREE > LASTE MEANS NONE)
*     BASE     INDEX OF FIRST PAGE ASSOCIATED WITH A FILE
*     TOP      INDEX OF LAST PAGE ASSOCIATED WITH A PAGE
*     BUF      PHONY ARRAY USED TO GET AT PAGES VIA ADDRESSES (INDEXES)
*              FROM PAGE TABLE  EX. BUF(PAGE(BASE(...)))
*
*ARGUMENTS
*  IN    KEY       IDENTIFICATEUR INTERNE (1..MAXSTD) DU FICHIER
*
*MESSAGES
*        FSTWARN('QDRRLS', 'FILE DOES NOT EXIST',ERRFNE,QDRRLS)
*
**

      INTEGER I, J, FILEI, TEMP
*

      QDRRLS= 0
      FILEI = IAND(KEY,255)
*

      IF( (FILEI.LT. 0 .OR. FILEI.GT.40))THEN
         QDRRLS=QDRERR('QDRRLS','FILE INDEX INVALID',11,6)
         RETURN

*
      ENDIF 
      IF( (BASE(FILEI).EQ.-1))THEN
         QDRRLS=QDRERR('QDRRLS', 'FILE DOES NOT EXIST',12,4)
         RETURN

*
      ENDIF 
      J = TOP(FILEI) - BASE(FILEI) + 1
      DO 23004 I=1,40
         IF( (BASE(I).NE.-1 .AND. BASE(I).GT.BASE(FILEI)))THEN
            BASE(I) = BASE(I) - J
            TOP(I) = TOP(I) - J
         ENDIF 

*
23004 CONTINUE 
      DO 23008 I = TOP(FILEI),BASE(FILEI),-1
         TEMP = PAGE(I)
         FREE = FREE - 1
         DO 23010 J = I,FREE-1
            PAGE(J) = PAGE(J+1)
23010    CONTINUE 
         PAGE(FREE) = TEMP

*
23008 CONTINUE 
      BASE(FILEI) =-1
      TOP(FILEI) =-1
*

      RETURN
      END

***S/P QSTARG     TRANSFER ARGUMENTS AU COMMON FSTC88 OU L'INVERSE
*
      SUBROUTINE QSTARG (CDATE, CDEET, CNPAS, CNI, CNJ, CNK,CIP1,
     % CIP2, CIP3,CTYPVAR,CNOMVAR,CETIKET,CGRTYP,CIG1,CIG2,CIG3,
     % CIG4,CDATYP, CSWA, CLNG, CDLTF, CUBC, CNBITS,  ARGTCOM)
*

      IMPLICIT NONE
      LOGICAL ARGTCOM
      CHARACTER *(*) CTYPVAR,CNOMVAR,CETIKET,CGRTYP
      INTEGER CDATE, CDEET, CNPAS, CNI, CNJ, CNK, CNBITS, CDATYP,
     % CIP1,CIP2, CIP3, CIG1, CIG2, CIG3, CIG4, CSWA, CLNG, CDLTF,
     % CUBC
*
*AUTEUR   M. VALIN  -  AVRIL -1989
*
*REVISION  000 NOUVELLE VERSION AVRIL 1989
*
*LANGAGE RATFOR
*
*OBJET (QSTARG)
*           TRANSFER LA VALEUR DES ARGUMENTS DE LA SUBROUTINE DANS LE
*           COMMON FSTC88 SI LA VALEUR DE L'ARGUMENT ARGTCOM=.TRUE.
*           ON TRANSFER LA VALEUR DES ARGUMENTS DANS LE COMMON FSTC88
*           SI ARGTCOM=.FALSE. TRANSFER DU COMMON AUX ARGUMENTS.
*
*MESSAGES   PAR FSTERR   CODE[32]  ' DIR DANS QSTARG INVALID'
*
*ARGUMENTS
*  IN/OUT   CDATE    ENTIER STAMP DATE OPERATIONNELLE
*  IN/OUT   CDEET    ENTIER PAS DE TEMPS
*  IN/OUT   CNPAS    ENTIER NO DU PAS de temps
*  IN/OUT   CNI      PREMIERE DIMENSION DU CHAMP
*  IN/OUT   CNJ      DEUXIEME DIMENSION DU CHAMP
*  IN/OUT   CNK      TROISIEME DIMENSION DU CHAMP NORMALEMENT=1
*  IN/OUT   CIP1     ENTIER NORMALEMENT NIVEAU DESCRIPTEUR <= 32767
*  IN/OUT   CIP2     ENTIER NORMALEMENT HEURE  DESCRIPTEUR <= 32767
*  IN/OUT   CIP3     ENTIER OUVERT POUR UTILISATION PAR USAGER <= 4095
*  IN/OUT   CTYPVAR  TYPE DE CHAMP CHARACTER * 1
*  IN/OUT   CNOMVAR  NOM DU CHAMP  CHARACTER * 2
*  IN/OUT   CETIKET  8 CARACTERES DE L'ETIQUETTE
*  IN/OUT   CGRTYP   GRID TYPE DU CHAMP CHARACTER * 1
*  IN/OUT   CIG1     ENTIER DESCRIPTEUR DE GRILLE <= 2047
*  IN/OUT   CIG2     ENTIER DESCRIPTEUR DE GRILLE <= 2047
*  IN/OUT   CIG3     ENTIER DESCRIPTEUR DE GRILLE <= 65535
*  IN/OUT   CIG4     ENTIER DESCRIPTEUR DE GRILLE <= 65535
*  IN/OUT   CDATYP   TYPE DE CHAMP POUR LA COMPRESSION 0-1-2-3
*  IN/OUT   CSWA     ENTIER ADRESSE EN CHUNKS(960 BITS) ORIGINE 1
*  IN/OUT   CLNG     ENTIER LONGUEUR(EN MOTS DISQUE) DES DONNEES
*  IN/OUT   CDLTF    ENTIER MARQUEUR D'EFFACEMENT ( 1=EFFACE)
*  IN/OUT   CUBC     ENTIER "UNUSED BITS COUNT"
*  IN/OUT   CNBITS   NOMBRE DE BITS
*  IN/OUT   ARGTCOM  .TRUE. ARG A COMMON  .FALSE. COMMON A ARG
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*
*--------------------------------------------------------------------------
*MODULES
*NONE
**

      CHARACTER *1 CAR1LOC
      CHARACTER *2 CAR2LOC
      CHARACTER *4 CAR4LOC
      CHARACTER *8 CAR8LOC
*-----------------------------------------------------------------------
*
*     TRANSFER VALEUR DES ARGUMENTS AUX VARIABLES DU COMMON FSTC88
*

      IF((ARGTCOM))THEN

*        ----------------------------------------------------------------
         DATE = CDATE
         DEET = CDEET
         NPAS = CNPAS
         NI   = CNI
         NJ   = CNJ
         NK   = MAX(1,CNK)
         NBITS= CNBITS
         DATYP= CDATYP
         IP1  = CIP1
         IP2  = CIP2
         IP3  = CIP3
         IG1  = CIG1
         IG2  = CIG2
         IG3  = CIG3
         IG4  = CIG4
         SWA  = CSWA
         LNG  = CLNG
         DLTF = CDLTF
         UBC  = CUBC
*
*        FINI AVEC LES ENTIERS  LES CARACTERES NEXT
*

         CAR1LOC = CTYPVAR
         READ(CAR1LOC,'(A1)') TYPVAR
         TYPVAR =ishft(TYPVAR,-(32 - (1*08)))
*

         CAR2LOC = CNOMVAR
         READ(CAR2LOC,'(A2)') NOMVAR
         NOMVAR =ishft(NOMVAR,-( 32 - (2*08)))
*

         CAR8LOC = CETIKET
         READ(CAR8LOC,'(A4,A2,A2)') ETIQ14,ETIQ56,ETIQ78
         ETIQ14 =ishft(ETIQ14,-( 32 - (4*08)))
         ETIQ56 =ishft(ETIQ56,-( 32 - (2*08)))
         ETIQ78 =ishft(ETIQ78,-( 32 - (2*08)))
         ETIQ58 = IOR(ETIQ78,ishft(ETIQ56,2*08))
*

         CAR1LOC = CGRTYP
         READ(CAR1LOC,'(A1)') GRTYP
         GRTYP =ishft(GRTYP,-( 32 - (1*08)))
*        ---------------------------------------------------------------

      ELSE 

*        ----------------------------------------------------------------
*        TRANSFER VALEUR DES VARIABLES DU COMMON FSTC88 AUX ARGUMENTS DE LA
*        ROUTINE QSTARG
*
         CDATE = DATE
         CDEET = DEET
         CNPAS = NPAS
         CNI   = NI
         CNJ   = NJ
         CNK   = MAX(1,NK)
         CNBITS= NBITS
         CDATYP= DATYP
         CIP1  = IP1
         CIP2  = IP2
         CIP3  = IP3
         CIG1  = IG1
         CIG2  = IG2
         CIG3  = IG3
         CIG4  = IG4
         CSWA  = SWA
         CLNG  = LNG
         CDLTF = DLTF
         CUBC  = UBC
*
*        FINI AVEC LES ENTIERS  LES CARACTERES NEXT
*

         WRITE(CAR1LOC,'(A1)')ishft(TYPVAR,32 - (1*08))
         CTYPVAR = CAR1LOC
*

         WRITE(CAR2LOC,'(A2)')ishft(NOMVAR,32 - (2*08))
         CNOMVAR = CAR2LOC
*

         WRITE(CAR8LOC,'(A4,A2,A2)')ishft(ETIQ14,32 - (4*08)),ishft(
     %   ETIQ56,32 - (2*08)),ishft(ETIQ78,32 - (2*08))
         CETIKET = CAR8LOC
*

         WRITE(CAR1LOC,'(A1)')ishft(GRTYP,32 - (1*08))
         CGRTYP = CAR1LOC
*        --------------------------------------------------------


*
      ENDIF 
      RETURN
      END

***FONCTION QSTDBG - IMPRIME COMMON FSTC88 DU DIRECTEUR DE CHAQUE FICHIER.
*
      FUNCTION QSTDBG(ORIGIN, NIVEAU)
      IMPLICIT NONE
      INTEGER QSTDBG
      INTEGER NIVEAU
      CHARACTER *(*) ORIGIN
      CHARACTER *7 LUIUN
*
*AUTEUR   - C. THIBEAULT - JAN 83
*
*REVISION  001 P. SARRAZIN JUIN 89 DORVAL P.Q. [ COS - NOS - NOSVE]
*
*LANGAGE  - RATFOR
*
*OBJET(QSTDBG)
*         - CETTE ROUTINE AIDE A METTRE A POINT LES FICHIERS STANDARDS
*           EN IMPRIMANT LE CONTENU DU BLOC COMMON /FSTD88/ QUI SERT A
*           LA GESTION DES FICHIERS ET EN IMPRIMANT LE CONTENU DU
*           DIRECTEUR DE CHAQUE FICHIER OUVERT.
*
*
*ARGUMENTS
*         ORIGIN  CHAINE HOLLERITH IDENTIFIANT L'APPEL (8 CAR MAX)
*         NIVEAU  PERMET D'AUGMENTER LE NIVEAU DE DETAIL DES MESSAGES
*                 0 DONNE LE CONTENU DU COMMON FSTC88
*                 1 DONNE, EN PLUS, LE CONTENU DU DIRECTEUR ET INDEX
*                   DE CHAQUE FICHIER STANDARD OUVERT.
*
*
*MESSAGES
*  600 FORMAT(1H0,' IND',1X,'IUN',1X,'DIRSZ',1X,'NBCORR',1X,'NUTIL',3X,
*             'NXTADR',1X,'NUMREC',1X,'PRMECR',1X,'NBECR',1X,'NBRECR',1X,
*             'NRECUP',2X,'NBEFF',1X,' NBEXT',1X,'MODIFS',1X,'FASTIO')
*  601 FORMAT(1X,I3,2X,I3,1X,I4,1X,I7,1X,I5,2X,I7,1X,I4,2X,L5,2X,I5,1X,I6,
*             1X,I6,1X,I6,1X,I6,1X,L5,1X,L5)
*  602 FORMAT(1H1, 'QSTDBG - ORIGINE=', A8, '  NIVEAU=',I1/)
*  605 FORMAT(1H1,'UNITE = ',I4)
*  620 FORMAT('DBG(',I2,')')
*

      EXTERNAL QSTUPC,QDRGET,QSTWPM,QSTINT
      INTEGER  QDRGET,QSTINT
*
*
*IMPLICITES
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
**

      INTEGER BUFFER( 12), I, IREC, KEY, IGET, CUR, NXT
      WRITE(LOGFIL,602) ORIGIN, NIVEAU
      WRITE(LOGFIL,600)
      DO 23000 I=0,40
         IF( (IUNTAB(I).EQ. -1 ))THEN
            GOTO 23000
         ENDIF 
         CUR = CURSEQ(I)
         NXT = NXTSEQ(I)
         IF((DIRSIZ(I).EQ.0 .AND. NBCORR(I).EQ.0))THEN
            CUR=0
            NXT=0
         ENDIF 
         WRITE(LOGFIL,601) I,IUNTAB(I),DIRSIZ(I),NBCORR(I),NUTIL(I),
     %   NXTADR(I),NUMREC(I),PRMECR(I),NBECR(I),NBRECR(I),NRECUP(I),
     %   NBEFF(I),NBEXT(I),CUR ,NXT ,MODIFS(I),FASTIO
23000 CONTINUE 
      IF((NIVEAU.GE. 1))THEN

*
         DO 23008 I=0,40
            IF( (IUNTAB(I).EQ. -1 .OR. DIRSIZ(I).EQ. 0 ))THEN
               GOTO 23008
            ENDIF 
            WRITE(LOGFIL,605) IUNTAB(I)
            WRITE(LOGFIL,*)
     %      '           KEY#  ID    IP1  IP2  IP3    NI    NJ',
     %'   NK ETIQ.    DATE ORIG.   DEET  NPAS GR   IG1  IG2   IG3   IG4'
     %      ,' DTY     SWA   LNG'
*

            DO 23012 IREC=0,NUTIL(I)-1
               KEY = IOR(ishft(IREC, 8), I)
               IGET = QDRGET(BUFFER(1), KEY, 1)
               CALL QSTUPC(BUFFER(1))
*

               IF((DLTF.EQ.1))THEN
                  QSTDBG=QDRERR('QSTDBG',' RECORD EFFACE',27,6)
                  GOTO 23012

*
               ENDIF 
               WRITE(LUIUN,620) IUNTAB(I)
               CALL QSTWPM(KEY, LUIUN)
23012       CONTINUE 
23008    CONTINUE 

*
*-----------------------------------------------------------------------
*
      ENDIF 
600   FORMAT(1H0,' IND',1X,'IUN',1X,'DIRSZ',1X,'NBCORR',1X,'NUTIL',
     %3X,'NXTADR',1X,'NUMREC',1X,'PRMECR',1X,'NBECR',1X,'NBRECR',1X,
     %'NRECUP',2X,'NBEFF',1X,' NBEXT',1X,' CURSEQ',1X,' NXTSEQ',1X,
     %'MODIFS',1X,'FASTIO')
601   FORMAT(1X,I3,2X,I3,1X,I4,1X,I7,1X,I5,2X,I7,1X,I4,2X,L5,2X,I5,
     %1X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,L5,1X,L5)
602   FORMAT(1H1, 'QSTDBG - ORIGINE=', A8, '  NIVEAU=',I1/)
605   FORMAT(1H1,'UNITE = ',I4)
620   FORMAT('DBG(',I2,')')
      RETURN
      END

***FONCTION QSTEOI , ECRIT LE DERNIER REC AVEC UN EOF DE 31
*
      FUNCTION QSTEOI(INDESC)
      IMPLICIT NONE
      INTEGER QSTEOI
      INTEGER INDESC
*
*AUTEUR   M. VALIN  -  FEV 90
*
*REVISION
*
*LANGAGE RATFOR
*
*OBJET (QSTEOI)
*           ECRIT LE DERNIER RECORD AVEC UN HEADER CONTENANT UN
*           EOF DE NIVEAU 31 FIN DU FICHIER.
*
*MODULES
*
*ARGUMENTS
*  IN       INDESC  EXTRAIT DE INDESC=QSTINT(IUN)
*
*IMPLICITES
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      EXTERNAL WAWRIT
      INTEGER I, EOD(30), IUN
      SAVE EOD
      DATA EOD /28*0,O"25252525252",O"25252525252"/
*

      QSTEOI=0
      IUN = IUNTAB(INDESC)
      DO 23000 I=1,28
         EOD(I) = 0
*
*--------------------------------------------------------------------------
*
*       STORE DANS LE TABLEAU LE FLAG DE TERMINAISON EOF DE 31 BIT 511
*       STORE INDICE COURANTE DANS LE TABLEAU LOCATION 575
*

23000 CONTINUE 
      EOD((1+ishft( 511,-(5))))=IOR( EOD((1+ishft( 511,-(5)))),ishft
     %(IAND( 31,ishft(-1,-(32-( 32)))),(31-IAND( 511,31))))
      EOD((1+ishft( 575,-(5))))=IOR( EOD((1+ishft( 575,-(5)))),ishft
     %(IAND( ((CURSEQ(INDESC)-1)/30),ishft(-1,-(32-( 32)))),(31-IAND
     %( 575,31))))
      CALL WAWRIT(IUN, EOD, NXTSEQ(INDESC),30)
*--------------------------------------------------------------------------
*

      RETURN
      END

***FONCTION QSTINT , RETOURNE L'INDEX DU FICHIER IUN
*
      FUNCTION QSTINT(IUN)
      IMPLICIT NONE
      INTEGER QSTINT
      INTEGER IUN
*
*AUTEUR   M. VALIN  -  JAN 89
*
*REVISION
*
*LANGAGE RATFOR
*
*OBJET (QSTINT)
*           RETOURNE L'INDEX DU FICHIER RND STD EXTRAIT DANS LA TABLE
*           DU FICHIER STANDARD
*
*MODULES
*
*ARGUMENTS
*  OUT      QSTINT  INDEX DU FICHIER DANS LA TABLE
*  IN       IUN     NUMERO D'UNITE FORTRAN
*
*IMPLICITES
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
**

      INTEGER INDQST
*

      INDQST = 0
*
*--------------------------------------------------------------------------

23000 IF( ((INDQST.LT.41) .AND. (IUNTAB(INDQST).NE.IUN)))THEN
         INDQST = INDQST + 1
*

         GOTO 23000
      ENDIF 
      QSTINT = INDQST
*--------------------------------------------------------------------------
*

      RETURN
      END

***FONCTION QSTWDR   REECRIRE DIRECTEUR DISQUE
*
      FUNCTION QSTWDR(INDESC)
*

      IMPLICIT NONE
      INTEGER QSTWDR
      INTEGER INDESC
*
*AUTEUR   M. VALIN  -  AVRIL -1989
*
*REVISION  000 NOUVELLE VERSION AVRIL 1989
*REVISION  001 bug fix pour nombre d'entree pair
*
*LANGAGE RATFOR
*
*OBJET(QSTWDR)
*        UNPACK MEMOIR INTERNE SECTION PAIRE - PACK FORMAT DISK
*        UNPACK MEMOIR INTERNE SECTION IMPAIRE - PACK FORMAT DISK
*        RECRIRE LE DIRECTEUR (HEADER) SUR DISQUE
*
*MESSAGES
*         WRITE(LOGFIL,*) ' FILE PROLOG UPDATED QSTWDR '
*
*ARGUMENTS
*  IN       INDESC    INDEX DU FICHIER RANDOM
*
*IMPLICITES
*
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL QSTPKA,QSTPKB,WAREAD,WAWRIT,QSTUPC,QDRGET,QDRPUT
      EXTERNAL QSTUPA,QSTUPB,QSTPKC
      INTEGER QDRGET,QDRPUT,QSTWHD,QSTRHD,QSTRDR
**

      INTEGER ISRT, KEY, IUN, BUFWDR(30), TABLE(12,2), IGET, I,J
      INTEGER BUFWHD(30), BUFRHD(30), BUFRDR(30), IPUT, INX
      INTEGER BUFFER(30), ADRBUF
*     EQUIVALENCE (BUFWDR(1),BUFWHD(1))
*     EQUIVALENCE (BUFWDR(1),BUFRHD(1)),(BUFWDR(1),BUFFER(1))
*
*

      DO 23000 I=1,12
         DO 23002 J=1,2
            TABLE(I,J) = 0
23002    CONTINUE 

*
23000 CONTINUE 
      QSTWDR =0
*

      DO 23004 ISRT = 0, NUTIL(INDESC)-1, 2
         DO 23006 I=1,30
            BUFWDR(I) = 0
23006    CONTINUE 
         KEY = IOR(ishft(ISRT, 8), INDESC)
         IGET = QDRGET(TABLE(1,1), KEY , 2)
         IF((IGET.LT. 0))THEN
            QSTWDR = IGET
            RETURN

*
         ENDIF 
         CALL QSTUPC(TABLE(1,1))
         CALL QSTPKA(BUFWDR(1))
*

         IF( (ISRT+1 .LT. NUTIL(INDESC)))THEN
            CALL QSTUPC(TABLE(1,2))
            CALL QSTPKB(BUFWDR(1))

*
         ENDIF 
         IUN = IUNTAB(INDESC)
         CALL WAWRIT(IUN, BUFWDR, 1+(ISRT/2)*30+30,30)
         IF((MSGLVL.LE.0))THEN
            WRITE(LOGFIL,*) ' FILE PROLOG UPDATED QSTWDR '
         ENDIF 

*
23004 CONTINUE 
      RETURN
*
*
*---------------------------------------------------------------------------
*
***FONCTION QSTWHD   BATIR L'ENTETE ET ECRIRE AU DEBUT
*

      ENTRY QSTWHD(INDESC)
*
*
*AUTEUR   M. VALIN  -  AVRIL -1989
*
*REVISION  000 NOUVELLE VERSION AVRIL 1989
*
*LANGAGE RATFOR
*
*OBJET(QSTWHD)
*        ECRIRE L'ENTETE SUR UNITE IUNTAB(INDESC)
*        LA POSITION 1 A DIMPRO
*
*MESSAGES
*         WRITE(LOGFIL,*) ' HEADER WRITEN QSTWHD '
*
*ARGUMENTS
*  IN       INDESC    INDEX DU FICHIER RANDOM
*
**

      QSTWHD = 0
      DO 23014 I= 1,30
         BUFWHD(I) = 0
*

23014 CONTINUE 
      BUFWHD(1) = RDSYNC
      BUFWHD(2) = RDSYN2
*

      BUFWHD((1+ishft( 095,-(5))))=IOR(BUFWHD((1+ishft( 095,-(5)))),
     %ishft(IAND( DIRSIZ(INDESC),ishft(-1,-(32-( 32)))),(31-IAND(
     % 095,31))))
      BUFWHD((1+ishft( 159,-(5))))=IOR(BUFWHD((1+ishft( 159,-(5)))),
     %ishft(IAND( NUTIL (INDESC),ishft(-1,-(32-( 32)))),(31-IAND(
     % 159,31))))
      BUFWHD((1+ishft( 223 ,-(5))))=IOR(BUFWHD((1+ishft( 223 ,-(5)))
     %),ishft(IAND( NBECR (INDESC),ishft(-1,-(32-( 32)))),(31-IAND(
     % 223 ,31))))
      BUFWHD((1+ishft( 287,-(5))))=IOR(BUFWHD((1+ishft( 287,-(5)))),
     %ishft(IAND( NBRECR(INDESC),ishft(-1,-(32-( 32)))),(31-IAND(
     % 287,31))))
      BUFWHD((1+ishft( 351 ,-(5))))=IOR(BUFWHD((1+ishft( 351 ,-(5)))
     %),ishft(IAND( NBEXT (INDESC) + 32768,ishft(-1,-(32-( 32)))),(
     %31-IAND( 351 ,31))))
      BUFWHD((1+ishft( 415,-(5))))=IOR(BUFWHD((1+ishft( 415,-(5)))),
     %ishft(IAND( NRECUP(INDESC),ishft(-1,-(32-( 32)))),(31-IAND(
     % 415,31))))
      BUFWHD((1+ishft( 479 ,-(5))))=IOR(BUFWHD((1+ishft( 479 ,-(5)))
     %),ishft(IAND( NBEFF (INDESC),ishft(-1,-(32-( 32)))),(31-IAND(
     % 479 ,31))))
      BUFWHD((1+ishft( 543,-(5))))=IOR(BUFWHD((1+ishft( 543,-(5)))),
     %ishft(IAND( NBCORR(INDESC),ishft(-1,-(32-( 32)))),(31-IAND(
     % 543,31))))
*

      CALL WAWRIT(IUNTAB(INDESC), BUFWHD, 1,30)
*

      IF((MSGLVL.LE.0))THEN
         WRITE(LOGFIL,*) ' HEADER WRITEN QSTWHD '
*

      ENDIF 
      RETURN
*
*
*---------------------------------------------------------------------------
*
***FONCTION QSTRHD   LIRE L'ENTETE ET TRANSFER DANS COMMON FSTC88
*

      ENTRY QSTRHD(INDESC)
*
*
*AUTEUR   M. VALIN  -  AVRIL -1989
*
*REVISION  000 NOUVELLE VERSION AVRIL 1989
*
*LANGAGE RATFOR
*
*OBJET(QSTRHD)
*        LIRE L'ENTETE SUR UNITE IUNTAB(INDESC)
*        LA POSITION 1 A DIMPRO
*
*MESSAGES
*         WRITE(LOGFIL,*) ' READ HEADER QSTRHD '
*
*ARGUMENTS
*  IN       INDESC    INDEX DU FICHIER RANDOM
*
**

      QSTRHD = 0
      IUN = IUNTAB(INDESC)
      CALL WAREAD(IUN, BUFRHD, 1,30)
*

      DIRSIZ(INDESC) =IAND(ishft(BUFRHD((1+ishft( 095,-(5)))),-((31-
     %IAND( 095,31)))),ishft(-1,-(32-( 32))))
      NUTIL (INDESC) =IAND(ishft(BUFRHD((1+ishft( 159,-(5)))),-((31-
     %IAND( 159,31)))),ishft(-1,-(32-( 32))))
      NBECR (INDESC) =IAND(ishft(BUFRHD((1+ishft( 223 ,-(5)))),-((31
     %-IAND( 223 ,31)))),ishft(-1,-(32-( 32))))
      NBRECR(INDESC) =IAND(ishft(BUFRHD((1+ishft( 287,-(5)))),-((31-
     %IAND( 287,31)))),ishft(-1,-(32-( 32))))
      NBEXT (INDESC) =IAND(ishft(BUFRHD((1+ishft( 351 ,-(5)))),-((31
     %-IAND( 351 ,31)))),ishft(-1,-(32-( 32))))
      NRECUP(INDESC) =IAND(ishft(BUFRHD((1+ishft( 415,-(5)))),-((31-
     %IAND( 415,31)))),ishft(-1,-(32-( 32))))
      NBEFF (INDESC) =IAND(ishft(BUFRHD((1+ishft( 479 ,-(5)))),-((31
     %-IAND( 479 ,31)))),ishft(-1,-(32-( 32))))
      NBCORR(INDESC) =IAND(ishft(BUFRHD((1+ishft( 543,-(5)))),-((31-
     %IAND( 543,31)))),ishft(-1,-(32-( 32))))
*

      IF((MSGLVL.LE.0))THEN
         WRITE(LOGFIL,*) ' READ HEADER QSTRHD '
*

      ENDIF 
      RETURN
*
*---------------------------------------------------------------------------
*
***FONCTION QSTRDR   DEPACK TABLE DU DISK PAIR/IMPAIR
*

      ENTRY QSTRDR( INDESC)
*
*
*AUTEUR   M. VALIN  -  AVRIL -1989
*
*REVISION  000 NOUVELLE VERSION AVRIL 1989
*
*LANGAGE RATFOR
*
*OBJET(QSTRDR)
*        LIRE DISQUE ENTRE PAIR IMPAIR
*
*
*MESSAGES
*
*ARGUMENTS
*  IN       INDESC    INDEX DU FICHIER RANDOM
*
**
*

      INX = -1
      ADRBUF =30 + 1
      QSTRDR = 0
      IUN = IUNTAB(INDESC)
      DO 23020 I =  0,  DIRSIZ(INDESC)-1,  2

*
*        DEPACK  TABLE DU DISK A ET B PAIR/IMPAIR
*
         CALL WAREAD(IUN,BUFFER(1),ADRBUF,30)
         ADRBUF = ADRBUF +30
*-------------------------------------------------------------------------
*
*         UNPACK ENTREE PAIRE
*

         CALL QSTUPA (BUFFER(1) )
         IF( (SWA .EQ. 1))THEN
            GOTO 23021
         ENDIF 
         NXTADR(INDESC) = MAX0(NXTADR(INDESC), (SWA + LNG) )
         INX = I
         KEY = INDESC +ishft(INX,  8)
*

         CALL QSTPKC (TABLE(1,1))
*-------------------------------------------------------------------------
*
*        UNPACK  ENTREE IMPAIRE
*

         CALL QSTUPB (BUFFER(1) )
         IF( (SWA .EQ. 1))THEN
            GOTO 23021
         ENDIF 
         NXTADR(INDESC) = MAX0(NXTADR(INDESC), (SWA + LNG) )
         INX = INX + 1
*

         CALL QSTPKC (TABLE(1,2))
*

         IPUT= QDRPUT( TABLE(1,1), KEY, 2 )
*
*        TABLE(1,1), KEY,2 ) IMPAIR   DANS QDRPUT 0,1,2,3....
*

         IF(( IPUT.LT. 0 ))THEN
            QSTRDR = IPUT
            RETURN

*
         ENDIF 

*-------------------------------------------------------------------------
*
*     SI INX PAIR STOCKER LA DERNIERE ENTREE
*
23020 CONTINUE 
23021 CONTINUE 
      IF((MOD(INX,2) .EQ. 0 ))THEN
         IPUT= QDRPUT( TABLE(1,1), KEY, 1 )
*
*         TABLE(1,1), KEY, 1 ) PAIR  DANS QDRPUT  0,1,2,3,....
*

         IF( (IPUT.LT. 0 ))THEN
            QSTRDR = IPUT
            RETURN
         ENDIF 
      ENDIF 
      QSTRDR = INX
*

      RETURN
*

      END

***FONCTION QSTWDE   MISE A JOUR D'UNE ENTREE DU DIRECTEUR
*
      FUNCTION QSTWDE( KEY, CORE, DISK)
*

      IMPLICIT NONE
      INTEGER QSTWDE
      LOGICAL CORE, DISK
      INTEGER KEY
*
*AUTEUR   M. VALIN  -  AVRIL -1989
*
*REVISION  000 NOUVELLE VERSION AVRIL 1989
*
*LANGAGE RATFOR
*
*OBJET (QSTWDE)
*           SI CORE TRUE ON REARRANGE DIRECTEUR DU CORE
*           SI DISK TRUE ON REARRANGE DIRECTEUR DU DISQUE
*
*MESSAGES
*
*ARGUMENTS
*  IN       KEY
*  IN       CORE      METRE A JOUR DU DIRECTEUR CORE
*  IN       DISK      METRE A JOUR DU DIRECTEUR DISQUE
*
*IMPLICITES
*

      EXTERNAL QDRERR, MEMOIRH
      INTEGER QDRERR, QDRSTAT, QDRTMP1, QDRTMP2, QDRTMP3
*
*
*REVISION
*         1.0.1 -  AJOUTER 2 TABLES POUR FICHIER RANDOM/SEQ STANDARD
*                   MODIFICATIONS 22 JANV 89
*
*  COMMON FSTC88   CE BLOC SERT A LA GESTION DES FICHIERS
*  ------ ------   STANDARDS (1988 OU AVANT ) QUI SONT OUVERTS.
*

      COMMON /FSTC88/ IUNTAB(0:41),DIRSIZ(0:40), NBCORR(0:40),NUTIL
     % (0:40), NXTADR(0:40), NUMREC(0:40),PRMECR(0:40), NBECR (0:40)
     %, NBRECR(0:40),NRECUP(0:40), NBEFF (0:40), NBEXT (0:40),MSKPRT
     %( 6,0:40),   SEARCH( 6,0:40),MASQUE( 6,0:40),   CURSLT( 12,0:
     %40),MODIFS(0:40),NXTSEQ(0:40),CURSEQ(0:40),DIAGP, LOGFIL,
     % DEBUG, FASTIO, TOLRNC, MSGLVL,NPAIRE,COPYMOD, CHAINE(0:40),
     % EFFDSC(0:40)
      INTEGER   IUNTAB, DIRSIZ, NUTIL , NXTADR, NUMREC, MSKPRT,
     %MASQUE, SEARCH, NBECR , NBRECR, NRECUP, NBEFF,NBEXT , NBCORR,
     % LOGFIL, DEBUG,  CURSLT, TOLRNC,MSGLVL, NPAIRE, NXTSEQ, CURSEQ
     %, CHAINE, EFFDSC
      LOGICAL   PRMECR, FASTIO, MODIFS, DIAGP, COPYMOD
*
*  IUNTAB  IUNTAB(I) >= 0 EST LE NUMERO D'UNITE DU FICHIER DECRIT
*                         PAR L'ENTREE I DES TABLES DE CE BLOC.
*          IUNTAB(I) = -1 INDIQUE UNE ENTREE LIBRE.
*          IUNTAB(MXSTD1) SERT DE SENTINELLE.
*
*  DIRSIZ  TAILLE DU DIRECTEUR SUR DISQUE, I.E. LE NOMBRE MAXIMUM
*          D'ENTREES QU'IL PEUT CONTENIR. (0 = SEQUENTIEL)
*  NUTIL   NOMBRE D'ENTREES EFFECTIVEMENT UTILISEES DANS L'INDEX
*          (MEMOIRE OU DISQUE).
*  NXTADR  PROCHAINE ADRESSE DISPONIBLE POUR ECRIRE UN ENREGISTREMENT.
*
*  NUMREC  POSITION COURANTE DE RECHERCHE DANS LE DIRECTEUR, UTILISEE
*          POUR PASSER AU 'SUIVANT'.  0 INDIQUE DE PARTIR AU DEBUT,
*          TANDIS QUE -1 INDIQUE QUE L'OPERATION 'SUIVANT' EST ILLEGALE.
*          POUR UN FICHIER SEQUENTIEL, NUMREC = 1 (OU 0).
*          -1 = RIEN DE VALIDE
*           0 = RIEN DE VALIDE / RECHERCHE DU SUIVANT ACCEPTABLE
*           1 = APRES QSTSUI/FSTSUI
*           2 = APRES LECTURE
*           FSTSEL = 0 / FSTPOS = -1 / FSTSKP = -1 / FSTRWD = -1
*
*  MSKPRT  MASQUE PARTIEL COURANT, SPECIFIE PAR LA ROUTINE STDMSQ.
*  MASQUE  MASQUE DE RECHERCHE COURANT.
*  SEARCH  VALEUR DE RECHERCHE COURANTE.
*
*  PRMECR  INDIQUE SI ON PEUT ECRIRE SUR LE FICHIER (.TRUE.) OU NON.
*
*  NBECR   NOMBRE TOTAL D'ECRITURES EFFECTUEES SUR CE FICHIER DEPUIS
*          SA CREATION (INCLUANT RE-ECRITURES ET RECUPERATIONS).
*  NBRECR  NOMBRE TOTAL DE RE-ECRITURES EFFECTUEES.
*  NRECUP  NOMBRE DE FOIS QU'ON A RECUPERE UNE QUELCONQUE ENTREE
*          DETRUITE (Y COMPRIS LORS D'UNE RE-ECRITURE).
*  NBEFF   NOMBRE D'ENREGISTREMENTS EFFACES (Y COMPRIS LORS D'UNE
*          RE-ECRITURE).
*  NBEXT   NOMBRE DE FOIS QU'ON A ETENDU L'INDEX-DISQUE.
*  NBCORR  NOMBRE DE FOIS QU'ON A CORRIGE L'ENTETE DU FICHIER.
*
*  CURSLT  ENTREE DE DIRECTEUR ACTIVE (LA SEULE SI SEQUENTIEL)
*
*  FASTIO  INDIQUE SI ON OPTIMISE L'IO AU PRIX DE LA SECURITE
*  MODIFS  INDIQUE (POUR FASTIO) SI LE DIRECTEUR D'UN FICHIER A ETE MODIFIE
*  DIAGP   INDIQUE S'IL FAUT IMPRIMER CERTAINS MESSAGES.
*  LOGFIL  UNITE FORTRAN QUI RECEVRA LES MESSAGES DE TOUT POIL.
*  DEBUG   OPTION DE TRACE POUR LA ROUTINE STDDBG.
*
*          CE BLOC COMMON CONTIENT AUSSI LE RESULTAT DE L'EXPANSION DE LA
*          DERNIERE "SLOT" ACTIVE (VOIR DECK PCKUNP) DANS LES VARIABLES
*          DATE A UBC. LE TOUT EST AUSSI DISPONIBLE SOUS FORME DE TABLE
*          DANS LE TABLEAU TABPRM (FORMAT HOLLERITH MAX. 4 CARACTERES).
*

      COMMON /FSTC88/ DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,
     %  DATYP,  IP1,   IP2,   IP3,   TYPVAR,NOMVAR, ETIQ14, ETIQ58,
     % GRTYP,  IG1,   IG2,IG3,   IG4,   SWA,   LNG,   DLTF,   UBC,
     %ETIQ56, ETIQ78
      INTEGER   DATE,   DEET,   NPAS,   NI,   NJ,   NK,NBITS,  DATYP
     %,  ETIQ14, NOMVAR, TYPVAR, IP1,IP2,   IP3,   GRTYP,  IG1,
     %   IG2,   IG3,IG4,   SWA,   LNG,   DLTF,   UBC,   ETIQ58,
     %ETIQ56, ETIQ78
      INTEGER   TABPRM(26)
      EQUIVALENCE   (TABPRM(1),DATE)
      INTEGER RDSYNC, RDSYN2, SQSYNC, SQSYN2
      COMMON /FSTSYNC/ RDSYNC, RDSYN2, SQSYNC, SQSYN2
*
*
**
*--------------------------------------------------------------------------
*MODULES

      EXTERNAL QSTPKA,QSTPKB,WAREAD,WAWRIT,QSTPKC,QDRPUT
*

      INTEGER QDRPUT,  ISRT, INDESC, IUN, NUMBER, BUFFER(30)
*

      QSTWDE =0
      ISRT=0
      INDESC = IAND(KEY,255)
*

      IF((CORE))THEN
         CALL QSTPKC(CURSLT(1,INDESC))
         ISRT = QDRPUT(CURSLT(1,INDESC), KEY, 1)
*

         IF((ISRT.LT. 0 ))THEN
            QSTWDE = ISRT
            RETURN
         ENDIF 

*
*---------------------------------------------------------------------------
*
      ENDIF 
      IF((DISK))THEN
         IUN = IUNTAB(INDESC)
         NUMBER =ishft(KEY,-(  8))
         CALL WAREAD(IUN, BUFFER, 1+(NUMBER/2)*30+30,30)
*
*         SI PAIR
*

         IF((IAND(NUMBER,1) .EQ. 0))THEN
            CALL QSTPKA(BUFFER(1))
         ELSE 
            CALL QSTPKB(BUFFER(1))

*
         ENDIF 
         CALL WAWRIT(IUN, BUFFER, 1+(NUMBER/2)*30+30,30)
*

      ENDIF 
      RETURN
*

      END

*** S/P R4AA4    TRANSFORMER R4A EN A4
*
      SUBROUTINE R4AA4(R4A,A4,N)
      IMPLICIT NONE
      INTEGER R4A(*), A4(*), N
      INTEGER NBMOT,BLANK,NI,DPC,I
*
*AUTEUR     M. LEPINE  MARS 85
*
*LANGAGE   RATFOR
*
*OBJET(R4AA4)
*     TRANSFORMER N CARACTERES CONTENUS DANS DES MOT R4A (4 CAR DE 8 BITS
*  ALIGNES DANS LA PARTIE DROITE DU MOT) EN N CARACTERES CONTENUS DANS DES
*  MOT DE TYPE A4 (4 CAR ALIGNES A GAUCHE DANS LE MOT)
*
*ARGUMENTS
*  OUT   A4     TABLEAU D'ENTIERS CONTENANT LES CAR. DE TYPE A4
*  IN    R4A    TABLEAU D'ENTIERS CONTENANT LES CAR. DE TYPE R4A
*  IN    N      NOMBRE DE CARACTERES A TRANSFORMER
*
**

      NBMOT = N / 4
      DO 23000 I = 1,NBMOT
         A4(I) = R4A(I)
23000 CONTINUE 
      NI = MOD(N,4)
      IF( (NI .NE. 0))THEN
         A4(NBMOT+1) =ishft(R4A(NBMOT+1),-(32-8*NI))
         DO 23004 I=3,NI,-1
            A4(I) = IOR(ishft(A4(I),8),32)
23004    CONTINUE 

*
      ENDIF 
      RETURN
      END

*** S/P R4ASTRG     TRANSFORMER DU R4A EN CARACTERES
*
      SUBROUTINE R4ASTRG(STRG,R4A,POSDEB,POSFIN)
      IMPLICIT NONE
      CHARACTER * (*) STRG
      INTEGER R4A(0:*)
      INTEGER POSDEB,POSFIN,POS,LNG,MAXCAR,MOT,CARPOS,SHFCNT,C,I,MSK
*
*AUTEUR     M. LEPINE  MARS 85
*
*LANGAGE    RATFOR
*
*OBJET(R4ASTRG)
*     TRANSFORMER N CARACTERES CONTENUS DANS DES MOT R4A (4 CAR. DE 8 BITS
*  ALIGNES DANS LA PARTIE DROITE DU MOT) EN N CARACTERES CONTENUS DANS UNE
*  CHAINE DE CARACTERES AU SENS FORTRAN.
*
*ARGUMENTS
*  IN     R4A     TABLEAU D'ENTIERS CONTENANT LES CARACTERES DE TYPE R4A
*  OUT    STRG    TABLEAU DE CARACTERES TRANSFORMES
*  IN     POSDEB  POSITION DU PREMIER CARACTERE DANS R4A
*  IN     POSFIN  POSITION DU DERNIER CARACTERE DANS R4A
*
**
*                    C170 - C180 - CRAY - SUN
*------------------------------------------------------------------

      POS = POSDEB
      DO 23000 I = 1,POSFIN-POSDEB+1
         MOT = POS / 4
         CARPOS = MOD(POS,4)
         SHFCNT = (3- CARPOS) * 8
         C = IAND(255,ishft(R4A(MOT),-( SHFCNT)))
*------------------------------------------------------------------

         WRITE(STRG(I:I),'(A1)')ishft(C, 32 - 08)
         POS = POS + 1

*
23000 CONTINUE 
      RETURN
      END

*** S/P STRGR4A    TRANSFORMER UNE CHAINE DE CAR EN R4A
*
      SUBROUTINE STRGR4A(STRG,R4A,POSDEB,POSFIN)
      CHARACTER * (*) STRG
      INTEGER R4A(0:*)
      INTEGER POSDEB,POSFIN,POS,LNG,MAXCAR,MOT,CARPOS,SHFCNT,C,I,MSK
*
*AUTEUR     M. LEPINE  MARS 85
*
*LANGAGE    RATFOR
*
*OBJET(STRGR4A)
*     TRANSFORMER UNE CHAINE DE CARACTERES EN MOT DE TYPE R4A
*  (4 CAR. DE 8 BITS ALIGNES DANS LA PARTIE DROITE DU MOT).
*
*ARGUMENTS
*  IN     STRG    CHAINE DE CARACTERES A TRANSFORMER
*  OUT    R4A     TABLEAU D'ENTIERS QUI CONTIENDRA LES CAR R4A
*  IN     POSDEB  POSITION DU PREMIER CARACTERE DANS R4A
*  IN     POSFIN  POSITION DU DERNIER CARACTERE DANS R4A
*
**
*

      LNG = LEN(STRG)
      MAXCAR = MIN(LNG,POSFIN-POSDEB+1)
      POS = POSDEB
      DO 23000 I = 1,MAXCAR
         READ(STRG(I:I),'(A1)') C
         C =ishft(C,-( 32 - 08))
         MOT = POS / 4
         CARPOS = MOD(POS,4)
         SHFCNT = (3-CARPOS) * 8
*-----------------------------------------------------------------------

         MSK =ishft(255, SHFCNT)
*

         R4A(MOT) = IAND(R4A(MOT),NOT(MSK))
         R4A(MOT) = IOR(R4A(MOT),ishft(C,SHFCNT))
*-----------------------------------------------------------------------

         POS = POS + 1

*
23000 CONTINUE 
      RETURN
      END

*** S/P SYSTMDT  EXTRAIRE HEURE ET DATE VALIDE A L EXECUTION
*
      SUBROUTINE SYSTMDT ( DAT, TIM )
*

      IMPLICIT NONE
      CHARACTER *(*) DAT, TIM
*
*AUTEUR   P. SARRAZIN  FEV 89
*
*REVISION  000 NOUVELLE VERSION FEV 1989
*
*LANGAGE RATFOR
*
*OBJET (SYSTMDT)
*           EXTRAIRE LA DATE ET L'HEURE DU SYSTEME REQUIS AU MOMENT
*           DE L EXECUTION.
*
*ARGUMENTS
*  OUT      DAT      DATE  DU SYSTEME VALIDE AU MOMENT DE L'EXECUTION
*  OUT      TIM      HEURE DU SYSTEME VALIDE AU MOMENT DE L'EXECUTION
*
**
*
*IMPLICITES

      EXTERNAL FDATE
*

      CHARACTER * 24 STRING
*

      CALL FDATE(STRING)
      DAT(1:15) = STRING(1:10)//STRING(20:24)
      TIM(1:8) = STRING(12:19)
*

      RETURN
      END
