"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lambdaHandler = void 0;
const AWS = require('aws-sdk');
exports.lambdaHandler = async (event = {}) => {
    console.log('event', event);
    try {
        switch (event.RequestType) {
            case 'Create':
                return await checkLambdaArn(event);
            case 'Update':
                return await checkLambdaArn(event);
        }
    }
    catch (err) {
        console.error('Unexpected error', err);
        return {
            Data: {
                Status: 'FAILED',
                Reason: JSON.stringify(err),
            },
        };
    }
};
const checkLambdaArn = async (event) => {
    let redactFunctions = [];
    let sortedRedactFunctions = [];
    let dateGroup = [];
    const props = event.ResourceProperties;
    const lambdaFixedName = props.LambdaFixedName;
    const genre = props.Genre;
    const physicalId = 'ComprehendLambda' + lambdaFixedName + (Math.floor(Math.random() * 1000000) + 1).toString();
    try {
        var lambda = new AWS.Lambda({ apiVersion: '2015-03-31' });
        let params = {};
        let functionArn = '';
        const result = await lambda.listFunctions(params).promise();
        if (lambdaFixedName === 'PiiAccessControlFunction') {
            for (var lambdaFunction of result.Functions) {
                var funcName = lambdaFunction.FunctionName;
                if (funcName.includes(lambdaFixedName)) {
                    functionArn = lambdaFunction.FunctionArn;
                    break;
                }
            }
            ;
        }
        if (lambdaFixedName === 'PiiRedactionFunction') {
            for (var lambdaFunction of result.Functions) {
                var funcName = lambdaFunction.FunctionName;
                if (funcName.includes(lambdaFixedName)) {
                    redactFunctions.push({
                        arn: lambdaFunction.FunctionArn,
                        lastModified: lambdaFunction.LastModified,
                    });
                }
            }
            ;
            for (var redactFunction of redactFunctions) {
                dateGroup.push(redactFunction.lastModified);
            }
            dateGroup.sort((a, b) => 0 - (a > b ? -1 : 1));
            for (var dateTime of dateGroup) {
                for (var redactFunction of redactFunctions) {
                    if (redactFunction.lastModified === dateTime) {
                        sortedRedactFunctions.push({
                            arn: redactFunction.arn,
                            lastModified: redactFunction.lastModified,
                        });
                    }
                }
            }
            switch (genre) {
                case 'Admin':
                    functionArn = sortedRedactFunctions[0].arn;
                    break;
                case 'Billing':
                    functionArn = sortedRedactFunctions[1].arn;
                    break;
                case 'CustSupport':
                    functionArn = sortedRedactFunctions[2].arn;
                    break;
                default:
                    functionArn = '';
                    break;
            }
        }
        return {
            Status: 'SUCCESS',
            Reason: '',
            LogicalResourceId: event.LogicalResourceId,
            PhysicalResourceId: physicalId,
            RequestId: event.RequestId,
            StackId: event.StackId,
            Data: { LambdaArn: functionArn },
        };
    }
    catch (error) {
        return {
            Status: 'FAILED',
            Reason: JSON.stringify(error),
            LogicalResourceId: event.LogicalResourceId,
            PhysicalResourceId: physicalId,
            RequestId: event.RequestId,
            StackId: event.StackId,
        };
    }
};
//# sourceMappingURL=data:application/json;base64,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