# -*- coding: utf-8 -*-
# Generated by Django 1.11.10 on 2018-09-05 17:20
from __future__ import unicode_literals

import sqlite3
import time

from django.db import migrations
from django.db import models
from django.db import transaction
from django.db.utils import OperationalError
from django.db.utils import ProgrammingError


def create_content_cache_key(apps, schema_editor):
    from kolibri.core.device.models import ContentCacheKey

    try:
        with transaction.atomic():
            ContentCacheKey.update_cache_key()
    except (OperationalError, ProgrammingError, sqlite3.OperationalError):
        # let's not run this on a database cache
        # that might not have been created yet
        pass


class Migration(migrations.Migration):

    dependencies = [("device", "0002_devicesettings_default_facility")]
    atomic = False

    operations = [
        migrations.CreateModel(
            name="ContentCacheKey",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("key", models.IntegerField(default=time.time)),
            ],
        ),
        migrations.RunPython(create_content_cache_key, migrations.RunPython.noop),
    ]
