"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gql = void 0;
const graphql_1 = require("graphql");
function gql(literals, ...placeholders) {
    const interleaved = [];
    for (let i = 0; i < placeholders.length; i++) {
        interleaved.push(literals[i]);
        interleaved.push(placeholders[i]);
    }
    interleaved.push(literals[literals.length - 1]);
    const actualSchema = interleaved.join('');
    return graphql_1.parse(actualSchema);
}
exports.gql = gql;
//# sourceMappingURL=gql.js.map