import { Template } from 'cloudform-types';
import { FileHandler } from './fileUtils';
import { TransformConfig } from './transformConfig';
import { FeatureFlagProvider } from '../FeatureFlags';
export declare const CLOUDFORMATION_FILE_NAME = "cloudformation-template.json";
export declare const PARAMETERS_FILE_NAME = "parameters.json";
export interface ProjectOptions {
    projectDirectory?: string;
    transformersFactory: Function;
    transformersFactoryArgs: object[];
    currentCloudBackendDirectory: string;
    rootStackFileName?: string;
    dryRun?: boolean;
    disableFunctionOverrides?: boolean;
    disablePipelineFunctionOverrides?: boolean;
    disableResolverOverrides?: boolean;
    buildParameters?: Object;
    minify?: boolean;
    featureFlags: FeatureFlagProvider;
}
export declare function buildProject(opts: ProjectOptions): Promise<{
    resolvers: import("../DeploymentResources").StringMap;
    stacks: {
        [name: string]: Template;
    };
    stackMapping: import("../DeploymentResources").StackMapping;
    pipelineFunctions: import("../DeploymentResources").StringMap;
    functions: {
        [path: string]: string;
    };
    schema: string;
    rootStack: Template;
}>;
export interface UploadOptions {
    directory: string;
    upload: FileHandler;
}
export declare function uploadDeployment(opts: UploadOptions): Promise<void>;
interface MigrationOptions {
    projectDirectory: string;
    cloudBackendDirectory?: string;
}
export declare function migrateAPIProject(opts: MigrationOptions): Promise<{
    project: any;
    cloudBackend: any;
}>;
export declare function revertAPIMigration(directory: string, oldProject: AmplifyApiV1Project): Promise<void>;
interface AmplifyApiV1Project {
    schema: string;
    parameters: any;
    template: Template;
}
export declare function readV1ProjectConfiguration(projectDirectory: string): Promise<AmplifyApiV1Project>;
export declare function makeTransformConfigFromOldProject(project: AmplifyApiV1Project): TransformConfig;
export {};
//# sourceMappingURL=amplifyUtils.d.ts.map