export interface IfNode {
    kind: 'If';
    predicate: Expression;
    expr: Expression;
    inline: boolean;
}
export declare function iff(predicate: Expression, expr: Expression, inline?: boolean): IfNode;
export interface IfElseNode {
    kind: 'IfElse';
    predicate: Expression;
    ifExpr: Expression;
    elseExpr: Expression;
    inline: boolean;
}
export declare function ifElse(predicate: Expression, ifExpr: Expression, elseExpr: Expression, inline?: boolean): IfElseNode;
export interface AndNode {
    kind: 'And';
    expressions: Expression[];
}
export declare function and(expressions: Expression[]): AndNode;
export interface OrNode {
    kind: 'Or';
    expressions: Expression[];
}
export declare function or(expressions: Expression[]): OrNode;
export interface ParensNode {
    kind: 'Parens';
    expr: Expression;
}
export declare function parens(expr: Expression): ParensNode;
export interface EqualsNode {
    kind: 'Equals';
    leftExpr: Expression;
    rightExpr: Expression;
}
export declare function equals(leftExpr: Expression, rightExpr: Expression): EqualsNode;
export interface NotEqualsNode {
    kind: 'NotEquals';
    leftExpr: Expression;
    rightExpr: Expression;
}
export declare function notEquals(leftExpr: Expression, rightExpr: Expression): NotEqualsNode;
export interface NotNode {
    kind: 'Not';
    expr: Expression;
}
export declare function not(expr: Expression): NotNode;
export interface ReturnNode {
    kind: 'Return';
    value: Expression;
}
export declare function ret(value?: Expression): ReturnNode;
export interface ForEachNode {
    kind: 'ForEach';
    key: ReferenceNode;
    collection: ReferenceNode;
    expressions: Expression[];
}
export declare function forEach(key: ReferenceNode, collection: ReferenceNode, expressions: Expression[]): ForEachNode;
export interface StringNode {
    kind: 'String';
    value: string;
}
export declare function str(value: string): StringNode;
export interface RawNode {
    kind: 'Raw';
    value: string;
}
export declare function raw(value: string): RawNode;
export interface QuotesNode {
    kind: 'Quotes';
    expr: Expression;
}
export declare function quotes(expr: Expression): QuotesNode;
export interface FloatNode {
    kind: 'Float';
    value: number;
}
export declare function float(value: number): FloatNode;
export interface IntNode {
    kind: 'Int';
    value: number;
}
export declare function int(value: number): IntNode;
export interface BooleanNode {
    kind: 'Boolean';
    value: boolean;
}
export declare function bool(value: boolean): BooleanNode;
export interface NullNode {
    kind: 'Null';
}
export declare function nul(): NullNode;
export interface ReferenceNode {
    kind: 'Reference';
    value: string;
}
export declare function ref(value: string): ReferenceNode;
export interface QuietReferenceNode {
    kind: 'QuietReference';
    value: string | Expression;
}
export declare function qref(value: string | Expression): QuietReferenceNode;
export interface ObjectNode {
    kind: 'Object';
    attributes: [string, Expression][];
}
export declare function obj(o: {
    [key: string]: Expression;
}): ObjectNode;
export interface ListNode {
    kind: 'List';
    expressions: Expression[];
}
export declare function list(expressions: Expression[]): ListNode;
export interface SetNode {
    kind: 'Set';
    key: ReferenceNode;
    value: Expression;
}
export declare function set(key: ReferenceNode, value: Expression): SetNode;
export interface CommentNode {
    kind: 'Comment';
    text: string;
}
export declare function comment(text: string): CommentNode;
export interface CompoundExpressionNode {
    kind: 'CompoundExpression';
    expressions: Expression[];
    joiner: string;
    recurseIndent: boolean;
}
export declare function compoundExpression(expressions: Expression[], joiner?: string, recurseIndent?: boolean): CompoundExpressionNode;
export declare type ToJsonNode = {
    kind: 'Util.ToJson';
    expr: Expression;
};
export declare function toJson(expr: Expression): ToJsonNode;
export declare type IsNullOrEmptyNode = {
    kind: 'Util.isNullOrEmpty';
    expr: Expression;
};
export declare function isNullOrEmpty(expr: Expression): IsNullOrEmptyNode;
export declare type NewLineNode = {
    kind: 'NewLine';
};
export declare function newline(): NewLineNode;
export declare function block(name: string, exprs: Expression[]): CompoundExpressionNode;
export declare function methodCall(methodName: ReferenceNode, ...params: Expression[]): CompoundExpressionNode;
export declare type Expression = IfNode | IfElseNode | AndNode | OrNode | ParensNode | EqualsNode | NotEqualsNode | ForEachNode | StringNode | RawNode | QuotesNode | FloatNode | IntNode | BooleanNode | NullNode | ReferenceNode | QuietReferenceNode | ObjectNode | ListNode | SetNode | CommentNode | CompoundExpressionNode | ToJsonNode | IsNullOrEmptyNode | NotNode | NewLineNode | ReturnNode;
//# sourceMappingURL=ast.d.ts.map