import { ModelAuthTransformerConfig } from 'graphql-auth-transformer';
import { Resource } from './resource';
export interface SchemaTransformerProps {
    /**
     * File path to the graphql schema
     *
     * @default schema.graphql
     */
    schemaPath?: string;
    /**
     * Path where transformed schema and resolvers will be placed
     *
     * @default appsync
     */
    outputPath?: string;
    /**
     * Set deletion protection on DynamoDB tables
     *
     * @default true
     */
    deletionProtectionEnabled?: boolean;
    /**
     * Where to enable DataStore or not
     *
     * @default false
     */
    syncEnabled?: boolean;
}
export declare class SchemaTransformer {
    outputs: any;
    resolvers: any;
    schemaPath: string;
    outputPath: string;
    isSyncEnabled: boolean;
    authRolePolicy: Resource | undefined;
    unauthRolePolicy: Resource | undefined;
    authTransformerConfig: ModelAuthTransformerConfig;
    constructor(props: SchemaTransformerProps);
    transform(): any;
    getResolvers(): any;
    private writeSchema;
    private writeResolversToFile;
    /**
     * @returns {@link TransformConfig}
    */
    private loadConfigSync;
}
