# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class MediaUtilization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        MediaUtilization - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'maximum_capacity': 'int',
            'interruptable_media_types': 'list[str]',
            'include_non_acd': 'bool'
        }

        self.attribute_map = {
            'maximum_capacity': 'maximumCapacity',
            'interruptable_media_types': 'interruptableMediaTypes',
            'include_non_acd': 'includeNonAcd'
        }

        self._maximum_capacity = None
        self._interruptable_media_types = None
        self._include_non_acd = None

    @property
    def maximum_capacity(self):
        """
        Gets the maximum_capacity of this MediaUtilization.
        Defines the maximum number of conversations of this type that an agent can handle at one time.

        :return: The maximum_capacity of this MediaUtilization.
        :rtype: int
        """
        return self._maximum_capacity

    @maximum_capacity.setter
    def maximum_capacity(self, maximum_capacity):
        """
        Sets the maximum_capacity of this MediaUtilization.
        Defines the maximum number of conversations of this type that an agent can handle at one time.

        :param maximum_capacity: The maximum_capacity of this MediaUtilization.
        :type: int
        """
        
        self._maximum_capacity = maximum_capacity

    @property
    def interruptable_media_types(self):
        """
        Gets the interruptable_media_types of this MediaUtilization.
        Defines the list of other media types that can interrupt a conversation of this media type.  Values include call, chat, email, callback, and message.

        :return: The interruptable_media_types of this MediaUtilization.
        :rtype: list[str]
        """
        return self._interruptable_media_types

    @interruptable_media_types.setter
    def interruptable_media_types(self, interruptable_media_types):
        """
        Sets the interruptable_media_types of this MediaUtilization.
        Defines the list of other media types that can interrupt a conversation of this media type.  Values include call, chat, email, callback, and message.

        :param interruptable_media_types: The interruptable_media_types of this MediaUtilization.
        :type: list[str]
        """
        
        self._interruptable_media_types = interruptable_media_types

    @property
    def include_non_acd(self):
        """
        Gets the include_non_acd of this MediaUtilization.
        If true, then track non-ACD conversations against utilization

        :return: The include_non_acd of this MediaUtilization.
        :rtype: bool
        """
        return self._include_non_acd

    @include_non_acd.setter
    def include_non_acd(self, include_non_acd):
        """
        Sets the include_non_acd of this MediaUtilization.
        If true, then track non-ACD conversations against utilization

        :param include_non_acd: The include_non_acd of this MediaUtilization.
        :type: bool
        """
        
        self._include_non_acd = include_non_acd

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

