# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AvailableTopic(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AvailableTopic - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'description': 'str',
            'id': 'str',
            'requires_permissions': 'list[str]',
            'schema': 'dict(str, object)'
        }

        self.attribute_map = {
            'description': 'description',
            'id': 'id',
            'requires_permissions': 'requiresPermissions',
            'schema': 'schema'
        }

        self._description = None
        self._id = None
        self._requires_permissions = None
        self._schema = None

    @property
    def description(self):
        """
        Gets the description of this AvailableTopic.


        :return: The description of this AvailableTopic.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AvailableTopic.


        :param description: The description of this AvailableTopic.
        :type: str
        """
        
        self._description = description

    @property
    def id(self):
        """
        Gets the id of this AvailableTopic.


        :return: The id of this AvailableTopic.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AvailableTopic.


        :param id: The id of this AvailableTopic.
        :type: str
        """
        
        self._id = id

    @property
    def requires_permissions(self):
        """
        Gets the requires_permissions of this AvailableTopic.


        :return: The requires_permissions of this AvailableTopic.
        :rtype: list[str]
        """
        return self._requires_permissions

    @requires_permissions.setter
    def requires_permissions(self, requires_permissions):
        """
        Sets the requires_permissions of this AvailableTopic.


        :param requires_permissions: The requires_permissions of this AvailableTopic.
        :type: list[str]
        """
        
        self._requires_permissions = requires_permissions

    @property
    def schema(self):
        """
        Gets the schema of this AvailableTopic.


        :return: The schema of this AvailableTopic.
        :rtype: dict(str, object)
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this AvailableTopic.


        :param schema: The schema of this AvailableTopic.
        :type: dict(str, object)
        """
        
        self._schema = schema

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

