/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.tw.jena.query.fulltext.analyzer;

import edu.rpi.tw.jena.query.fulltext.analyzer.Util;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingMultilingualAnalyzer
extends DelegatingAnalyzerWrapper {
    private static Logger log = LoggerFactory.getLogger(IndexingMultilingualAnalyzer.class);
    private Analyzer defaultAnalyzer;

    public IndexingMultilingualAnalyzer(Analyzer defaultAnalyzer) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        int idx = fieldName.lastIndexOf("_");
        if (idx == -1) {
            return this.defaultAnalyzer;
        }
        String lang = fieldName.substring(idx + 1);
        Analyzer analyzer = Util.getIndexAnalyzer(lang);
        analyzer = (Analyzer)ObjectUtils.defaultIfNull((Object)analyzer, (Object)Util.getLocalizedAnalyzer(lang));
        analyzer = (Analyzer)ObjectUtils.defaultIfNull((Object)analyzer, (Object)this.defaultAnalyzer);
        log.trace("getWrappedAnalyzer fieldName: {}, analyzer: {}", (Object)fieldName, (Object)analyzer);
        return analyzer;
    }

    public String toString() {
        return "IndexingMultilingualAnalyzer(default=" + this.defaultAnalyzer + ")";
    }
}

