/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.tw.jena.query.fulltext;

import edu.rpi.tw.jena.query.fulltext.TextQueryPF;
import edu.rpi.tw.jena.query.fulltext.assembler.TextAssembler;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.Metadata;

public class TextQuery {
    private static volatile boolean initialized = false;
    private static Object lock = new Object();
    public static String NS = "http://jena.apache.org/fulltext#";
    public static String IRI = "http://jena.apache.org/#text";
    public static final Symbol textIndex = Symbol.create((String)(NS + "index"));
    public static final String PATH = "edu.rpi.tw.jena.query.fulltext";
    private static String metadataLocation = "org/apache/jena/query/text/properties.xml";
    private static Metadata metadata = new Metadata(metadataLocation);
    public static final String NAME = "ARQ Text Query";
    public static final String VERSION = metadata.get("edu.rpi.tw.jena.query.fulltext.version", "unknown");
    public static final String BUILD_DATE = metadata.get("edu.rpi.tw.jena.query.fulltext.build.datetime", "unset");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (initialized) {
                JenaSystem.logLifecycle((String)"TextQuery.init - skip", (Object[])new Object[0]);
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle((String)"TextQuery.init - start", (Object[])new Object[0]);
            TextAssembler.init();
            SystemInfo sysInfo = new SystemInfo(IRI, PATH, VERSION, BUILD_DATE);
            SystemARQ.registerSubSystem((SystemInfo)sysInfo);
            PropertyFunctionRegistry.get().put("http://jena.apache.org/fulltext#search", new PropertyFunctionFactory(){

                public PropertyFunction create(String uri) {
                    return new TextQueryPF();
                }
            });
            JenaSystem.logLifecycle((String)"TextQuery.init - finish", (Object[])new Object[0]);
        }
    }

    static {
        JenaSystem.init();
    }
}

