/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.encoder;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Encoders;

public final class Encode {
    private Encode() {
    }

    public static String forHtml(String input) {
        return Encode.forXml(input);
    }

    public static void forHtml(Writer out, String input) throws IOException {
        Encode.forXml(out, input);
    }

    public static String forHtmlContent(String input) {
        return Encode.forXmlContent(input);
    }

    public static void forHtmlContent(Writer out, String input) throws IOException {
        Encode.forXmlContent(out, input);
    }

    public static String forHtmlAttribute(String input) {
        return Encode.forXmlAttribute(input);
    }

    public static void forHtmlAttribute(Writer out, String input) throws IOException {
        Encode.forXmlAttribute(out, input);
    }

    public static String forHtmlUnquotedAttribute(String input) {
        return Encode.encode(Encoders.HTML_UNQUOTED_ATTRIBUTE_ENCODER, input);
    }

    public static void forHtmlUnquotedAttribute(Writer out, String input) throws IOException {
        Encode.encode(Encoders.HTML_UNQUOTED_ATTRIBUTE_ENCODER, out, input);
    }

    public static String forCssString(String input) {
        return Encode.encode(Encoders.CSS_STRING_ENCODER, input);
    }

    public static void forCssString(Writer out, String input) throws IOException {
        Encode.encode(Encoders.CSS_STRING_ENCODER, out, input);
    }

    public static String forCssUrl(String input) {
        return Encode.encode(Encoders.CSS_URL_ENCODER, input);
    }

    public static void forCssUrl(Writer out, String input) throws IOException {
        Encode.encode(Encoders.CSS_URL_ENCODER, out, input);
    }

    @Deprecated
    public static String forUri(String input) {
        return Encode.encode(Encoders.URI_ENCODER, input);
    }

    @Deprecated
    public static void forUri(Writer out, String input) throws IOException {
        Encode.encode(Encoders.URI_ENCODER, out, input);
    }

    public static String forUriComponent(String input) {
        return Encode.encode(Encoders.URI_COMPONENT_ENCODER, input);
    }

    public static void forUriComponent(Writer out, String input) throws IOException {
        Encode.encode(Encoders.URI_COMPONENT_ENCODER, out, input);
    }

    public static String forXml(String input) {
        return Encode.encode(Encoders.XML_ENCODER, input);
    }

    public static void forXml(Writer out, String input) throws IOException {
        Encode.encode(Encoders.XML_ENCODER, out, input);
    }

    public static String forXmlContent(String input) {
        return Encode.encode(Encoders.XML_CONTENT_ENCODER, input);
    }

    public static void forXmlContent(Writer out, String input) throws IOException {
        Encode.encode(Encoders.XML_CONTENT_ENCODER, out, input);
    }

    public static String forXmlAttribute(String input) {
        return Encode.encode(Encoders.XML_ATTRIBUTE_ENCODER, input);
    }

    public static void forXmlAttribute(Writer out, String input) throws IOException {
        Encode.encode(Encoders.XML_ATTRIBUTE_ENCODER, out, input);
    }

    public static String forXmlComment(String input) {
        return Encode.encode(Encoders.XML_COMMENT_ENCODER, input);
    }

    public static void forXmlComment(Writer out, String input) throws IOException {
        Encode.encode(Encoders.XML_COMMENT_ENCODER, out, input);
    }

    public static String forCDATA(String input) {
        return Encode.encode(Encoders.CDATA_ENCODER, input);
    }

    public static void forCDATA(Writer out, String input) throws IOException {
        Encode.encode(Encoders.CDATA_ENCODER, out, input);
    }

    public static String forJava(String input) {
        return Encode.encode(Encoders.JAVA_ENCODER, input);
    }

    public static void forJava(Writer out, String input) throws IOException {
        Encode.encode(Encoders.JAVA_ENCODER, out, input);
    }

    public static String forJavaScript(String input) {
        return Encode.encode(Encoders.JAVASCRIPT_ENCODER, input);
    }

    public static void forJavaScript(Writer out, String input) throws IOException {
        Encode.encode(Encoders.JAVASCRIPT_ENCODER, out, input);
    }

    public static String forJavaScriptAttribute(String input) {
        return Encode.encode(Encoders.JAVASCRIPT_ATTRIBUTE_ENCODER, input);
    }

    public static void forJavaScriptAttribute(Writer out, String input) throws IOException {
        Encode.encode(Encoders.JAVASCRIPT_ATTRIBUTE_ENCODER, out, input);
    }

    public static String forJavaScriptBlock(String input) {
        return Encode.encode(Encoders.JAVASCRIPT_BLOCK_ENCODER, input);
    }

    public static void forJavaScriptBlock(Writer out, String input) throws IOException {
        Encode.encode(Encoders.JAVASCRIPT_BLOCK_ENCODER, out, input);
    }

    public static String forJavaScriptSource(String input) {
        return Encode.encode(Encoders.JAVASCRIPT_SOURCE_ENCODER, input);
    }

    public static void forJavaScriptSource(Writer out, String input) throws IOException {
        Encode.encode(Encoders.JAVASCRIPT_SOURCE_ENCODER, out, input);
    }

    static String encode(Encoder encoder, String str2) {
        int n;
        int j;
        if (str2 == null) {
            str2 = "null";
        }
        if ((j = encoder.firstEncodedOffset(str2, 0, n = str2.length())) == n) {
            return str2;
        }
        return new Buffer().encode(encoder, str2, j);
    }

    static void encode(Encoder encoder, Writer out, String str2) throws IOException {
        int n;
        int j;
        if (str2 == null) {
            str2 = "null";
        }
        if ((j = encoder.firstEncodedOffset(str2, 0, n = str2.length())) == n) {
            out.write(str2);
            return;
        }
        new Buffer().encode(encoder, out, str2, j);
    }

    static class Buffer {
        static final int INPUT_BUFFER_SIZE = 1024;
        static final int OUTPUT_BUFFER_SIZE = 2048;
        final CharBuffer _input = CharBuffer.allocate(1024);
        final CharBuffer _output = CharBuffer.allocate(2048);

        Buffer() {
        }

        String encode(Encoder encoder, String str2, int j) {
            int n = str2.length();
            int remaining = n - j;
            if (remaining <= 1024 && j <= 2048) {
                str2.getChars(0, j, this._output.array(), 0);
                str2.getChars(j, n, this._input.array(), 0);
                this._input.limit(remaining).position(0);
                this._output.clear().position(j);
                CoderResult cr = encoder.encodeArrays(this._input, this._output, true);
                if (cr.isUnderflow()) {
                    return new String(this._output.array(), 0, this._output.position());
                }
                CharBuffer tmp = CharBuffer.allocate(this._output.position() + encoder.maxEncodedLength(this._input.remaining()));
                tmp.put(this._output.array(), 0, this._output.position());
                cr = encoder.encodeArrays(this._input, tmp, true);
                if (cr.isOverflow()) {
                    throw new AssertionError((Object)"unexpected result from encoder");
                }
                return new String(tmp.array(), 0, tmp.position());
            }
            int m = j + encoder.maxEncodedLength(remaining);
            CharBuffer buffer = CharBuffer.allocate(m);
            str2.getChars(0, j, buffer.array(), 0);
            str2.getChars(j, n, buffer.array(), m - remaining);
            CharBuffer input = buffer.duplicate();
            input.limit(m).position(m - remaining);
            buffer.position(j);
            CoderResult cr = encoder.encodeArrays(input, buffer, true);
            if (cr.isOverflow()) {
                throw new AssertionError((Object)"unexpected result from encoder");
            }
            return new String(buffer.array(), 0, buffer.position());
        }

        void encode(Encoder encoder, Writer out, String str2, int j) throws IOException {
            out.write(str2, 0, j);
            int n = str2.length();
            this._input.clear();
            this._output.clear();
            char[] inputArray = this._input.array();
            char[] outputArray = this._output.array();
            while (true) {
                CoderResult cr;
                int remainingInput = n - j;
                int startPosition = this._input.position();
                int batchSize = Math.min(remainingInput, this._input.remaining());
                str2.getChars(j, j + batchSize, inputArray, startPosition);
                this._input.limit(startPosition + batchSize);
                while (!(cr = encoder.encodeArrays(this._input, this._output, batchSize == remainingInput)).isUnderflow()) {
                    out.write(outputArray, 0, this._output.position());
                    this._output.clear();
                }
                if ((j += this._input.position() - startPosition) == n) {
                    out.write(outputArray, 0, this._output.position());
                    return;
                }
                this._input.compact();
            }
        }
    }
}

