/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.web.servlet.OncePerRequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdviceFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AdviceFilter.class);

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        return true;
    }

    protected void postHandle(ServletRequest request, ServletResponse response) throws Exception {
    }

    public void afterCompletion(ServletRequest request, ServletResponse response, Exception exception) throws Exception {
    }

    protected void executeChain(ServletRequest request, ServletResponse response, FilterChain chain) throws Exception {
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        Exception exception = null;
        try {
            boolean continueChain = this.preHandle(request, response);
            if (log.isTraceEnabled()) {
                log.trace("Invoked preHandle method.  Continuing chain?: [" + continueChain + "]");
            }
            if (continueChain) {
                this.executeChain(request, response, chain);
            }
            this.postHandle(request, response);
            if (log.isTraceEnabled()) {
                log.trace("Successfully invoked postHandle method");
            }
        }
        catch (Exception e2) {
            exception = e2;
        }
        finally {
            this.cleanup(request, response, exception);
        }
    }

    protected void cleanup(ServletRequest request, ServletResponse response, Exception existing) throws ServletException, IOException {
        Exception exception = existing;
        try {
            this.afterCompletion(request, response, exception);
            if (log.isTraceEnabled()) {
                log.trace("Successfully invoked afterCompletion method.");
            }
        }
        catch (Exception e2) {
            if (exception == null) {
                exception = e2;
            }
            log.debug("afterCompletion implementation threw an exception.  This will be ignored to allow the original source exception to be propagated.", e2);
        }
        if (exception != null) {
            if (exception instanceof ServletException) {
                throw (ServletException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (log.isDebugEnabled()) {
                String msg = "Filter execution resulted in an unexpected Exception (not IOException or ServletException as the Filter API recommends).  Wrapping in ServletException and propagating.";
                log.debug(msg);
            }
            throw new ServletException(exception);
        }
    }
}

