/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class NamedMatches
implements Matches {
    private final Matches in;
    private final String name;

    public NamedMatches(String name, Matches in) {
        this.in = Objects.requireNonNull(in);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public MatchesIterator getMatches(String field) throws IOException {
        return this.in.getMatches(field);
    }

    @Override
    public Collection<Matches> getSubMatches() {
        return Collections.singleton(this.in);
    }

    @Override
    public Iterator<String> iterator() {
        return this.in.iterator();
    }

    public static Query wrapQuery(String name, Query in) {
        return new NamedQuery(name, in);
    }

    public static List<NamedMatches> findNamedMatches(Matches matches) {
        ArrayList<NamedMatches> nm = new ArrayList<NamedMatches>();
        LinkedList<Matches> toProcess = new LinkedList<Matches>();
        toProcess.add(matches);
        while (toProcess.size() > 0) {
            matches = (Matches)toProcess.remove(0);
            if (matches instanceof NamedMatches) {
                nm.add((NamedMatches)matches);
            }
            toProcess.addAll(matches.getSubMatches());
        }
        return nm;
    }

    private static class NamedQuery
    extends Query {
        private final String name;
        private final Query in;

        private NamedQuery(String name, Query in) {
            this.name = name;
            this.in = in;
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            Weight w = this.in.createWeight(searcher, scoreMode, boost);
            return new FilterWeight(w){

                @Override
                public Matches matches(LeafReaderContext context2, int doc) throws IOException {
                    Matches m = this.in.matches(context2, doc);
                    if (m == null) {
                        return null;
                    }
                    return new NamedMatches(name, m);
                }
            };
        }

        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            Query rewritten = this.in.rewrite(reader);
            if (rewritten != this.in) {
                return new NamedQuery(this.name, rewritten);
            }
            return this;
        }

        @Override
        public String toString(String field) {
            return "NamedQuery(" + this.name + "," + this.in.toString(field) + ")";
        }

        @Override
        public void visit(QueryVisitor visitor) {
            QueryVisitor sub = visitor.getSubVisitor(BooleanClause.Occur.MUST, this);
            this.in.visit(sub);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedQuery that = (NamedQuery)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.in);
        }
    }
}

