/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public abstract class FieldComparator<T> {
    public abstract int compare(int var1, int var2);

    public abstract void setTopValue(T var1);

    public abstract T value(int var1);

    public abstract LeafFieldComparator getLeafComparator(LeafReaderContext var1) throws IOException;

    public int compareValues(T first, T second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return ((Comparable)first).compareTo(second);
    }

    public void setSingleSort() {
    }

    public void disableSkipping() {
    }

    public static class TermValComparator
    extends FieldComparator<BytesRef>
    implements LeafFieldComparator {
        private final BytesRef[] values;
        private final BytesRefBuilder[] tempBRs;
        private BinaryDocValues docTerms;
        private final String field;
        private BytesRef bottom;
        private BytesRef topValue;
        private final int missingSortCmp;

        public TermValComparator(int numHits, String field, boolean sortMissingLast) {
            this.values = new BytesRef[numHits];
            this.tempBRs = new BytesRefBuilder[numHits];
            this.field = field;
            this.missingSortCmp = sortMissingLast ? 1 : -1;
        }

        private BytesRef getValueForDoc(int doc) throws IOException {
            if (this.docTerms.advanceExact(doc)) {
                return this.docTerms.binaryValue();
            }
            return null;
        }

        @Override
        public int compare(int slot1, int slot2) {
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            return this.compareValues(val1, val2);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            BytesRef comparableBytes = this.getValueForDoc(doc);
            return this.compareValues(this.bottom, comparableBytes);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            BytesRef comparableBytes = this.getValueForDoc(doc);
            if (comparableBytes == null) {
                this.values[slot] = null;
            } else {
                if (this.tempBRs[slot] == null) {
                    this.tempBRs[slot] = new BytesRefBuilder();
                }
                this.tempBRs[slot].copyBytes(comparableBytes);
                this.values[slot] = this.tempBRs[slot].get();
            }
        }

        protected BinaryDocValues getBinaryDocValues(LeafReaderContext context2, String field) throws IOException {
            return DocValues.getBinary(context2.reader(), field);
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context2) throws IOException {
            this.docTerms = this.getBinaryDocValues(context2, this.field);
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(BytesRef value) {
            this.topValue = value;
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (val2 == null) {
                return -this.missingSortCmp;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return this.compareValues(this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void setScorer(Scorable scorer) {
        }
    }

    public static class TermOrdValComparator
    extends FieldComparator<BytesRef>
    implements LeafFieldComparator {
        final int[] ords;
        final BytesRef[] values;
        private final BytesRefBuilder[] tempBRs;
        final int[] readerGen;
        int currentReaderGen = -1;
        SortedDocValues termsIndex;
        private final String field;
        int bottomSlot = -1;
        int bottomOrd;
        boolean bottomSameReader;
        BytesRef bottomValue;
        BytesRef topValue;
        boolean topSameReader;
        int topOrd;
        final int missingSortCmp;
        final int missingOrd;

        public TermOrdValComparator(int numHits, String field) {
            this(numHits, field, false);
        }

        public TermOrdValComparator(int numHits, String field, boolean sortMissingLast) {
            this.ords = new int[numHits];
            this.values = new BytesRef[numHits];
            this.tempBRs = new BytesRefBuilder[numHits];
            this.readerGen = new int[numHits];
            this.field = field;
            if (sortMissingLast) {
                this.missingSortCmp = 1;
                this.missingOrd = Integer.MAX_VALUE;
            } else {
                this.missingSortCmp = -1;
                this.missingOrd = -1;
            }
        }

        private int getOrdForDoc(int doc) throws IOException {
            if (this.termsIndex.advanceExact(doc)) {
                return this.termsIndex.ordValue();
            }
            return -1;
        }

        @Override
        public int compare(int slot1, int slot2) {
            if (this.readerGen[slot1] == this.readerGen[slot2]) {
                return this.ords[slot1] - this.ords[slot2];
            }
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (val2 == null) {
                return -this.missingSortCmp;
            }
            return val1.compareTo(val2);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            assert (this.bottomSlot != -1);
            int docOrd = this.getOrdForDoc(doc);
            if (docOrd == -1) {
                docOrd = this.missingOrd;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - docOrd;
            }
            if (this.bottomOrd >= docOrd) {
                return 1;
            }
            return -1;
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            int ord = this.getOrdForDoc(doc);
            if (ord == -1) {
                ord = this.missingOrd;
                this.values[slot] = null;
            } else {
                assert (ord >= 0);
                if (this.tempBRs[slot] == null) {
                    this.tempBRs[slot] = new BytesRefBuilder();
                }
                this.tempBRs[slot].copyBytes(this.termsIndex.lookupOrd(ord));
                this.values[slot] = this.tempBRs[slot].get();
            }
            this.ords[slot] = ord;
            this.readerGen[slot] = this.currentReaderGen;
        }

        protected SortedDocValues getSortedDocValues(LeafReaderContext context2, String field) throws IOException {
            return DocValues.getSorted(context2.reader(), field);
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context2) throws IOException {
            this.termsIndex = this.getSortedDocValues(context2, this.field);
            ++this.currentReaderGen;
            if (this.topValue != null) {
                int ord = this.termsIndex.lookupTerm(this.topValue);
                if (ord >= 0) {
                    this.topSameReader = true;
                    this.topOrd = ord;
                } else {
                    this.topSameReader = false;
                    this.topOrd = -ord - 2;
                }
            } else {
                this.topOrd = this.missingOrd;
                this.topSameReader = true;
            }
            if (this.bottomSlot != -1) {
                this.setBottom(this.bottomSlot);
            }
            return this;
        }

        @Override
        public void setBottom(int bottom) throws IOException {
            this.bottomSlot = bottom;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                assert (this.ords[this.bottomSlot] == this.missingOrd);
                this.bottomOrd = this.missingOrd;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int ord = this.termsIndex.lookupTerm(this.bottomValue);
                if (ord < 0) {
                    this.bottomOrd = -ord - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = ord;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        @Override
        public void setTopValue(BytesRef value) {
            this.topValue = value;
        }

        @Override
        public BytesRef value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) throws IOException {
            int ord = this.getOrdForDoc(doc);
            if (ord == -1) {
                ord = this.missingOrd;
            }
            if (this.topSameReader) {
                return this.topOrd - ord;
            }
            if (ord <= this.topOrd) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (val2 == null) {
                return -this.missingSortCmp;
            }
            return val1.compareTo(val2);
        }

        @Override
        public void setScorer(Scorable scorer) {
        }
    }

    public static final class RelevanceComparator
    extends FieldComparator<Float>
    implements LeafFieldComparator {
        private final float[] scores;
        private float bottom;
        private Scorable scorer;
        private float topValue;

        public RelevanceComparator(int numHits) {
            this.scores = new float[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Float.compare(this.scores[slot2], this.scores[slot1]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            float score = this.scorer.score();
            assert (!Float.isNaN(score));
            return Float.compare(score, this.bottom);
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.scores[slot] = this.scorer.score();
            assert (!Float.isNaN(this.scores[slot]));
        }

        @Override
        public LeafFieldComparator getLeafComparator(LeafReaderContext context2) {
            return this;
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.scores[bottom];
        }

        @Override
        public void setTopValue(Float value) {
            this.topValue = value.floatValue();
        }

        @Override
        public void setScorer(Scorable scorer) {
            this.scorer = ScoreCachingWrappingScorer.wrap(scorer);
        }

        @Override
        public Float value(int slot) {
            return Float.valueOf(this.scores[slot]);
        }

        @Override
        public int compareValues(Float first, Float second) {
            return second.compareTo(first);
        }

        @Override
        public int compareTop(int doc) throws IOException {
            float docValue = this.scorer.score();
            assert (!Float.isNaN(docValue));
            return Float.compare(docValue, this.topValue);
        }
    }
}

