/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.search.IndexSearcher;

public class SumTotalTermFreqValueSource
extends ValueSource {
    protected final String indexedField;

    public SumTotalTermFreqValueSource(String indexedField) {
        this.indexedField = indexedField;
    }

    public String name() {
        return "sumtotaltermfreq";
    }

    @Override
    public String description() {
        return this.name() + '(' + this.indexedField + ')';
    }

    @Override
    public FunctionValues getValues(Map context2, LeafReaderContext readerContext) throws IOException {
        return (FunctionValues)context2.get(this);
    }

    @Override
    public void createWeight(Map context2, IndexSearcher searcher) throws IOException {
        long sumTotalTermFreq = 0L;
        for (LeafReaderContext readerContext : searcher.getTopReaderContext().leaves()) {
            Terms terms = readerContext.reader().terms(this.indexedField);
            if (terms == null) continue;
            long v = terms.getSumTotalTermFreq();
            assert (v != -1L);
            sumTotalTermFreq += v;
        }
        final long ttf = sumTotalTermFreq;
        context2.put(this, new LongDocValues(this){

            @Override
            public long longVal(int doc) {
                return ttf;
            }
        });
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.indexedField.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SumTotalTermFreqValueSource other = (SumTotalTermFreqValueSource)o;
        return this.indexedField.equals(other.indexedField);
    }
}

