/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene60;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.bkd.BKDReader;

public class Lucene60PointsReader
extends PointsReader
implements Closeable {
    final IndexInput dataIn;
    final SegmentReadState readState;
    final Map<Integer, BKDReader> readers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene60PointsReader(SegmentReadState readState) throws IOException {
        HashMap<Integer, Long> fieldToFileOffset;
        block21: {
            this.readers = new HashMap<Integer, BKDReader>();
            this.readState = readState;
            String indexFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "dii");
            fieldToFileOffset = new HashMap<Integer, Long>();
            try (ChecksumIndexInput indexIn = readState.directory.openChecksumInput(indexFileName, readState.context);){
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(indexIn, "Lucene60PointsFormatMeta", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
                    int count = indexIn.readVInt();
                    for (int i = 0; i < count; ++i) {
                        int fieldNumber = indexIn.readVInt();
                        long fp = indexIn.readVLong();
                        fieldToFileOffset.put(fieldNumber, fp);
                    }
                }
                catch (Throwable t) {
                    try {
                        priorE = t;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(indexIn, priorE);
                    }
                }
                CodecUtil.checkFooter(indexIn, priorE);
            }
        }
        String dataFileName = IndexFileNames.segmentFileName(readState.segmentInfo.name, readState.segmentSuffix, "dim");
        boolean success = false;
        this.dataIn = readState.directory.openInput(dataFileName, readState.context);
        try {
            CodecUtil.checkIndexHeader(this.dataIn, "Lucene60PointsFormatData", 0, 0, readState.segmentInfo.getId(), readState.segmentSuffix);
            CodecUtil.retrieveChecksum(this.dataIn);
            for (Map.Entry ent : fieldToFileOffset.entrySet()) {
                int fieldNumber = (Integer)ent.getKey();
                long fp = (Long)ent.getValue();
                this.dataIn.seek(fp);
                BKDReader reader = new BKDReader(this.dataIn, this.dataIn, this.dataIn);
                this.readers.put(fieldNumber, reader);
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this);
    }

    @Override
    public PointValues getValues(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index point values");
        }
        return this.readers.get(fieldInfo.number);
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.dataIn);
    }

    @Override
    public void close() throws IOException {
        this.dataIn.close();
        this.readers.clear();
    }
}

